/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.archive.dialog.uploadfile;

import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.DataModelHandler;
import org.grits.toolbox.core.datamodel.property.WorkspaceProperty;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;
import org.grits.toolbox.core.preference.share.SingleChoicePreference;
import org.grits.toolbox.entry.archive.model.ArchivedFile;
import org.grits.toolbox.entry.archive.model.DocumentType;
import org.grits.toolbox.entry.archive.model.TypicalArchivedFile;
import org.grits.toolbox.entry.archive.preference.KeywordPreference;
import org.grits.toolbox.entry.archive.preference.doctype.DocTypePreference;
import org.grits.toolbox.entry.archive.utility.DocumentTypeLabelComparator;
import org.grits.toolbox.entry.archive.utility.DocumentTypeLabelProvider;

public class UploadDialog
extends TitleAreaDialog {
    private static Logger logger = Logger.getLogger(UploadDialog.class);
    private Text locationText = null;
    private Text displayNameText = null;
    private ComboViewer personCombo = null;
    private ComboViewer documentTypeCombo = null;
    private ComboViewer documentSubTypeCombo = null;
    private ArchivedFile archivedFile = null;
    protected Set<String> existingNames = new HashSet<String>();
    private String workspacePath = null;
    private File sourceFile = null;

    public UploadDialog(Shell parentShell, HashSet<String> existingNames) {
        super(parentShell);
        this.existingNames = existingNames;
    }

    public void create() {
        super.create();
        this.setTitle("Upload File");
        this.setMessage("Upload File to the Archive");
        this.getShell().setText("Upload");
        this.getButton(0).setText("Upload");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 2048);
        container.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout layout = new GridLayout(4, false);
        layout.marginTop = 10;
        layout.marginBottom = 40;
        layout.marginLeft = 10;
        layout.marginRight = 10;
        layout.verticalSpacing = 20;
        layout.horizontalSpacing = 10;
        container.setLayout((Layout)layout);
        WorkspaceProperty workspaceProperty = (WorkspaceProperty)DataModelHandler.instance().getRoot().getProperty();
        this.workspacePath = workspaceProperty.getLocation().substring(0, workspaceProperty.getLocation().length() - 1);
        this.locationText = new Text(container, 2049);
        GridData textData = new GridData(4, 1, true, false);
        textData.horizontalSpan = 2;
        textData.minimumWidth = 450;
        this.locationText.setLayoutData((Object)textData);
        this.locationText.setText("");
        Button browseFileButton = new Button(container, 8);
        browseFileButton.setText(" Browse File ");
        GridData browseButtonGridData = new GridData(128);
        browseButtonGridData.horizontalSpan = 1;
        browseFileButton.setLayoutData((Object)browseButtonGridData);
        Button browseFolderButton = new Button(container, 8);
        browseFolderButton.setText(" Browse Folder ");
        GridData browseFolderGridData = new GridData(128);
        browseFolderGridData.horizontalSpan = 1;
        browseFolderButton.setLayoutData((Object)browseFolderGridData);
        Label displayLabel = new Label(container, 0);
        displayLabel.setText("Archive Name");
        this.displayNameText = new Text(container, 2048);
        this.displayNameText.setText("");
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 3;
        buttonData.horizontalAlignment = 4;
        this.displayNameText.setLayoutData((Object)buttonData);
        this.displayNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UploadDialog.this.verifyInput();
            }
        });
        browseFileButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String selected = null;
                FileDialog fileDialog = new FileDialog(UploadDialog.this.getShell(), 4096);
                fileDialog.setText("Select File");
                fileDialog.setFileName("");
                selected = fileDialog.open();
                try {
                    if (selected != null) {
                        selected = selected.trim();
                        logger.debug((Object)("Selected file : " + selected));
                        UploadDialog.this.locationText.setText(selected);
                        File sourceFile = Paths.get(UploadDialog.this.locationText.getText(), new String[0]).toFile();
                        UploadDialog.this.displayNameText.setText(sourceFile.getName());
                        UploadDialog.this.displayNameText.selectAll();
                        UploadDialog.this.displayNameText.setFocus();
                    }
                }
                catch (InvalidPathException invalidPathException) {
                    UploadDialog.this.setErrorMessage("Select a valid file");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        browseFolderButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String selected = null;
                DirectoryDialog folderDialog = new DirectoryDialog(UploadDialog.this.getShell(), 4096);
                folderDialog.setText("Select Folder");
                selected = folderDialog.open();
                try {
                    if (selected != null) {
                        logger.debug((Object)("Selected folder : " + selected));
                        UploadDialog.this.locationText.setText(selected);
                        File locationFolder = Paths.get(UploadDialog.this.locationText.getText(), new String[0]).toFile();
                        UploadDialog.this.displayNameText.setText(String.valueOf(locationFolder.getName()) + ".zip");
                        UploadDialog.this.displayNameText.selectAll();
                        UploadDialog.this.displayNameText.setFocus();
                    }
                }
                catch (InvalidPathException invalidPathException) {
                    UploadDialog.this.setErrorMessage("Select a valid folder");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.personCombo = this.createComboLine(container, "Person", 3);
        this.personCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        SingleChoicePreference personPreference = ProjectPreferenceStore.getSingleChoicePreference((ProjectPreferenceStore.Preference)ProjectPreferenceStore.Preference.PERSON);
        ArrayList<String> personList = new ArrayList<String>();
        personList.addAll(personPreference.getAllValues());
        String[] persons = this.getSortedArrayFromList(personList);
        this.personCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.personCombo.setInput((Object)persons);
        this.selectInCombo(this.personCombo, personPreference.getDefaultValue());
        this.documentTypeCombo = this.createComboLine(container, "Document Type", 3);
        this.documentTypeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!((StructuredSelection)UploadDialog.this.documentTypeCombo.getSelection()).isEmpty()) {
                    DocumentType selectedDocumentType = (DocumentType)((StructuredSelection)UploadDialog.this.documentTypeCombo.getSelection()).getFirstElement();
                    String[] documentSubTypes = UploadDialog.this.getSortedArrayFromList(new ArrayList<String>(selectedDocumentType.getSubTypes()));
                    UploadDialog.this.documentSubTypeCombo.setInput((Object)documentSubTypes);
                    UploadDialog.this.selectInCombo(UploadDialog.this.documentSubTypeCombo, selectedDocumentType.getSelectedSubType());
                }
            }
        });
        DocTypePreference.loadPreferences();
        DocumentType[] documentTypes = this.getSortedDocumentFromList(new ArrayList<DocumentType>(DocTypePreference.ALL_DOCUMENT_TYPES));
        this.documentTypeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.documentTypeCombo.setLabelProvider((IBaseLabelProvider)new DocumentTypeLabelProvider());
        this.documentTypeCombo.setInput((Object)documentTypes);
        if (DocTypePreference.DEFAULT_DOCUMENT_TYPE != null) {
            int i = 0;
            int selectionIndex = 0;
            String[] stringArray = this.documentTypeCombo.getCombo().getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String docType = stringArray[n2];
                selectionIndex = docType.equals(DocTypePreference.DEFAULT_DOCUMENT_TYPE.getLabel()) ? i : selectionIndex;
                ++i;
                ++n2;
            }
            this.documentTypeCombo.getCombo().select(selectionIndex);
        }
        this.documentSubTypeCombo = this.createComboLine(container, "Sub Type", 3);
        this.documentSubTypeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        String[] documentSubTypes = null;
        this.documentSubTypeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        if (DocTypePreference.DEFAULT_DOCUMENT_TYPE != null) {
            documentSubTypes = this.getSortedArrayFromList(new ArrayList<String>(DocTypePreference.DEFAULT_DOCUMENT_TYPE.getSubTypes()));
            this.documentSubTypeCombo.setInput((Object)documentSubTypes);
            this.selectInCombo(this.documentSubTypeCombo, DocTypePreference.DEFAULT_DOCUMENT_TYPE.getSelectedSubType());
        }
        browseFileButton.setFocus();
        composite.setLayoutData((Object)new GridData(1808));
        return composite;
    }

    protected void verifyInput() {
        this.setErrorMessage(null);
        String errorMessage = null;
        String archiveName = this.displayNameText.getText().trim();
        String location = this.locationText.getText().trim();
        if (archiveName.isEmpty()) {
            errorMessage = "Archive Name cannot be empty. Please add an archive name";
        } else if (location.isEmpty()) {
            errorMessage = "Invalid File/Folder path.";
        } else {
            File locationFile = null;
            try {
                locationFile = Paths.get(location, new String[0]).toFile();
            }
            catch (Exception exception) {
                errorMessage = "Invalid File/Folder path.";
            }
            if (errorMessage == null && locationFile != null) {
                logger.debug((Object)("parent file" + locationFile.getParentFile()));
                if (locationFile.isDirectory() && (locationFile.getAbsolutePath().equals(this.workspacePath) || locationFile.getAbsolutePath().contains(String.valueOf(this.workspacePath) + File.separator))) {
                    errorMessage = "Cannot upload workspace content as archive. Please select another folder.";
                }
                if (errorMessage == null && this.existingNames.contains(archiveName)) {
                    errorMessage = "This name already exists in the archive. Please choose a unique archive name.";
                }
            }
        }
        this.setErrorMessage(errorMessage);
    }

    private void selectInCombo(ComboViewer comboViewer, String selectedValue) {
        String[] arrayOfValues = comboViewer.getCombo().getItems();
        if (arrayOfValues.length > 0 && selectedValue != null) {
            int i = 0;
            int selectionIndex = -1;
            String[] stringArray = arrayOfValues;
            int n = arrayOfValues.length;
            int n2 = 0;
            while (n2 < n) {
                String position = stringArray[n2];
                if (selectedValue != null && position.equals(selectedValue)) {
                    selectionIndex = i;
                }
                ++i;
                ++n2;
            }
            comboViewer.setInput((Object)arrayOfValues);
            if (selectionIndex >= 0) {
                comboViewer.getCombo().select(selectionIndex);
            }
        }
    }

    private ComboViewer createComboLine(Composite composite, String label, int horizontalSpan) {
        Label labelLabel = new Label(composite, 0);
        GridData labelGridData = new GridData();
        labelGridData.verticalAlignment = 1;
        labelLabel.setLayoutData((Object)labelGridData);
        labelLabel.setText(label);
        ComboViewer comboViewer = new ComboViewer(composite, 8);
        GridData comboGridData = new GridData();
        comboGridData.grabExcessHorizontalSpace = true;
        comboGridData.horizontalAlignment = 4;
        comboGridData.horizontalSpan = horizontalSpan;
        comboViewer.getCombo().setLayoutData((Object)comboGridData);
        return comboViewer;
    }

    private String[] getSortedArrayFromList(List<String> listOfValue) {
        Collections.sort(listOfValue);
        String[] arrayOfValue = new String[listOfValue.size()];
        int i = 0;
        Iterator<String> iterator = listOfValue.iterator();
        while (iterator.hasNext()) {
            String value;
            arrayOfValue[i] = value = iterator.next();
            ++i;
        }
        return arrayOfValue;
    }

    private DocumentType[] getSortedDocumentFromList(List<DocumentType> listOfValue) {
        Collections.sort(listOfValue, new DocumentTypeLabelComparator());
        DocumentType[] arrayOfValue = new DocumentType[listOfValue.size()];
        int i = 0;
        Iterator<DocumentType> iterator = listOfValue.iterator();
        while (iterator.hasNext()) {
            DocumentType value;
            arrayOfValue[i] = value = iterator.next();
            ++i;
        }
        return arrayOfValue;
    }

    public void setErrorMessage(String newErrorMessage) {
        super.setErrorMessage(newErrorMessage);
        this.getButton(0).setEnabled(newErrorMessage == null);
    }

    protected void okPressed() {
        String location = this.locationText.getText().trim();
        if (!location.isEmpty()) {
            String archiveName = this.displayNameText.getText().trim();
            if (!archiveName.isEmpty()) {
                if (this.personCombo.getCombo().getItems().length == 0 || this.personCombo.getCombo().getSelectionIndex() >= 0) {
                    try {
                        this.sourceFile = Paths.get(location, new String[0]).toFile();
                    }
                    catch (InvalidPathException ex) {
                        logger.error((Object)ex.getMessage(), (Throwable)ex);
                        this.setErrorMessage("Select a valid file");
                    }
                    if (this.sourceFile.isDirectory()) {
                        if (this.sourceFile.getAbsolutePath().equals(this.workspacePath) || this.sourceFile.getAbsolutePath().contains(String.valueOf(this.workspacePath) + File.separator)) {
                            this.setErrorMessage("Cannot upload workspace content as archive. Please select another folder.");
                        } else if (archiveName.equals(".zip") || !archiveName.endsWith(".zip")) {
                            archiveName = String.valueOf(archiveName) + ".zip";
                        }
                    }
                    this.archivedFile = new ArchivedFile();
                    TypicalArchivedFile typicalArchivedFile = new TypicalArchivedFile();
                    typicalArchivedFile.setFileName(archiveName);
                    if (!this.documentTypeCombo.getSelection().isEmpty()) {
                        DocumentType selectedDocType = (DocumentType)this.documentTypeCombo.getElementAt(this.documentTypeCombo.getCombo().getSelectionIndex());
                        typicalArchivedFile.setDocumentType(selectedDocType.clone());
                        if (!this.documentSubTypeCombo.getSelection().isEmpty()) {
                            typicalArchivedFile.getDocumentType().setSelectedSubType(this.documentSubTypeCombo.getCombo().getText());
                        }
                    }
                    this.archivedFile.setPerson(this.personCombo.getCombo().getText());
                    this.archivedFile.setTypicalArchivedFile(typicalArchivedFile);
                    Date currentDate = new Date();
                    this.archivedFile.setSetDate(currentDate);
                    this.archivedFile.setModifiedDate(currentDate);
                    KeywordPreference.loadPreferences();
                    this.archivedFile.setKeywords(new HashSet<String>(KeywordPreference.DEFAULT_KEYWORDS));
                    super.okPressed();
                } else {
                    this.setErrorMessage("Select the person");
                }
            } else {
                this.setErrorMessage("Archive Name cannot be empty");
            }
        } else {
            this.setErrorMessage("Select a valid file");
        }
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public ArchivedFile getArchivedFile() {
        return this.archivedFile;
    }
}

