/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.archive.editor.pages.archivedemail;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;
import org.grits.toolbox.core.preference.share.SingleChoicePreference;
import org.grits.toolbox.entry.archive.config.ImageRegistry;
import org.grits.toolbox.entry.archive.editor.ArchiveEntryEditor;
import org.grits.toolbox.entry.archive.editor.pages.AbstractArchivePage;
import org.grits.toolbox.entry.archive.editor.pages.archivedemail.actions.AddArchivedEmail;
import org.grits.toolbox.entry.archive.editor.pages.archivedemail.actions.AddReplyEmail;
import org.grits.toolbox.entry.archive.editor.pages.archivedemail.actions.DeleteAll;
import org.grits.toolbox.entry.archive.editor.pages.archivedemail.actions.DeleteEmail;
import org.grits.toolbox.entry.archive.editor.pages.archivedfile.actions.sort.ArchivedFileColumnComparatorListener;
import org.grits.toolbox.entry.archive.editor.pages.archivedfile.actions.sort.ArchivedFileViewerComparator;
import org.grits.toolbox.entry.archive.editor.pages.archivedfile.actions.sort.SortFileNames;
import org.grits.toolbox.entry.archive.model.ArchivedBasicEmail;
import org.grits.toolbox.entry.archive.model.ArchivedEmail;
import org.grits.toolbox.entry.archive.model.ArchivedEmailTopic;

public class EmailArchivePage
extends AbstractArchivePage {
    private Logger logger = Logger.getLogger(EmailArchivePage.class);
    public static final String ID = "1";
    public static final String PAGE_TITLE = "Email  ";
    private static final Image EMAIL_ICON = ImageRegistry.getImageDescriptor("org.grits.toolbox.entry.archive", ImageRegistry.ArchiveImage.ADD_EMAIL_ICON).createImage();
    private static final Image REPLY_ICON = ImageRegistry.getImageDescriptor("org.grits.toolbox.entry.archive", ImageRegistry.ArchiveImage.REPLY_EMAIL_ICON).createImage();
    private ArchivedBasicEmail selectedArchivedEmail = null;
    private ArrayList<Action> leftSectionActions = null;
    private Composite rightSideComposite = null;
    private ComboViewer fromPersonCombo = null;
    private Text subjectText = null;
    private CDateTime cDateTime = null;
    private Text emailContentText = null;
    private Text notesText = null;
    private Label lastEditedText = null;
    private boolean oldSelection = true;
    private SortFileNames sortByName;
    @Inject
    EMenuService menuService;

    @Inject
    public EmailArchivePage(ArchiveEntryEditor archiveEntryEditor, CTabItem cTabItem) {
        super(archiveEntryEditor, cTabItem);
    }

    public Boolean isOldSelection() {
        return this.oldSelection;
    }

    private ArchiveEntryEditor getArchiveEntryEditor() {
        return this.getEditor();
    }

    public ArchivedBasicEmail getSelectedArchivedEmail() {
        return this.selectedArchivedEmail;
    }

    @Override
    public void createRestOftheContent() {
        this.logger.debug((Object)"- START : Retrieving all ArchivedBasicEmail for the Archive Editor.");
        try {
            this.rightSideComposite = new Composite((Composite)this.getRightSectionOfPage(), 0);
            GridLayout rightSideCompositeLayout = new GridLayout();
            rightSideCompositeLayout.verticalSpacing = 15;
            rightSideCompositeLayout.horizontalSpacing = 10;
            rightSideCompositeLayout.numColumns = 4;
            rightSideCompositeLayout.makeColumnsEqualWidth = false;
            this.rightSideComposite.setLayout((Layout)rightSideCompositeLayout);
            this.fromPersonCombo = this.createComboLine("From", 3);
            this.fromPersonCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    String person;
                    if (EmailArchivePage.this.selectedArchivedEmail != null && EmailArchivePage.this.fromPersonCombo.getCombo().getSelectionIndex() >= 0 && !Objects.equals(person = EmailArchivePage.this.fromPersonCombo.getCombo().getItem(EmailArchivePage.this.fromPersonCombo.getCombo().getSelectionIndex()), EmailArchivePage.this.selectedArchivedEmail.getFromPerson())) {
                        EmailArchivePage.this.selectedArchivedEmail.setFromPerson(person);
                        EmailArchivePage.this.pageEdited();
                        EmailArchivePage.this.refreshPage();
                    }
                }
            });
            SingleChoicePreference personPreference = ProjectPreferenceStore.getSingleChoicePreference((ProjectPreferenceStore.Preference)ProjectPreferenceStore.Preference.PERSON);
            ArrayList<String> personList = new ArrayList<String>();
            personList.addAll(personPreference.getAllValues());
            String[] persons = this.getSortedArrayFromList(personList);
            this.fromPersonCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.fromPersonCombo.setInput((Object)persons);
            this.createLabel("Date");
            this.cDateTime = new CDateTime(this.rightSideComposite, 3);
            GridData textGridData = new GridData();
            textGridData.grabExcessHorizontalSpace = true;
            textGridData.horizontalAlignment = 4;
            textGridData.minimumWidth = 100;
            textGridData.horizontalSpan = 3;
            this.cDateTime.setLayoutData((Object)textGridData);
            this.cDateTime.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.changeDate();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.changeDate();
                }

                private void changeDate() {
                    Date date;
                    if (EmailArchivePage.this.selectedArchivedEmail != null && !Objects.equals(date = EmailArchivePage.this.cDateTime.getSelection(), EmailArchivePage.this.selectedArchivedEmail.getEmailDate())) {
                        EmailArchivePage.this.selectedArchivedEmail.setEmailDate(date);
                        EmailArchivePage.this.pageEdited();
                        EmailArchivePage.this.refreshPage();
                    }
                }
            });
            this.subjectText = this.createLineForLabel("Subject", 10000, 2112, 520, -1, 3);
            this.subjectText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String subject;
                    if (EmailArchivePage.this.selectedArchivedEmail != null && !Objects.equals(subject = EmailArchivePage.this.subjectText.getText().trim(), EmailArchivePage.this.selectedArchivedEmail.getEmailSubject())) {
                        EmailArchivePage.this.selectedArchivedEmail.setEmailSubject(subject);
                        EmailArchivePage.this.pageEdited();
                        EmailArchivePage.this.refreshPage();
                    }
                }
            });
            this.subjectText.setEnabled(false);
            this.emailContentText = this.createLineForLabel("Email", 10000, 2624, 520, 400, 3);
            this.emailContentText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String description;
                    if (EmailArchivePage.this.selectedArchivedEmail != null && !Objects.equals(description = EmailArchivePage.this.emailContentText.getText().trim(), EmailArchivePage.this.selectedArchivedEmail.getEmailContent())) {
                        EmailArchivePage.this.selectedArchivedEmail.setEmailContent(description);
                        EmailArchivePage.this.pageEdited();
                    }
                }
            });
            this.notesText = this.createLineForLabel("Notes", 10000, 2624, 520, 60, 3);
            this.notesText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String notes;
                    if (EmailArchivePage.this.selectedArchivedEmail != null && !Objects.equals(notes = EmailArchivePage.this.notesText.getText().trim(), EmailArchivePage.this.selectedArchivedEmail.getNotes())) {
                        EmailArchivePage.this.selectedArchivedEmail.setNotes(notes);
                        EmailArchivePage.this.pageEdited();
                    }
                }
            });
            this.lastEditedText = new Label(this.rightSideComposite, 0);
            this.lastEditedText.setText("Last Edited on ");
            GridData labelGridData = new GridData();
            labelGridData.horizontalSpan = 2;
            labelGridData.verticalAlignment = 1;
            this.lastEditedText.setLayoutData((Object)labelGridData);
            this.rightSideComposite.setLayoutData((Object)new TableWrapData(256));
            this.getRightSectionOfPage().setClient((Control)this.rightSideComposite);
            this.clearAll();
        }
        catch (Exception ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        this.logger.debug((Object)"- END   : Retrieving all ArchivedBasicEmail for the Archive Editor.");
    }

    public void pageEdited() {
        if (this.selectedArchivedEmail != null && this.oldSelection) {
            this.selectedArchivedEmail.setModifiedDate(new Date());
            this.getArchiveEntryEditor().markDirty();
        }
    }

    protected String getCSKeywords(Set<String> keywordSet) {
        String keywords = "";
        String separator = ", ";
        for (String keyword : keywordSet) {
            if (keyword.isEmpty()) continue;
            keywords = String.valueOf(keywords) + keyword + separator;
        }
        if (!keywords.isEmpty()) {
            keywords = keywords.substring(0, keywords.length() - separator.length());
        }
        return keywords;
    }

    private String[] getSortedArrayFromList(List<String> listOfValues) {
        Collections.sort(listOfValues);
        String[] arrayOfValue = new String[listOfValues.size()];
        int i = 0;
        if (!listOfValues.contains("  --  No Selection -- ")) {
            arrayOfValue = new String[listOfValues.size() + 1];
            arrayOfValue[0] = "  --  No Selection -- ";
            i = 1;
        }
        Iterator<String> iterator = listOfValues.iterator();
        while (iterator.hasNext()) {
            String value;
            arrayOfValue[i] = value = iterator.next();
            ++i;
        }
        return arrayOfValue;
    }

    private ComboViewer createComboLine(String label, int horizontalSpan) {
        Label labelLabel = new Label(this.rightSideComposite, 0);
        labelLabel.setText(label);
        labelLabel.setFont(this.boldFont);
        GridData labelGridData = new GridData();
        labelGridData.verticalAlignment = 1;
        labelLabel.setLayoutData((Object)labelGridData);
        ComboViewer comboViewer = new ComboViewer(this.rightSideComposite, 8);
        GridData comboGridData = new GridData();
        comboGridData.grabExcessHorizontalSpace = true;
        comboGridData.horizontalAlignment = 4;
        comboGridData.horizontalSpan = horizontalSpan;
        comboViewer.getCombo().setLayoutData((Object)comboGridData);
        return comboViewer;
    }

    protected Text createLineForLabel(String label, int textLimit, int style, int minimumTextWidth, int heightHint, int horizontalSpan) {
        this.createLabel(label);
        Text labelText = new Text(this.rightSideComposite, style);
        labelText.setTextLimit(textLimit);
        GridData textGridData = new GridData();
        textGridData.grabExcessHorizontalSpace = true;
        textGridData.horizontalAlignment = 4;
        textGridData.minimumWidth = minimumTextWidth;
        if (heightHint > 0) {
            textGridData.heightHint = heightHint;
        }
        textGridData.horizontalSpan = horizontalSpan;
        labelText.setLayoutData((Object)textGridData);
        return labelText;
    }

    private void createLabel(String label) {
        Label labelLabel = new Label(this.rightSideComposite, 0);
        labelLabel.setText(label);
        labelLabel.setFont(this.boldFont);
        GridData labelGridData = new GridData();
        labelGridData.verticalAlignment = 1;
        labelLabel.setLayoutData((Object)labelGridData);
    }

    @Override
    protected List<Action> getLeftSectionActions() {
        this.leftSectionActions = new ArrayList();
        this.leftSectionActions.add(0, new AddArchivedEmail(this));
        this.leftSectionActions.add(1, new AddReplyEmail(this));
        this.leftSectionActions.add(2, new DeleteEmail(this));
        this.leftSectionActions.add(3, new DeleteAll(this));
        this.sortByName = new SortFileNames(this.leftSideTreeViewer);
        this.leftSectionActions.add(4, this.sortByName);
        this.createContextMenu();
        return this.leftSectionActions;
    }

    protected void createContextMenu() {
        if (this.leftSideTreeViewer != null) {
            MenuManager contextMenu = new MenuManager("#ViewerMenu-email");
            contextMenu.setRemoveAllWhenShown(true);
            contextMenu.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager mgr) {
                    if (EmailArchivePage.this.leftSideTreeViewer.getSelection() != null && !EmailArchivePage.this.leftSideTreeViewer.getSelection().isEmpty()) {
                        EmailArchivePage.this.fillContextMenu(mgr);
                    }
                }
            });
            Menu menu = contextMenu.createContextMenu((Control)this.leftSideTreeViewer.getTree());
            this.leftSideTreeViewer.getTree().setMenu(menu);
            this.menuService.registerContextMenu((Object)this.leftSideTreeViewer, "#ViewerMenu-email");
        }
    }

    protected void fillContextMenu(IMenuManager contextMenu) {
        contextMenu.add((IAction)this.leftSectionActions.get(0));
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.add((IAction)this.leftSectionActions.get(1));
        contextMenu.add((IAction)this.leftSectionActions.get(2));
        contextMenu.add((IAction)this.leftSectionActions.get(3));
    }

    @Override
    public void setSelection(Object selectedObject) {
        String selectionTitle = "No Selection";
        if (selectedObject instanceof ArchivedBasicEmail || selectedObject instanceof ArchivedEmailTopic) {
            this.oldSelection = false;
            this.selectedArchivedEmail = selectedObject instanceof ArchivedEmailTopic ? ((ArchivedEmailTopic)selectedObject).getlastReplyEmail() : (ArchivedBasicEmail)selectedObject;
            selectionTitle = "Selection : " + this.selectedArchivedEmail.getDisplayTitle();
            this.resetPerson(this.selectedArchivedEmail.getFromPerson());
            this.cDateTime.setSelection(this.selectedArchivedEmail.getEmailDate());
            String value = this.selectedArchivedEmail.getEmailSubject() == null ? "" : this.selectedArchivedEmail.getEmailSubject();
            this.subjectText.setText(value);
            value = this.selectedArchivedEmail.getEmailContent() == null ? "" : this.selectedArchivedEmail.getEmailContent();
            this.emailContentText.setText(value);
            value = this.selectedArchivedEmail.getNotes() == null ? "" : this.selectedArchivedEmail.getNotes();
            this.notesText.setText(value);
            value = this.selectedArchivedEmail.getModifiedDate() == null ? "" : this.selectedArchivedEmail.getModifiedDate().toString();
            this.lastEditedText.setText("Last Edited on " + value);
            this.makeControlsEditable(true);
            this.oldSelection = true;
        } else {
            this.clearAll();
        }
        this.getRightSectionOfPage().setText(selectionTitle);
    }

    private void clearAll() {
        this.oldSelection = false;
        this.makeControlsEditable(false);
        this.selectedArchivedEmail = null;
        this.lastEditedText.setText("Last Edited on ");
        this.emailContentText.setText("");
        this.notesText.setText("");
        this.subjectText.setText("");
        this.fromPersonCombo.getCombo().select(0);
        this.cDateTime.setSelection(null);
    }

    private void makeControlsEditable(boolean editable) {
        this.fromPersonCombo.getCombo().setEnabled(editable);
        this.cDateTime.setEnabled(editable);
        this.subjectText.setEnabled(editable);
        this.emailContentText.setEnabled(editable);
        this.notesText.setEnabled(editable);
    }

    private void resetCombo(ComboViewer comboViewer, String selectedValue) {
        int selectionIndex = 0;
        if (selectedValue != null) {
            comboViewer.getCombo().clearSelection();
            String[] arrayOfValues = comboViewer.getCombo().getItems();
            int i = 0;
            String[] stringArray = arrayOfValues;
            int n = arrayOfValues.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (value.equals(selectedValue)) {
                    selectionIndex = i;
                    break;
                }
                ++i;
                ++n2;
            }
        }
        comboViewer.getCombo().select(selectionIndex);
    }

    private void resetPerson(String selectedPerson) {
        if (selectedPerson != null) {
            boolean found = false;
            String[] stringArray = this.fromPersonCombo.getCombo().getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String docName = stringArray[n2];
                if (docName.equals(selectedPerson)) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) {
                this.fromPersonCombo.add((Object)selectedPerson);
            }
        }
        this.resetCombo(this.fromPersonCombo, selectedPerson);
    }

    @Override
    protected List<?> getInput() {
        return this.getArchiveEntryEditor().getArchive().getArchivedEmails();
    }

    @Override
    public void refreshPage() {
        TreeSelection selection = (TreeSelection)this.leftSideTreeViewer.getSelection();
        this.getLeftSideTreeViewer().refresh();
        this.setSelection(selection.getFirstElement());
    }

    @Override
    protected void setUpColumns(TreeViewer treeViewer) {
        treeViewer.setComparator((ViewerComparator)new ArchivedFileViewerComparator(this.getArchiveEntryEditor()));
        TreeViewerColumn columnViewer0 = new TreeViewerColumn(treeViewer, 16384);
        columnViewer0.getColumn().setWidth(170);
        columnViewer0.getColumn().setText("Email");
        columnViewer0.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ArchivedEmail) {
                    return ((ArchivedEmail)element).getDisplayTitle();
                }
                return null;
            }

            public Image getImage(Object element) {
                if (element instanceof ArchivedBasicEmail) {
                    return EmailArchivePage.this.getEmailIcon((ArchivedBasicEmail)element);
                }
                return null;
            }
        });
        columnViewer0.getColumn().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EmailArchivePage.this.sortByName.run();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                EmailArchivePage.this.sortByName.run();
            }
        });
        TreeViewerColumn columnViewer1 = new TreeViewerColumn(treeViewer, 16384);
        columnViewer1.getColumn().setWidth(150);
        columnViewer1.getColumn().setText("Date");
        columnViewer1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ArchivedBasicEmail && ((ArchivedBasicEmail)element).getArchivedEmailTopic() != null) {
                    ArchivedBasicEmail archivedBasicEmail = (ArchivedBasicEmail)element;
                    return archivedBasicEmail == null ? " " : " " + ArchivedEmail.DATE_FORMAT1.format(archivedBasicEmail.getEmailDate());
                }
                if (element instanceof ArchivedEmail) {
                    ArchivedEmail archivedEmail = (ArchivedEmail)element;
                    String dateValue = archivedEmail.getEmailDate() == null ? " " : " " + ArchivedEmail.DATE_FORMAT0.format(archivedEmail.getEmailDate());
                    return dateValue;
                }
                return null;
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        columnViewer1.getColumn().addSelectionListener((SelectionListener)new ArchivedFileColumnComparatorListener(treeViewer));
    }

    protected Image getEmailIcon(ArchivedEmail archivedEmail) {
        Image icon = null;
        try {
            if (archivedEmail instanceof ArchivedBasicEmail) {
                icon = ((ArchivedBasicEmail)archivedEmail).getArchivedEmailTopic() == null ? EMAIL_ICON : REPLY_ICON;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return icon;
    }

    @Inject
    @Optional
    public void preferenceUpdated(@UIEventTopic(value="preference_value_changed_in_grits") String preferenceName) {
        if (this.fromPersonCombo != null && preferenceName.equals(ProjectPreferenceStore.Preference.PERSON.getPreferenceName())) {
            String personSelection = this.fromPersonCombo.getSelection().isEmpty() ? null : (String)((StructuredSelection)this.fromPersonCombo.getSelection()).getFirstElement();
            SingleChoicePreference personPreference = ProjectPreferenceStore.getSingleChoicePreference((ProjectPreferenceStore.Preference)ProjectPreferenceStore.Preference.PERSON);
            ArrayList<String> personList = new ArrayList<String>();
            personList.addAll(personPreference.getAllValues());
            this.fromPersonCombo.setInput((Object)this.getSortedArrayFromList(personList));
            this.resetPerson(personSelection);
        }
    }

    @Override
    protected String getTitle() {
        return PAGE_TITLE;
    }
}

