/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.property.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.UnsupportedTypeException;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.datamodel.io.PropertyReader;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.core.utilShare.XMLUtils;
import org.grits.toolbox.entry.ms.preference.MassSpecPreference;
import org.grits.toolbox.entry.ms.property.FileLock;
import org.grits.toolbox.entry.ms.property.FileLockManager;
import org.grits.toolbox.entry.ms.property.FileLockingUtils;
import org.grits.toolbox.entry.ms.property.LockEntry;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.ExternalQuantAlias;
import org.grits.toolbox.entry.ms.property.datamodel.ExternalQuantFileToAlias;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecMetaData;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecUISettings;
import org.grits.toolbox.entry.ms.property.io.MassSpecReaderVersion0;
import org.grits.toolbox.entry.ms.property.io.MassSpecReaderVersion1;
import org.grits.toolbox.entry.ms.property.io.MassSpecReaderVersion1_1;
import org.grits.toolbox.entry.ms.property.io.MassSpecReaderVersion1_2;
import org.grits.toolbox.entry.ms.property.io.MassSpecReaderVersion1_3;
import org.grits.toolbox.ms.file.FileCategory;
import org.grits.toolbox.ms.file.MSFileInfo;
import org.jdom.Element;

public class MassSpecPropertyReader
extends PropertyReader {
    private static final Logger logger = Logger.getLogger(MassSpecPropertyReader.class);

    public Property read(Element propertyElement) throws IOException, UnsupportedVersionException {
        MassSpecProperty property = new MassSpecProperty();
        PropertyReader.addGenericInfo((Element)propertyElement, (Property)property);
        if (property.getVersion() == null) {
            try {
                MassSpecReaderVersion0.read(propertyElement, property);
                property.setVersion("1.3");
                if (property.getMassSpecMetaData() != null) {
                    property.getMassSpecMetaData().setVersion("1.2");
                }
                this.convertIntoMSPropertyDataFiles(property, propertyElement);
                this.addFilesToLockManager(propertyElement, property);
                this.updateMassSpecMetaData(property, propertyElement);
                PropertyReader.UPDATE_PROJECT_XML = true;
            }
            catch (UnsupportedTypeException e) {
                throw new IOException(e.getMessage(), e);
            }
        } else if (property.getVersion().equals("1.0")) {
            MassSpecReaderVersion1.read(propertyElement, property);
            property.setVersion("1.3");
            if (property.getMassSpecMetaData() != null) {
                property.getMassSpecMetaData().setVersion("1.2");
            }
            this.convertIntoMSPropertyDataFiles(property, propertyElement);
            this.addFilesToLockManager(propertyElement, property);
            this.updateMassSpecMetaData(property, propertyElement);
            PropertyReader.UPDATE_PROJECT_XML = true;
        } else if (property.getVersion().equals("1.1")) {
            MassSpecReaderVersion1_1.read(propertyElement, property);
            if (property.getMassSpecMetaData() != null) {
                property.getMassSpecMetaData().setVersion("1.2");
            }
            property.setVersion("1.3");
            this.convertIntoMSPropertyDataFiles(property, propertyElement);
            this.addFilesToLockManager(propertyElement, property);
            this.updateMassSpecMetaData(property, propertyElement);
            PropertyReader.UPDATE_PROJECT_XML = true;
        } else if (property.getVersion().equals("1.2")) {
            MassSpecReaderVersion1_2.read(propertyElement, property);
            property.setVersion("1.3");
            this.convertIntoMSPropertyDataFiles(property, propertyElement);
            this.addFilesToLockManager(propertyElement, property);
            this.updateMassSpecMetaData(property, propertyElement);
            PropertyReader.UPDATE_PROJECT_XML = true;
        } else if (property.getVersion().equals("1.3")) {
            MassSpecReaderVersion1_3.read(propertyElement, property);
            this.updateMassSpecMetaData(property, propertyElement);
            this.adjustFilePathsForLockFile(propertyElement, property);
            PropertyReader.UPDATE_PROJECT_XML = true;
        } else {
            throw new UnsupportedVersionException("This version is currently not supported.", property.getVersion());
        }
        return property;
    }

    private void adjustFilePathsForLockFile(Element propertyElement, MassSpecProperty property) {
        try {
            FileLockManager lockMng = null;
            String metadataPath = property.getMSSettingsFile().getName();
            String lockFilePath = String.valueOf(this.getMSFolder(propertyElement)) + File.separator;
            lockFilePath = metadataPath.lastIndexOf(File.separator) != -1 ? String.valueOf(lockFilePath) + metadataPath.substring(0, metadataPath.lastIndexOf(File.separator)) + File.separator + ".lockFile" : String.valueOf(lockFilePath) + ".lockFile";
            lockMng = FileLockingUtils.readLockFile(lockFilePath);
            for (FileLock file : lockMng.getFileList()) {
                if (file.getFilename().contains("\\") && !File.separator.equals("\\")) {
                    file.setFilename(file.getFilename().replace("\\", File.separator));
                    continue;
                }
                if (!file.getFilename().contains("/") || File.separator.equals("/")) continue;
                file.setFilename(file.getFilename().replace("/", File.separator));
            }
            FileLockingUtils.writeLockFile(lockMng, lockFilePath);
        }
        catch (JAXBException e) {
            logger.error((Object)"Could not fix file paths in the lock file. Locking mechanism may not work", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Could not fix file paths in the lock file. Locking mechanism may not work", (Throwable)e);
        }
    }

    String getMSFolder(Element propertyElement) {
        Element entryElement = propertyElement.getDocument().getRootElement().getChild("entry");
        String projectName = entryElement == null ? null : entryElement.getAttributeValue("name");
        String workspaceFolder = PropertyHandler.getVariable((String)"workspace_location");
        String msFolder = String.valueOf(workspaceFolder.substring(0, workspaceFolder.length() - 1)) + File.separator + projectName + File.separator + MassSpecProperty.getFoldername();
        return msFolder;
    }

    List<LockEntry> getAllChildrenEntries(Element propertyElement, String propertyId) {
        ArrayList<LockEntry> children = new ArrayList<LockEntry>();
        Element matchEntry = this.findEntryElementById(propertyElement, propertyId);
        if (matchEntry != null) {
            for (Object ch : matchEntry.getChildren("entry")) {
                if (!(ch instanceof Element)) continue;
                String entryId = ((Element)ch).getAttributeValue("id");
                String displayName = ((Element)ch).getAttributeValue("name");
                LockEntry entry = new LockEntry();
                entry.setEntryId(Integer.parseInt(entryId));
                entry.setEntryName(displayName);
                children.add(entry);
            }
        }
        return children;
    }

    private Element findEntryElementById(Element entryElement, String propertyId) {
        Element element = null;
        for (Object ch : entryElement.getChildren("entry")) {
            if (!(ch instanceof Element)) continue;
            if (((Element)ch).getAttributeValue("id").equals(propertyId)) {
                element = (Element)ch;
                break;
            }
            Element e = this.findEntryElementById((Element)ch, propertyId);
            if (e == null) continue;
            element = e;
            break;
        }
        return element;
    }

    void addFilesToLockManager(Element propertyElement, MassSpecProperty property) throws IOException {
        try {
            FileLockManager lockMng = null;
            String metadataPath = property.getMSSettingsFile().getName();
            String lockFilePath = String.valueOf(this.getMSFolder(propertyElement)) + File.separator;
            lockFilePath = metadataPath.lastIndexOf(File.separator) != -1 ? String.valueOf(lockFilePath) + metadataPath.substring(0, metadataPath.lastIndexOf(File.separator)) + File.separator + ".lockFile" : String.valueOf(lockFilePath) + ".lockFile";
            lockMng = FileLockingUtils.readLockFile(lockFilePath);
            if (property.getMassSpecMetaData().getFileList() == null) {
                return;
            }
            for (PropertyDataFile propertyDataFile : property.getMassSpecMetaData().getFileList()) {
                if (!(propertyDataFile instanceof MSPropertyDataFile)) continue;
                if (propertyDataFile.getName() != null && !propertyDataFile.getName().isEmpty()) {
                    lockMng.addFile(propertyDataFile.getName());
                }
                if (((MSPropertyDataFile)propertyDataFile).getChildren() == null) continue;
                for (MSPropertyDataFile child : ((MSPropertyDataFile)propertyDataFile).getChildren()) {
                    lockMng.addFile(child.getName());
                    if (!child.getCategory().equals((Object)FileCategory.EXTERNAL_QUANTIFICATION_CATEGORY)) continue;
                    ExternalQuantAlias eqa = new ExternalQuantAlias();
                    eqa.setAlias(MSPropertyDataFile.getLegacyExternalQuantAlias(child));
                    property.getMassSpecMetaData().addExternalQuantFile(child, eqa);
                    String sExtQuantType = MassSpecUISettings.getExternalQuantType(child);
                    ExternalQuantFileToAlias mAliases = property.getMassSpecMetaData().getExternalQuantToAliasByQuantType(sExtQuantType);
                    property.getMassSpecMetaData().updateQuantAliasKeyInfo(child, mAliases, null);
                }
            }
            String string = propertyElement.getAttributeValue("id");
            Element entryElement = propertyElement.getDocument().getRootElement().getChild("entry");
            List<LockEntry> entries = this.getAllChildrenEntries(entryElement, string);
            for (MSPropertyDataFile file : property.getMassSpecMetaData().getFileList()) {
                if (file.getChildren() == null) continue;
                for (MSPropertyDataFile child : file.getChildren()) {
                    for (LockEntry entry : entries) {
                        lockMng.lockFile(child.getName(), entry);
                        if (child.getCategory() != FileCategory.EXTERNAL_QUANTIFICATION_CATEGORY) continue;
                        ExternalQuantAlias eqa = new ExternalQuantAlias();
                        eqa.setAlias(MSPropertyDataFile.getLegacyExternalQuantAlias(child));
                        property.getMassSpecMetaData().addExternalQuantFile(child, eqa);
                        String sExtQuantType = MassSpecUISettings.getExternalQuantType(child);
                        ExternalQuantFileToAlias mAliases = property.getMassSpecMetaData().getExternalQuantToAliasByQuantType(sExtQuantType);
                        property.getMassSpecMetaData().updateQuantAliasKeyInfo(child, mAliases, null);
                    }
                }
            }
            FileLockingUtils.writeLockFile(lockMng, lockFilePath);
        }
        catch (JAXBException e) {
            logger.error((Object)"Could not add files into the lock file. Locking mechanism may not work", (Throwable)e);
        }
    }

    void convertIntoMSPropertyDataFiles(Property property, Element propertyElement) {
        ArrayList<PropertyDataFile> dataFiles = new ArrayList<PropertyDataFile>();
        ArrayList<MSPropertyDataFile> settingsDataFiles = new ArrayList<MSPropertyDataFile>();
        if (property.getDataFiles() == null) {
            return;
        }
        MSPropertyDataFile parentFile = null;
        if (property instanceof MassSpecProperty) {
            MassSpecMetaData settings = ((MassSpecProperty)property).getMassSpecMetaData();
            if (settings != null) {
                boolean fullMS = false;
                PropertyDataFile rawFile = this.getRawFile(property, false);
                String sRawFileName = rawFile == null ? "" : rawFile.getName();
                String sVersion = rawFile == null ? "1.0" : rawFile.getVersion();
                String sType = rawFile == null ? MSFileInfo.getType((String)"MS", (String)"RAW") : rawFile.getType();
                parentFile = MSPropertyDataFile.getCurrentVersionFileFromLegacyVersion(sRawFileName, sVersion, sType);
                parentFile.setIsParent(true);
                MSPropertyDataFile extractFile = null;
                for (PropertyDataFile propertyDataFile : property.getDataFiles()) {
                    if (propertyDataFile.getType().equals("lockfile")) {
                        dataFiles.add(propertyDataFile);
                        continue;
                    }
                    if (propertyDataFile.getType().equals(MSFileInfo.getType((String)"MS", (String)"RAW")) || propertyDataFile.getType().equals(MSFileInfo.getType((String)"MSFULL", (String)"RAW"))) continue;
                    if (propertyDataFile.getType().equals("details")) {
                        dataFiles.add(propertyDataFile);
                        continue;
                    }
                    if (propertyDataFile.getType().equals(MSFileInfo.getType((String)"MSFULL", (String)"mzML")) || propertyDataFile.getType().equals(MSFileInfo.getType((String)"MSFULL", (String)"mzXML"))) {
                        fullMS = true;
                        continue;
                    }
                    if (propertyDataFile.getType().equals("ThermoExtract")) {
                        extractFile = MSPropertyDataFile.getCurrentVersionFileFromLegacyVersion(propertyDataFile.getName(), propertyDataFile.getVersion(), propertyDataFile.getType());
                        continue;
                    }
                    MSPropertyDataFile newDataFile = MSPropertyDataFile.getCurrentVersionFileFromLegacyVersion(propertyDataFile.getName(), propertyDataFile.getVersion(), propertyDataFile.getType());
                    if (newDataFile == null) continue;
                    parentFile.addChild(newDataFile);
                }
                MSPropertyDataFile parentFile2 = null;
                PropertyDataFile fullMSFile = this.getRawFile(property, true);
                if (fullMSFile == null) {
                    if (fullMS) {
                        parentFile2 = MSPropertyDataFile.getCurrentVersionFileFromLegacyVersion("", "1.0", "RAW");
                        parentFile2.setIsParent(true);
                    }
                    if (!fullMS && extractFile != null) {
                        parentFile.addChild(extractFile);
                    }
                } else {
                    parentFile2 = MSPropertyDataFile.getCurrentVersionFileFromLegacyVersion(fullMSFile.getName(), fullMSFile.getVersion(), fullMSFile.getType());
                    parentFile2.setIsParent(true);
                }
                if (parentFile2 != null) {
                    for (PropertyDataFile propertyDataFile : property.getDataFiles()) {
                        if (propertyDataFile.getType().equals("lockfile") || propertyDataFile.getType().equals(MSFileInfo.getType((String)"MS", (String)"RAW")) || propertyDataFile.getType().equals(MSFileInfo.getType((String)"MSFULL", (String)"RAW")) || propertyDataFile.getType().equals("details") || propertyDataFile.getType().equals(MSFileInfo.getType((String)"MS", (String)"mzML")) || propertyDataFile.getType().equals(MSFileInfo.getType((String)"MS", (String)"mzXML"))) continue;
                        MSPropertyDataFile newDataFile = MSPropertyDataFile.getCurrentVersionFileFromLegacyVersion(propertyDataFile.getName(), propertyDataFile.getVersion(), propertyDataFile.getType());
                        parentFile2.addChild(newDataFile);
                    }
                    settingsDataFiles.add(parentFile2);
                }
                settingsDataFiles.add(parentFile);
                settings.setFileList(settingsDataFiles);
            }
            property.getDataFiles().clear();
            property.setDataFiles(dataFiles);
        }
    }

    private void updateMassSpecMetaData(Property property, Element propertyElement) {
        MassSpecMetaData settings;
        if (property instanceof MassSpecProperty && (settings = ((MassSpecProperty)property).getMassSpecMetaData()) != null) {
            String settingsFilePath = String.valueOf(this.getMSFolder(propertyElement)) + File.separator + ((MassSpecProperty)property).getMSSettingsFile().getName();
            MassSpecProperty.updateMSSettings(settings, settingsFilePath);
        }
    }

    private PropertyDataFile getRawFile(Property property, boolean isFull) {
        for (PropertyDataFile file : property.getDataFiles()) {
            if (isFull && file.getType().equals(MSFileInfo.getType((String)"MSFULL", (String)"RAW"))) {
                return file;
            }
            if (isFull || !file.getType().equals(MSFileInfo.getType((String)"MS", (String)"RAW"))) continue;
            return file;
        }
        return null;
    }

    protected static MassSpecMetaData getMassSpecMetaDataFromXML(String xmlString) {
        MassSpecMetaData metaData = (MassSpecMetaData)XMLUtils.getObjectFromXML((String)xmlString, MassSpecPreference.class);
        return metaData;
    }
}

