/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.views.tabbed;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.editor.IEntryEditorPart;
import org.grits.toolbox.datamodel.ms.preference.MassSpecViewerPreference;
import org.grits.toolbox.datamodel.ms.tablemodel.FillTypes;
import org.grits.toolbox.datamodel.ms.tablemodel.MassSpecTableDataObject;
import org.grits.toolbox.display.control.spectrum.chart.GRITSChartComposite;
import org.grits.toolbox.display.control.spectrum.chart.GRITSJFreeChart;
import org.grits.toolbox.display.control.spectrum.chart.GRITSSpectralViewerChart;
import org.grits.toolbox.display.control.spectrum.chart.GRITSSpectralViewerData;
import org.grits.toolbox.display.control.spectrum.datamodel.MSIonData;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.entry.ms.exceptions.MSException;
import org.grits.toolbox.entry.ms.extquantfiles.process.CustomAnnotationDataProcessor;
import org.grits.toolbox.entry.ms.extquantfiles.process.QuantFileProcessor;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotationPeak;
import org.grits.toolbox.entry.ms.process.loader.MassSpecTableDataProcessor;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecSpectraControlPanelView;
import org.grits.toolbox.ms.file.extquant.data.QuantPeakMatch;
import org.grits.toolbox.ms.file.reader.impl.MzXmlReader;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.utils.io.MzXMLFileReader;
import org.jfree.chart.JFreeChart;

public class MassSpecSpectraView
implements IEntryEditorPart {
    public static final String VIEW_ID = "plugin.ms.views.MSSpectraView";
    private static final Logger logger = Logger.getLogger(MassSpecSpectraView.class);
    protected Composite parent = null;
    protected String sMzXMLFile = null;
    protected Integer iScanNum = null;
    protected String sDescription = null;
    protected Double dMz = null;
    protected Integer iMSLevel = null;
    protected MassSpecTableDataProcessor peakListTableProcessor = null;
    protected MassSpecTableDataProcessor scanListtableProcessor = null;
    protected Composite compositeTop = null;
    protected Composite compositeBottom = null;
    protected MSSpectraViewerSashForm sashForm = null;
    protected MassSpecSpectraControlPanelView controlPanel = null;
    protected Boolean bIsCentroid = false;
    protected GRITSSpectralViewerChart svChart = null;
    protected GRITSJFreeChart jFreeChart = null;
    protected GRITSChartComposite chartComposite = null;
    protected Entry entry;
    private MPart part;

    @Inject
    public MassSpecSpectraView(@Optional Entry entry) {
        this.entry = entry;
    }

    public Entry getEntry() {
        return this.entry;
    }

    public boolean isLoaded() {
        return this.svChart != null;
    }

    public void setPeakListTableProcessor(MassSpecTableDataProcessor tableProcessor) {
        this.peakListTableProcessor = tableProcessor;
    }

    public MassSpecTableDataProcessor getPeakListTableProcessor() {
        return this.peakListTableProcessor;
    }

    public void setScanListTableProcessor(MassSpecTableDataProcessor tableProcessor) {
        this.scanListtableProcessor = tableProcessor;
    }

    public MassSpecTableDataProcessor getScanListTableProcessor() {
        return this.scanListtableProcessor;
    }

    public GRITSSpectralViewerChart getSpectralViewerChart() {
        return this.svChart;
    }

    public boolean isSameRunAs(String _sMzXMLFile) {
        if (this.sMzXMLFile == null || _sMzXMLFile == null) {
            return false;
        }
        return this.sMzXMLFile.equals(_sMzXMLFile);
    }

    public Composite getView() {
        return this.sashForm;
    }

    public GRITSChartComposite getChart() {
        return this.chartComposite;
    }

    public void setDescription(String sDescription) {
        this.sDescription = sDescription;
    }

    public void setMzXMLFile(String sMzXMLFile) {
        this.sMzXMLFile = sMzXMLFile;
    }

    public void setScanNum(Integer iScanNum) {
        this.iScanNum = iScanNum;
    }

    public void setMSLevel(Integer iMSLevel) {
        this.iMSLevel = iMSLevel;
    }

    public void setMz(Double dMz) {
        this.dMz = dMz;
    }

    protected ArrayList<MSIonData> getCurrentScanDataTIM() {
        MzXmlReader reader = null;
        ArrayList<MSIonData> alIons = new ArrayList<MSIonData>();
        try {
            reader = new MzXmlReader();
            List scans = reader.readMzXmlFileForTIM(this.sMzXMLFile);
            int i = 0;
            while (i < scans.size()) {
                Scan scan = (Scan)scans.get(i);
                if (scan != null && scan.getPrecursor() != null) {
                    MSIonData ion = new MSIonData(scan.getPrecursor().getMz().doubleValue(), scan.getPrecursor().getIntensity().doubleValue());
                    alIons.add(ion);
                }
                ++i;
            }
            this.bIsCentroid = true;
            return alIons;
        }
        catch (Exception ex) {
            reader = null;
            logger.error((Object)"General Exception in getCurrentScanData.", (Throwable)ex);
            return null;
        }
    }

    protected boolean needsTIMLoad() throws MSException {
        block8: {
            try {
                org.systemsbiology.jrap.grits.stax.Scan scan = null;
                if (this.iScanNum != null && this.iScanNum > 0) break block8;
                MzXMLFileReader reader = null;
                try {
                    reader = new MzXMLFileReader(this.sMzXMLFile);
                }
                catch (IOException e) {
                    reader = null;
                    logger.error((Object)"IO Exception in getCurrentScanData.", (Throwable)e);
                }
                catch (Exception ex) {
                    reader = null;
                    logger.error((Object)"General Exception in getCurrentScanData.", (Throwable)ex);
                }
                if (reader == null) {
                    throw new MSException(3);
                }
                scan = reader.getFirstMS1Scan();
                if (scan == null) {
                    return true;
                }
            }
            catch (MSException e) {
                throw e;
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return false;
    }

    protected ArrayList<MSIonData> getCurrentScanData() throws MSException {
        double[][] massIntList;
        block17: {
            MassSpecEntityProperty prop = null;
            if (this.entry != null && this.entry.getProperty() instanceof MassSpecEntityProperty) {
                prop = (MassSpecEntityProperty)this.entry.getProperty();
            }
            if (this.iScanNum == null || this.iScanNum <= 0) {
                if (prop.getMassSpecParentProperty().getMassSpecMetaData().getMsExperimentType().equals("Total Ion Mapping (TIM)") && (prop.getMassSpecParentProperty().getMassSpecMetaData().getMzXMLFullFileName() == null || prop.getMassSpecParentProperty().getMassSpecMetaData().getMzXMLFullFileName().equals(""))) {
                    return this.getCurrentScanDataTIM();
                }
                if (prop.getMassSpecParentProperty().getMassSpecMetaData().getMsExperimentType().equals("Direct Infusion") && this.needsTIMLoad()) {
                    return this.getCurrentScanDataTIM();
                }
            }
            MzXMLFileReader reader = null;
            try {
                reader = new MzXMLFileReader(this.sMzXMLFile);
            }
            catch (IOException e) {
                reader = null;
                logger.error((Object)"IO Exception in getCurrentScanData.", (Throwable)e);
            }
            catch (Exception ex) {
                reader = null;
                logger.error((Object)"General Exception in getCurrentScanData.", (Throwable)ex);
            }
            if (reader == null) {
                return null;
            }
            org.systemsbiology.jrap.grits.stax.Scan scan = null;
            if (this.iScanNum == null || this.iScanNum <= 0) {
                scan = reader.getFirstMS1Scan();
                if (scan == null) {
                    if (prop.getMassSpecParentProperty().getMassSpecMetaData().getMzXMLFullFileName() != null) {
                        throw new Exception("Ah ah. Not implemented");
                    }
                    throw new MSException(1);
                }
            } else {
                scan = reader.getScan(this.iScanNum.intValue());
            }
            if (scan == null) {
                throw new MSException(4);
            }
            this.iScanNum = scan.getHeader().getNum();
            this.bIsCentroid = scan.getHeader().getCentroided() == 1;
            massIntList = scan.getMassIntensityList();
            if (massIntList != null && massIntList.length != 0) break block17;
            return null;
        }
        try {
            return this.convertMS(massIntList);
        }
        catch (MSException e) {
            throw e;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private ArrayList<MSIonData> convertMS(double[][] _massIntList) {
        try {
            ArrayList<MSIonData> alData = new ArrayList<MSIonData>(_massIntList.length);
            int i = 0;
            while (i < _massIntList[0].length) {
                MSIonData ionData = new MSIonData(_massIntList[0][i], _massIntList[1][i]);
                alData.add(ionData);
                ++i;
            }
            return alData;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    @PostConstruct
    public void postConstruct(Composite parent, MPart part) {
        this.parent = parent;
        this.part = part;
    }

    @Focus
    public void setFocus() {
    }

    public void setPartName(String partName) {
        this.part.setLabel(partName);
    }

    protected GRITSSpectralViewerData initSpectralViewerData() throws MSException {
        try {
            GRITSSpectralViewerData svd = new GRITSSpectralViewerData();
            ArrayList<MSIonData> alRawData = this.getCurrentScanData();
            if (alRawData == null || alRawData.isEmpty()) {
                return svd;
            }
            svd.setRawData(alRawData);
            this.setScanListTableData(svd);
            this.setPeakListTableData(svd);
            return svd;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    protected void setScanListTableData(GRITSSpectralViewerData svd) throws MSException {
        try {
            ArrayList<MSIonData> alPickedPeaks = new ArrayList<MSIonData>();
            HashMap<Double, List<Object>> htPickedPeakLabels = new HashMap<Double, List<Object>>();
            svd.setPickedPeaks(alPickedPeaks);
            svd.setPickedPeakLabels(htPickedPeakLabels);
            if (this.getScanListTableProcessor() == null || svd == null) {
                return;
            }
            MassSpecTableDataObject msTable = this.getScanListTableProcessor().getSimianTableDataObject();
            if (msTable.getMzCols() == null || msTable.getMzCols().isEmpty()) {
                return;
            }
            int i = 0;
            while (i < msTable.getTableData().size()) {
                GRITSListDataRow alRow = (GRITSListDataRow)msTable.getTableData().get(i);
                Double dMz = null;
                Double dIntensity = null;
                Integer iScanNo = null;
                boolean bIsPrecursor = false;
                try {
                    dMz = (Double)alRow.getDataRow().get((Integer)msTable.getMzCols().get(0));
                    dIntensity = (Double)alRow.getDataRow().get((Integer)msTable.getPeakIntensityCols().get(0));
                    if (!msTable.getScanNoCols().isEmpty() && alRow.getDataRow().get((Integer)msTable.getScanNoCols().get(0)) != null) {
                        iScanNo = (Integer)alRow.getDataRow().get((Integer)msTable.getScanNoCols().get(0));
                    }
                    String sIsPrecursor = null;
                    if (msTable.getPeakIsPrecursorCols() != null && !msTable.getPeakIsPrecursorCols().isEmpty()) {
                        sIsPrecursor = (String)alRow.getDataRow().get((Integer)msTable.getPeakIsPrecursorCols().get(0));
                    }
                    bIsPrecursor = iScanNo != null || sIsPrecursor != null && sIsPrecursor.equals("Yes");
                }
                catch (Exception ex) {
                    logger.error((Object)"Invalid number format for m/z or intensity in table", (Throwable)ex);
                }
                if (dMz != null && dIntensity != null) {
                    MSIonData msData = new MSIonData(dMz.doubleValue(), dIntensity.doubleValue());
                    if (bIsPrecursor && !alPickedPeaks.contains(msData)) {
                        alPickedPeaks.add(msData);
                        Object oLabel = this.getPeakLabel(dMz, iScanNo);
                        if (oLabel != null) {
                            List<Object> al = null;
                            if (htPickedPeakLabels.containsKey(dMz)) {
                                al = (List)htPickedPeakLabels.get(dMz);
                            } else {
                                al = new ArrayList();
                                htPickedPeakLabels.put(dMz, al);
                            }
                            if (!al.contains(oLabel)) {
                                al.add(oLabel);
                            }
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    protected void setPeakListTableData(GRITSSpectralViewerData svd) throws MSException {
        try {
            ArrayList<MSIonData> alAnnotatedPeaks = new ArrayList<MSIonData>();
            HashMap<Double, List<Object>> htAnnotatedLabels = new HashMap<Double, List<Object>>();
            svd.setAnnotatedPeaks(alAnnotatedPeaks);
            svd.setAnnotatedPeakLabels(htAnnotatedLabels);
            if (this.getPeakListTableProcessor() == null || svd == null) {
                return;
            }
            MassSpecTableDataObject msTable = this.getPeakListTableProcessor().getSimianTableDataObject();
            if (msTable.getMzCols() == null || msTable.getMzCols().isEmpty() || msTable.getFillType() == FillTypes.Scans) {
                return;
            }
            int i = 0;
            while (i < msTable.getTableData().size()) {
                GRITSListDataRow alRow = (GRITSListDataRow)msTable.getTableData().get(i);
                Double dMz = null;
                Double dIntensity = null;
                try {
                    dMz = (Double)alRow.getDataRow().get((Integer)msTable.getMzCols().get(0));
                    dIntensity = (Double)alRow.getDataRow().get((Integer)msTable.getPeakIntensityCols().get(0));
                }
                catch (Exception ex) {
                    logger.error((Object)"Invalid number format for m/z or intensity in table", (Throwable)ex);
                }
                if (dMz != null && dIntensity != null) {
                    MSIonData msData = new MSIonData(dMz.doubleValue(), dIntensity.doubleValue());
                    int iMSLevel = ((MassSpecEntityProperty)this.getPeakListTableProcessor().getSourceProperty()).getMsLevel() - 1;
                    Object oLabel = this.getPeakLabelForSpecialPeaks(dMz, dIntensity, iMSLevel);
                    if (oLabel != null && !alAnnotatedPeaks.contains(msData)) {
                        alAnnotatedPeaks.add(msData);
                        List<Object> al = null;
                        if (htAnnotatedLabels.containsKey(dMz)) {
                            al = (List)htAnnotatedLabels.get(dMz);
                        } else {
                            al = new ArrayList();
                            htAnnotatedLabels.put(dMz, al);
                        }
                        if (!al.contains(oLabel)) {
                            al.add(oLabel);
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    protected Object getPeakLabelForSpecialPeaks(Double dMz, Double dIntensity, int iMSLevel) {
        if (this.getPeakListTableProcessor().getQuantFileProcessors() == null || this.getPeakListTableProcessor().getQuantFileProcessors().isEmpty()) {
            return null;
        }
        for (QuantFileProcessor fp : this.getPeakListTableProcessor().getQuantFileProcessors()) {
            if (!(fp instanceof CustomAnnotationDataProcessor)) continue;
            CustomAnnotationDataProcessor sfp = (CustomAnnotationDataProcessor)fp;
            if (this.iScanNum == null || sfp.getQuantPeakData() == null || sfp.getQuantPeakData().getPeaks() == null || sfp.getQuantPeakMatches() == null || sfp.getQuantPeakMatches().get(this.iScanNum) == null) continue;
            QuantPeakMatch match = null;
            for (QuantPeakMatch qpm : sfp.getQuantPeakMatches().get(this.iScanNum)) {
                if (!(qpm.getMinMz() < dMz) || !(qpm.getMaxMz() > dMz)) continue;
                match = qpm;
                break;
            }
            if (match == null) continue;
            String sLabel = Double.toString(match.getMzMostAbundant());
            MassSpecCustomAnnotationPeak annotatedPeak = sfp.getMassSpecCustomAnnotation().getAnnotatedPeaks().get(match.getMzMostAbundant());
            if (annotatedPeak != null && annotatedPeak.getMSLevel() == iMSLevel) {
                sLabel = match.getMzMostAbundant() + " - " + sfp.getMassSpecCustomAnnotation().getAnnotatedPeaks().get(match.getMzMostAbundant()).getPeakLabel();
            }
            return sLabel;
        }
        return null;
    }

    protected Object getPeakLabel(Double dMz, Integer iScanNo) {
        if (iScanNo == null) {
            return null;
        }
        DecimalFormat df = new DecimalFormat("0.00");
        String sLabel = iScanNo != null ? "Scan: " + iScanNo + ", " + df.format(dMz) : df.format(dMz);
        return sLabel;
    }

    protected GRITSSpectralViewerChart getNewSpectralViewerChart() {
        return new GRITSSpectralViewerChart(this.sDescription, this.iScanNum.intValue(), this.iMSLevel.intValue(), this.bIsCentroid == false, false);
    }

    protected void initializeChartData() throws MSException {
        try {
            GRITSSpectralViewerData svd = this.initSpectralViewerData();
            if (svd == null || svd.getRawData() == null || svd.getRawData().isEmpty()) {
                throw new MSException(2);
            }
            this.svChart = this.getNewSpectralViewerChart();
            this.controlPanel.enableComponents(svd);
            this.svChart.setSpectralViewerData(svd);
        }
        catch (MSException ex) {
            throw ex;
        }
        catch (Exception e) {
            logger.error((Object)"Error initializing chart data.", (Throwable)e);
            this.svChart = null;
        }
    }

    protected void updatePrefs() {
        MassSpecViewerPreference pref = (MassSpecViewerPreference)this.getScanListTableProcessor().getSimianTableDataObject().getTablePreferences();
        pref.setShowRaw(this.controlPanel.getShowSpectra().getSelection());
        pref.setShowPicked(this.controlPanel.getPickedPeaks().getSelection());
        pref.setShowPickedLabels(this.controlPanel.getPickedPeakLabels().getSelection());
        pref.setShowAnnotated(this.controlPanel.getAnnotatedPeaks().getSelection());
        pref.setShowAnnotatedLabels(this.controlPanel.getAnnotatedPeakLabels().getSelection());
        pref.writePreference();
    }

    protected void initializeChartPlot() {
        MassSpecViewerPreference pref = (MassSpecViewerPreference)this.getScanListTableProcessor().getSimianTableDataObject().getTablePreferences();
        this.controlPanel.getShowSpectra().setSelection(pref.isShowRaw());
        this.controlPanel.getAnnotatedPeaks().setSelection(pref.isShowAnnotated());
        if (this.controlPanel.getAnnotatedPeaks().getSelection()) {
            this.controlPanel.getAnnotatedPeaks().setEnabled(true);
            this.controlPanel.getAnnotatedPeakLabels().setEnabled(true);
            this.controlPanel.getAnnotatedPeakLabels().setSelection(pref.isShowAnnotatedLabels());
        }
        this.controlPanel.getPickedPeaks().setSelection(pref.isShowPicked());
        if (this.controlPanel.getPickedPeaks().getSelection()) {
            this.controlPanel.getPickedPeaks().setEnabled(true);
            this.controlPanel.getPickedPeakLabels().setEnabled(true);
            this.controlPanel.getPickedPeakLabels().setSelection(pref.isShowPickedLabels());
        }
        this.jFreeChart = this.svChart.createChart();
    }

    public void updateChartPlot() {
        MassSpecSpectraControlPanelView cp = this.controlPanel;
        this.svChart.updateChart(cp.showRaw(), cp.showPickedPeaks(), cp.showPickedPeakLabels(), cp.showAnnotatedPeaks(), cp.showAnnotatedPeakLabels(), false, false);
        this.updatePrefs();
    }

    protected MassSpecSpectraControlPanelView getNewSpectraControlPanel() {
        this.part.getContext().set(MassSpecSpectraView.class, (Object)this);
        MassSpecSpectraControlPanelView cp = (MassSpecSpectraControlPanelView)ContextInjectionFactory.make(MassSpecSpectraControlPanelView.class, (IEclipseContext)this.part.getContext());
        return cp;
    }

    public MassSpecSpectraControlPanelView getControlPanel() {
        return this.controlPanel;
    }

    public void createChart(Composite parent) throws MSException {
        this.sashForm = new MSSpectraViewerSashForm(parent, 512, this);
        this.controlPanel = this.getNewSpectraControlPanel();
        this.compositeTop = new Composite((Composite)this.sashForm, 2048);
        this.compositeTop.setLayout((Layout)new GridLayout(1, false));
        this.controlPanel.createPartControl(this.compositeTop);
        this.controlPanel.getShowSpectra().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                MassSpecSpectraView.this.setWeights();
                MassSpecSpectraView.this.controlPanel.cbShowSpectra.removePaintListener((PaintListener)this);
            }
        });
        this.createThisChart();
    }

    protected int[] getSashWeights() {
        int dPrefTopWeight = this.getPrefEntityScrollerWeight();
        int dPrefBotWeight = 1000 - dPrefTopWeight;
        return new int[]{dPrefTopWeight, dPrefBotWeight};
    }

    protected int getPrefEntityScrollerWeight() {
        if (this.compositeTop == null) {
            return 1;
        }
        int iTopHeight = this.controlPanel.getShowSpectra().getSize().y * 4 + 30;
        this.compositeTop.setSize(this.compositeTop.getSize().x, 100);
        int iFormHeight = this.sashForm.getSize().y;
        int iTopWeight = (int)Math.ceil((double)iTopHeight / (double)iFormHeight * 1000.0) + 30;
        return iTopWeight;
    }

    protected void setWeights() {
        int[] dWeights = this.getSashWeights();
        try {
            this.sashForm.setWeights(dWeights);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.debug((Object)("Weight calculation failed: " + dWeights));
            this.sashForm.setWeights(new int[]{10, 90});
        }
    }

    public void createThisChart() throws MSException {
        try {
            if (this.compositeBottom != null) {
                this.compositeBottom.dispose();
            }
            this.compositeBottom = new Composite((Composite)this.sashForm, 2048);
            this.compositeBottom.setLayout((Layout)new GridLayout(1, false));
            GridData gridData = new GridData();
            gridData.verticalAlignment = 4;
            gridData.grabExcessVerticalSpace = true;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.initializeChartData();
            this.initializeChartPlot();
            this.updateChartPlot();
            this.chartComposite = new GRITSChartComposite(this.compositeBottom, 0, (JFreeChart)this.jFreeChart, true);
            this.chartComposite.setMzXMLFile(this.sMzXMLFile);
            this.chartComposite.setScanNum(this.iScanNum);
            this.chartComposite.setLayoutData((Object)gridData);
            this.sashForm.layout(true);
            this.setWeights();
        }
        catch (MSException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"Error parsing mzXML file", (Throwable)e);
        }
    }

    public void createView() throws MSException {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        layout.numColumns = 1;
        this.parent.setLayout((Layout)layout);
        this.createChart(this.parent);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.chartComposite.setLayoutData((Object)gridData);
    }

    public boolean equals(String _sMzXMLFile, Integer _iScanNum) {
        if (this.iScanNum == null || _iScanNum == null) {
            return false;
        }
        return this.isSameRunAs(_sMzXMLFile) && this.iScanNum.equals(_iScanNum);
    }

    public void createPartControl(Composite parent) {
    }

    public void setDirty(boolean b) {
    }

    public boolean isDirty() {
        return false;
    }

    public void setEntry(Entry entry) {
        this.entry = entry;
    }

    public class MSSpectraViewerSashForm
    extends SashForm {
        private MassSpecSpectraView view;

        public MSSpectraViewerSashForm(Composite parent, int style, MassSpecSpectraView view) {
            super(parent, style);
            this.view = view;
        }

        public MassSpecSpectraView getMSSpectraView() {
            return this.view;
        }
    }
}

