/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.util.io.lipid;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.grits.toolbox.tools.gsl.database.lipid.LipidDatabase;

public class LipidDatabaseFileHandler {
    public static final Logger logger = Logger.getLogger(LipidDatabaseFileHandler.class);

    public static void exportXML(String a_strFilename, LipidDatabase a_database) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{LipidDatabase.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)a_database, new File(a_strFilename));
        }
        catch (JAXBException e) {
            logger.error((Object)"An error in export LipidDatabase to XML", (Throwable)e);
        }
    }

    public static LipidDatabase importXML(String a_strFileName) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{LipidDatabase.class});
            Unmarshaller um = context.createUnmarshaller();
            return (LipidDatabase)um.unmarshal((Reader)new FileReader(a_strFileName));
        }
        catch (JAXBException e) {
            logger.error((Object)"An error in importing LipidDatabase from XML.", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"LipidDatabase XML file not found.", (Throwable)e);
        }
        return null;
    }
}

