/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.gelato;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.grits.toolbox.ms.annotation.gelato.AnnotateFragments;
import org.grits.toolbox.ms.annotation.gelato.GelatoUtils;
import org.grits.toolbox.ms.annotation.gelato.GlycanStructureAnnotation;
import org.grits.toolbox.ms.annotation.structure.GlycanStructure;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.FeatureSelection;
import org.grits.toolbox.ms.om.data.GlycanAnnotation;
import org.grits.toolbox.ms.om.data.GlycanFeature;
import org.grits.toolbox.ms.om.data.GlycanScansAnnotation;
import org.grits.toolbox.ms.om.data.IonSettings;
import org.grits.toolbox.ms.om.data.MoleculeSettings;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.ms.om.io.xml.AnnotationWriter;
import org.grits.toolbox.widgets.progress.IProgressListener;
import org.grits.toolbox.widgets.tools.INotifyingProcess;
import org.grits.toolbox.widgets.tools.NotifyingProcessUtil;

public class GlycanMatcher
implements INotifyingProcess {
    private static final Logger logger = Logger.getLogger(GlycanMatcher.class);
    protected GlycanStructureAnnotation parent;
    protected int iScanNum;
    protected Data data;
    protected boolean isCanceled = false;
    protected List<IProgressListener> lProgressListeners;
    protected boolean bCancel = false;

    public GlycanMatcher(GlycanStructureAnnotation parent) {
        this.parent = parent;
    }

    public Data getData() {
        return this.data;
    }

    public int getScanNum() {
        return this.iScanNum;
    }

    public GlycanScansAnnotation getParentScansAnnotation() {
        return this.parent.glycanScanAnnotations;
    }

    protected boolean calculateScores(GlycanScansAnnotation glycanScanAnnotations, GlycanAnnotation annotation, GlycanFeature feature, int iParentScanNum, int iSubScanNum) {
        return GlycanMatcher.calculateScores(this.getData(), this.getParentScansAnnotation(), glycanScanAnnotations, annotation, feature, iParentScanNum, iSubScanNum);
    }

    public static boolean calculateScores(Data data, GlycanScansAnnotation parentScanAnnotations, GlycanScansAnnotation glycanScanAnnotations, GlycanAnnotation annotation, GlycanFeature feature, int iParentScanNum, int iSubScanNum) {
        try {
            double dCountingScore = 0.0;
            double dIntensityScore = 0.0;
            double dRawCountingScore = 0.0;
            double dRawIntensityScore = 0.0;
            if (iParentScanNum > 0 && glycanScanAnnotations.getFragmentScansAnnotations() != null && glycanScanAnnotations.getFragmentScansAnnotations().containsKey(iParentScanNum)) {
                HashMap<String, Integer> uniqueAnnotations = new HashMap<String, Integer>();
                List listFragments = (List)glycanScanAnnotations.getFragmentScansAnnotations().get(iParentScanNum);
                for (Object scansAnnot : listFragments) {
                    if (!scansAnnot.getScanAnnotations().containsKey(iSubScanNum)) continue;
                    for (GlycanFeature f : (List)scansAnnot.getScanAnnotations().get(iSubScanNum)) {
                        uniqueAnnotations.put(((FeatureSelection)f.getFeatureSelections().get(0)).getRowId(), 1);
                    }
                }
                List unfragFeatures = (List)parentScanAnnotations.getScanAnnotations().get(iSubScanNum);
                if (unfragFeatures != null) {
                    for (GlycanFeature f : unfragFeatures) {
                        uniqueAnnotations.put(((FeatureSelection)f.getFeatureSelections().get(0)).getRowId(), 1);
                    }
                }
                double dNumAnnotPeaks = uniqueAnnotations.keySet().size();
                dCountingScore = dNumAnnotPeaks / (double)((Scan)data.getScans().get(iSubScanNum)).getPeaklist().size();
                dRawCountingScore = dNumAnnotPeaks / (double)((Scan)data.getScans().get(iSubScanNum)).getTotalNumPeaks().intValue();
                double annotatedIntensity = 0.0;
                double totalIntensity = 0.0;
                for (Peak p : ((Scan)data.getScans().get(iSubScanNum)).getPeaklist()) {
                    totalIntensity += p.getIntensity().doubleValue();
                }
                if (uniqueAnnotations.keySet() != null && uniqueAnnotations.keySet().size() != 0) {
                    for (Peak p : ((Scan)data.getScans().get(iSubScanNum)).getPeaklist()) {
                        if (p.getIntensity() == null || p.getIntensity() < 0.0) continue;
                        String sPeakId = Integer.toString(p.getId());
                        String sRowId = Feature.getRowId((Integer)p.getId(), (Integer)iSubScanNum);
                        if (!uniqueAnnotations.containsKey(sPeakId) && !uniqueAnnotations.containsKey(sRowId)) continue;
                        annotatedIntensity += p.getIntensity().doubleValue();
                    }
                }
                dIntensityScore = annotatedIntensity / totalIntensity;
                dRawIntensityScore = annotatedIntensity / ((Scan)data.getScans().get(iSubScanNum)).getTotalIntensity();
            }
            annotation.getScores().put(Integer.toString(iSubScanNum), dCountingScore);
            feature.getDoubleProp().put(GlycanStructureAnnotation.countingScoreData.getKey(), dCountingScore);
            feature.getDoubleProp().put(GlycanStructureAnnotation.intensityScoreData.getKey(), dIntensityScore);
            feature.getDoubleProp().put(GlycanStructureAnnotation.rawCountingScoreData.getKey(), dRawCountingScore);
            feature.getDoubleProp().put(GlycanStructureAnnotation.rawIntensityScoreData.getKey(), dRawIntensityScore);
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    protected void handleUnscoredPeak(Peak parentPeak) {
    }

    public List<Integer> getMatchingSubScans(Data data, int iCurScanNum, Peak parentPeak) {
        ArrayList<Integer> iMatchingScans = new ArrayList<Integer>();
        List<Integer> lScans = GelatoUtils.getSubScanForPrecursor(this.getData(), iCurScanNum, parentPeak);
        if (!lScans.isEmpty()) {
            for (Integer iSubScanNum : lScans) {
                iMatchingScans.add(iSubScanNum);
            }
        }
        return iMatchingScans;
    }

    protected boolean scorePeakToFeature(double glycanMz, Glycan glycan, String glycanType, GlycanAnnotation annotation, GlycanScansAnnotation glycanScanAnnotation, GlycanStructure structure, List<IonSettings> lParentAdducts, List<Integer> lParentAdductCounts, int iParentCharge, List<IonSettings> lParentIonExchanges, List<Integer> lParentExchangeCounts, int iParentExchangeCount, List<MoleculeSettings> lParentNeutralLosses, List<Integer> lParentNeutralLossCounts, int iParentNeutralLossCount, AnalyteSettings settings, Peak parentPeak, int iParentScan, String tempPath, AnnotationWriter writer) {
        return GlycanMatcher.scorePeakToFeature(this.getData(), this.getParentScansAnnotation(), glycanMz, glycan, glycanType, annotation, glycanScanAnnotation, structure, lParentAdducts, lParentAdductCounts, iParentCharge, lParentIonExchanges, lParentExchangeCounts, iParentExchangeCount, lParentNeutralLosses, lParentNeutralLossCounts, iParentNeutralLossCount, settings, parentPeak, iParentScan, tempPath, writer);
    }

    public static boolean scorePeakToFeature(Data data, GlycanScansAnnotation parentScansAnnotation, double glycanMz, Glycan glycan, String glycanType, GlycanAnnotation annotation, GlycanScansAnnotation glycanScanAnnotation, GlycanStructure structure, List<IonSettings> lParentAdducts, List<Integer> lParentAdductCounts, int iParentCharge, List<IonSettings> lParentIonExchanges, List<Integer> lParentExchangeCounts, int iParentExchangeCount, List<MoleculeSettings> lParentNeutralLosses, List<Integer> lParentNeutralLossCounts, int iParentNeutralLossCount, AnalyteSettings settings, Peak parentPeak, int iParentScanNum, String tempPath, AnnotationWriter writer) {
        try {
            List<Integer> lScans = GelatoUtils.getSubScanForPrecursor(data, iParentScanNum, parentPeak);
            if (lScans.isEmpty()) {
                GlycanFeature feature = GelatoUtils.getNewGlycanFeature(data, glycan.toString(), parentPeak.getMz(), glycanMz, iParentCharge, glycanType, lParentAdducts, lParentAdductCounts, lParentIonExchanges, lParentExchangeCounts, lParentNeutralLosses, lParentNeutralLossCounts, null, parentPeak.getId(), annotation);
                GlycanMatcher.addAnnotationToScan(data, parentScansAnnotation, iParentScanNum, annotation, structure, feature);
                return false;
            }
            if (glycanScanAnnotation.getFragmentScansAnnotations() == null) {
                glycanScanAnnotation.setFragmentScansAnnotations(new HashMap());
            }
            ArrayList<GlycanScansAnnotation> subScanAnnotations = null;
            if (!glycanScanAnnotation.getFragmentScansAnnotations().containsKey(iParentScanNum)) {
                subScanAnnotations = new ArrayList();
                glycanScanAnnotation.getFragmentScansAnnotations().put(iParentScanNum, subScanAnnotations);
            } else {
                subScanAnnotations = (List)glycanScanAnnotation.getFragmentScansAnnotations().get(iParentScanNum);
            }
            boolean bRes = false;
            for (Integer iSubScanNum : lScans) {
                GlycanFeature feature = GelatoUtils.getNewGlycanFeature(data, glycan.toString(), parentPeak.getMz(), glycanMz, iParentCharge, glycanType, lParentAdducts, lParentAdductCounts, lParentIonExchanges, lParentExchangeCounts, lParentNeutralLosses, lParentNeutralLossCounts, iSubScanNum, parentPeak.getId(), annotation);
                GlycanMatcher.addAnnotationToScan(data, glycanScanAnnotation, iParentScanNum, annotation, structure, feature);
                if (iSubScanNum == null || data.getScans().get(iSubScanNum) == null || ((Scan)data.getScans().get(iSubScanNum)).getPrecursor() == null) continue;
                AnnotateFragments annFragments = new AnnotateFragments(parentScansAnnotation);
                annFragments.annotateFragments(subScanAnnotations, iSubScanNum, feature, structure, lParentAdducts, lParentAdductCounts, iParentCharge, lParentIonExchanges, lParentExchangeCounts, iParentExchangeCount, lParentNeutralLosses, lParentNeutralLossCounts, iParentNeutralLossCount, annotation, structure.getGWBSequence(), data, settings, ((Scan)data.getScans().get(iSubScanNum)).getPrecursor().getId(), tempPath, writer);
                boolean bCurRes = GlycanMatcher.calculateScores(data, parentScansAnnotation, glycanScanAnnotation, annotation, feature, iParentScanNum, iSubScanNum);
                bRes |= bCurRes;
            }
            return bRes;
        }
        catch (Exception e) {
            logger.error((Object)"Error matching glycans in matchGlycanStructure2.", (Throwable)e);
            return false;
        }
    }

    protected Peak getMostAbundantPeak(List<Peak> lPeaks) {
        double dMaxInt = Double.MIN_VALUE;
        Peak maxPeak = null;
        for (Peak peak : lPeaks) {
            if (!(peak.getIntensity() > dMaxInt)) continue;
            dMaxInt = peak.getIntensity();
            maxPeak = peak;
        }
        return maxPeak;
    }

    public static void addAnnotationToScan(Data data, GlycanScansAnnotation glycanScanAnnotations, int iScanNum, GlycanAnnotation anntotation, GlycanStructure structure, GlycanFeature feature) {
        try {
            if (glycanScanAnnotations.getScanAnnotations().get(iScanNum) == null) {
                ArrayList<GlycanFeature> glycanFeature = new ArrayList<GlycanFeature>();
                glycanFeature.add(feature);
                glycanScanAnnotations.getScanAnnotations().put(iScanNum, glycanFeature);
            } else if (!((List)glycanScanAnnotations.getScanAnnotations().get(iScanNum)).contains(feature)) {
                ((List)glycanScanAnnotations.getScanAnnotations().get(iScanNum)).add(feature);
            }
            if (data.getAnnotatedScan().get(iScanNum) == null) {
                ArrayList<String> ids = new ArrayList<String>();
                ids.add(structure.getId());
                data.getAnnotatedScan().put(iScanNum, ids);
            } else if (!((List)data.getAnnotatedScan().get(iScanNum)).contains(structure.getId())) {
                ((List)data.getAnnotatedScan().get(iScanNum)).add(structure.getId());
            }
            if (!data.getAnnotation().contains(anntotation)) {
                data.getAnnotation().add(anntotation);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error matching glycans in matchGlycanStructure.", (Throwable)e);
        }
    }

    public boolean matchGlycanStructure(boolean _polarity, Data _data, int iParentScanNum, GlycanScansAnnotation glycanScanAnnotations, Glycan glycan, GlycanStructure structure, String glycanType, GlycanAnnotation annotation, List<IonSettings> lAdductsToAnalyze, List<Integer> lAdductsToAnalyzeCounts, List<IonSettings> lExchangesToAnalyze, List<Integer> lExchangesToAnalyzeCounts, List<MoleculeSettings> lNeutralLossesToAnalyze, List<Integer> lNeutralLossesToAnalyzeCounts, AnalyteSettings settings, String tempPath, AnnotationWriter writer) {
        try {
            logger.debug((Object)("Structure: " + structure));
            this.data = _data;
            this.iScanNum = iParentScanNum;
            double[] glycanMzAndCharge = GlycanStructureAnnotation.getGlycanMzAndCharge(glycan, settings, lAdductsToAnalyze, lAdductsToAnalyzeCounts, lExchangesToAnalyze, lExchangesToAnalyzeCounts, lNeutralLossesToAnalyze, lNeutralLossesToAnalyzeCounts);
            double glycanMz = glycanMzAndCharge[0];
            int iParentCharge = (int)glycanMzAndCharge[1];
            int iNumParentExchanges = (int)glycanMzAndCharge[2];
            int iNumParentLosses = (int)glycanMzAndCharge[3];
            Scan scan = (Scan)this.getData().getScans().get(this.getScanNum());
            this.setMaxValue(scan.getPeaklist().size());
            boolean bRes = false;
            for (int iPeakInx = 0; iPeakInx < scan.getPeaklist().size(); ++iPeakInx) {
                if (this.isCanceled) {
                    return false;
                }
                Peak aPeak = (Peak)scan.getPeaklist().get(iPeakInx);
                this.updateListeners("Processing peak m/z: " + (aPeak != null ? aPeak.getMz() : "null"), iPeakInx);
                if (scan.getPolarity() != null && !scan.getPolarity().equals(_polarity)) continue;
                int[] iPeakMatchInfo = GelatoUtils.getMatchingPeak(scan, iPeakInx, glycanMz, _data.getDataHeader().getMethod(), true);
                if (iPeakMatchInfo != null && iPeakMatchInfo[1] != -1) {
                    logger.debug((Object)("Glycan: " + glycan + ", glycan m/z: " + glycanMz + ", Scan: " + this.getScanNum()));
                    logger.debug((Object)("\tPeak match:  peak id: " + aPeak.getId() + ", peak m/z: " + aPeak.getMz()));
                    Peak peak = (Peak)scan.getPeaklist().get(iPeakMatchInfo[1]);
                    logger.debug((Object)("\t\tFinal peak id: " + peak.getId() + ", Final peak mz: " + peak.getMz()));
                    if (this.getData().getDataHeader().getMethod().getTrustMzCharge().booleanValue()) {
                        int iPrecursorCharge = -1;
                        if (peak.getPrecursorCharge() != null) {
                            iPrecursorCharge = peak.getPrecursorCharge();
                        }
                        if (iPrecursorCharge != -1 && peak.getPrecursorCharge() != iParentCharge) {
                            this.updateListeners("Processing peak m/z: " + (aPeak != null ? aPeak.getMz() : "null"), iPeakInx + 1);
                            continue;
                        }
                    }
                    bRes = true;
                    boolean bScored = this.scorePeakToFeature(glycanMz, glycan, glycanType, annotation, glycanScanAnnotations, structure, lAdductsToAnalyze, lAdductsToAnalyzeCounts, iParentCharge, lExchangesToAnalyze, lExchangesToAnalyzeCounts, iNumParentExchanges, lNeutralLossesToAnalyze, lNeutralLossesToAnalyzeCounts, iNumParentLosses, settings, peak, this.getScanNum(), tempPath, writer);
                    if (bScored) {
                        logger.debug((Object)"\t\t\tSCORED!");
                        if (!((Scan)this.getData().getScans().get(this.getScanNum())).getAnnotatedPeaks().containsKey(peak.getId()) || !((Boolean)((Scan)this.getData().getScans().get(this.getScanNum())).getAnnotatedPeaks().get(peak.getId())).booleanValue()) {
                            int iNumAnnot = ((Scan)this.getData().getScans().get(this.getScanNum())).getNumAnnotatedPeaks() != null ? ((Scan)this.getData().getScans().get(this.getScanNum())).getNumAnnotatedPeaks() : 0;
                            ((Scan)this.getData().getScans().get(this.getScanNum())).setNumAnnotatedPeaks(Integer.valueOf(iNumAnnot + 1));
                            ((Scan)this.getData().getScans().get(this.getScanNum())).getAnnotatedPeaks().put(peak.getId(), Boolean.TRUE);
                        }
                    }
                    iPeakInx = iPeakMatchInfo[0] - 1;
                    continue;
                }
                this.handleUnscoredPeak(aPeak);
            }
            this.updateListeners("Done!", scan.getPeaklist().size());
            return bRes;
        }
        catch (Exception e) {
            logger.error((Object)"Error matching glycans in matchGlycanStructure.", (Throwable)e);
            return false;
        }
    }

    public void setProgressListeners(List<IProgressListener> lProgressListeners) {
        this.lProgressListeners = lProgressListeners;
    }

    public void addProgressListeners(IProgressListener lProgressListener) {
        this.lProgressListeners.add(lProgressListener);
    }

    public List<IProgressListener> getProgressListeners() {
        return this.lProgressListeners;
    }

    public boolean isCanceled() {
        return this.bCancel;
    }

    public void setCanceled(boolean bCancel) {
        this.bCancel = bCancel;
    }

    public void updateListeners(String _sMsg, int _iVal) {
        NotifyingProcessUtil.updateListeners(this.getProgressListeners(), (String)_sMsg, (int)_iVal);
    }

    public void updateErrorListener(String _sMsg) {
        NotifyingProcessUtil.updateErrorListener(this.getProgressListeners(), (String)_sMsg);
    }

    public void updateErrorListener(String _sMsg, Throwable t) {
        NotifyingProcessUtil.updateErrorListener(this.getProgressListeners(), (String)_sMsg, (Throwable)t);
    }

    public void setMaxValue(int _iVal) {
        NotifyingProcessUtil.setMaxValue(this.getProgressListeners(), (int)_iVal);
    }

    public void setProgressType(IProgressListener.ProgressType progressType) {
        NotifyingProcessUtil.setProgressType(this.getProgressListeners(), (IProgressListener.ProgressType)progressType);
    }
}

