/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.editor;

import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.editor.IEntryEditorPart;

public abstract class EntryEditorPart
implements IEntryEditorPart {
    public static final String EVENT_TOPIC_CONTENT_MODIFIED = "content_modified_in_a_tab";
    protected Entry entry = null;
    protected Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    protected String errMsg = null;
    boolean dirty = false;
    @Inject
    protected IEclipseContext context;
    @Inject
    IEventBroker eventBroker;

    public IEclipseContext getContext() {
        return this.context;
    }

    @Override
    public Entry getEntry() {
        return this.entry;
    }

    @Override
    public void setEntry(Entry entry) {
        this.entry = entry;
    }

    @Override
    public void setDirty(boolean d) {
        this.dirty = d;
        this.eventBroker.send(EVENT_TOPIC_CONTENT_MODIFIED, (Object)this);
    }

    @Persist
    public void doSave(IProgressMonitor monitor) {
        this.updateProjectProperty();
        this.savePreference();
        this.setDirty(false);
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    public Image getTitleImage() {
        return this.entry.getProperty().getImage().createImage();
    }

    protected void setErrorMessage(Label targetLabel, String errMsg) {
        targetLabel.setForeground(this.getParent().getDisplay().getSystemColor(3));
        this.errMsg = errMsg;
    }

    protected void removeError(Label targetLabel) {
        targetLabel.setForeground(this.getParent().getDisplay().getSystemColor(2));
    }

    protected boolean checkBasicLengthCheck(Label tagetLabel, Text targetText, int min, int max) {
        if (tagetLabel.getFont().equals((Object)this.boldFont)) {
            if (targetText.getText().length() == min) {
                this.setErrorMessage(tagetLabel, "Please provide a name for " + tagetLabel.getText());
                return false;
            }
        } else if (targetText.getText().length() > max) {
            this.setErrorMessage(tagetLabel, String.valueOf(tagetLabel.getText()) + " cannot be longer than " + max + " characters");
            return false;
        }
        return true;
    }

    protected boolean checkValidDouble(Label label, String input) {
        try {
            double a = Double.parseDouble(input);
            if (a < 0.0) {
                this.setErrorMessage(label, "Invalid number. Please use a positive number.");
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(label, "Invalid format. Please use a number.");
            return false;
        }
        this.removeError(label);
        return true;
    }

    protected Label setMandatoryLabel(Label lable) {
        lable.setText(String.valueOf(lable.getText()) + "*");
        lable.setFont(this.boldFont);
        return lable;
    }

    protected abstract void updateProjectProperty();

    protected abstract void savePreference();

    protected abstract Composite getParent();
}

