/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.projectexplorer.dialog;

import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.DataModelHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.dialog.ModalDialog;
import org.grits.toolbox.core.utilShare.ListenerFactory;
import org.grits.toolbox.core.utilShare.validator.EntryNameValidator;

public class NewProjectDialog
extends ModalDialog {
    private static final Logger logger = Logger.getLogger(NewProjectDialog.class);
    private Text projectNameText = null;
    private String projectName = null;
    private Label projectNameLabel = null;
    private Text descriptionText = null;
    private String description = null;
    private Label descriptionLabel = null;
    private Entry workspaceEntry = null;
    private Set<String> existingNames = null;
    private Button okButton = null;

    public NewProjectDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("New Project");
        this.setMessage("To create a new project");
        this.okButton.setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        logger.debug((Object)"START : Opening the new Project Dialog");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.verticalSpacing = 10;
        parent.setLayout((Layout)gridLayout);
        GridData projectNameData = new GridData();
        this.projectNameLabel = new Label(parent, 0);
        this.projectNameLabel.setText("Name");
        this.projectNameLabel = this.setMandatoryLabel(this.projectNameLabel);
        this.projectNameLabel.setLayoutData((Object)projectNameData);
        GridData projectNameTextData = new GridData();
        projectNameTextData.grabExcessHorizontalSpace = true;
        projectNameTextData.horizontalAlignment = 4;
        projectNameTextData.horizontalSpan = 3;
        this.projectNameText = new Text(parent, 2048);
        this.projectNameText.setLayoutData((Object)projectNameTextData);
        this.workspaceEntry = DataModelHandler.instance().getRoot();
        this.existingNames = EntryNameValidator.getExistingNames(this.workspaceEntry, "org.grits.toolbox.property.project", null);
        this.projectNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewProjectDialog.this.okButton.setEnabled(NewProjectDialog.this.isValidInput());
            }
        });
        GridData descriptionData = new GridData();
        this.descriptionLabel = new Label(parent, 0);
        this.descriptionLabel.setText("Description");
        this.descriptionLabel.setLayoutData((Object)descriptionData);
        GridData descriptionTextData = new GridData();
        descriptionTextData.minimumHeight = 80;
        descriptionTextData.grabExcessHorizontalSpace = true;
        descriptionTextData.grabExcessVerticalSpace = true;
        descriptionTextData.horizontalAlignment = 4;
        descriptionTextData.horizontalSpan = 3;
        this.descriptionText = new Text(parent, 2562);
        this.descriptionText.setLayoutData((Object)descriptionTextData);
        this.descriptionText.addTraverseListener(ListenerFactory.getTabTraverseListener());
        this.descriptionText.addKeyListener(ListenerFactory.getCTRLAListener());
        this.createSeparator(4);
        this.createButtonCancel(parent);
        this.okButton = this.createButtonOK(parent);
        logger.debug((Object)"END   : Opening the new Project Dialog");
        return parent;
    }

    @Override
    protected boolean isValidInput() {
        if (!this.checkBasicLengthCheck(this.projectNameLabel, this.projectNameText, 0, 32)) {
            return false;
        }
        String errorMessage = EntryNameValidator.validateProjectName(this.existingNames, this.projectNameText.getText().trim());
        if (errorMessage != null) {
            this.setError(this.projectNameLabel, errorMessage);
            return false;
        }
        this.removeError(this.projectNameLabel);
        return this.checkBasicLengthCheck(this.descriptionLabel, this.descriptionText, 0, Integer.parseInt(PropertyHandler.getVariable("descriptionLength")));
    }

    protected void okPressed() {
        this.saveInput();
    }

    protected void saveInput() {
        this.projectName = this.projectNameText.getText().trim();
        this.description = this.descriptionText.getText().trim();
    }

    @Override
    public Entry createEntry() {
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public String getProjectName() {
        return this.projectName;
    }
}

