/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.io.ms.annotation.glycan.process.export;

import java.io.File;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.log4j.Logger;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.io.ms.annotation.process.export.MSAnnotationExportDatabaseProcess;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.util.structure.glycan.database.GlycanDatabase;
import org.grits.toolbox.util.structure.glycan.database.GlycanStructure;
import org.grits.toolbox.widgets.processDialog.ProgressDialog;
import org.grits.toolbox.widgets.progress.IProgressThreadHandler;

public class MSGlycanAnnotationExportDatabaseProcess
extends MSAnnotationExportDatabaseProcess {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationExportDatabaseProcess.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean threadStart(IProgressThreadHandler a_progressThreadHandler) throws Exception {
        try {
            GlycanDatabase database = new GlycanDatabase();
            database.setName(this.getDbName());
            database.setDescription(this.getDescription());
            database.setVersion(this.getVersion());
            ArrayList<GlycanStructure> structures = new ArrayList<GlycanStructure>();
            database.setStructures(structures);
            ((ProgressDialog)a_progressThreadHandler).setMax(this.tableDataObject.getTableData().size());
            ((ProgressDialog)a_progressThreadHandler).setProcessMessageLabel("Exporting data");
            int cnt = 1;
            int i = 0;
            while (true) {
                if (i >= this.getTableDataObject().getTableData().size()) {
                    database.setStructureCount(Integer.valueOf(structures.size()));
                    ((ProgressDialog)a_progressThreadHandler).setMax(database.getStructureCount().intValue());
                    ((ProgressDialog)a_progressThreadHandler).setProcessMessageLabel("Exporting data");
                    this.saveDatabase(database, this.getOutputFile());
                    return true;
                }
                if (this.isCanceled()) {
                    return false;
                }
                int iParentScanIdCol = -1;
                if (this.getTableDataObject().getParentNoCol() != null && !this.getTableDataObject().getParentNoCol().isEmpty()) {
                    iParentScanIdCol = (Integer)this.getTableDataObject().getParentNoCol().get(0);
                }
                int iPeakIdCol = (Integer)this.getTableDataObject().getPeakIdCols().get(0);
                int iFeatureIdCol = (Integer)this.getTableDataObject().getFeatureIdCols().get(0);
                Integer iParentScanNum = null;
                if (this.getMasterParentScan() != -1) {
                    iParentScanNum = this.getMasterParentScan();
                } else if (iParentScanIdCol != -1 && ((GRITSListDataRow)this.getTableDataObject().getTableData().get(i)).getDataRow().get(iParentScanIdCol) != null) {
                    iParentScanNum = (Integer)((GRITSListDataRow)this.getTableDataObject().getTableData().get(i)).getDataRow().get(iParentScanIdCol);
                }
                Integer iPeakId = (Integer)((GRITSListDataRow)this.getTableDataObject().getTableData().get(i)).getDataRow().get(iPeakIdCol);
                String sFeatureId = (String)((GRITSListDataRow)this.getTableDataObject().getTableData().get(i)).getDataRow().get(iFeatureIdCol);
                if (sFeatureId != null || !this.hideUnAnnotatedRows()) {
                    Integer iScanNum = null;
                    if (this.getTableDataObject().getScanNoCols() != null && !this.getTableDataObject().getScanNoCols().isEmpty()) {
                        iScanNum = (Integer)this.getTableDataObject().getScanNoCols().get(0);
                    }
                    String iRowId = Feature.getRowId((Integer)iPeakId, iScanNum);
                    if (iPeakId == null || sFeatureId == null || iParentScanNum == null || !this.getTableDataObject().isHiddenRow(iParentScanNum, iRowId, sFeatureId)) {
                        boolean bInvisible = false;
                        if (iPeakId != null && iParentScanNum != null && this.getTableDataObject().isInvisibleRow(iParentScanNum, iRowId)) {
                            bInvisible = true;
                        }
                        if (!bInvisible) {
                            int sequenceCol = (Integer)this.getTableDataObject().getSequenceCols().get(0);
                            String sequence = (String)((GRITSListDataRow)this.getTableDataObject().getTableData().get(i)).getDataRow().get(sequenceCol);
                            if (sequence != null && !sequence.isEmpty()) {
                                int iInx1 = sequence.indexOf("~|~");
                                if (iInx1 < 0) {
                                    GlycanStructure structure = new GlycanStructure();
                                    structure.setGWBSequence(sequence);
                                    structure.setId(String.valueOf(cnt));
                                    ++cnt;
                                    structures.add(structure);
                                } else {
                                    String sRemaining = sequence;
                                    do {
                                        String sSeq = iInx1 > 0 ? sRemaining.substring(0, iInx1) : sRemaining;
                                        GlycanStructure structure = new GlycanStructure();
                                        structure.setGWBSequence(sSeq);
                                        structure.setId(String.valueOf(cnt));
                                        ++cnt;
                                        structures.add(structure);
                                        sRemaining = iInx1 > 0 ? sRemaining.substring(iInx1 + "~|~".length()) : null;
                                        int n = iInx1 = sRemaining != null ? sRemaining.indexOf("~|~") : -1;
                                    } while (sRemaining != null);
                                }
                            }
                        }
                        ((ProgressDialog)a_progressThreadHandler).updateProgresBar("Scan: " + (i + 1));
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void saveDatabase(GlycanDatabase database, String filePath) throws JAXBException {
        JAXBContext t_context = JAXBContext.newInstance((Class[])new Class[]{GlycanDatabase.class});
        Marshaller t_marshaller = t_context.createMarshaller();
        t_context = JAXBContext.newInstance((Class[])new Class[]{GlycanDatabase.class});
        t_marshaller = t_context.createMarshaller();
        t_marshaller.setProperty("jaxb.formatted.output", (Object)true);
        t_marshaller.marshal((Object)database, new File(filePath));
    }
}

