/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.preference;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanAnnotationPreference;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanAnnotationSettingsPreference;
import org.grits.toolbox.entry.ms.annotation.glycan.util.PreferenceUtils;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.preference.MSGlycanAnnotationSettingsPreferenceWizard;

public class MSGlycanAnnotationPreferencePage
extends PreferencePage {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationPreferencePage.class);
    protected MSGlycanAnnotationSettingsPreference preferences = null;
    private MSGlycanAnnotationPreference currentSetting = null;
    private GridLayout gridLayout;
    private Combo cmbSelectSetting;
    private Button btnEditCurrent;
    private Button btnDeleteCurrent;
    private Button btnCreateNew;
    private Button btnExport;
    private Button btnImport;

    public MSGlycanAnnotationPreferencePage() {
        this.loadWorkspacePreferences();
    }

    protected Control createContents(Composite parent) {
        this.initGridLayout();
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)this.gridLayout);
        this.addSelectSettingsItem(container);
        this.addExportCurrent(container);
        this.addDeleteCurrent(container);
        this.addEditCurrent(container);
        this.addCreateNewItem(container);
        this.addImport(container);
        this.setEditEnabled(false);
        return parent;
    }

    protected void initGridLayout() {
        this.gridLayout = new GridLayout(6, false);
    }

    protected void addSelectSettingsItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        Label lblSelectSetting = new Label(parent, 0);
        lblSelectSetting.setText("Current Settings");
        lblSelectSetting.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false, 5, 1);
        this.cmbSelectSetting = new Combo(parent, 8);
        this.cmbSelectSetting.setLayoutData((Object)gd2);
        this.initStoredSettingList();
        this.cmbSelectSetting.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MSGlycanAnnotationPreferencePage.this.processSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void processSelection() {
        this.setEditEnabled(false);
        if (!this.cmbSelectSetting.getText().trim().equals("")) {
            this.setEditEnabled(true);
            MSGlycanAnnotationPreference selSetting = this.getCurrentSetting(this.cmbSelectSetting.getText());
            if (selSetting == null) {
                return;
            }
            this.currentSetting = selSetting;
        }
    }

    public void setEditEnabled(boolean _bVal) {
        this.btnDeleteCurrent.setEnabled(_bVal);
        this.btnEditCurrent.setEnabled(_bVal);
        this.btnExport.setEnabled(_bVal);
    }

    protected void initStoredSettingList() {
        this.cmbSelectSetting.removeAll();
        this.cmbSelectSetting.add("");
        if (this.preferences != null && this.preferences.getPreferenceList() != null) {
            for (MSGlycanAnnotationPreference setting : this.preferences.getPreferenceList()) {
                this.cmbSelectSetting.add(setting.getName());
            }
        }
    }

    protected void addDeleteCurrent(Composite parent) {
        GridData gd3 = new GridData(4, 4, false, false, 1, 1);
        this.btnDeleteCurrent = new Button(parent, 0);
        this.btnDeleteCurrent.setText("Delete Selected");
        this.btnDeleteCurrent.setLayoutData((Object)gd3);
        this.btnDeleteCurrent.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                int iSelInx = MSGlycanAnnotationPreferencePage.this.cmbSelectSetting.getSelectionIndex();
                if (iSelInx == 0) {
                    return;
                }
                boolean bVal = MessageDialog.openConfirm((Shell)MSGlycanAnnotationPreferencePage.this.getShell(), (String)"Delete Selected?", (String)"Delete selected. Are you sure?");
                if (bVal) {
                    MSGlycanAnnotationPreference setting = MSGlycanAnnotationPreferencePage.this.getCurrentSetting(MSGlycanAnnotationPreferencePage.this.cmbSelectSetting.getItem(iSelInx));
                    if (setting == null) {
                        return;
                    }
                    MSGlycanAnnotationPreferencePage.this.preferences.remove(setting);
                    MSGlycanAnnotationPreferencePage.this.cmbSelectSetting.remove(iSelInx);
                    MSGlycanAnnotationPreferencePage.this.currentSetting = null;
                    MSGlycanAnnotationPreferencePage.this.clearValues();
                    MSGlycanAnnotationPreferencePage.this.setEditEnabled(false);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    protected MSGlycanAnnotationPreference getCurrentSetting(String settingName) {
        if (this.preferences == null || this.preferences.getPreferenceList() == null) {
            return null;
        }
        int i = 0;
        while (i < this.preferences.getPreferenceList().size()) {
            MSGlycanAnnotationPreference curSetting = (MSGlycanAnnotationPreference)this.preferences.getPreferenceList().get(i);
            if (curSetting.getName().equals(settingName)) {
                return curSetting;
            }
            ++i;
        }
        return null;
    }

    protected void addEditCurrent(final Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.btnEditCurrent = new Button(parent, 0);
        this.btnEditCurrent.setText("Edit Selected");
        this.btnEditCurrent.setLayoutData((Object)gd1);
        this.btnEditCurrent.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                MSGlycanAnnotationSettingsPreferenceWizard wizard = MSGlycanAnnotationPreferencePage.this.getMSAnnotationSettingsPreferenceWizard(MSGlycanAnnotationPreferencePage.this.currentSetting);
                WizardDialog dialog = new WizardDialog(parent.getShell(), (IWizard)wizard);
                try {
                    if (dialog.open() == 0) {
                        MSGlycanAnnotationPreferencePage.this.preferences.getPreferenceList().remove(MSGlycanAnnotationPreferencePage.this.currentSetting);
                        MSGlycanAnnotationPreferencePage.this.currentSetting = wizard.getPreferences();
                        MSGlycanAnnotationPreferencePage.this.preferences.getPreferenceList().add(MSGlycanAnnotationPreferencePage.this.currentSetting);
                    }
                }
                catch (Exception e1) {
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                    ErrorUtils.createErrorMessageBox((Shell)MSGlycanAnnotationPreferencePage.this.getShell(), (String)"Exception", (Exception)e1);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    protected void addCreateNewItem(final Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.btnCreateNew = new Button(parent, 0);
        this.btnCreateNew.setText("Create New");
        this.btnCreateNew.setLayoutData((Object)gd1);
        this.btnCreateNew.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                MSGlycanAnnotationPreferencePage.this.setEditEnabled(false);
                MSGlycanAnnotationPreferencePage.this.clearValues();
                IInputValidator myValidator = new IInputValidator(){

                    public String isValid(String newText) {
                        if ((this).MSGlycanAnnotationPreferencePage.this.preferences != null) {
                            for (MSGlycanAnnotationPreference setting : (this).MSGlycanAnnotationPreferencePage.this.preferences.getPreferenceList()) {
                                if (!newText.equals(setting.getName())) continue;
                                return "Already exists! Please choose a different name";
                            }
                        }
                        return null;
                    }
                };
                InputDialog nameDialog = new InputDialog(parent.getShell(), "Preference Name", "Please enter a name for the new preference setting", "", myValidator);
                if (nameDialog.open() == 0) {
                    String preferenceName = nameDialog.getValue();
                    if (preferenceName == null) {
                        return;
                    }
                    MSGlycanAnnotationSettingsPreferenceWizard wizard = MSGlycanAnnotationPreferencePage.this.getMSAnnotationSettingsPreferenceWizard(preferenceName);
                    WizardDialog dialog = new WizardDialog(parent.getShell(), (IWizard)wizard);
                    try {
                        if (dialog.open() == 0) {
                            MSGlycanAnnotationPreferencePage.this.currentSetting = wizard.getPreferences();
                            MSGlycanAnnotationPreferencePage.this.preferences.getPreferenceList().add(MSGlycanAnnotationPreferencePage.this.currentSetting);
                            MSGlycanAnnotationPreferencePage.this.cmbSelectSetting.add(MSGlycanAnnotationPreferencePage.this.currentSetting.getName());
                            MSGlycanAnnotationPreferencePage.this.cmbSelectSetting.select(MSGlycanAnnotationPreferencePage.this.cmbSelectSetting.getItemCount() - 1);
                        }
                    }
                    catch (Exception e1) {
                        logger.error((Object)e1.getMessage(), (Throwable)e1);
                        ErrorUtils.createErrorMessageBox((Shell)MSGlycanAnnotationPreferencePage.this.getShell(), (String)"Exception", (Exception)e1);
                    }
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    private void addImport(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.btnImport = new Button(parent, 0);
        this.btnImport.setText("Import");
        this.btnImport.setLayoutData((Object)gd1);
        this.btnImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(MSGlycanAnnotationPreferencePage.this.getShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.xml"});
                String fileName = dialog.open();
                if (fileName != null && !fileName.isEmpty()) {
                    try {
                        String line;
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(fileName));
                        String xmlString = "";
                        while ((line = bufferedReader.readLine()) != null) {
                            xmlString = String.valueOf(xmlString) + line + "\n";
                        }
                        bufferedReader.close();
                        MSGlycanAnnotationPreference newPref = (MSGlycanAnnotationPreference)PreferenceUtils.unmarshallFromXML((String)xmlString, MSGlycanAnnotationPreference.class);
                        if (newPref != null) {
                            for (MSGlycanAnnotationPreference setting : MSGlycanAnnotationPreferencePage.this.preferences.getPreferenceList()) {
                                if (!newPref.getName().equals(setting.getName())) continue;
                                MessageDialog.openInformation((Shell)MSGlycanAnnotationPreferencePage.this.getShell(), (String)"Info", (String)"Already exists! Updating the existing");
                                setting.setMethod(newPref.getMethod());
                                return;
                            }
                            MSGlycanAnnotationPreferencePage.this.preferences.getPreferenceList().add(newPref);
                            MSGlycanAnnotationPreferencePage.this.cmbSelectSetting.add(newPref.getName());
                            MSGlycanAnnotationPreferencePage.this.cmbSelectSetting.select(MSGlycanAnnotationPreferencePage.this.cmbSelectSetting.getItemCount() - 1);
                            MSGlycanAnnotationPreferencePage.this.currentSetting = newPref;
                        }
                    }
                    catch (FileNotFoundException e1) {
                        MessageDialog.openError((Shell)MSGlycanAnnotationPreferencePage.this.getShell(), (String)"Error", (String)"Selected file cannot be found");
                        logger.error((Object)"Selected file cannot be found", (Throwable)e1);
                    }
                    catch (IOException e1) {
                        MessageDialog.openError((Shell)MSGlycanAnnotationPreferencePage.this.getShell(), (String)"Error", (String)"Selected file cannot be opened");
                        logger.error((Object)"Selected file Selected file cannot be opened", (Throwable)e1);
                    }
                    catch (JAXBException e1) {
                        MessageDialog.openError((Shell)MSGlycanAnnotationPreferencePage.this.getShell(), (String)"Error", (String)"Selected file does not contain a valid preference");
                        logger.error((Object)"Selected file does not contain a valid preference", (Throwable)e1);
                    }
                }
            }
        });
    }

    private void addExportCurrent(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.btnExport = new Button(parent, 0);
        this.btnExport.setText("Export");
        this.btnExport.setLayoutData((Object)gd1);
        this.btnExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MSGlycanAnnotationPreferencePage.this.currentSetting != null) {
                    FileDialog dialog = new FileDialog(MSGlycanAnnotationPreferencePage.this.getShell(), 8192);
                    dialog.setOverwrite(true);
                    dialog.setFileName(String.valueOf(MSGlycanAnnotationPreferencePage.this.currentSetting.getName()) + ".xml");
                    dialog.setFilterExtensions(new String[]{"*.xml"});
                    String fileName = dialog.open();
                    if (fileName != null && !fileName.isEmpty()) {
                        try {
                            String xmlString = PreferenceUtils.marshalXML((Object)MSGlycanAnnotationPreferencePage.this.currentSetting);
                            FileWriter fileWriter = new FileWriter(fileName);
                            fileWriter.write(xmlString);
                            fileWriter.close();
                        }
                        catch (IOException e1) {
                            logger.error((Object)("Could not write the selected preference settings to the given file: " + fileName), (Throwable)e1);
                            MessageDialog.openError((Shell)MSGlycanAnnotationPreferencePage.this.getShell(), (String)"Error", (String)("Could not write the selected preference settings to the given file: " + fileName));
                        }
                        catch (JAXBException e1) {
                            logger.error((Object)("Could not write the selected preference settings to the given file: " + fileName), (Throwable)e1);
                            MessageDialog.openError((Shell)MSGlycanAnnotationPreferencePage.this.getShell(), (String)"Error", (String)("Could not write the selected preference settings to the given file: " + fileName));
                        }
                    }
                }
            }
        });
    }

    protected void clearValues() {
        this.cmbSelectSetting.select(0);
    }

    protected void addSeparatorLine1(Composite parent) {
        GridData gd1 = new GridData(4, 4, true, false, 6, 1);
        Label lblSeparator = new Label(parent, 258);
        lblSeparator.setLayoutData((Object)gd1);
    }

    protected void performApply() {
        this.save();
    }

    public boolean performOk() {
        this.save();
        return true;
    }

    protected void save() {
        try {
            logger.debug((Object)"Time to save values!");
            this.preferences.saveValues();
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    protected void performDefaults() {
        boolean load = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Are you sure?", (String)"This will remove all the preferences you've created and load the default ones if any. Do you want to continue?");
        if (load) {
            this.preferences = new MSGlycanAnnotationSettingsPreference();
            this.preferences.loadDefaults();
            this.initStoredSettingList();
            this.setEditEnabled(false);
        }
    }

    protected boolean loadWorkspacePreferences() {
        try {
            this.preferences = PreferenceUtils.getMSGlycanAnnotationSettingsPreferences((PreferenceEntity)MSGlycanAnnotationSettingsPreference.getPreferenceEntity(), MSGlycanAnnotationSettingsPreference.class);
        }
        catch (Exception ex) {
            logger.error((Object)"Error getting the mass spec preferences", (Throwable)ex);
        }
        return this.preferences != null;
    }

    protected MSGlycanAnnotationSettingsPreferenceWizard getMSAnnotationSettingsPreferenceWizard(MSGlycanAnnotationPreference setting) {
        return new MSGlycanAnnotationSettingsPreferenceWizard(setting);
    }

    protected MSGlycanAnnotationSettingsPreferenceWizard getMSAnnotationSettingsPreferenceWizard(String preferenceName) {
        return new MSGlycanAnnotationSettingsPreferenceWizard(preferenceName);
    }
}

