/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard;

import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.utilShare.SelectionInterface;
import org.grits.toolbox.core.utilShare.TextFieldUtils;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.ExperimentSelectionAdapter;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.MSGlycanAnnotationWizard;
import org.grits.toolbox.ms.annotation.filter.Filter;

public class GeneralInformation
extends WizardPage
implements SelectionInterface {
    protected final Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    private Text txtExp;
    private Text txtName;
    private Text txtDesc;
    private MSGlycanAnnotationWizard myWizard;
    private boolean readyToFinish = false;
    private String displayName = "";
    private String annDescription = "";

    public GeneralInformation(MSGlycanAnnotationWizard wizard, List<Filter> preFilters) {
        super("wizardPage");
        this.setTitle("General Information");
        this.setDescription("Input general information");
        this.myWizard = wizard;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(3, false));
        Label lblMsExperiment = new Label(container, 0);
        lblMsExperiment.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblMsExperiment.setText("MS Experiment");
        this.txtExp = new Text(container, 2056);
        this.txtExp.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnBrowse = new Button(container, 0);
        btnBrowse.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnBrowse.setText("Browse");
        this.myWizard.getMSEntries();
        ExperimentSelectionAdapter sampleProjectSelectionAdapter = new ExperimentSelectionAdapter();
        sampleProjectSelectionAdapter.setParent(container);
        sampleProjectSelectionAdapter.setParentWindow(this);
        btnBrowse.addSelectionListener((SelectionListener)sampleProjectSelectionAdapter);
        Label lblDisplayName = new Label(container, 0);
        lblDisplayName.setText("Display Name");
        lblDisplayName = this.setMandatoryLabel(lblDisplayName);
        this.txtName = new Text(container, 2048);
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralInformation.this.setDisplayName(GeneralInformation.this.txtName.getText().trim());
                if (GeneralInformation.this.validateInput()) {
                    GeneralInformation.this.canFlipToNextPage();
                    GeneralInformation.this.getWizard().getContainer().updateButtons();
                } else {
                    GeneralInformation.this.readyToFinish = false;
                    GeneralInformation.this.canFlipToNextPage();
                    GeneralInformation.this.getWizard().getContainer().updateButtons();
                }
            }
        });
        this.txtName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label lblDescription = new Label(container, 0);
        lblDescription.setText("Description");
        this.txtDesc = new Text(container, 2050);
        this.txtDesc.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralInformation.this.annDescription = GeneralInformation.this.txtDesc.getText().trim();
            }
        });
        GridData gd_txtDesc = new GridData(4, 0x1000000, true, false, 2, 1);
        gd_txtDesc.heightHint = 66;
        this.txtDesc.setLayoutData((Object)gd_txtDesc);
        this.setControl((Control)container);
        this.setControl((Control)container);
        this.setPageComplete(false);
    }

    protected Label setMandatoryLabel(Label lable) {
        lable.setText(String.valueOf(lable.getText()) + "*");
        lable.setFont(this.boldFont);
        return lable;
    }

    public IWizardPage getNextPage() {
        return super.getNextPage();
    }

    public boolean validateInput() {
        if (TextFieldUtils.isEmpty((Text)this.txtExp)) {
            this.setErrorMessage("Please select MS Experiment");
            return false;
        }
        if (TextFieldUtils.isEmpty((Text)this.txtName)) {
            this.setErrorMessage("Please input display name");
            return false;
        }
        this.setErrorMessage(null);
        this.readyToFinish = true;
        return true;
    }

    public boolean canFlipToNextPage() {
        return this.readyToFinish;
    }

    public void updateComponent(SelectionAdapter adapter) {
        if (adapter instanceof ExperimentSelectionAdapter) {
            this.txtExp.setText(((ExperimentSelectionAdapter)adapter).getEntry().getDisplayName());
            if (this.validateInput()) {
                this.canFlipToNextPage();
                this.getWizard().getContainer().updateButtons();
            } else {
                this.readyToFinish = false;
                this.canFlipToNextPage();
                this.getWizard().getContainer().updateButtons();
            }
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getAnnDescription() {
        return this.annDescription;
    }

    public void setAnnDescription(String annDescription) {
        this.annDescription = annDescription;
    }
}

