/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard;

import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanAnnotationPreference;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanAnnotationSettingsPreference;
import org.grits.toolbox.entry.ms.annotation.glycan.util.FileUtils;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.AddAdductsForm;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.AddIonExchangeForm;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.AddNeutralLossForm;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.FragmentSettingsForm;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.GeneralInformationMulti;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.GlycanSettingsForm;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.util.structure.glycan.filter.om.FiltersLibrary;
import org.grits.toolbox.util.structure.glycan.util.FilterUtils;

public class MSGlycanAnnotationWizard
extends Wizard {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationWizard.class);
    protected GeneralInformationMulti initial = null;
    protected GlycanSettingsForm glycanSettingsForm = null;
    protected AddAdductsForm ionSettingsForm = null;
    protected FragmentSettingsForm fragmentSettingsForm = null;
    protected AddIonExchangeForm ionExchangeForm = null;
    protected AddNeutralLossForm neutralLossForm = null;
    protected List<Entry> msEntries = null;
    protected Method method = null;
    protected MSGlycanAnnotationPreference preferences = null;
    protected FiltersLibrary filterLibrary;

    public MSGlycanAnnotationWizard() {
        this.setWindowTitle("MS Annotation");
        this.method = new Method();
        try {
            this.filterLibrary = FilterUtils.readFilters((String)this.getDefaultFiltersPath());
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"Error getting the filters", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Error getting the filters", (Throwable)e);
        }
        catch (JAXBException e) {
            logger.error((Object)"Error getting the filters", (Throwable)e);
        }
    }

    public MSGlycanAnnotationPreference getPreferences() {
        return this.preferences;
    }

    public void setPreferences(MSGlycanAnnotationPreference preferences) {
        this.preferences = preferences;
        this.glycanSettingsForm.updateControlsFromPreferences();
        this.fragmentSettingsForm.updateControlsFromPreferences();
        this.ionSettingsForm.updateControlsFromPreferences();
        this.ionExchangeForm.updateControlsFromPreferences();
        this.neutralLossForm.updateControlsFromPreferences();
    }

    public FragmentSettingsForm getFragmentSettings() {
        return this.fragmentSettingsForm;
    }

    public AddIonExchangeForm getIonExchangeForm() {
        return this.ionExchangeForm;
    }

    public AddNeutralLossForm getNeutralLossForm() {
        return this.neutralLossForm;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public GlycanSettingsForm getGlycanSettingsForm() {
        return this.glycanSettingsForm;
    }

    public void setGlycanSettingsForm(GlycanSettingsForm one) {
        this.glycanSettingsForm = one;
    }

    public AddAdductsForm getIonSettingsForm() {
        return this.ionSettingsForm;
    }

    public void setIonSettingsForm(AddAdductsForm two) {
        this.ionSettingsForm = two;
    }

    public GeneralInformationMulti getInitial() {
        return this.initial;
    }

    public void setInitial(GeneralInformationMulti initial) {
        this.initial = initial;
    }

    public void addPages() {
        this.initial = new GeneralInformationMulti(this.msEntries);
        try {
            this.initial.loadPreferences(MSGlycanAnnotationSettingsPreference.class, MSGlycanAnnotationSettingsPreference.getPreferenceEntity());
        }
        catch (UnsupportedVersionException e) {
            logger.error((Object)"Could not load preferences", (Throwable)e);
        }
        this.glycanSettingsForm = new GlycanSettingsForm(this.method, this, this.filterLibrary);
        this.fragmentSettingsForm = new FragmentSettingsForm(this.method);
        this.ionSettingsForm = new AddAdductsForm(this.method);
        this.ionExchangeForm = new AddIonExchangeForm(this.method);
        this.neutralLossForm = new AddNeutralLossForm(this.method);
        this.addPage((IWizardPage)this.initial);
        this.addPage((IWizardPage)this.glycanSettingsForm);
        this.addPage((IWizardPage)this.fragmentSettingsForm);
        this.addPage((IWizardPage)this.ionSettingsForm);
        this.addPage((IWizardPage)this.ionExchangeForm);
        this.addPage((IWizardPage)this.neutralLossForm);
    }

    public boolean canFinish() {
        if (!this.glycanSettingsForm.canFinish()) {
            return false;
        }
        this.glycanSettingsForm.save();
        if (!this.fragmentSettingsForm.canFinish()) {
            return false;
        }
        this.fragmentSettingsForm.save();
        if (!this.ionSettingsForm.canFlipToNextPage()) {
            return false;
        }
        this.ionSettingsForm.save();
        if (!this.ionExchangeForm.canFlipToNextPage()) {
            return false;
        }
        this.ionExchangeForm.save();
        if (!this.neutralLossForm.isPageComplete()) {
            return false;
        }
        this.neutralLossForm.save();
        return this.ionSettingsForm.isPageComplete() && this.initial.canFlipToNextPage() && this.glycanSettingsForm.canFlipToNextPage() && this.fragmentSettingsForm.canFinish() && this.ionExchangeForm.isPageComplete() && this.neutralLossForm.isPageComplete();
    }

    public boolean performFinish() {
        boolean bCanFinish = this.canFinish();
        return bCanFinish;
    }

    public List<Entry> getMSEntries() {
        return this.msEntries;
    }

    public void setMSEntries(List<Entry> msEntries) {
        this.msEntries = msEntries;
    }

    public String getDefaultFiltersPath() {
        return FileUtils.getFilterPath();
    }
}

