/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.dialog.ProjectExplorerDialog;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.utilShare.EntrySelectionAdapter;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.GeneralInformationMulti;

public class MassSpecChooserDialog
extends EntrySelectionAdapter {
    private Grid entryDialogGrid = null;
    private HashMap<String, String> listEntries = null;
    private List<Entry> entries = null;
    private String annotationMethod;

    public MassSpecChooserDialog(String a_propertyType, String a_dialogTitle, String a_dialogMessage, String a_strAnnotMethod) {
        super(a_propertyType, a_dialogTitle, a_dialogMessage);
        this.annotationMethod = a_strAnnotMethod;
    }

    public static String getDisplayNameByEntryName(String _sEntryId) {
        Entry root = PropertyHandler.getDataModel().getRoot();
        return MassSpecChooserDialog.getDisplayNameByEntryName(_sEntryId, root);
    }

    public static String getDisplayNameByEntryName(String _sEntryId, Entry root) {
        ArrayList<Entry> alStack = new ArrayList<Entry>();
        alStack.add(root);
        while (!alStack.isEmpty()) {
            Entry curEntry = (Entry)alStack.remove(0);
            boolean cfr_ignored_0 = curEntry.getProperty() instanceof MassSpecProperty;
            List children = curEntry.getChildren();
            for (Entry child : children) {
                alStack.add(child);
            }
        }
        return null;
    }

    public void widgetSelected(SelectionEvent event) {
        Entry entry;
        Shell newShell = new Shell(this.parent.getShell(), 0x10008000);
        ProjectExplorerDialog dlg = new ProjectExplorerDialog(newShell);
        dlg.addFilter("org.grits.toolbox.property.ms");
        dlg.setTitle("Mass Spec Selection");
        dlg.setMessage("Choose an MS Experiment to add");
        if (dlg.open() == 0 && (entry = dlg.getEntry()) != null) {
            String displayName = entry.getDisplayName();
            if (displayName == null) {
                throw new NullPointerException("Unable to determine display name for entry: " + entry.getDisplayName());
            }
            if (this.listEntries.isEmpty()) {
                this.addToList(entry, displayName);
            } else if (!this.listEntries.containsKey(displayName)) {
                this.addToList(entry, displayName);
            }
        }
    }

    private boolean sameParent(Entry entry, String type) {
        Entry myParent;
        Entry curParent = DataModelSearch.findParentByType((Entry)this.entries.get(0), (String)type);
        return curParent.equals(myParent = DataModelSearch.findParentByType((Entry)entry, (String)type));
    }

    private void addToList(Entry entry, String name) {
        String stamp = GeneralInformationMulti.getAnnotationPostfix(this.annotationMethod);
        this.listEntries.put(name, String.valueOf(name) + stamp);
        GridItem item = new GridItem(this.entryDialogGrid, 0);
        item.setText(0, name);
        item.setText(1, String.valueOf(name) + stamp);
        this.entryDialogGrid.setSelection(this.entryDialogGrid.getItemCount() - 1);
        this.entries.add(entry);
        this.entryDialogGrid.notifyListeners(24, null);
    }

    public void setList(Grid entryDialogGrid) {
        this.entryDialogGrid = entryDialogGrid;
    }

    public void setListEntries(HashMap<String, String> listEntries) {
        this.listEntries = listEntries;
    }

    public void setEntries(List<Entry> simGLycanEntryList) {
        this.entries = simGLycanEntryList;
    }
}

