/*
 * Decompiled with CFR 0.152.
 */
package org.jat.generation.internal.helpers;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;

public class ImageConverter {
    private static final PaletteData PALETTE_DATA = new PaletteData(0xFF0000, 65280, 255);

    public static Image convert(BufferedImage srcImage) {
        ImageData swtImageData = new ImageData(srcImage.getWidth(), srcImage.getHeight(), 24, PALETTE_DATA);
        int scansize = (srcImage.getWidth() * 3 + 3) * 4 / 4;
        WritableRaster alphaRaster = srcImage.getAlphaRaster();
        byte[] alphaBytes = new byte[srcImage.getWidth()];
        int y = 0;
        while (y < srcImage.getHeight()) {
            int[] buff = srcImage.getRGB(0, y, srcImage.getWidth(), 1, null, 0, scansize);
            swtImageData.setPixels(0, y, srcImage.getWidth(), buff, 0);
            if (alphaRaster != null) {
                int[] alpha = alphaRaster.getPixels(0, y, srcImage.getWidth(), 1, (int[])null);
                int i = 0;
                while (i < srcImage.getWidth()) {
                    alphaBytes[i] = (byte)alpha[i];
                    ++i;
                }
                swtImageData.setAlphas(0, y, srcImage.getWidth(), alphaBytes, 0);
            }
            ++y;
        }
        return new Image((Device)PlatformUI.getWorkbench().getDisplay(), swtImageData);
    }

    public static BufferedImage convert(Image srcImage) {
        ImageData imageData = srcImage.getImageData();
        int width = imageData.width;
        int height = imageData.height;
        ImageData maskData = null;
        int[] alpha = new int[1];
        if (imageData.alphaData == null) {
            maskData = imageData.getTransparencyMask();
        }
        BufferedImage image = new BufferedImage(imageData.width, imageData.height, 2);
        WritableRaster alphaRaster = image.getAlphaRaster();
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int color = imageData.getPixel(x, y);
                color = ImageConverter.translateColor(imageData, color);
                image.setRGB(x, y, color);
                if (alphaRaster != null) {
                    if (imageData.alphaData != null) {
                        alpha[0] = imageData.getAlpha(x, y);
                        alphaRaster.setPixel(x, y, alpha);
                    } else if (maskData != null) {
                        alpha[0] = maskData.getPixel(x, y) == 0 ? 0 : 255;
                        alphaRaster.setPixel(x, y, alpha);
                    }
                }
                ++x;
            }
            ++y;
        }
        return image;
    }

    private static int translateColor(ImageData imageData, int color) {
        int bitCount = imageData.depth;
        RGB[] rgb = imageData.getRGBs();
        if (bitCount == 1 || bitCount == 4 || bitCount == 8) {
            if (rgb != null) {
                Color foo = new Color(rgb[color].red, rgb[color].green, rgb[color].blue);
                color = foo.getRGB();
            } else {
                color = 0;
            }
        } else if (bitCount == 16) {
            int BLUE_MASK = 31;
            int GREEN_MASK = 992;
            int RED_MASK = 31744;
            color = ImageConverter.applyRGBMask(color, RED_MASK, GREEN_MASK, BLUE_MASK);
        } else if (bitCount == 24) {
            int blue = (color & 0xFF0000) >> 16;
            int green = (color & 0xFF00) >> 8;
            int red = color & 0xFF;
            Color foo = new Color(red, green, blue);
            color = foo.getRGB();
        } else if (bitCount == 32) {
            int blue = (color & 0xFF000000) >>> 24;
            int green = (color & 0xFF0000) >> 16;
            int red = (color & 0xFF00) >> 8;
            Color foo = new Color(red, green, blue);
            color = foo.getRGB();
        }
        return color;
    }

    private static int applyRGBMask(int color, int redMask, int greenMask, int blueMask) {
        int shiftCount = ImageConverter.getShiftCount(redMask);
        int maskSize = ImageConverter.countBits(redMask);
        int red = (color & redMask) >>> shiftCount;
        red = red * 255 / ((int)Math.pow(2.0, maskSize) - 1);
        shiftCount = ImageConverter.getShiftCount(greenMask);
        maskSize = ImageConverter.countBits(greenMask);
        int green = (color & greenMask) >>> shiftCount;
        green = green * 255 / ((int)Math.pow(2.0, maskSize) - 1);
        shiftCount = ImageConverter.getShiftCount(blueMask);
        maskSize = ImageConverter.countBits(blueMask);
        int blue = (color & blueMask) >>> shiftCount;
        blue = blue * 255 / ((int)Math.pow(2.0, maskSize) - 1);
        Color foo = new Color(red, green, blue);
        color = foo.getRGB();
        return color;
    }

    private static int getShiftCount(int mask) {
        int count = 0;
        while (mask != 0 && (mask & 1) == 0) {
            mask >>>= 1;
            ++count;
        }
        return count;
    }

    private static int countBits(int mask) {
        int count = 0;
        int index = 0;
        while (index < 32) {
            if ((mask & 1) != 0) {
                ++count;
            }
            mask >>>= 1;
            ++index;
        }
        return count;
    }
}

