/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.preference;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.preference.PreferenceHandler;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.core.preference.share.PreferenceReader;
import org.grits.toolbox.core.preference.share.PreferenceWriter;
import org.grits.toolbox.core.utilShare.XMLUtils;
import org.grits.toolbox.entry.ms.preference.IMSPreferenceWithCustomAnnotation;
import org.grits.toolbox.entry.ms.preference.IMSPreferenceWithStandardQuant;
import org.grits.toolbox.entry.ms.preference.MassSpecPreferenceLoader;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotation;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotationTemplate;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecStandardQuant;
import org.grits.toolbox.ms.om.data.Method;

@XmlRootElement(name="massSpecPreferences")
public class MassSpecPreference
implements IMSPreferenceWithCustomAnnotation,
IMSPreferenceWithStandardQuant {
    private static final Logger logger = Logger.getLogger(MassSpecPreference.class);
    private static final String PREFERENCE_NAME_ALL = "org.grits.toolbox.entry.ms.all";
    private static final String CURRENT_VERSION = "1.2";
    private static final String DEFAULT_ADDUCT_FILE = "msSettings.adductType.xml";
    private static final String DEFAULT_COLLISION_FILE = "msSettings.collisionType.xml";
    private static final String DEFAULT_DERIVITIZATION_FILE = "msSettings.derivType.xml";
    private static final String DEFAULT_GLYCAN_FILE = "msSettings.glycanType.xml";
    private static final String DEFAULT_RELEASE_FILE = "msSettings.releaseType.xml";
    private static final String VALUE_SEPERATOR = "~~~~~";
    private String derivatizationType = null;
    private Set<String> allDerivatizationTypes = null;
    private String collisionType = null;
    private Set<String> allCollisionTypes = null;
    private String adductType = null;
    private Set<String> allAdductTypes = null;
    private String releaseType = null;
    private Set<String> allReleaseTypes = null;
    private String glycanType = null;
    private Set<String> allGlycanTypes = null;
    private String instrument = "";
    private Double collisionEnergy = 30.0;
    private String experimentType = null;
    private Set<String> allExperimentTypes = null;
    private List<MassSpecCustomAnnotation> customAnnotations = new ArrayList<MassSpecCustomAnnotation>();
    private String customAnnotationsText = null;
    private List<MassSpecStandardQuant> standardQuantList = new ArrayList<MassSpecStandardQuant>();
    private String standardQuantText = null;

    public String getExperimentType() {
        return this.experimentType;
    }

    @XmlAttribute(name="experimentType")
    public void setExperimentType(String experimentType) {
        this.experimentType = experimentType;
    }

    public Set<String> getAllExperimentTypes() {
        return this.allExperimentTypes;
    }

    @XmlTransient
    public void setAllExperimentTypes(Set<String> allExperimentTypes) {
        this.allExperimentTypes = allExperimentTypes;
    }

    public String getAdductType() {
        return this.adductType;
    }

    @XmlAttribute(name="adductType")
    public void setAdductType(String adductType) {
        this.adductType = adductType;
    }

    public Set<String> getAllAdductTypes() {
        return this.allAdductTypes;
    }

    @XmlTransient
    public void setAllAdductTypes(Set<String> allAdductTypes) {
        this.allAdductTypes = allAdductTypes;
    }

    public String getCollisionType() {
        return this.collisionType;
    }

    @XmlAttribute(name="collisionType")
    public void setCollisionType(String collisionType) {
        this.collisionType = collisionType;
    }

    public Set<String> getAllCollisionTypes() {
        return this.allCollisionTypes;
    }

    @XmlTransient
    public void setAllCollisionTypes(Set<String> allCollisionTypes) {
        this.allCollisionTypes = allCollisionTypes;
    }

    public String getDerivatizationType() {
        return this.derivatizationType;
    }

    @XmlAttribute(name="derivType")
    public void setDerivatizationType(String derivatizationType) {
        this.derivatizationType = derivatizationType;
    }

    public Set<String> getAllDerivatizationTypes() {
        return this.allDerivatizationTypes;
    }

    @XmlTransient
    public void setAllDerivatizationTypes(Set<String> allDerivatizationTypes) {
        this.allDerivatizationTypes = allDerivatizationTypes;
    }

    public String getGlycanType() {
        return this.glycanType;
    }

    @XmlAttribute(name="glycanType")
    public void setGlycanType(String glycanType) {
        this.glycanType = glycanType;
    }

    public Set<String> getAllGlycanTypes() {
        return this.allGlycanTypes;
    }

    @XmlTransient
    public void setAllGlycanTypes(Set<String> allGlycanTypes) {
        this.allGlycanTypes = allGlycanTypes;
    }

    public String getReleaseType() {
        return this.releaseType;
    }

    @XmlAttribute(name="releaseType")
    public void setReleaseType(String releaseType) {
        this.releaseType = releaseType;
    }

    public Set<String> getAllReleaseTypes() {
        return this.allReleaseTypes;
    }

    @XmlTransient
    public void setAllReleaseTypes(Set<String> allReleaseTypes) {
        this.allReleaseTypes = allReleaseTypes;
    }

    public String getInstrument() {
        return this.instrument;
    }

    @XmlAttribute(name="instrument")
    public void setInstrument(String instrument) {
        this.instrument = instrument;
    }

    public Double getCollisionEnergy() {
        return this.collisionEnergy;
    }

    @XmlAttribute(name="collisionEnergy")
    public void setCollisionEnergy(Double collisionEnergy) {
        this.collisionEnergy = collisionEnergy;
    }

    @Override
    public List<MassSpecCustomAnnotation> getCustomAnnotations() {
        return this.customAnnotations;
    }

    @XmlTransient
    public void setCustomAnnotations(List<MassSpecCustomAnnotation> customAnnotations) {
        this.customAnnotations = customAnnotations;
    }

    public String getCustomAnnotationText() {
        return this.customAnnotationsText;
    }

    @XmlAttribute(name="customAnnotationsText")
    public void setCustomAnnotationText(String customAnnotationsText) {
        this.customAnnotationsText = customAnnotationsText;
    }

    public static MassSpecCustomAnnotation lookupCustomAnnotation(List<MassSpecCustomAnnotation> customAnnotations, String annotationName) {
        if (customAnnotations != null && !customAnnotations.isEmpty()) {
            int i = 0;
            while (i < customAnnotations.size()) {
                MassSpecCustomAnnotation annotation = customAnnotations.get(i);
                if (annotation.getAnnotationName().equalsIgnoreCase(annotationName)) {
                    return annotation;
                }
                ++i;
            }
        }
        return null;
    }

    public static String createCustomAnnotationsText(MassSpecCustomAnnotation annotation) {
        annotation.updateAnnotatedPeakText();
        String asText = XMLUtils.marshalObjectXML((Object)annotation);
        return asText;
    }

    public static String createCustomAnnotationsText(List<MassSpecCustomAnnotation> customAnnotations) {
        StringBuilder sb = new StringBuilder();
        int iAnnotCnt = 0;
        if (customAnnotations != null && !customAnnotations.isEmpty()) {
            int i = 0;
            while (i < customAnnotations.size()) {
                MassSpecCustomAnnotation annotation = customAnnotations.get(i);
                if (annotation != null) {
                    if (iAnnotCnt > 0) {
                        sb.append(VALUE_SEPERATOR);
                    }
                    String sXML = MassSpecPreference.createCustomAnnotationsText(annotation);
                    sb.append(sXML);
                    ++iAnnotCnt;
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public static List<MassSpecCustomAnnotation> unmarshalCustomAnnotationsList(String sCustomAnnotationText) {
        ArrayList<MassSpecCustomAnnotation> msca = new ArrayList<MassSpecCustomAnnotation>();
        try {
            if (sCustomAnnotationText != null) {
                String[] annotations;
                if (sCustomAnnotationText.startsWith(VALUE_SEPERATOR)) {
                    int iStartPos = sCustomAnnotationText.indexOf(VALUE_SEPERATOR) + VALUE_SEPERATOR.length();
                    sCustomAnnotationText = sCustomAnnotationText.substring(iStartPos);
                }
                if (!sCustomAnnotationText.equals("") && (annotations = sCustomAnnotationText.split(VALUE_SEPERATOR)) != null && annotations.length > 0) {
                    int i = 0;
                    while (i < annotations.length) {
                        String annotXML = annotations[i];
                        MassSpecCustomAnnotation annotation = (MassSpecCustomAnnotation)XMLUtils.getObjectFromXML((String)annotXML, MassSpecCustomAnnotation.class);
                        if (annotation != null) {
                            annotation.unmarshalAnnotatedPeakList();
                            msca.add(annotation);
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error loading default options from xml files.", (Throwable)ex);
        }
        return msca;
    }

    @Override
    public List<MassSpecStandardQuant> getStandardQuant() {
        return this.standardQuantList;
    }

    @XmlTransient
    public void setStandardQuant(List<MassSpecStandardQuant> standardQuant) {
        this.standardQuantList = standardQuant;
    }

    public String getStandardQuantText() {
        return this.standardQuantText;
    }

    @XmlAttribute(name="standardQuantText")
    public void setStandardQuantText(String standardQuantText) {
        this.standardQuantText = standardQuantText;
    }

    public static MassSpecStandardQuant lookupStandardQuant(List<MassSpecStandardQuant> standardQuantList, String standardQuantName) {
        if (standardQuantList != null && !standardQuantList.isEmpty()) {
            int i = 0;
            while (i < standardQuantList.size()) {
                MassSpecStandardQuant standardQuant = standardQuantList.get(i);
                if (standardQuant.getStandardQuantName().equalsIgnoreCase(standardQuantName)) {
                    return standardQuant;
                }
                ++i;
            }
        }
        return null;
    }

    public static String createStandardQuantText(MassSpecStandardQuant standardQuant) {
        standardQuant.updateStandardQuantPeakText();
        String asText = XMLUtils.marshalObjectXML((Object)standardQuant);
        return asText;
    }

    public static String createStandardQuantText(List<MassSpecStandardQuant> standardQuantList) {
        StringBuilder sb = new StringBuilder();
        int iAnnotCnt = 0;
        if (standardQuantList != null && !standardQuantList.isEmpty()) {
            int i = 0;
            while (i < standardQuantList.size()) {
                MassSpecStandardQuant standardQuant = standardQuantList.get(i);
                if (standardQuant != null) {
                    if (iAnnotCnt > 0) {
                        sb.append(VALUE_SEPERATOR);
                    }
                    String sXML = MassSpecPreference.createStandardQuantText(standardQuant);
                    sb.append(sXML);
                    ++iAnnotCnt;
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public static List<MassSpecStandardQuant> unmarshalStandardQuantList(String sStandardQuantText) {
        ArrayList<MassSpecStandardQuant> mssq = new ArrayList<MassSpecStandardQuant>();
        try {
            if (sStandardQuantText != null) {
                String[] stdQuantList;
                if (sStandardQuantText.startsWith(VALUE_SEPERATOR)) {
                    int iStartPos = sStandardQuantText.indexOf(VALUE_SEPERATOR) + VALUE_SEPERATOR.length();
                    sStandardQuantText = sStandardQuantText.substring(iStartPos);
                }
                if (!sStandardQuantText.equals("") && (stdQuantList = sStandardQuantText.split(VALUE_SEPERATOR)) != null && stdQuantList.length > 0) {
                    int i = 0;
                    while (i < stdQuantList.length) {
                        String stdQuantXML = stdQuantList[i];
                        MassSpecStandardQuant standardQuant = (MassSpecStandardQuant)XMLUtils.getObjectFromXML((String)stdQuantXML, MassSpecStandardQuant.class);
                        if (standardQuant != null) {
                            standardQuant.unmarshalStandardQuantPeakList();
                            mssq.add(standardQuant);
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error loading default options from xml files.", (Throwable)ex);
        }
        return mssq;
    }

    private static MassSpecPreference getMassSpecPreferencesFromXML(String xmlString) {
        MassSpecPreference msPreference = (MassSpecPreference)XMLUtils.getObjectFromXML((String)xmlString, MassSpecPreference.class);
        return msPreference;
    }

    public static String marshalXML(MassSpecPreference object) {
        String xmlString = XMLUtils.marshalObjectXML((Object)object);
        return xmlString;
    }

    private String loadDefaultOptions(Set<String> _sAllPreferences, String _sDefaultPreferenceFile) {
        String sDefault = null;
        try {
            HashMap optionMap = PreferenceHandler.getPreferenceValues((String)_sDefaultPreferenceFile, (String)"org.grits.toolbox.entry.ms");
            for (String option : optionMap.keySet()) {
                _sAllPreferences.add(option);
                if (!((Boolean)optionMap.get(option)).booleanValue()) continue;
                sDefault = option;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error loading default options from xml files.", (Throwable)ex);
            throw ex;
        }
        return sDefault;
    }

    private String loadDefaultOptions(Set<String> _sAllPreferences, String[] _sDefaultOptions) {
        String sDefault = null;
        try {
            String[] stringArray = _sDefaultOptions;
            int n = _sDefaultOptions.length;
            int n2 = 0;
            while (n2 < n) {
                String option = stringArray[n2];
                _sAllPreferences.add(option);
                if (sDefault == null) {
                    sDefault = option;
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error loading default options from String array.", (Throwable)ex);
            throw ex;
        }
        return sDefault;
    }

    public void loadDefaultOptions() {
        this.allDerivatizationTypes = new HashSet<String>();
        this.allAdductTypes = new HashSet<String>();
        this.allCollisionTypes = new HashSet<String>();
        this.allGlycanTypes = new HashSet<String>();
        this.allReleaseTypes = new HashSet<String>();
        this.allExperimentTypes = new HashSet<String>();
        try {
            String sDefault = null;
            try {
                sDefault = this.loadDefaultOptions(this.allDerivatizationTypes, DEFAULT_DERIVITIZATION_FILE);
                if (this.derivatizationType == null) {
                    this.derivatizationType = sDefault;
                }
            }
            catch (Exception ex) {
                throw new Exception("Unable to load dervitization preferences", ex);
            }
            try {
                sDefault = this.loadDefaultOptions(this.allAdductTypes, DEFAULT_ADDUCT_FILE);
                if (this.adductType == null) {
                    this.adductType = sDefault;
                }
            }
            catch (Exception ex) {
                throw new Exception("Unable to load adduct preferences", ex);
            }
            try {
                sDefault = this.loadDefaultOptions(this.allCollisionTypes, DEFAULT_COLLISION_FILE);
                if (this.collisionType == null) {
                    this.collisionType = sDefault;
                }
            }
            catch (Exception ex) {
                throw new Exception("Unable to load collision preferences", ex);
            }
            try {
                sDefault = this.loadDefaultOptions(this.allGlycanTypes, DEFAULT_GLYCAN_FILE);
                if (this.glycanType == null) {
                    this.glycanType = sDefault;
                }
            }
            catch (Exception ex) {
                throw new Exception("Unable to load glycan preferences", ex);
            }
            try {
                sDefault = this.loadDefaultOptions(this.allReleaseTypes, DEFAULT_RELEASE_FILE);
                if (this.releaseType == null) {
                    this.releaseType = sDefault;
                }
            }
            catch (Exception ex) {
                throw new Exception("Unable to load release preferences", ex);
            }
            try {
                sDefault = this.loadDefaultOptions(this.allExperimentTypes, Method.MS_TYPES);
                if (this.experimentType == null) {
                    this.experimentType = sDefault;
                }
            }
            catch (Exception ex) {
                throw new Exception("Unable to load experiment type preferences", ex);
            }
            if (this.customAnnotations == null) {
                this.customAnnotations = new ArrayList<MassSpecCustomAnnotation>();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error loading default options", (Throwable)ex);
        }
    }

    public static MassSpecPreference getMassSpecPreferences(PreferenceEntity preferenceEntity) throws UnsupportedVersionException {
        MassSpecPreference preferenceSettings = null;
        if (preferenceEntity != null) {
            preferenceSettings = MassSpecPreference.getMassSpecPreferencesFromXML(preferenceEntity.getValue());
            List<MassSpecCustomAnnotation> ca = MassSpecPreference.unmarshalCustomAnnotationsList(preferenceSettings.getCustomAnnotationText());
            preferenceSettings.setCustomAnnotations(ca);
            List<MassSpecStandardQuant> sq = MassSpecPreference.unmarshalStandardQuantList(preferenceSettings.getStandardQuantText());
            preferenceSettings.setStandardQuant(sq);
            preferenceSettings.loadDefaultOptions();
        }
        return preferenceSettings;
    }

    @Override
    public boolean saveValues() {
        PreferenceEntity preferenceEntity = new PreferenceEntity(PREFERENCE_NAME_ALL);
        preferenceEntity.setVersion(CURRENT_VERSION);
        this.setCustomAnnotationText(MassSpecPreference.createCustomAnnotationsText(this.getCustomAnnotations()));
        this.setStandardQuantText(MassSpecPreference.createStandardQuantText(this.getStandardQuant()));
        preferenceEntity.setValue(MassSpecPreference.marshalXML(this));
        return PreferenceWriter.savePreference((PreferenceEntity)preferenceEntity);
    }

    public static PreferenceEntity getPreferenceEntity() throws UnsupportedVersionException {
        PreferenceEntity preferenceEntity = PreferenceReader.getPreferenceByName((String)PREFERENCE_NAME_ALL);
        return preferenceEntity;
    }

    public static IMSPreferenceWithCustomAnnotation loadWorkspacePreferences() {
        try {
            return MassSpecPreferenceLoader.getMassSpecPreferences();
        }
        catch (Exception ex) {
            logger.error((Object)"Error getting the mass spec preferences", (Throwable)ex);
            return null;
        }
    }

    public void loadDefaultCustomAnnotations() {
        this.customAnnotations.clear();
        try {
            URL resourceURL = FileLocator.toFileURL((URL)Platform.getBundle((String)"org.grits.toolbox.entry.ms").getResource("preference"));
            File preferenceDir = new File(resourceURL.getPath());
            if (preferenceDir.exists() && preferenceDir.isDirectory()) {
                File[] prefSubDirs;
                File[] fileArray = prefSubDirs = preferenceDir.listFiles();
                int n = prefSubDirs.length;
                int n2 = 0;
                while (n2 < n) {
                    File subDir = fileArray[n2];
                    if (subDir.isDirectory() && subDir.getName().equals("customAnnotation")) {
                        File[] files;
                        File[] fileArray2 = files = subDir.listFiles();
                        int n3 = files.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            File file = fileArray2[n4];
                            if (file.getName().endsWith(".xml")) {
                                this.processMassSpecCustomAnnotation(file.getAbsolutePath());
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)"Could not load default preference files", (Throwable)e);
        }
    }

    private void processMassSpecCustomAnnotation(String fileName) {
        try {
            MassSpecCustomAnnotationTemplate template = MassSpecCustomAnnotationTemplate.unmarshalAnnotationTemplate(fileName);
            MassSpecCustomAnnotation msca = template.copyToNewAnnotation();
            this.customAnnotations.add(msca);
        }
        catch (Exception exception) {
            logger.warn((Object)(String.valueOf(fileName) + " is not a valid preference file"));
        }
    }
}

