/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.preference;

import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.entry.ms.preference.MassSpecPreference;
import org.grits.toolbox.entry.ms.preference.MassSpecStandardQuantPreferenceUI;

public class MassSpecStandardQuantPreferencePage
extends PreferencePage
implements IPropertyChangeListener {
    private static final Logger logger = Logger.getLogger(MassSpecStandardQuantPreferencePage.class);
    protected MassSpecStandardQuantPreferenceUI standardQuantPreference;
    protected MassSpecPreference preferences = (MassSpecPreference)MassSpecPreference.loadWorkspacePreferences();

    protected Control createContents(Composite parent) {
        this.standardQuantPreference = new MassSpecStandardQuantPreferenceUI(parent, 2048, this, false);
        this.standardQuantPreference.setLocalStandardQuant(this.preferences);
        this.standardQuantPreference.initComponents();
        return parent;
    }

    public boolean isValid() {
        if (!this.standardQuantPreference.isPageCompete()) {
            this.setErrorMessage(this.standardQuantPreference.getErrorMessage());
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void performApply() {
        this.save();
    }

    public boolean performOk() {
        this.save();
        return true;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.setValid(this.isValid());
    }

    protected void save() {
        try {
            this.standardQuantPreference.updateSettings();
            this.standardQuantPreference.updatePreferences();
            logger.debug((Object)"Time to save values!");
            this.standardQuantPreference.save();
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    protected void performDefaults() {
        boolean load = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Are you sure?", (String)"This will remove all the standard quantification preferences you've created, if any. Do you want to continue?");
        if (load) {
            this.preferences = new MassSpecPreference();
            this.preferences.saveValues();
            this.standardQuantPreference.clearValues();
            this.standardQuantPreference.initStoredStandardQuant();
            this.standardQuantPreference.initLocalStandardQuant();
            this.standardQuantPreference.processSelection(null);
            this.standardQuantPreference.updateUI();
        }
    }
}

