/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.preference.viewer;

import java.io.File;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.entry.ms.preference.MSConvertPreference;

public class MSConvertPreferencePage
extends PreferencePage {
    private static final Logger logger = Logger.getLogger(MSConvertPreferencePage.class);
    MSConvertPreference preferences;
    private Text programLocation;
    private Combo fileTypeCombo;

    public MSConvertPreferencePage() {
        try {
            this.preferences = MSConvertPreference.loadPreferences();
        }
        catch (UnsupportedVersionException e) {
            logger.error((Object)"Error loading MSConvert preferences: ", (Throwable)e);
            this.preferences = new MSConvertPreference();
            this.preferences.loadDefaultOptions();
        }
    }

    protected Control createContents(Composite parent) {
        final Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        container.setLayout((Layout)gridLayout);
        Label locationLabel = new Label(container, 0);
        locationLabel.setText("Program Location");
        this.programLocation = new Text(container, 2048);
        this.programLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.programLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MSConvertPreferencePage.this.setValid(MSConvertPreferencePage.this.isReadyToFinish());
            }
        });
        if (this.preferences != null && this.preferences.getLocation() != null) {
            this.programLocation.setText(this.preferences.getLocation());
        }
        Button browseButton = new Button(container, 8);
        browseButton.setText("Browse");
        browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(container.getShell());
                String selectedDir = dialog.open();
                if (selectedDir != null) {
                    File msConvert = new File(String.valueOf(selectedDir) + File.separator + "msconvert.exe");
                    if (!msConvert.exists()) {
                        MessageDialog.openWarning((Shell)MSConvertPreferencePage.this.getShell(), (String)"Not Found", (String)"Could not locate msconvert.exe in the selected folder. Please make sure to select the correct folder");
                        return;
                    }
                    MSConvertPreferencePage.this.programLocation.setText(selectedDir);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label fileTypeLabel = new Label(container, 0);
        fileTypeLabel.setText("Convert To");
        this.fileTypeCombo = new Combo(container, 0);
        this.fileTypeCombo.setItems(new String[]{"mzXML", "mzML"});
        this.fileTypeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fileTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MSConvertPreferencePage.this.setValid(MSConvertPreferencePage.this.isReadyToFinish());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.preferences != null && this.preferences.getFileType() != null) {
            if (this.preferences.getFileType().equalsIgnoreCase("mzml")) {
                this.fileTypeCombo.select(1);
                this.setValid(this.isReadyToFinish());
            } else {
                this.fileTypeCombo.select(0);
                this.setValid(this.isReadyToFinish());
            }
        } else {
            this.fileTypeCombo.select(0);
            this.setValid(this.isReadyToFinish());
        }
        new Label(container, 0);
        int i = 0;
        while (i < 9) {
            new Label(container, 0);
            ++i;
        }
        Link helpLink = new Link(container, 0);
        helpLink.setLayoutData((Object)new GridData(16384, 128, true, true, 3, 3));
        helpLink.setText("Please check <A>http://proteowizard.sourceforge.net/tools.shtml/</A> for more information.");
        helpLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)"http://proteowizard.sourceforge.net/tools.shtml");
            }
        });
        return container;
    }

    protected void performApply() {
        this.save();
    }

    public boolean isReadyToFinish() {
        if (this.programLocation != null && this.programLocation.getText() != null && !this.programLocation.getText().isEmpty()) {
            if (this.fileTypeCombo != null && this.fileTypeCombo.getSelectionIndex() != -1) {
                this.setMessage(null);
                return true;
            }
            this.setMessage("Please select a file type to convert into");
        } else {
            this.setMessage("Please enter the location for the MSConvert tool");
        }
        return false;
    }

    public boolean performOk() {
        boolean valid = this.isReadyToFinish();
        this.setValid(valid);
        if (valid) {
            this.save();
        }
        return valid;
    }

    private void save() {
        this.preferences.setLocation(this.programLocation.getText());
        this.preferences.setFileType(this.fileTypeCombo.getItem(this.fileTypeCombo.getSelectionIndex()));
        this.preferences.saveValues();
    }
}

