/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.preference.viewer;

import org.apache.log4j.Logger;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.grits.toolbox.datamodel.ms.preference.MassSpecViewerPreference;
import org.grits.toolbox.datamodel.ms.tablemodel.FillTypes;
import org.grits.toolbox.display.control.table.dialog.GRITSTableColumnChooser;
import org.grits.toolbox.display.control.table.tablecore.IGritsTable;
import org.grits.toolbox.entry.ms.preference.viewer.MassSpecViewerPreferencePage_NatBridge;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;

public class MassSpecViewerPreferencePage
extends PreferencePage
implements IPropertyChangeListener {
    private static final Logger logger = Logger.getLogger(MassSpecViewerPreferencePage.class);
    protected Composite parent;
    protected GRITSTableColumnChooser chooser = null;
    protected Point originalSize = null;
    protected boolean bNeedPaint = true;
    protected Label comboLabel = null;
    protected Combo comboMSlevel = null;
    protected Label comboTableLabel = null;
    protected Combo comboTablelevel = null;
    protected static String OVERVIEW = "Overview";
    protected static String MAX_DISPLAY = ">3";
    protected static int MAX_VAL = 5;
    protected Group natContainer = null;
    protected MassSpecViewerPreferencePage_NatBridge[][] natBridge = null;
    public static final String[] MS_LEVELS = new String[]{OVERVIEW, "1", "2", "3", MAX_DISPLAY};
    protected Group spectraContainer = null;
    protected Boolean[][] showSpectra = null;
    protected Button cbShowSpectra = null;
    protected Button cbAnnotatedPeaks = null;
    protected Boolean[][] showAnnotatedPeaks = null;
    protected Button cbAnnotatedPeakLabels = null;
    protected Boolean[][] showAnnotatedPeakLabels = null;
    protected Button cbPickedPeaks = null;
    protected Boolean[][] showPickedPeaks = null;
    protected Button cbPickedPeakLabels = null;
    protected Boolean[][] showPickedPeakLabels = null;

    protected int getTableNumber() {
        int iTableNum = this.comboTablelevel.getSelectionIndex();
        return iTableNum;
    }

    protected String[] getMSLevels() {
        return MS_LEVELS;
    }

    protected FillTypes getTableFillType() {
        FillTypes[] fillTypes = MassSpecMultiPageViewer.getPreferencePageFillTypes(this.getCurMSLevel());
        FillTypes fillType = fillTypes[this.getTableNumber()];
        return fillType;
    }

    protected String getTableFillLabel() {
        String[] labels = MassSpecMultiPageViewer.getPreferencePageLabels(this.getCurMSLevel());
        String label = labels[this.getTableNumber()];
        return label;
    }

    protected void initTableTypes(Composite container) {
        GridData gridData1 = GridDataFactory.fillDefaults().grab(true, false).create();
        gridData1.horizontalSpan = 2;
        this.comboTableLabel = new Label(container, 0);
        this.comboTableLabel.setText("Table Type:");
        this.comboTableLabel.setLayoutData((Object)gridData1);
        GridData gridData2 = GridDataFactory.fillDefaults().grab(true, false).create();
        gridData2.horizontalSpan = 2;
        this.comboTablelevel = new Combo(container, 8);
        this.comboTablelevel.setLayoutData((Object)gridData2);
        this.updateTableTypeCombo(1);
        this.addTableTypeComboSelectionListener();
    }

    protected void updateTableTypeCombo(int _iMSLevel) {
        String[] tableTypes = MassSpecMultiPageViewer.getPreferencePageLabels(_iMSLevel);
        String defaultTable = tableTypes[0];
        this.comboTablelevel.setItems(tableTypes);
        this.comboTablelevel.setText(defaultTable);
    }

    protected void addTableTypeComboSelectionListener() {
        this.comboTablelevel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MassSpecViewerPreferencePage.this.updateColumnChooserElements((Composite)MassSpecViewerPreferencePage.this.natContainer, false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void initMSLevel(Composite container) {
        GridData gridData1 = GridDataFactory.fillDefaults().grab(true, false).create();
        gridData1.horizontalSpan = 2;
        this.comboLabel = new Label(container, 0);
        this.comboLabel.setText("MS Level:");
        this.comboLabel.setLayoutData((Object)gridData1);
        GridData gridData2 = GridDataFactory.fillDefaults().grab(true, false).create();
        gridData2.horizontalSpan = 2;
        this.comboMSlevel = new Combo(container, 8);
        this.comboMSlevel.setItems(this.getMSLevels());
        this.comboMSlevel.setText(this.getMSLevels()[0]);
        this.comboMSlevel.setLayoutData((Object)gridData2);
        this.addMSLevelComboSelectionListener();
    }

    protected void addMSLevelComboSelectionListener() {
        this.comboMSlevel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int iMSLevel = MassSpecViewerPreferencePage.this.getCurMSLevel();
                MassSpecViewerPreferencePage.this.updateTableTypeCombo(iMSLevel);
                MassSpecViewerPreferencePage.this.updateColumnChooserElements((Composite)MassSpecViewerPreferencePage.this.natContainer, false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public boolean showPickedPeaks() {
        return this.cbPickedPeaks.getSelection();
    }

    public boolean showPickedPeakLabels() {
        return this.cbPickedPeakLabels.getSelection();
    }

    public boolean showAnnotatedPeakLabels() {
        return this.cbAnnotatedPeakLabels.getSelection();
    }

    public boolean showAnnotatedPeaks() {
        return this.cbAnnotatedPeaks.getSelection();
    }

    protected void createSpectraContainer(Composite container) {
        this.spectraContainer = new Group(container, 0);
        this.spectraContainer.setText("Spectrum Viewer Settings");
        GridData gridData1 = GridDataFactory.fillDefaults().grab(true, false).create();
        gridData1.horizontalSpan = 4;
        this.spectraContainer.setLayoutData((Object)gridData1);
        GridLayout layout = new GridLayout(4, false);
        layout.horizontalSpacing = 25;
        layout.marginLeft = 10;
        layout.marginTop = 10;
        this.spectraContainer.setLayout((Layout)layout);
    }

    protected void createNatContainer(Composite container) {
        this.natContainer = new Group(container, 0);
        this.natContainer.setText("");
        GridData gridData1 = GridDataFactory.fillDefaults().grab(true, false).create();
        gridData1.horizontalSpan = 4;
        this.natContainer.setLayoutData((Object)gridData1);
        GridLayout layout = new GridLayout(4, false);
        layout.horizontalSpacing = 25;
        layout.marginLeft = 10;
        layout.marginTop = 10;
        this.natContainer.setLayout((Layout)layout);
    }

    protected void setMSElements(Composite container) {
        this.cbShowSpectra = new Button(container, 32);
        this.cbShowSpectra.setText("Raw Spectra");
        GridData gdRawSpectra = new GridData(1, 1, false, false, 4, 1);
        this.cbShowSpectra.setLayoutData((Object)gdRawSpectra);
        this.cbShowSpectra.setSelection(true);
        this.cbShowSpectra.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int iCurMS = MassSpecViewerPreferencePage.this.getCurMSLevel() - 1;
                MassSpecViewerPreferencePage.this.showSpectra[MassSpecViewerPreferencePage.this.getTableNumber()][iCurMS] = MassSpecViewerPreferencePage.this.cbShowSpectra.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.showSpectra = new Boolean[this.getMaxNumTables()][MAX_VAL];
    }

    protected void setPickedPeaksElements(Composite container) {
        this.cbPickedPeaks = new Button(container, 32);
        this.cbPickedPeaks.setText("Picked Peaks");
        GridData gdPickedPeaks = new GridData(1, 1, false, false, 2, 1);
        this.cbPickedPeaks.setLayoutData((Object)gdPickedPeaks);
        this.showPickedPeaks = new Boolean[this.getMaxNumTables()][MAX_VAL];
        this.cbPickedPeaks.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int iCurMS = MassSpecViewerPreferencePage.this.getCurMSLevel() - 1;
                MassSpecViewerPreferencePage.this.showPickedPeaks[MassSpecViewerPreferencePage.this.getTableNumber()][iCurMS] = MassSpecViewerPreferencePage.this.cbPickedPeaks.getSelection();
                if (!MassSpecViewerPreferencePage.this.cbPickedPeaks.getSelection()) {
                    MassSpecViewerPreferencePage.this.cbPickedPeakLabels.setSelection(false);
                }
                MassSpecViewerPreferencePage.this.cbPickedPeakLabels.setEnabled(MassSpecViewerPreferencePage.this.cbPickedPeaks.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.cbPickedPeakLabels = new Button(container, 32);
        this.cbPickedPeakLabels.setText("Show labels");
        GridData gdPickedPeakLabels = new GridData(1, 1, false, false, 2, 1);
        this.cbPickedPeakLabels.setLayoutData((Object)gdPickedPeakLabels);
        this.cbPickedPeakLabels.setEnabled(false);
        this.cbPickedPeakLabels.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int iCurMS = MassSpecViewerPreferencePage.this.getCurMSLevel() - 1;
                MassSpecViewerPreferencePage.this.showPickedPeakLabels[MassSpecViewerPreferencePage.this.getTableNumber()][iCurMS] = MassSpecViewerPreferencePage.this.cbPickedPeakLabels.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.showPickedPeakLabels = new Boolean[this.getMaxNumTables()][MAX_VAL];
    }

    protected void setAnnotatedElements(Composite container) {
        this.cbAnnotatedPeaks = new Button(container, 32);
        this.cbAnnotatedPeaks.setText("Annotated Peaks");
        GridData gdAnnotatedPeaks = new GridData(1, 1, false, false, 2, 1);
        this.cbAnnotatedPeaks.setLayoutData((Object)gdAnnotatedPeaks);
        this.showAnnotatedPeaks = new Boolean[this.getMaxNumTables()][MAX_VAL];
        this.cbAnnotatedPeaks.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int iCurMS = MassSpecViewerPreferencePage.this.getCurMSLevel() - 1;
                MassSpecViewerPreferencePage.this.showAnnotatedPeaks[MassSpecViewerPreferencePage.this.getTableNumber()][iCurMS] = MassSpecViewerPreferencePage.this.cbAnnotatedPeaks.getSelection();
                if (!MassSpecViewerPreferencePage.this.cbAnnotatedPeaks.getSelection()) {
                    MassSpecViewerPreferencePage.this.cbAnnotatedPeakLabels.setSelection(false);
                }
                MassSpecViewerPreferencePage.this.cbAnnotatedPeakLabels.setEnabled(MassSpecViewerPreferencePage.this.cbAnnotatedPeaks.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.cbAnnotatedPeakLabels = new Button(container, 32);
        this.cbAnnotatedPeakLabels.setText("Show labels");
        GridData gdAnnotatedPeakLabels = new GridData(1, 1, false, false, 2, 1);
        this.cbAnnotatedPeakLabels.setLayoutData((Object)gdAnnotatedPeakLabels);
        this.cbAnnotatedPeakLabels.setEnabled(false);
        this.cbAnnotatedPeakLabels.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int iCurMS = MassSpecViewerPreferencePage.this.getCurMSLevel() - 1;
                MassSpecViewerPreferencePage.this.showAnnotatedPeakLabels[MassSpecViewerPreferencePage.this.getTableNumber()][iCurMS] = MassSpecViewerPreferencePage.this.cbAnnotatedPeakLabels.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.showAnnotatedPeakLabels = new Boolean[this.getMaxNumTables()][MAX_VAL];
    }

    protected void initComponents(Composite container) {
        this.initMSLevel(container);
        this.initTableTypes(container);
        this.initNatTable(container);
        this.createSpectraContainer(container);
        this.setMSElements((Composite)this.spectraContainer);
        this.setPickedPeaksElements((Composite)this.spectraContainer);
        this.setAnnotatedElements((Composite)this.spectraContainer);
    }

    protected void initNatTable(Composite container) {
        this.createNatContainer(container);
        this.natBridge = new MassSpecViewerPreferencePage_NatBridge[this.getMaxNumTables()][MAX_VAL];
        this.addColumnChooserElements((Composite)this.natContainer);
    }

    protected int getMaxNumTables() {
        int iMaxTableTypes = MassSpecMultiPageViewer.getPreferencePageMaxNumPages();
        return iMaxTableTypes;
    }

    protected Control createContents(Composite parent) {
        this.parent = parent;
        GridLayout layout = new GridLayout(4, false);
        parent.setLayout((Layout)layout);
        this.initComponents(parent);
        parent.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (MassSpecViewerPreferencePage.this.bNeedPaint) {
                    MassSpecViewerPreferencePage.this.updateColumnChooserElements((Composite)MassSpecViewerPreferencePage.this.natContainer, false);
                    MassSpecViewerPreferencePage.this.bNeedPaint = false;
                }
            }
        });
        return parent;
    }

    protected void addColumnChooserElements(Composite container) {
        int iCurMS;
        int iTableNum = this.getTableNumber();
        if (this.natBridge[iTableNum][iCurMS = this.getCurMSLevel() - 1] == null) {
            this.natBridge[iTableNum][iCurMS] = this.getPreferenceUItoNatBridge(false);
        }
        if (this.chooser == null) {
            this.chooser = new GRITSTableColumnChooser(this.parent.getShell(), false, true, (IGritsTable)this.natBridge[iTableNum][iCurMS].getNatTable());
            this.chooser.getColumnChooserDialog().populateDialogArea(container);
            GridData layout = (GridData)container.getLayoutData();
            layout.horizontalSpan = 4;
            this.chooser.addListenersOnColumnChooserDialog();
        }
    }

    protected void updateColumnChooserElements(Composite container, boolean _bDefault) {
        int iCurMS;
        int iTableNum = this.getTableNumber();
        if (this.natBridge[iTableNum][iCurMS = this.getCurMSLevel() - 1] == null || _bDefault) {
            this.natBridge[iTableNum][iCurMS] = this.getPreferenceUItoNatBridge(_bDefault);
        }
        if (this.chooser == null) {
            this.chooser = new GRITSTableColumnChooser(this.parent.getShell(), false, true, (IGritsTable)this.natBridge[iTableNum][iCurMS].getNatTable());
            this.chooser.getColumnChooserDialog().populateDialogArea(container);
            this.chooser.addListenersOnColumnChooserDialog();
        } else {
            this.chooser.getHiddenColumnEntries().clear();
            this.chooser.getColumnChooserDialog().removeAllLeaves();
            this.chooser.reInit((IGritsTable)this.natBridge[iTableNum][iCurMS].getNatTable());
        }
        this.chooser.populateDialog();
        GridData layout = (GridData)container.getLayoutData();
        layout.horizontalSpan = 4;
        if (this.showSpectra[iTableNum][iCurMS] == null) {
            MassSpecViewerPreference pref = this.natBridge[iTableNum][iCurMS].getPreference();
            this.showSpectra[iTableNum][iCurMS] = new Boolean(pref.isShowRaw());
            this.showPickedPeaks[iTableNum][iCurMS] = new Boolean(pref.isShowPicked());
            this.showPickedPeakLabels[iTableNum][iCurMS] = new Boolean(pref.isShowPickedLabels());
            this.showAnnotatedPeaks[iTableNum][iCurMS] = new Boolean(pref.isShowAnnotated());
            this.showAnnotatedPeakLabels[iTableNum][iCurMS] = new Boolean(pref.isShowAnnotatedLabels());
        }
        this.cbShowSpectra.setSelection(this.showSpectra[iTableNum][iCurMS].booleanValue());
        if (this.comboMSlevel.getText().equals(OVERVIEW)) {
            this.cbPickedPeaks.setEnabled(false);
            this.cbPickedPeakLabels.setEnabled(false);
            this.cbAnnotatedPeaks.setEnabled(false);
            this.cbAnnotatedPeakLabels.setEnabled(false);
        } else {
            this.cbPickedPeaks.setEnabled(true);
            this.cbAnnotatedPeaks.setEnabled(true);
        }
        this.cbPickedPeaks.setSelection(this.showPickedPeaks[iTableNum][iCurMS].booleanValue());
        if (this.cbPickedPeaks.getSelection()) {
            this.cbPickedPeakLabels.setEnabled(true);
        } else {
            this.cbPickedPeakLabels.setEnabled(false);
        }
        this.cbPickedPeakLabels.setSelection(this.showPickedPeakLabels[iTableNum][iCurMS].booleanValue());
        this.cbAnnotatedPeaks.setSelection(this.showAnnotatedPeaks[iTableNum][iCurMS].booleanValue());
        if (this.cbAnnotatedPeaks.getSelection()) {
            this.cbAnnotatedPeakLabels.setEnabled(true);
        } else {
            this.cbAnnotatedPeakLabels.setEnabled(false);
        }
        this.cbAnnotatedPeakLabels.setSelection(this.showAnnotatedPeakLabels[iTableNum][iCurMS].booleanValue());
    }

    protected int getCurMSLevel() {
        int iMSLevel = 1;
        try {
            if (this.comboMSlevel.getText().equals(MAX_DISPLAY)) {
                iMSLevel = MAX_VAL;
            } else if (!this.comboMSlevel.getText().equals(OVERVIEW)) {
                iMSLevel = Integer.parseInt(this.comboMSlevel.getText()) + 1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            iMSLevel = 1;
        }
        return iMSLevel;
    }

    protected Point doComputeSize() {
        if (this.originalSize == null) {
            this.originalSize = super.doComputeSize();
        }
        return this.originalSize;
    }

    public Point computeSize() {
        if (this.originalSize == null) {
            this.originalSize = super.computeSize();
        }
        logger.debug((Object)("Dialog size: " + this.originalSize));
        return this.originalSize;
    }

    protected MassSpecViewerPreferencePage_NatBridge getPreferenceUItoNatBridge(boolean _bDefault) {
        int iMSLevel = this.getCurMSLevel();
        MassSpecViewerPreferencePage_NatBridge natBridge = new MassSpecViewerPreferencePage_NatBridge(new Composite((Composite)this.getShell(), 0), iMSLevel, this.getTableFillType());
        natBridge.initializeComponents(_bDefault);
        return natBridge;
    }

    protected String getType() {
        return "org.grits.toolbox.property.ms";
    }

    public void setContainer(IPreferencePageContainer container) {
        super.setContainer(container);
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    protected void performApply() {
        this.save();
    }

    public boolean performOk() {
        this.save();
        return true;
    }

    protected void setPageComplete(boolean b) {
        if (b) {
            this.setErrorMessage(null);
        }
        this.setValid(b);
    }

    protected void save() {
        int i = 0;
        while (i < this.getMaxNumTables()) {
            int j = 0;
            while (j < MAX_VAL) {
                if (this.natBridge[i][j] != null) {
                    this.updateMassSpecViewerPreference(i, j);
                    this.save(this.natBridge[i][j]);
                }
                ++j;
            }
            ++i;
        }
    }

    protected void updateMassSpecViewerPreference(int iMSLevel, int iTableType) {
        MassSpecViewerPreference pref = this.natBridge[iMSLevel][iTableType].getPreference();
        pref.setShowRaw(this.showSpectra[iMSLevel][iTableType].booleanValue());
        pref.setShowPicked(this.showPickedPeaks[iMSLevel][iTableType].booleanValue());
        pref.setShowPickedLabels(this.showPickedPeakLabels[iMSLevel][iTableType].booleanValue());
        pref.setShowAnnotated(this.showAnnotatedPeaks[iMSLevel][iTableType].booleanValue());
        pref.setShowAnnotatedLabels(this.showAnnotatedPeakLabels[iMSLevel][iTableType].booleanValue());
    }

    protected void save(MassSpecViewerPreferencePage_NatBridge natBridge) {
        natBridge.updatePreferences();
    }

    protected void performDefaults() {
        this.updateColumnChooserElements((Composite)this.natContainer, true);
    }
}

