/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.views.tabbed;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.PerspectiveStackImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.IPartListener;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.editor.CancelableMultiPageEditor;
import org.grits.toolbox.core.editor.IEntryEditorPart;
import org.grits.toolbox.core.preference.share.IGritsPreferenceStore;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.datamodel.ms.preference.MassSpecViewerPreference;
import org.grits.toolbox.datamodel.ms.tablemodel.FillTypes;
import org.grits.toolbox.display.control.table.preference.TableViewerPreference;
import org.grits.toolbox.entry.ms.dialog.MassSpecCustomAnnotationDialog;
import org.grits.toolbox.entry.ms.dialog.MassSpecExternalQuantDialog;
import org.grits.toolbox.entry.ms.dialog.MassSpecPeakIntensityApplyDialog;
import org.grits.toolbox.entry.ms.dialog.MassSpecStandardQuantApplyDialog;
import org.grits.toolbox.entry.ms.exceptions.MSException;
import org.grits.toolbox.entry.ms.process.loader.MassSpecTableDataProcessor;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.entry.ms.tablehelpers.MassSpecTable;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewerTableRefreshWorker;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewerWorker;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecPeaksView;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecPropertyView;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecScanHierarchyView;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecScansView;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecSpectraView;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecTableBase;
import org.grits.toolbox.ms.file.MSFile;
import org.grits.toolbox.ms.file.reader.IMSAnnotationFileReader;
import org.grits.toolbox.ms.file.reader.IMSFileReader;
import org.grits.toolbox.ms.file.scan.data.ScanView;
import org.grits.toolbox.widgets.processDialog.GRITSProgressDialog;
import org.grits.toolbox.widgets.progress.CancelableThread;
import org.grits.toolbox.widgets.progress.IProgressListener;
import org.grits.toolbox.widgets.progress.IProgressThreadHandler;
import org.grits.toolbox.widgets.tools.GRITSProcessStatus;
import org.grits.toolbox.widgets.tools.GRITSWorker;

public class MassSpecMultiPageViewer
extends CancelableMultiPageEditor
implements IPropertyChangeListener {
    private static final Logger logger = Logger.getLogger(MassSpecMultiPageViewer.class);
    protected Entry entry = null;
    protected MassSpecPropertyView propertyView = null;
    protected int propertyViewTabIndex = -1;
    protected MassSpecScansView scansView = null;
    protected int scansViewTabIndex = -1;
    protected MassSpecSpectraView spectraView = null;
    protected int spectraViewTabIndex = -1;
    protected List<MassSpecPeaksView> alPeaksViews = null;
    protected int alPeaksViewsFirstTabIndex = -1;
    protected int iMinMSLevel;
    protected MSPropertyDataFile msFile;
    @Inject
    protected IGritsPreferenceStore gritsPreferenceStore;
    @Inject
    protected EPartService partService;
    @Inject
    protected EModelService modelService;
    @Inject
    protected static IGritsDataModelService gritsModelService;
    @Inject
    MDirtyable dirtyable;
    @Inject
    IEclipseContext context;
    @Inject
    protected MApplication application;
    public static Map<String, Integer> mSourceToMinMSLevel;
    public static final String VIEW_ID = "plugin.ms.annotation.views.MassSpecMultiPageViewer";
    public static final String MIN_MS_LEVEL_CONTEXT = "MinMSLevelContext";
    public static final String EVENT_PARENT_ENTRY_VALUE_MODIFIED = "Value_Modified_for_Checkboxes";
    public static final String SCAN_HIEARARCHYPARTNAME = "ScanHierarchy";
    public static MassSpecCustomAnnotationDialog massSpecCustomAnnotationDialog;
    public static MassSpecStandardQuantApplyDialog massSpecStandardQuantApplyDialog;
    public static MassSpecExternalQuantDialog massSpecExternalQuantDialog;
    public static MassSpecPeakIntensityApplyDialog massSpecPeakIntensityApplyDialog;

    static {
        mSourceToMinMSLevel = new HashMap<String, Integer>();
        massSpecCustomAnnotationDialog = null;
        massSpecStandardQuantApplyDialog = null;
        massSpecExternalQuantDialog = null;
        massSpecPeakIntensityApplyDialog = null;
    }

    public String toString() {
        return "MassSpecMultiPageViewer (" + this.entry + ")";
    }

    public MassSpecMultiPageViewer() {
        this.alPeaksViews = new ArrayList<MassSpecPeaksView>();
    }

    @Inject
    public MassSpecMultiPageViewer(Entry entry) {
        this.entry = entry;
        this.alPeaksViews = new ArrayList<MassSpecPeaksView>();
    }

    @Inject
    public MassSpecMultiPageViewer(MPart part) {
        this.entry = (Entry)part.getTransientData().get("org.grits.toolbox.entry.current");
        this.alPeaksViews = new ArrayList<MassSpecPeaksView>();
    }

    @PostConstruct
    public void createPartControl(Composite parent, final MPart part) {
        super.createPartControl(parent, part);
        EPartService ePartService = (EPartService)part.getContext().get(EPartService.class);
        ePartService.addPartListener(new IPartListener(){

            public void partVisible(MPart part2) {
            }

            public void partHidden(MPart targetMPart) {
            }

            public void partDeactivated(MPart targetMPart) {
            }

            public void partBroughtToTop(MPart targetMPart) {
                PerspectiveStackImpl perspectiveStack;
                String perspectiveName;
                if (part == targetMPart && part.getObject() != null && part.getObject() instanceof MassSpecMultiPageViewer && ((perspectiveName = (perspectiveStack = (PerspectiveStackImpl)MassSpecMultiPageViewer.this.modelService.find("org.grits.toolbox.core.perspectivestack.0", (MUIElement)MassSpecMultiPageViewer.this.application)).getSelectedElement().getElementId()).equals("org.grits.toolbox.core.perspective.msperspective") || perspectiveName.equals("org.grits.toolbox.core.perspective.msperspective.<MS Perspective>"))) {
                    MassSpecMultiPageViewer.this.addScanHierarchyPage((MassSpecEntityProperty)((MassSpecMultiPageViewer)((Object)part.getObject())).getEntry().getProperty());
                }
            }

            public void partActivated(MPart part2) {
            }
        });
    }

    protected String getScanHierarchyPartName() {
        return SCAN_HIEARARCHYPARTNAME;
    }

    @PreDestroy
    public void preDestroy(MPart part) {
        this.clearScanHierarchyPage((MassSpecEntityProperty)this.getEntry().getProperty());
    }

    public IEclipseContext getContext() {
        return this.context;
    }

    public EPartService getPartService() {
        return this.partService;
    }

    public int getPropertyViewTabIndex() {
        return this.propertyViewTabIndex;
    }

    public void setPropertyViewTabIndex(int propertyViewTabIndex) {
        this.propertyViewTabIndex = propertyViewTabIndex;
    }

    public int getScansViewTabIndex() {
        return this.scansViewTabIndex;
    }

    public void setScansViewTabIndex(int scansViewTabIndex) {
        this.scansViewTabIndex = scansViewTabIndex;
    }

    public int getSpectraViewTabIndex() {
        return this.spectraViewTabIndex;
    }

    public void setSpectraViewTabIndex(int spectraViewTabIndex) {
        this.spectraViewTabIndex = spectraViewTabIndex;
    }

    public int getPeaksViewsFirstTabIndex() {
        return this.alPeaksViewsFirstTabIndex;
    }

    public void setPeaksViewsFirstTabIndex(int alPeaksViewsFirstTabIndex) {
        this.alPeaksViewsFirstTabIndex = alPeaksViewsFirstTabIndex;
    }

    public GRITSProgressDialog getThreadedDialog() {
        return this.dtpdThreadedDialog;
    }

    public void setThreadedDialog(GRITSProgressDialog dtpdThreadedDialog) {
        this.dtpdThreadedDialog = dtpdThreadedDialog;
    }

    public int getMinMSLevel() {
        return this.iMinMSLevel;
    }

    public void setMinMSLevel(int iMinMSLevel) {
        this.iMinMSLevel = iMinMSLevel;
    }

    public Entry getEntry() {
        return this.entry;
    }

    public void setEntry(Entry entry) {
        this.entry = entry;
    }

    public boolean hasMSFile(MassSpecEntityProperty msEntityProp) {
        MSPropertyDataFile file = msEntityProp.getDataFile();
        return file != null && !file.getName().equals("");
    }

    protected int getMinMSLevelFromSourceFile(MassSpecEntityProperty msEntityProp, Entry newEntry) {
        if (!this.hasMSFile(msEntityProp)) {
            return 0;
        }
        MSPropertyDataFile sourceFile = msEntityProp.getDataFile();
        msEntityProp.getMassSpecParentProperty();
        String sFileName = String.valueOf(MassSpecProperty.getFullyQualifiedFolderName(newEntry)) + File.separator + msEntityProp.getDataFile().getName();
        int iMinMSLevel = -1;
        if (mSourceToMinMSLevel.containsKey(sFileName)) {
            iMinMSLevel = mSourceToMinMSLevel.get(sFileName);
        } else {
            msEntityProp.getMassSpecParentProperty();
            MSFile msFile = sourceFile.getMSFileWithReader(MassSpecProperty.getFullyQualifiedFolderName(newEntry), msEntityProp.getMassSpecParentProperty().getMassSpecMetaData().getMsExperimentType());
            IMSFileReader reader = msFile.getReader();
            if (reader != null && reader instanceof IMSAnnotationFileReader) {
                iMinMSLevel = ((IMSAnnotationFileReader)reader).getMinMSLevel(msFile);
                mSourceToMinMSLevel.put(sFileName, iMinMSLevel);
            }
        }
        if (iMinMSLevel < 0) {
            logger.error((Object)"An error occurred reading the MS file. It is likely not formatted correctly.");
            String sMessage = "An error occurred reading the MS file. It is likely invalid.";
            this.dtpdThreadedDialog.getMajorProgressBarListener().setError(sMessage);
        }
        return iMinMSLevel;
    }

    protected Entry getFirstPageEntry() {
        try {
            Entry parentEntry = null;
            if (gritsModelService.getLastSelection() != null && gritsModelService.getLastSelection().getFirstElement() instanceof Entry) {
                parentEntry = (Entry)gritsModelService.getLastSelection().getFirstElement();
            }
            Entry newEntry = MassSpecEntityProperty.getTableCompatibleEntry(parentEntry);
            MassSpecEntityProperty msEntityProp = (MassSpecEntityProperty)newEntry.getProperty();
            msEntityProp.setScanNum(-1);
            msEntityProp.setParentScanNum(-1);
            msEntityProp.setMz(0.0);
            msEntityProp.setParentMz(0.0);
            int iMSLevel = 1;
            this.setMinMSLevel(iMSLevel);
            msEntityProp.setMsLevel(this.getMinMSLevel());
            newEntry.setDisplayName(newEntry.getDisplayName());
            return newEntry;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    protected Object getDesiredActivePage() {
        return this.propertyView;
    }

    public void setActivePage() {
        try {
            int i = 0;
            while (i < this.getPageCount()) {
                IEntryEditorPart page = this.getPageItem(i);
                if (page != null && page.equals(this.getDesiredActivePage())) {
                    this.setActivePage(i);
                    return;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to getFirstTabIndex", (Throwable)ex);
        }
    }

    public int determineMinMSLevel() {
        try {
            CancelableThread t = new CancelableThread(){

                public boolean threadStart(IProgressThreadHandler a_progressThreadHandler) throws Exception {
                    try {
                        logger.debug((Object)"Determing properties of MS file");
                        int iMinMSLevel = MassSpecMultiPageViewer.this.getMinMSLevelFromSourceFile((MassSpecEntityProperty)MassSpecMultiPageViewer.this.entry.getProperty(), MassSpecMultiPageViewer.this.entry);
                        MassSpecMultiPageViewer.this.setMinMSLevel(iMinMSLevel);
                        return true;
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        return false;
                    }
                }
            };
            t.setProgressThreadHandler((IProgressThreadHandler)this.getThreadedDialog());
            this.getThreadedDialog().setThread(t);
            this.dtpdThreadedDialog.getMinorProgressBarListener(0).setProgressType(IProgressListener.ProgressType.Indeterminant);
            t.start();
            while (!t.isCanceled() && !t.isFinished() && t.isAlive()) {
                if (Display.getDefault().readAndDispatch()) continue;
                Display.getDefault().sleep();
            }
            this.dtpdThreadedDialog.getMinorProgressBarListener(0).setProgressType(IProgressListener.ProgressType.Determinant);
            if (t.isCanceled()) {
                t.interrupt();
                return GRITSProcessStatus.CANCEL;
            }
            return GRITSProcessStatus.OK;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return GRITSProcessStatus.ERROR;
        }
    }

    public void setStatus(int iStatus) {
        this.iStatus = iStatus;
    }

    public int getStatus() {
        return this.iStatus;
    }

    public int reLoadScansTab(List<String> columnKeys) {
        this.dtpdThreadedDialog = new GRITSProgressDialog(Display.getCurrent().getActiveShell(), 1, true);
        this.dtpdThreadedDialog.open();
        this.dtpdThreadedDialog.getMajorProgressBarListener().setMaxValue(1);
        MassSpecMultiPageViewerTableRefreshWorker msmpvw = new MassSpecMultiPageViewerTableRefreshWorker(this, columnKeys);
        this.dtpdThreadedDialog.setGritsWorker((GRITSWorker)msmpvw);
        int iSuccess = this.dtpdThreadedDialog.startWorker();
        return iSuccess;
    }

    protected int addPages(int _iMajorCount, MassSpecEntityProperty prop) {
        this.dtpdThreadedDialog = new GRITSProgressDialog(new Shell(), 1, true);
        this.dtpdThreadedDialog.open();
        this.dtpdThreadedDialog.getMajorProgressBarListener().setMaxValue(_iMajorCount);
        MassSpecMultiPageViewerWorker msmpvw = new MassSpecMultiPageViewerWorker(this, prop);
        this.dtpdThreadedDialog.setGritsWorker((GRITSWorker)msmpvw);
        int iSuccess = this.dtpdThreadedDialog.startWorker();
        return iSuccess;
    }

    protected int getNumMajorSteps(MassSpecEntityProperty prop) {
        int iCount = 2;
        int iTabCnt = 0;
        this.setPropertyViewTabIndex(iTabCnt++);
        this.setSpectraViewTabIndex(iTabCnt++);
        if (this.getMinMSLevel() < 0) {
            ++iCount;
        }
        this.setScansViewTabIndex(iTabCnt++);
        iCount += 2;
        if (this.needsPeaksView(prop)) {
            iCount += 2;
            this.setPeaksViewsFirstTabIndex(iTabCnt++);
        }
        return iCount;
    }

    public int addPropertyPage() {
        try {
            boolean success = this.initMSPropertyView();
            int iPageCount = this.getPageCount();
            if (success) {
                try {
                    int inx = this.getPropertyViewTabIndex();
                    if (inx >= this.getPageCount()) {
                        inx = this.addPage((IEntryEditorPart)this.propertyView, this.entry);
                        this.setPropertyViewTabIndex(inx);
                    } else {
                        this.addPage(inx, (IEntryEditorPart)this.propertyView, this.entry);
                    }
                    this.setPageText(inx, "MS Properties");
                    this.setActivePage(inx);
                    this.setStatus(GRITSProcessStatus.OK);
                }
                catch (Exception ex) {
                    logger.error((Object)"Unable to open MS property view", (Throwable)ex);
                    this.setStatus(GRITSProcessStatus.ERROR);
                }
            }
            if (this.isCanceled()) {
                this.setStatus(GRITSProcessStatus.CANCEL);
            }
            boolean bl = success = this.getStatus() == GRITSProcessStatus.OK;
            if (!success) {
                if (this.getPageCount() != iPageCount) {
                    this.removePage(this.getPageCount());
                }
                this.propertyView = null;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open MS property view", (Throwable)ex);
            this.setStatus(GRITSProcessStatus.ERROR);
        }
        if (this.getStatus() == GRITSProcessStatus.ERROR) {
            String sMessage = "An error occurred creating the MS Properties tab.";
            this.dtpdThreadedDialog.getMajorProgressBarListener().setError(sMessage);
        }
        return this.getStatus();
    }

    public int addSpectraPage(MassSpecEntityProperty prop) {
        try {
            boolean success = true;
            MSException spectraException = null;
            try {
                success = this.initSpectraView(prop);
            }
            catch (MSException e) {
                spectraException = e;
                logger.error((Object)e.getMessage(), (Throwable)e);
                success = false;
            }
            if (this.isCanceled()) {
                this.setStatus(GRITSProcessStatus.CANCEL);
            }
            int iPageCount = this.getPageCount();
            if (success) {
                try {
                    int inx = this.getSpectraViewTabIndex();
                    if (inx >= this.getPageCount()) {
                        inx = this.addPage((Control)this.spectraView.getView());
                        this.setSpectraViewTabIndex(inx);
                    } else {
                        this.addPage(inx, (Control)this.spectraView.getView());
                    }
                    this.setPageText(inx, "Spectra");
                    this.setActivePage(inx);
                }
                catch (Exception ex) {
                    this.spectraView = null;
                    logger.error((Object)"Error adding Spectra View tab.", (Throwable)ex);
                }
            }
            boolean bl = success = this.spectraView != null && this.spectraView.isLoaded();
            if (!success) {
                if (this.getPageCount() != iPageCount) {
                    this.removePage(this.getPageCount());
                }
                this.spectraView = null;
                String sMessage = null;
                sMessage = spectraException instanceof MSException ? spectraException.getMessage() : "An error occurred creating the Spectra tab.";
                this.setStatus(GRITSProcessStatus.ERROR);
                this.dtpdThreadedDialog.getMajorProgressBarListener().setError(sMessage);
                return this.getStatus();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open MS spectra view", (Throwable)ex);
            this.setStatus(GRITSProcessStatus.ERROR);
        }
        if (this.getStatus() == GRITSProcessStatus.ERROR) {
            String sMessage = "An error occurred creating the MS Spectra tab.";
            this.dtpdThreadedDialog.getMajorProgressBarListener().setError(sMessage);
        }
        return this.getStatus();
    }

    public int clearScanHierarchyPage(MassSpecEntityProperty prop) {
        MPart part = this.partService.findPart(this.getScanHierarchyPartName());
        if (part != null) {
            MassSpecScanHierarchyView view = (MassSpecScanHierarchyView)part.getObject();
            if (view != null && view.getProperty() != null && view.getProperty() == prop) {
                view.setProperty(null);
                view.initializeView(new ArrayList<ScanView>());
            }
            this.setStatus(GRITSProcessStatus.OK);
        }
        return this.getStatus();
    }

    public int addScanHierarchyPage(MassSpecEntityProperty prop) {
        MPart part = this.getScanHiearchyViewPart();
        if (part == null) {
            this.setStatus(GRITSProcessStatus.ERROR);
            this.dtpdThreadedDialog.getMajorProgressBarListener().setError("Part stack not found. Is the following ID correct?org.grits.toolbox.core.partstack.ms");
            return this.getStatus();
        }
        MassSpecScanHierarchyView view = (MassSpecScanHierarchyView)part.getObject();
        if ((view.getProperty() == null || view.getProperty() != prop) && this.needsScanHierarchyReload(view.getProperty(), prop)) {
            view.setViewer(this);
            view.setProperty(prop);
            try {
                List<ScanView> scans = this.getScanViewData(prop);
                if (scans == null || scans.isEmpty()) {
                    logger.error((Object)"No scan data returned from mzXML.");
                }
                view.initializeView(scans);
            }
            catch (Exception e) {
                logger.error((Object)"Unable to open MS Scan Hiearchy view", (Throwable)e);
                this.setStatus(GRITSProcessStatus.ERROR);
            }
        }
        if (this.getStatus() == GRITSProcessStatus.ERROR) {
            String sMessage = "An error occurred creating the MS Scan Hierarchy View.";
            this.dtpdThreadedDialog.getMajorProgressBarListener().setError(sMessage);
        }
        return this.getStatus();
    }

    protected boolean needsScanHierarchyReload(MassSpecEntityProperty oldProp, MassSpecEntityProperty newProp) {
        return oldProp == null || oldProp.getMassSpecParentProperty() != newProp.getMassSpecParentProperty() || !((Object)((Object)oldProp.getDataFile())).equals((Object)newProp.getDataFile());
    }

    protected MPart getScanHiearchyViewPart() {
        MPart part;
        String label = "Scan Hierarchy View";
        MPart msPart = this.partService.findPart("ScanHierarchy-Annotation");
        if (msPart != null) {
            this.partService.hidePart(msPart, true);
        }
        if ((part = this.partService.findPart(SCAN_HIEARARCHYPARTNAME)) != null) {
            this.partService.activate(part);
        } else {
            part = this.partService.createPart(SCAN_HIEARARCHYPARTNAME);
            part.setLabel(label);
            List stacks = this.modelService.findElements((MUIElement)this.application, "org.grits.toolbox.core.partstack.ms", MPartStack.class, null);
            if (stacks.size() < 1) {
                this.setStatus(GRITSProcessStatus.ERROR);
                this.dtpdThreadedDialog.getMajorProgressBarListener().setError("Part stack not found. Is the following ID correct?org.grits.toolbox.core.partstack.ms");
                return null;
            }
            ((MPartStack)stacks.get(0)).getChildren().add(part);
            ((MPartStack)stacks.get(0)).setVisible(true);
            this.partService.showPart(part, EPartService.PartState.ACTIVATE);
        }
        return part;
    }

    List<ScanView> getScanViewData(MassSpecEntityProperty prop) throws Exception {
        MSPropertyDataFile msSourceFile = prop.getDataFile();
        MSFile msFile = msSourceFile.getMSFileWithReader(MassSpecProperty.getFullyQualifiedFolderName(this.entry), prop.getMassSpecParentProperty().getMassSpecMetaData().getMsExperimentType());
        IMSFileReader reader = msFile.getReader();
        if (reader == null || !(reader instanceof IMSAnnotationFileReader)) {
            return null;
        }
        int iMax = ((IMSAnnotationFileReader)reader).getMaxScanNumber(msFile);
        this.dtpdThreadedDialog.getMinorProgressBarListener(0).setMaxValue(iMax);
        this.dtpdThreadedDialog.getMinorProgressBarListener(0).setProgressMessage("Reading data file...");
        reader.addProgressListeners((IProgressListener)this.dtpdThreadedDialog.getMinorProgressBarListener(0));
        List scans = ((IMSAnnotationFileReader)reader).readMSFileForView(msFile, 1, -1, -1);
        this.dtpdThreadedDialog.getMinorProgressBarListener(0).setProgressMessage("Done...");
        return scans;
    }

    public int addMSScansTab_Step1(MassSpecEntityProperty prop) {
        try {
            int iSuccess = this.initScansView(prop);
            this.dtpdThreadedDialog.setMinorStatus(iSuccess);
            if (iSuccess == GRITSProcessStatus.CANCEL) {
                this.setStatus(GRITSProcessStatus.CANCEL);
                return GRITSProcessStatus.CANCEL;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open MS Scans view", (Throwable)ex);
            this.setStatus(GRITSProcessStatus.ERROR);
        }
        if (this.getStatus() == GRITSProcessStatus.ERROR) {
            String sMessage = "An error occurred creating the MS Scans tab.";
            this.dtpdThreadedDialog.getMajorProgressBarListener().setError(sMessage);
        }
        return this.getStatus();
    }

    public int addMSScansTab_Step2() {
        try {
            boolean success = true;
            int iPageCount = this.getPageCount();
            try {
                int inx = this.getScansViewTabIndex();
                if (inx >= this.getPageCount()) {
                    inx = this.addPage((IEntryEditorPart)this.scansView, this.entry);
                    this.setScansViewTabIndex(inx);
                } else {
                    this.addPage(inx, (IEntryEditorPart)this.scansView, this.entry);
                }
                this.setPageText(inx, "MS Scans");
                this.setActivePage(inx);
                int iSuccess = this.scansView.getStatus();
                this.setStatus(iSuccess);
                this.dtpdThreadedDialog.setMinorStatus(iSuccess);
            }
            catch (Exception ex) {
                logger.error((Object)"Error adding MS Scans tab.", (Throwable)ex);
                this.setStatus(GRITSProcessStatus.ERROR);
            }
            boolean bl = success = this.getStatus() != GRITSProcessStatus.ERROR;
            if (!success) {
                if (this.getPageCount() != iPageCount) {
                    this.removePage(this.getPageCount() - 1);
                }
                this.scansView = null;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open MS Scans view", (Throwable)ex);
            this.setStatus(GRITSProcessStatus.ERROR);
        }
        if (this.getStatus() == GRITSProcessStatus.ERROR) {
            String sMessage = "An error occurred creating the MS Scans tab.";
            this.dtpdThreadedDialog.getMajorProgressBarListener().setError(sMessage);
        }
        return this.getStatus();
    }

    public int addPeakListPage_Step1(MassSpecEntityProperty prop) {
        try {
            int iSuccess = this.initPeaksView(prop);
            this.dtpdThreadedDialog.setMinorStatus(iSuccess);
            if (iSuccess == GRITSProcessStatus.CANCEL) {
                this.setStatus(GRITSProcessStatus.CANCEL);
                return GRITSProcessStatus.CANCEL;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open MS Peaks view", (Throwable)ex);
            this.setStatus(GRITSProcessStatus.ERROR);
        }
        if (this.getStatus() == GRITSProcessStatus.ERROR) {
            String sMessage = "An error occurred creating the MS Peaks tab.";
            this.dtpdThreadedDialog.getMajorProgressBarListener().setError(sMessage);
        }
        return this.getStatus();
    }

    public int addPeakListPage_Step2() {
        try {
            boolean success = true;
            int iPageCount = this.getPageCount();
            try {
                int inx = this.getPeaksViewsFirstTabIndex();
                if (inx >= this.getPageCount()) {
                    inx = this.addPage((IEntryEditorPart)this.alPeaksViews.get(0), this.entry);
                    this.setPeaksViewsFirstTabIndex(inx);
                } else {
                    this.addPage(inx, (IEntryEditorPart)this.alPeaksViews.get(0), this.entry);
                }
                this.setPageText(inx, "Peak List");
                this.setActivePage(inx);
                int iSuccess = this.scansView.getStatus();
                this.setStatus(iSuccess);
                this.dtpdThreadedDialog.setMinorStatus(iSuccess);
            }
            catch (Exception ex) {
                logger.error((Object)"Error adding Peaks List tab.", (Throwable)ex);
                this.setStatus(GRITSProcessStatus.ERROR);
            }
            boolean bl = success = this.getStatus() != GRITSProcessStatus.ERROR;
            if (!success) {
                if (this.getPageCount() != iPageCount) {
                    this.removePage(this.getPageCount());
                }
                this.alPeaksViews = null;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open MS Peaks view", (Throwable)ex);
            this.setStatus(GRITSProcessStatus.ERROR);
        }
        if (this.getStatus() == GRITSProcessStatus.ERROR) {
            String sMessage = "An error occurred creating the MS Peaks tab.";
            this.dtpdThreadedDialog.getMajorProgressBarListener().setError(sMessage);
        }
        return this.getStatus();
    }

    public int addExternalQuantPage_Step1(MassSpecEntityProperty prop) {
        try {
            int iSuccess = this.initPeaksView(prop);
            this.dtpdThreadedDialog.setMinorStatus(iSuccess);
            if (iSuccess == GRITSProcessStatus.CANCEL) {
                this.setStatus(GRITSProcessStatus.CANCEL);
                return GRITSProcessStatus.CANCEL;
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Unable to open External Quant tab: " + prop.getPeakListNumber()), (Throwable)ex);
            this.setStatus(GRITSProcessStatus.ERROR);
        }
        if (this.getStatus() == GRITSProcessStatus.ERROR) {
            String sMessage = "An error occurred creating the External Quant tab: " + prop.getPeakListNumber();
            this.dtpdThreadedDialog.getMajorProgressBarListener().setError(sMessage);
        }
        return this.getStatus();
    }

    public int addExternalQuantPage_Step2(String sTitle, MassSpecEntityProperty prop) {
        try {
            boolean success = true;
            int iPageCount = this.getPageCount();
            try {
                int inx = this.addPage((IEntryEditorPart)this.alPeaksViews.get(prop.getPeakListNumber()), this.entry);
                this.setPageText(inx, sTitle);
                this.setActivePage(inx);
                int iSuccess = this.alPeaksViews.get(prop.getPeakListNumber()).getStatus();
                this.setStatus(iSuccess);
                this.dtpdThreadedDialog.setMinorStatus(iSuccess);
            }
            catch (Exception ex) {
                logger.error((Object)("Error adding External Quant tab: " + prop.getPeakListNumber()), (Throwable)ex);
                this.setStatus(GRITSProcessStatus.ERROR);
            }
            boolean bl = success = this.getStatus() != GRITSProcessStatus.ERROR;
            if (!success) {
                if (this.getPageCount() != iPageCount) {
                    this.removePage(this.getPageCount());
                }
                this.alPeaksViews.set(prop.getPeakListNumber(), null);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Unable to open External Quant tab: " + prop.getPeakListNumber()), (Throwable)ex);
            this.setStatus(GRITSProcessStatus.ERROR);
        }
        if (this.getStatus() == GRITSProcessStatus.ERROR) {
            String sMessage = "An error occurred creating the External Quant tab: " + prop.getPeakListNumber();
            this.dtpdThreadedDialog.getMajorProgressBarListener().setError(sMessage);
        }
        return this.getStatus();
    }

    public void createPages() {
        if (this.entry == null || !(this.entry.getProperty() instanceof MassSpecEntityProperty)) {
            this.entry = this.getFirstPageEntry();
        }
        if (this.entry.getProperty() instanceof MassSpecEntityProperty && ((MassSpecEntityProperty)this.entry.getProperty()).getDataFile() != null) {
            this.msFile = ((MassSpecEntityProperty)this.entry.getProperty()).getDataFile();
        }
        Property prop = this.entry.getProperty();
        int iNumSteps = this.getNumMajorSteps((MassSpecEntityProperty)prop);
        this.getPart().getContext().set(MassSpecMultiPageViewer.class, (Object)this);
        this.iStatus = this.addPages(iNumSteps, (MassSpecEntityProperty)prop);
        String fileNameHeader = this.msFile != null ? this.msFile.getName().substring(this.msFile.getName().lastIndexOf(File.separator) + 1) : "";
        this.setPartName(String.valueOf(this.entry.getDisplayName()) + " (" + fileNameHeader + ")");
        this.setActivePage();
    }

    protected boolean initMSPropertyView() {
        try {
            this.propertyView = (MassSpecPropertyView)((Object)ContextInjectionFactory.make(MassSpecPropertyView.class, (IEclipseContext)this.getPart().getContext()));
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open ms property view", (Throwable)ex);
            return false;
        }
    }

    protected int initScansView(MassSpecEntityProperty entityProperty) {
        try {
            this.scansView = this.getNewScansView(this.entry, entityProperty);
            int iSuccess = this.scansView.setTableDataProcessor(this.dtpdThreadedDialog);
            return iSuccess;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open scans view", (Throwable)ex);
            return GRITSProcessStatus.ERROR;
        }
    }

    protected int reInitScansView(List<String> columnKeys) {
        try {
            this.scansView.getTableDataProcessor().setProgressBarDialog(this.dtpdThreadedDialog);
            this.scansView.reLoadView();
            if (columnKeys != null) {
                for (String keyVal : columnKeys) {
                    this.scansView.getViewBase().getNatTable().moveToFirstColumn(keyVal);
                }
                this.scansView.getViewBase().getNatTable().updatePreferenceSettingsFromCurrentView();
                this.scansView.getViewBase().getNatTable().getGRITSTableDataObject().getTablePreferences().writePreference();
            }
            return GRITSProcessStatus.OK;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open scans view", (Throwable)ex);
            return GRITSProcessStatus.ERROR;
        }
    }

    public boolean needsPeaksView(MassSpecEntityProperty entityProperty) {
        return entityProperty.getScanNum() != null && entityProperty.getScanNum() > 0;
    }

    public boolean needsSpectraView(MassSpecEntityProperty entityProperty) {
        return true;
    }

    protected int initPeaksView(MassSpecEntityProperty entityProperty) {
        try {
            MassSpecEntityProperty msProp = (MassSpecEntityProperty)((Object)entityProperty.clone());
            MassSpecPeaksView peaksView = this.getNewPeaksView(this.entry, msProp);
            int iSuccess = peaksView.setTableDataProcessor(this.dtpdThreadedDialog);
            if (iSuccess == GRITSProcessStatus.OK) {
                this.alPeaksViews.add(peaksView);
            }
            return iSuccess;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open peaks view", (Throwable)ex);
            return GRITSProcessStatus.ERROR;
        }
    }

    protected MassSpecSpectraView getNewSpectraView() {
        this.getPart().getContext().set(Entry.class, (Object)this.entry);
        MassSpecSpectraView view = (MassSpecSpectraView)ContextInjectionFactory.make(MassSpecSpectraView.class, (IEclipseContext)this.getPart().getContext());
        return view;
    }

    protected boolean initSpectraView(MassSpecEntityProperty prop) throws MSException {
        try {
            int iMSLevelForSpectrum = 1;
            if (prop.getMsLevel() != null) {
                iMSLevelForSpectrum = prop.getMsLevel();
                if (this.entry.getParent().getProperty() instanceof MassSpecEntityProperty) {
                    MassSpecEntityProperty parentProp = (MassSpecEntityProperty)this.entry.getParent().getProperty();
                    iMSLevelForSpectrum = parentProp.getMsLevel();
                }
            }
            this.spectraView = this.getNewSpectraView();
            if (this.getScansView() != null) {
                MassSpecTableDataProcessor scansTableProcessor = (MassSpecTableDataProcessor)this.getScansView().getTableDataProcessor();
                this.spectraView.setScanListTableProcessor(scansTableProcessor);
            }
            if (this.getPeaksView() != null && !this.getPeaksView().isEmpty()) {
                MassSpecTableDataProcessor peaksTableProcessor = (MassSpecTableDataProcessor)this.getPeaksView().get(0).getTableDataProcessor();
                this.spectraView.setPeakListTableProcessor(peaksTableProcessor);
            }
            this.spectraView.setMSLevel(iMSLevelForSpectrum);
            this.spectraView.setScanNum(prop.getScanNum());
            this.updateMSView(prop, this.spectraView);
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open spectra view", (Throwable)ex);
            return false;
        }
    }

    protected MassSpecProperty getMSProperty(Entry entry) {
        if (entry == null || entry.getProperty() == null) {
            return null;
        }
        if (entry.getProperty() instanceof MassSpecProperty) {
            return (MassSpecProperty)entry.getProperty();
        }
        return this.getMSProperty(entry.getParent());
    }

    protected void updateMSView(MassSpecEntityProperty msProperty, MassSpecSpectraView view) throws MSException {
        if (msProperty == null) {
            return;
        }
        String sMzXMLFile = null;
        if (!(msProperty.getScanNum() != null && msProperty.getScanNum() > 0 || msProperty.getMassSpecParentProperty().getMassSpecMetaData().getMzXMLFullFileName() == null || msProperty.getMassSpecParentProperty().getMassSpecMetaData().getMzXMLFullFileName().equals(""))) {
            sMzXMLFile = String.valueOf(MassSpecProperty.getFullyQualifiedFolderName(this.entry)) + File.separator + msProperty.getMassSpecParentProperty().getMassSpecMetaData().getMzXMLFullFileName();
        } else if (msProperty.getDataFile() != null && !msProperty.getDataFile().getName().equals("")) {
            sMzXMLFile = String.valueOf(MassSpecProperty.getFullyQualifiedFolderName(this.entry)) + File.separator + msProperty.getDataFile().getName();
        }
        view.setDescription(this.entry.getDisplayName());
        view.setMzXMLFile(sMzXMLFile);
        view.setScanNum(msProperty.getScanNum());
        try {
            view.createChart(this.getContainer());
        }
        catch (MSException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"Unable to update spectra view", (Throwable)e);
        }
    }

    protected void updateColumnVisibility(MassSpecTable table, MassSpecViewerPreference curPref, MassSpecViewerPreference updatePref) {
        if (curPref.getClass().equals(updatePref.getClass()) && curPref.getMSLevel() == updatePref.getMSLevel() && curPref.getFillType() == updatePref.getFillType() && !updatePref.getColumnSettings().equals(curPref.getColumnSettings())) {
            table.getGRITSTableDataObject().setTablePreferences((TableViewerPreference)updatePref);
            table.updateViewFromPreferenceSettings();
        }
    }

    protected void updateColumnVisibilityForView(MassSpecScansView scansView, MassSpecViewerPreference updatePref) {
        try {
            if (scansView == null || scansView.getViewBase() == null) {
                return;
            }
            MassSpecTableBase viewBase = scansView.getViewBase();
            if (viewBase.getNatTable() == null) {
                return;
            }
            MassSpecTable table = viewBase.getNatTable();
            MassSpecViewerPreference curPref = (MassSpecViewerPreference)table.getGRITSTableDataObject().getTablePreferences();
            this.updateColumnVisibility(table, curPref, updatePref);
        }
        catch (Exception ex) {
            logger.error((Object)("Error updating scans view from editor: " + this.getTitle()), (Throwable)ex);
        }
    }

    protected void updateColumnVisibility(MassSpecViewerPreference updatePref) {
        if (this.getScansView() != null) {
            try {
                MassSpecScansView scansView = this.getScansView();
                this.updateColumnVisibilityForView(scansView, updatePref);
            }
            catch (Exception ex) {
                logger.error((Object)("Error updating scans view from editor: " + this.getTitle()), (Throwable)ex);
            }
        }
        if (this.getPeaksView() != null) {
            int j = 0;
            while (j < this.getPeaksView().size()) {
                try {
                    MassSpecPeaksView peaksView = this.getPeaksView().get(j);
                    this.updateColumnVisibilityForView(peaksView, updatePref);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error updating peak view: " + j + " from editor: " + this.getTitle()), (Throwable)ex);
                }
                ++j;
            }
        }
    }

    @Optional
    @Inject
    public void updatePreferences(@UIEventTopic(value="preference_value_changed_in_grits") String preferenceName) {
        if (MassSpecViewerPreference.getPreferenceID().equals(preferenceName)) {
            try {
                PreferenceEntity preferenceEntity = this.gritsPreferenceStore.getPreferenceEntity(preferenceName);
                MassSpecViewerPreference updatePref = (MassSpecViewerPreference)TableViewerPreference.getTableViewerPreference((PreferenceEntity)preferenceEntity, MassSpecViewerPreference.class);
                this.updateColumnVisibility(updatePref);
            }
            catch (UnsupportedVersionException e) {
                logger.error((Object)"Error updating column visibility", (Throwable)e);
            }
        }
    }

    public static MassSpecMultiPageViewer getActiveViewerForEntry(IEclipseContext context, Entry entry) {
        EPartService partService = (EPartService)context.get(EPartService.class);
        for (MPart part : partService.getParts()) {
            if (!(part.getObject() instanceof MassSpecMultiPageViewer) || !((MassSpecMultiPageViewer)((Object)part.getObject())).getEntry().equals(entry)) continue;
            return (MassSpecMultiPageViewer)((Object)part.getObject());
        }
        return null;
    }

    protected MassSpecScansView getNewScansView(Entry entry, MassSpecEntityProperty entityProperty) {
        MassSpecEntityProperty msProp = (MassSpecEntityProperty)((Object)entityProperty.clone());
        msProp.setParentScanNum(entityProperty.getScanNum());
        msProp.setScanNum(null);
        this.getPart().getContext().set(MIN_MS_LEVEL_CONTEXT, (Object)this.getMinMSLevel());
        this.getPart().getContext().set(Property.class, (Object)msProp);
        this.getPart().getContext().set(Entry.class, (Object)entry);
        MassSpecScansView view = (MassSpecScansView)ContextInjectionFactory.make(MassSpecScansView.class, (IEclipseContext)this.getPart().getContext());
        return view;
    }

    protected MassSpecPeaksView getNewPeaksView(Entry entry, MassSpecEntityProperty entityProperty) {
        this.getPart().getContext().set(MIN_MS_LEVEL_CONTEXT, (Object)this.getMinMSLevel());
        this.getPart().getContext().set(Property.class, (Object)entityProperty);
        this.getPart().getContext().set(Entry.class, (Object)entry);
        MassSpecPeaksView view = (MassSpecPeaksView)ContextInjectionFactory.make(MassSpecPeaksView.class, (IEclipseContext)this.getPart().getContext());
        return view;
    }

    public MassSpecScansView getScansView() {
        return this.scansView;
    }

    public List<MassSpecPeaksView> getPeaksView() {
        return this.alPeaksViews;
    }

    public void setDirty(boolean d) {
        this.dirtyable.setDirty(d);
    }

    public boolean isDirty() {
        return this.dirtyable.isDirty();
    }

    @Persist
    public void doSave(final IProgressMonitor monitor) {
        GRITSProgressDialog progressDialog = new GRITSProgressDialog(Display.getCurrent().getActiveShell(), 0, false, false);
        progressDialog.open();
        progressDialog.getMajorProgressBarListener().setMaxValue(3 + this.alPeaksViews.size());
        progressDialog.setGritsWorker(new GRITSWorker(){

            public int doWork() {
                if (MassSpecMultiPageViewer.this.propertyView != null && MassSpecMultiPageViewer.this.propertyView.isDirty()) {
                    this.updateListeners("Saving properties", 1);
                    MassSpecMultiPageViewer.this.propertyView.doSave(monitor);
                }
                if (MassSpecMultiPageViewer.this.scansView != null && MassSpecMultiPageViewer.this.scansView.isDirty()) {
                    this.updateListeners("Saving scans", 2);
                    MassSpecMultiPageViewer.this.scansView.doSave(monitor);
                }
                int i = 3;
                for (MassSpecPeaksView peaksView : MassSpecMultiPageViewer.this.alPeaksViews) {
                    if (peaksView == null || !peaksView.isDirty()) continue;
                    this.updateListeners("Saving changes", i++);
                    peaksView.doSave(monitor);
                }
                MassSpecMultiPageViewer.this.setDirty(false);
                this.updateListeners("Done saving", i);
                return GRITSProcessStatus.OK;
            }
        });
        progressDialog.startWorker();
    }

    @Optional
    @Inject
    public void tabContentModified(@UIEventTopic(value="content_modified_in_a_tab") IEntryEditorPart part) {
        if (part.equals((Object)this.propertyView) || part.equals(this.scansView) || this.alPeaksViews.contains(part)) {
            this.setDirty(part.isDirty());
        }
    }

    public static String[] getPreferencePageLabels(int _iMSLevel) {
        if (_iMSLevel == 1) {
            return new String[]{"MS Scans"};
        }
        return new String[]{"MS Scans", "Peak List"};
    }

    public static FillTypes[] getPreferencePageFillTypes(int _iMSLevel) {
        if (_iMSLevel == 1) {
            return new FillTypes[]{FillTypes.Scans};
        }
        return new FillTypes[]{FillTypes.Scans, FillTypes.PeakList};
    }

    public static int getPreferencePageMaxNumPages() {
        return 2;
    }

    @Focus
    public void setFocus() {
        this.getContainer().forceFocus();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("Window Closed")) {
            massSpecCustomAnnotationDialog = null;
        } else if (event.getProperty().equals("Window Closed")) {
            massSpecStandardQuantApplyDialog = null;
        }
    }
}

