/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.views.tabbed.content;

import java.io.File;
import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.grits.toolbox.entry.ms.property.FileLockManager;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.entry.ms.views.tabbed.content.FileContentProvider;
import org.grits.toolbox.ms.file.FileCategory;
import org.grits.toolbox.ms.file.MSFileInfo;

public class MassSpecFileListTableComposite
extends Composite {
    private List<MSPropertyDataFile> fileList;
    private TreeViewer fileTableViewer;
    private FileLockManager fileLockManager;
    private boolean inUsedRequired = true;

    public MassSpecFileListTableComposite(Composite parent, int style) {
        super(parent, style);
    }

    public MassSpecFileListTableComposite(Composite parent, int style, boolean inUseRequired) {
        this(parent, style);
        this.inUsedRequired = inUseRequired;
    }

    public void setFileList(List<MSPropertyDataFile> fileList) {
        this.fileList = fileList;
    }

    public TreeViewer getFileTableViewer() {
        return this.fileTableViewer;
    }

    public void setFileLockManager(FileLockManager fileLockManager) {
        this.fileLockManager = fileLockManager;
    }

    public void initComponents() {
        GridLayout layout2 = new GridLayout(1, true);
        layout2.marginWidth = 2;
        layout2.marginHeight = 2;
        this.setLayout((Layout)layout2);
        this.fileTableViewer = new TreeViewer((Composite)this, 67584);
        Tree fileTree = this.fileTableViewer.getTree();
        GridData gd_table_2 = new GridData(4, 4, true, true, 1, 1);
        gd_table_2.heightHint = 300;
        fileTree.setLayoutData((Object)gd_table_2);
        fileTree.setHeaderVisible(true);
        fileTree.setLinesVisible(true);
        TreeViewerColumn treeViewerColumn2 = new TreeViewerColumn(this.fileTableViewer, 0);
        TreeColumn tblclmnFile = treeViewerColumn2.getColumn();
        tblclmnFile.setWidth(300);
        tblclmnFile.setText("File");
        treeViewerColumn2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MSPropertyDataFile) {
                    String fileName;
                    String fileNameToDisplay = "";
                    fileNameToDisplay = ((MSPropertyDataFile)((Object)element)).getOriginalFileName() != null ? ((fileName = ((MSPropertyDataFile)((Object)element)).getOriginalFileName()).lastIndexOf(File.separator) != -1 ? fileName.substring(fileName.lastIndexOf(File.separator) + 1) : fileName) : ((fileName = ((MSPropertyDataFile)((Object)element)).getName()).lastIndexOf(File.separator) != -1 ? fileName.substring(fileName.lastIndexOf(File.separator) + 1) : fileName);
                    if (((MSPropertyDataFile)((Object)element)).getIsParent().booleanValue()) {
                        if (fileNameToDisplay.isEmpty()) {
                            fileNameToDisplay = "<Not specified>";
                        }
                        if (((MSPropertyDataFile)((Object)element)).getCategory().equals((Object)FileCategory.ANNOTATION_CATEGORY)) {
                            return String.valueOf(FileCategory.ANNOTATION_CATEGORY.getLabel()) + " File: " + fileNameToDisplay;
                        }
                        if (((MSPropertyDataFile)((Object)element)).getCategory().equals((Object)FileCategory.EXTERNAL_QUANTIFICATION_CATEGORY)) {
                            return String.valueOf(FileCategory.EXTERNAL_QUANTIFICATION_CATEGORY.getLabel()) + " File: " + fileNameToDisplay;
                        }
                    } else {
                        return fileNameToDisplay;
                    }
                }
                return "";
            }
        });
        TreeViewerColumn treeViewerColumn3 = new TreeViewerColumn(this.fileTableViewer, 0);
        TreeColumn tblclmnFormat = treeViewerColumn3.getColumn();
        tblclmnFormat.setWidth(100);
        tblclmnFormat.setText("Format");
        treeViewerColumn3.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MSPropertyDataFile) {
                    return MSFileInfo.getMSFormat((String)((MSPropertyDataFile)((Object)element)).getType());
                }
                return "";
            }
        });
        if (this.inUsedRequired) {
            TreeViewerColumn treeViewerColumn4 = new TreeViewerColumn(this.fileTableViewer, 0);
            TreeColumn tblclmnType = treeViewerColumn4.getColumn();
            tblclmnType.setWidth(100);
            tblclmnType.setText("In Use");
            treeViewerColumn4.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    boolean locked;
                    if (element instanceof MSPropertyDataFile && MassSpecFileListTableComposite.this.fileLockManager != null && (locked = MassSpecFileListTableComposite.this.fileLockManager.isFileLocked(((MSPropertyDataFile)((Object)element)).getName()))) {
                        return "Yes";
                    }
                    return "No";
                }
            });
        }
        this.fileTableViewer.setContentProvider((IContentProvider)new FileContentProvider());
        if (this.fileList != null) {
            this.fileTableViewer.setInput(this.fileList);
        }
        this.fileTableViewer.expandAll();
    }
}

