/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.report.views;

import org.apache.log4j.Logger;
import org.grits.toolbox.entry.ms.annotation.glycan.report.property.MSGlycanAnnotationReportProperty;
import org.grits.toolbox.entry.ms.annotation.glycan.report.views.MSGlycanAnnotationReportMultiPageViewer;
import org.grits.toolbox.widgets.tools.GRITSProcessStatus;
import org.grits.toolbox.widgets.tools.GRITSWorker;

public class MSGlycanAnnotationReportMultiPageViewerWorker
extends GRITSWorker {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationReportMultiPageViewerWorker.class);
    protected int iMajorCount = 0;
    protected int iMajorMax = 0;
    protected MSGlycanAnnotationReportProperty prop = null;
    private MSGlycanAnnotationReportMultiPageViewer parentEditor = null;

    public MSGlycanAnnotationReportMultiPageViewerWorker(MSGlycanAnnotationReportMultiPageViewer parentEditor, int _iMajorCount, MSGlycanAnnotationReportProperty prop) {
        this.setParentEditor(parentEditor);
        this.iMajorMax = _iMajorCount;
        this.prop = prop;
    }

    public int doWork() {
        this.iMajorCount = 0;
        int iSuccess = this.addResultsPage(this.prop, this.iMajorCount);
        ++this.iMajorCount;
        if (iSuccess != GRITSProcessStatus.OK) {
            return iSuccess;
        }
        if ((iSuccess = this.addPropertyPage(this.iMajorCount++)) != GRITSProcessStatus.OK) {
            return iSuccess;
        }
        this.updateListeners("Finished MS Glycan Report work!", this.iMajorCount);
        logger.debug((Object)"Finished MS Glycan Report work");
        return iSuccess;
    }

    public MSGlycanAnnotationReportMultiPageViewer getParentEditor() {
        return this.parentEditor;
    }

    public void setParentEditor(MSGlycanAnnotationReportMultiPageViewer parentEditor) {
        this.parentEditor = parentEditor;
    }

    public int addResultsPage(MSGlycanAnnotationReportProperty prop, int iProcessCount) {
        try {
            this.updateListeners("Creating Results tab (loading)", iProcessCount);
            int iSuccess = this.getParentEditor().addResultsPage_Step1(prop);
            if (iSuccess != GRITSProcessStatus.OK) {
                return iSuccess;
            }
            this.updateListeners("CreatingResults tab (populating)", iProcessCount + 1);
            iSuccess = this.getParentEditor().addResultsPage_Step2();
            this.updateListeners("Creating Results tab (done)", iProcessCount + 2);
            return iSuccess;
        }
        catch (Exception e) {
            logger.error((Object)"Unable to open MS property view", (Throwable)e);
            return GRITSProcessStatus.ERROR;
        }
    }

    public int addPropertyPage(int iProcessCount) {
        try {
            this.updateListeners("Creating property tab (loading)", iProcessCount);
            int iSuccess = this.getParentEditor().addPropertyPage();
            this.updateListeners("Creating property tab (done)", iProcessCount + 1);
            return iSuccess;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open MS property view", (Throwable)ex);
            return GRITSProcessStatus.ERROR;
        }
    }
}

