/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.archive.dialog.uploadfile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.entry.archive.editor.pages.archivedfile.FileArchivePage;
import org.grits.toolbox.entry.archive.model.ArchivedFile;

public class DownloadFileDialog
extends TitleAreaDialog {
    private static Logger logger = Logger.getLogger(DownloadFileDialog.class);
    private FileArchivePage fileArchivePage = null;
    private ArchivedFile selectedArchivedFile = null;
    private Set<String> existingNames = null;
    private Text locationText = null;
    private Button overwrite = null;

    public DownloadFileDialog(FileArchivePage fileArchivePage, ArchivedFile inputArchivedFile) {
        super(Display.getCurrent().getActiveShell());
        this.fileArchivePage = fileArchivePage;
        this.selectedArchivedFile = inputArchivedFile;
        this.existingNames = new HashSet<String>();
    }

    public void create() {
        super.create();
        this.setTitle("Download File");
        this.setMessage("Download File From the Archive");
        this.getShell().setText("Download");
        this.getButton(0).setText("Download");
        this.getShell().setSize(700, 360);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 2048);
        container.setLayoutData((Object)new GridData(4, 1024, false, false));
        GridLayout layout = new GridLayout(5, false);
        layout.marginTop = 10;
        layout.marginBottom = 20;
        layout.marginLeft = 10;
        layout.marginRight = 10;
        layout.verticalSpacing = 20;
        layout.horizontalSpacing = 10;
        container.setLayout((Layout)layout);
        this.locationText = new Text(container, 2049);
        GridData textData = new GridData(4, 1, true, false);
        textData.horizontalSpan = 4;
        textData.minimumWidth = 300;
        this.locationText.setLayoutData((Object)textData);
        Button browseFolderButton = new Button(container, 8);
        browseFolderButton.setText(" Download Location ");
        GridData browseButtonGridData = new GridData(128);
        browseButtonGridData.horizontalSpan = 1;
        browseFolderButton.setLayoutData((Object)browseButtonGridData);
        Font currentFont = Display.getCurrent().getSystemFont();
        FontData fontData = currentFont.getFontData()[0];
        Font boldFont = new Font((Device)Display.getCurrent(), fontData.getName(), fontData.getHeight(), 1);
        Label label = new Label(container, 8);
        GridData labelData = new GridData(16384);
        labelData.horizontalSpan = 4;
        label.setLayoutData((Object)labelData);
        this.overwrite = new Button(container, 32);
        this.overwrite.setText("Overwrite Existing");
        this.overwrite.setSelection(false);
        this.overwrite.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DownloadFileDialog.this.verifyInput();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DownloadFileDialog.this.verifyInput();
            }
        });
        label = new Label(container, 8);
        label.setText("Selected Archive     ");
        Label selectFilesLabel = new Label(container, 8);
        GridData fileLabelData = new GridData(16384);
        fileLabelData.horizontalSpan = 1;
        selectFilesLabel.setLayoutData((Object)fileLabelData);
        selectFilesLabel.setText(this.selectedArchivedFile.getTypicalArchivedFile().getFileName());
        selectFilesLabel.setFont(boldFont);
        browseFolderButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DownloadFileDialog.this.setErrorMessage(null);
                String selected = null;
                FileDialog fileDialog = new FileDialog(DownloadFileDialog.this.getShell(), 8192);
                fileDialog.setFileName(DownloadFileDialog.this.selectedArchivedFile.getTypicalArchivedFile().getFileName());
                fileDialog.setOverwrite(true);
                fileDialog.setText("Save Location");
                selected = fileDialog.open();
                if (selected != null) {
                    try {
                        DownloadFileDialog.this.existingNames = new HashSet<String>(Arrays.asList(new File(selected).getParentFile().list()));
                        DownloadFileDialog.this.locationText.setText(selected);
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex.getMessage(), (Throwable)ex);
                        DownloadFileDialog.this.setErrorMessage("Please select a valid location to download.");
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.locationText.setText("");
        this.locationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DownloadFileDialog.this.verifyInput();
            }
        });
        browseFolderButton.setFocus();
        composite.setLayoutData((Object)new GridData(1808));
        return composite;
    }

    protected void verifyInput() {
        this.setErrorMessage(null);
        String location = this.locationText.getText().trim();
        if (location.isEmpty()) {
            this.setErrorMessage("Please select a valid location to download.");
        } else {
            try {
                File file = Paths.get(location, new String[0]).toFile();
                if (file != null) {
                    String downloadFileName = file.getName();
                    File parentFolder = file.getParentFile();
                    if (parentFolder != null && parentFolder.exists()) {
                        if (downloadFileName == null || downloadFileName.isEmpty()) {
                            this.setErrorMessage("The file name cannot be empty. Please choose a valid name for the download file.");
                        } else if (this.existingNames.contains(downloadFileName) && !this.overwrite.getSelection()) {
                            this.setErrorMessage("The file name already exists. You need to check overwrite to overwrite the existing file in the selected folder.");
                        }
                    } else {
                        this.setErrorMessage("The selected file parent directory does not exist. Please select a valid directory to download.");
                    }
                } else {
                    this.setErrorMessage("Please select a valid location to download.");
                }
            }
            catch (InvalidPathException invalidPathException) {
                this.setErrorMessage("Select a valid location");
            }
        }
    }

    public void setErrorMessage(String newErrorMessage) {
        super.setErrorMessage(newErrorMessage);
        this.getButton(0).setEnabled(newErrorMessage == null);
    }

    protected void okPressed() {
        String location = this.locationText.getText().trim();
        try {
            File downloadFolder = null;
            String downloadName = null;
            try {
                File file = Paths.get(location, new String[0]).toFile();
                downloadFolder = file.getParentFile();
                downloadName = file.getName();
            }
            catch (Exception exception) {
                this.setErrorMessage("Select a valid folder location.");
            }
            if (downloadFolder != null && downloadFolder.isDirectory()) {
                int len;
                File archiveFile = new File(this.fileArchivePage.getEditor().getArchiveFolder(), this.selectedArchivedFile.getTypicalArchivedFile().getFileName());
                FileInputStream fis = new FileInputStream(archiveFile);
                File downloadFile = new File(downloadFolder, downloadName);
                FileOutputStream fileOutputStream = new FileOutputStream(downloadFile);
                byte[] buffer = new byte[1024];
                while ((len = fis.read(buffer)) > 0) {
                    fileOutputStream.write(buffer, 0, len);
                }
                fileOutputStream.close();
                fis.close();
                super.okPressed();
            } else {
                this.setErrorMessage("Select a valid folder location.");
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("Error downloading " + this.selectedArchivedFile.getTypicalArchivedFile().getFileName() + "\n" + e.getMessage()), (Throwable)e);
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Download Problem", (String)("The selected file could not be downloaded from the archive \"" + this.selectedArchivedFile.getTypicalArchivedFile().getFileName() + "\".\n" + e.getMessage()));
            super.cancelPressed();
        }
        catch (Exception e) {
            logger.error((Object)("Error downloading " + this.selectedArchivedFile.getTypicalArchivedFile().getFileName() + "\n" + e.getMessage()), (Throwable)e);
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Download Problem", (String)("The selected file could not be downloaded.\n\"" + this.selectedArchivedFile.getTypicalArchivedFile().getFileName() + "\""));
            super.cancelPressed();
        }
    }
}

