/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.figures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.visualization.widgets.datadefinition.IManualValueChangeListener;
import org.eclipse.nebula.visualization.widgets.figureparts.Bulb;
import org.eclipse.nebula.visualization.widgets.figureparts.PolarPoint;
import org.eclipse.nebula.visualization.widgets.figureparts.RoundScale;
import org.eclipse.nebula.visualization.widgets.figureparts.RoundScaledRamp;
import org.eclipse.nebula.visualization.widgets.figures.AbstractRoundRampedFigure;
import org.eclipse.nebula.visualization.widgets.util.GraphicsUtil;
import org.eclipse.nebula.visualization.widgets.util.PointsUtil;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.widgets.Display;

public class KnobFigure
extends AbstractRoundRampedFigure {
    private static final Color WHITE_COLOR = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_WHITE);
    private static final Color GRAY_COLOR = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_GRAY);
    private static final Font DEFAULT_LABEL_FONT = XYGraphMediaFactory.getInstance().getFont(new FontData("Arial", 12, 1));
    private static final int BORDER_WIDTH = 2;
    private static final int DISABLED_ALPHA = 100;
    private boolean effect3D = true;
    private double increment = 1.0;
    private Thumb thumb;
    private Bulb bulb;
    private Color thumbColor = GRAY_COLOR;
    private Label valueLabel;
    private List<IManualValueChangeListener> knobListeners = new ArrayList<IManualValueChangeListener>();

    public KnobFigure() {
        this.transparent = true;
        this.scale.setScaleLineVisible(false);
        this.ramp.setRampWidth(12);
        this.valueLabel = new Label();
        this.valueLabel.setFont(DEFAULT_LABEL_FONT);
        this.bulb = new Bulb();
        this.thumb = new Thumb();
        this.thumb.setOutline(false);
        this.setLayoutManager((LayoutManager)new KnobLayout());
        this.add((IFigure)this.ramp, "ramp");
        this.add((IFigure)this.bulb, "bulb");
        this.add((IFigure)this.scale, "scale");
        this.add((IFigure)this.valueLabel, "valueLabel");
        this.add((IFigure)this.thumb, "thumb");
        this.addFigureListener(new FigureListener(){

            public void figureMoved(IFigure source) {
                KnobFigure.this.ramp.setDirty(true);
                KnobFigure.this.revalidate();
            }
        });
    }

    public void addManualValueChangeListener(IManualValueChangeListener listener) {
        this.knobListeners.add(listener);
    }

    private double calcValueChange(double difference, double oldValue) {
        double change;
        double dragRange = ((RoundScale)this.scale).getLengthInDegrees();
        if (this.scale.isLogScaleEnabled()) {
            double c = dragRange / (Math.log10(this.scale.getRange().getUpper()) - Math.log10(this.scale.getRange().getLower()));
            change = oldValue * (Math.pow(10.0, -difference / c) - 1.0);
        } else {
            change = -(this.scale.getRange().getUpper() - this.scale.getRange().getLower()) * difference / dragRange;
        }
        return change;
    }

    private void fireManualValueChange(double newManualValue) {
        for (IManualValueChangeListener l : this.knobListeners) {
            l.manualValueChanged(newManualValue);
        }
    }

    public double getIncrement() {
        return this.increment;
    }

    public Color getThumbColor() {
        return this.thumbColor;
    }

    public boolean isEffect3D() {
        return this.effect3D;
    }

    public void manualSetValue(double value) {
        this.setValue(this.getCoercedValue(value));
    }

    protected void paintClientArea(Graphics graphics) {
        super.paintClientArea(graphics);
        if (!this.isEnabled()) {
            graphics.setAlpha(100);
            graphics.setBackgroundColor(GRAY_COLOR);
            graphics.fillRectangle(this.bounds);
        }
    }

    public void removeManualValueChangeListener(IManualValueChangeListener listener) {
        if (this.knobListeners.contains(listener)) {
            this.knobListeners.remove(listener);
        }
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
    }

    public void setBulbColor(Color color) {
        this.bulb.setBulbColor(color);
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        this.thumb.setCursor(cursor);
    }

    public void setEffect3D(boolean effect3D) {
        this.effect3D = effect3D;
        this.bulb.setEffect3D(effect3D);
        this.repaint();
    }

    public void setEnabled(boolean value) {
        super.setEnabled(value);
        if (value) {
            this.thumb.setCursor(Cursors.HAND);
        }
        this.repaint();
    }

    public void setFont(Font f) {
        this.scale.setFont(f);
        super.setFont(f);
    }

    public void setIncrement(double increment) {
        this.increment = increment;
    }

    public void setThumbColor(Color thumbColor) {
        if (this.thumbColor != null && this.thumbColor.equals((Object)thumbColor)) {
            return;
        }
        this.thumbColor = thumbColor;
        this.repaint();
    }

    @Override
    public void setValue(double value) {
        super.setValue(value);
        this.valueLabel.setText(this.getValueText());
    }

    public void setValueLabelVisibility(boolean visible) {
        this.valueLabel.setVisible(visible);
    }

    class KnobLayout
    extends AbstractLayout {
        private static final int GAP_BTW_BULB_SCALE = 4;
        public static final String SCALE = "scale";
        public static final String BULB = "bulb";
        public static final String RAMP = "ramp";
        public static final String THUMB = "thumb";
        public static final String VALUE_LABEL = "valueLabel";
        private RoundScale scale;
        private RoundScaledRamp ramp;
        private Bulb bulb;
        private Thumb thumb;
        private Label valueLabel;

        KnobLayout() {
        }

        protected Dimension calculatePreferredSize(IFigure container, int w, int h) {
            Insets insets = container.getInsets();
            Dimension d = new Dimension(256, 256);
            d.expand(insets.getWidth(), insets.getHeight());
            return d;
        }

        public void layout(IFigure container) {
            Rectangle area = container.getClientArea();
            area.height = area.width = Math.min(area.width, area.height);
            area.shrink(2, 2);
            Point center = area.getCenter();
            Rectangle bulbBounds = null;
            if (this.scale != null) {
                this.scale.setBounds(area);
                bulbBounds = area.getCopy();
                bulbBounds.shrink(area.width / 2 - this.scale.getInnerRadius() + 4, area.height / 2 - this.scale.getInnerRadius() + 4);
            }
            if (this.scale != null && this.ramp != null && this.ramp.isVisible()) {
                Rectangle rampBounds = area.getCopy();
                this.ramp.setBounds(rampBounds.shrink(area.width / 2 - this.scale.getInnerRadius() - this.ramp.getRampWidth() + 2, area.height / 2 - this.scale.getInnerRadius() - this.ramp.getRampWidth() + 2));
            }
            if (this.valueLabel != null && this.valueLabel.isVisible()) {
                Dimension labelSize = this.valueLabel.getPreferredSize();
                this.valueLabel.setBounds(new Rectangle(bulbBounds.x + bulbBounds.width / 2 - labelSize.width / 2, bulbBounds.y + bulbBounds.height * 3 / 4 - labelSize.height / 2, labelSize.width, labelSize.height));
            }
            if (this.bulb != null && this.scale != null && this.bulb.isVisible()) {
                this.bulb.setBounds(bulbBounds);
            }
            if (this.scale != null && this.thumb != null && this.thumb.isVisible()) {
                Point thumbCenter = new Point((double)bulbBounds.x + (double)bulbBounds.width * 7.0 / 8.0, (double)(bulbBounds.y + bulbBounds.height / 2));
                double valuePosition = 360.0 - this.scale.getValuePosition(KnobFigure.this.getCoercedValue(), false);
                thumbCenter = PointsUtil.rotate(thumbCenter, valuePosition, center);
                int thumbDiameter = bulbBounds.width / 6;
                this.thumb.setBounds(new Rectangle(thumbCenter.x - thumbDiameter / 2, thumbCenter.y - thumbDiameter / 2, thumbDiameter, thumbDiameter));
            }
        }

        public void setConstraint(IFigure child, Object constraint) {
            if (constraint.equals(SCALE)) {
                this.scale = (RoundScale)child;
            } else if (constraint.equals(RAMP)) {
                this.ramp = (RoundScaledRamp)child;
            } else if (constraint.equals(BULB)) {
                this.bulb = (Bulb)child;
            } else if (constraint.equals(THUMB)) {
                this.thumb = (Thumb)child;
            } else if (constraint.equals(VALUE_LABEL)) {
                this.valueLabel = (Label)child;
            }
        }
    }

    class Thumb
    extends Ellipse {
        public Thumb() {
            this.setCursor(Cursors.HAND);
            ThumbDragger thumbDragger = new ThumbDragger();
            this.addMouseMotionListener((MouseMotionListener)thumbDragger);
            this.addMouseListener(thumbDragger);
        }

        public void setEnabled(boolean value) {
            super.setEnabled(value);
        }

        protected void fillShape(Graphics graphics) {
            graphics.setAntialias(1);
            Pattern pattern = null;
            graphics.setBackgroundColor(KnobFigure.this.thumbColor);
            boolean support3D = GraphicsUtil.testPatternSupported(graphics);
            if (support3D && KnobFigure.this.effect3D) {
                try {
                    graphics.setBackgroundColor(KnobFigure.this.thumbColor);
                    super.fillShape(graphics);
                    pattern = GraphicsUtil.createScaledPattern(graphics, (Device)Display.getCurrent(), this.bounds.x, this.bounds.y, this.bounds.x + this.bounds.width, this.bounds.y + this.bounds.height, WHITE_COLOR, 0, WHITE_COLOR, 255);
                    graphics.setBackgroundPattern(pattern);
                }
                catch (Exception exception) {
                    support3D = false;
                    pattern.dispose();
                }
            }
            super.fillShape(graphics);
            if (KnobFigure.this.effect3D && support3D) {
                pattern.dispose();
            }
            graphics.setForegroundColor(KnobFigure.this.thumbColor);
        }

        class ThumbDragger
        extends MouseMotionListener.Stub
        implements MouseListener {
            private PolarPoint startPP;
            protected double oldValuePosition;
            protected boolean armed;
            Point pole;

            ThumbDragger() {
            }

            public void mouseDoubleClicked(MouseEvent me) {
            }

            public void mouseDragged(MouseEvent me) {
                if (!this.armed) {
                    return;
                }
                PolarPoint currentPP = PolarPoint.point2PolarPoint(this.pole, me.getLocation());
                currentPP.rotateAxis(((RoundScale)((Thumb)Thumb.this).KnobFigure.this.scale).getEndAngle(), false);
                if (currentPP.theta * 180.0 / Math.PI > ((RoundScale)((Thumb)Thumb.this).KnobFigure.this.scale).getLengthInDegrees()) {
                    currentPP.theta = Math.abs(((RoundScale)((Thumb)Thumb.this).KnobFigure.this.scale).getValuePosition(KnobFigure.this.getCoercedValue(), true) - ((RoundScale)((Thumb)Thumb.this).KnobFigure.this.scale).getLengthInDegrees()) < ((RoundScale)((Thumb)Thumb.this).KnobFigure.this.scale).getLengthInDegrees() / 2.0 ? ((RoundScale)((Thumb)Thumb.this).KnobFigure.this.scale).getLengthInDegrees() * Math.PI / 180.0 : 0.0;
                }
                double difference = currentPP.theta * 180.0 / Math.PI - this.oldValuePosition;
                double valueChange = KnobFigure.this.calcValueChange(difference, ((Thumb)Thumb.this).KnobFigure.this.value);
                if (KnobFigure.this.increment <= 0.0 || Math.abs(valueChange) > KnobFigure.this.increment / 2.0) {
                    if (KnobFigure.this.increment > 0.0) {
                        KnobFigure.this.manualSetValue(((Thumb)Thumb.this).KnobFigure.this.value + KnobFigure.this.increment * (double)Math.round(valueChange / KnobFigure.this.increment));
                    } else {
                        KnobFigure.this.manualSetValue(((Thumb)Thumb.this).KnobFigure.this.value + valueChange);
                    }
                    this.oldValuePosition = ((RoundScale)((Thumb)Thumb.this).KnobFigure.this.scale).getValuePosition(((Thumb)Thumb.this).KnobFigure.this.value, true);
                    KnobFigure.this.fireManualValueChange(((Thumb)Thumb.this).KnobFigure.this.value);
                    KnobFigure.this.revalidate();
                    KnobFigure.this.repaint();
                }
                me.consume();
            }

            public void mousePressed(MouseEvent me) {
                if (me.button != 1) {
                    return;
                }
                this.armed = true;
                this.pole = ((Thumb)Thumb.this).KnobFigure.this.scale.getBounds().getCenter();
                this.startPP = PolarPoint.point2PolarPoint(this.pole, Thumb.this.bounds.getCenter());
                this.startPP.rotateAxis(((RoundScale)((Thumb)Thumb.this).KnobFigure.this.scale).getEndAngle(), false);
                this.oldValuePosition = ((RoundScale)((Thumb)Thumb.this).KnobFigure.this.scale).getValuePosition(KnobFigure.this.getCoercedValue(), true);
                me.consume();
            }

            public void mouseReleased(MouseEvent me) {
                if (me.button != 1) {
                    return;
                }
                if (!this.armed) {
                    return;
                }
                this.armed = false;
                me.consume();
            }
        }
    }
}

