/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.dialog;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.GlycanSettings;

public class DatabaseSettingsTableComposite
extends Composite {
    List<AnalyteSettings> anaylteSettings = new ArrayList<AnalyteSettings>();
    TableViewer settingsTableViewer;
    private Table settingsTable;

    public DatabaseSettingsTableComposite(Composite parent, int style) {
        super(parent, style);
    }

    public void setAnaylteSettings(List<AnalyteSettings> anaylteSettings) {
        this.anaylteSettings = anaylteSettings;
        if (this.settingsTableViewer != null) {
            this.settingsTableViewer.setInput(anaylteSettings);
            this.settingsTableViewer.refresh();
        }
    }

    public List<AnalyteSettings> getAnaylteSettings() {
        return this.anaylteSettings;
    }

    public TableViewer getSettingsTableViewer() {
        return this.settingsTableViewer;
    }

    public void createTable() {
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        this.setLayout((Layout)layout);
        this.settingsTableViewer = new TableViewer((Composite)this, 67584);
        this.settingsTable = this.settingsTableViewer.getTable();
        GridData gd_table_2 = new GridData(4, 128, true, false, 1, 1);
        gd_table_2.heightHint = 80;
        this.settingsTable.setLayoutData((Object)gd_table_2);
        this.settingsTable.setHeaderVisible(true);
        this.settingsTable.setLinesVisible(true);
        TableViewerColumn databaseNameColumn = new TableViewerColumn(this.settingsTableViewer, 0);
        TableColumn dColumn = databaseNameColumn.getColumn();
        dColumn.setText("Database Name");
        dColumn.setWidth(200);
        databaseNameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                GlycanSettings gSettings;
                if (element instanceof AnalyteSettings && (gSettings = ((AnalyteSettings)element).getGlycanSettings()) != null && gSettings.getFilter() != null) {
                    String dbName = gSettings.getFilter().getDatabase();
                    if (dbName.lastIndexOf(File.separator) != -1) {
                        dbName = dbName.substring(dbName.lastIndexOf(File.separator) + 1);
                    }
                    return String.valueOf(dbName) + " (version: " + (gSettings.getFilter().getVersion() != null ? gSettings.getFilter().getVersion() : "1.0") + ")";
                }
                return "";
            }
        });
        TableViewerColumn derivColumn = new TableViewerColumn(this.settingsTableViewer, 0);
        derivColumn.getColumn().setText("Derivazitation Name");
        derivColumn.getColumn().setWidth(150);
        derivColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                GlycanSettings gSettings;
                if (element instanceof AnalyteSettings && (gSettings = ((AnalyteSettings)element).getGlycanSettings()) != null) {
                    return gSettings.getPerDerivatisationType();
                }
                return "";
            }
        });
        TableViewerColumn reducingEndColumn = new TableViewerColumn(this.settingsTableViewer, 0);
        reducingEndColumn.getColumn().setText("Reducing End Name");
        reducingEndColumn.getColumn().setWidth(150);
        reducingEndColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                GlycanSettings gSettings;
                if (element instanceof AnalyteSettings && (gSettings = ((AnalyteSettings)element).getGlycanSettings()) != null && gSettings.getReducingEnd() != null) {
                    return gSettings.getReducingEnd().getLabel();
                }
                return "";
            }
        });
        TableViewerColumn useDBMetadateColumn = new TableViewerColumn(this.settingsTableViewer, 0);
        useDBMetadateColumn.getColumn().setText("Use Database Metadata");
        useDBMetadateColumn.getColumn().setWidth(100);
        useDBMetadateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                GlycanSettings gSettings;
                if (element instanceof AnalyteSettings && (gSettings = ((AnalyteSettings)element).getGlycanSettings()) != null && gSettings.getFilter() != null) {
                    gSettings.getFilter().getUseDatabaseStructureMetaInfo().booleanValue();
                    return gSettings.getFilter().getUseDatabaseStructureMetaInfo() != false ? "yes" : "no";
                }
                return "";
            }
        });
        TableViewerColumn filterColumn = new TableViewerColumn(this.settingsTableViewer, 0);
        filterColumn.getColumn().setText("Filter");
        filterColumn.getColumn().setWidth(200);
        filterColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                GlycanSettings gSettings;
                if (element instanceof AnalyteSettings && (gSettings = ((AnalyteSettings)element).getGlycanSettings()) != null && gSettings.getFilterSetting() != null) {
                    return gSettings.getFilterSetting().getName() != null ? gSettings.getFilterSetting().getName() : gSettings.getFilterSetting().getFilter().toString();
                }
                return "";
            }
        });
        this.settingsTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.settingsTableViewer.setInput(this.anaylteSettings);
    }
}

