/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.handler;

import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.MSAnnotationTableDataObject;
import org.grits.toolbox.datamodel.ms.tablemodel.MassSpecTableDataObject;
import org.grits.toolbox.entry.ms.annotation.glycan.dialog.MSGlycanAnnotationPeakIntensityApplyDialog;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationMultiPageViewer;
import org.grits.toolbox.entry.ms.annotation.process.loader.MSAnnotationTableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationEntityProperty;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecPeaksView;

public class ShowMSGlycanAnnotationPeakIntensityDialog {
    private static final Logger logger = Logger.getLogger(ShowMSGlycanAnnotationPeakIntensityDialog.class);

    @Execute
    public Object execute(@Named(value="e4ActivePart") MPart part, @Named(value="activeShell") Shell shell) {
        MSGlycanAnnotationMultiPageViewer curView = null;
        if (part != null && part.getObject() instanceof MSGlycanAnnotationMultiPageViewer) {
            curView = (MSGlycanAnnotationMultiPageViewer)((Object)part.getObject());
        }
        if (curView == null) {
            logger.error((Object)"An MS Glycan Annotation report must be open and active in order to use the Peak Intensity option");
            ErrorUtils.createWarningMessageBox((Shell)shell, (String)"No open report", (String)"An MS Glycan Annotation report must be open and active in order to use the Peak Intensity option");
            return null;
        }
        Entry msEntry = curView.getEntry();
        Property msProp = msEntry.getProperty();
        if (msProp instanceof MassSpecEntityProperty) {
            if (MSGlycanAnnotationMultiPageViewer.msGlycanAnnotationPeakIntensityApplyDialog == null || MSGlycanAnnotationMultiPageViewer.msGlycanAnnotationPeakIntensityApplyDialog.getShell() == null || MSGlycanAnnotationMultiPageViewer.msGlycanAnnotationPeakIntensityApplyDialog.getShell().isDisposed()) {
                MSAnnotationTableDataObject msatdo = (MSAnnotationTableDataObject)((MSAnnotationTableDataProcessor)((MassSpecPeaksView)curView.getPeaksView().get(0)).getTableDataProcessor()).getSimianTableDataObject();
                MSGlycanAnnotationMultiPageViewer.msGlycanAnnotationPeakIntensityApplyDialog = new MSGlycanAnnotationPeakIntensityApplyDialog(shell, (MassSpecMultiPageViewer)curView, (MassSpecTableDataObject)msatdo);
                MSGlycanAnnotationMultiPageViewer.msGlycanAnnotationPeakIntensityApplyDialog.addListener((IPropertyChangeListener)curView);
                MSGlycanAnnotationMultiPageViewer.msGlycanAnnotationPeakIntensityApplyDialog.open();
            } else {
                MSGlycanAnnotationMultiPageViewer.msGlycanAnnotationPeakIntensityApplyDialog.getShell().forceActive();
            }
            return null;
        }
        logger.error((Object)"An MS Glycan report must be open and active in order to use the Filter option");
        ErrorUtils.createWarningMessageBox((Shell)shell, (String)"No open report", (String)"An MS Glycan report must be open and active in order to use the Standard Quantification option");
        return null;
    }

    @CanExecute
    public boolean isEnabled(@Named(value="e4ActivePart") MPart part, EPartService partService) {
        MSAnnotationEntityProperty msAnnotEntityProp;
        MSGlycanAnnotationMultiPageViewer curView = null;
        if (part != null && part.getObject() instanceof MSGlycanAnnotationMultiPageViewer) {
            curView = (MSGlycanAnnotationMultiPageViewer)((Object)part.getObject());
        } else {
            for (MPart mPart : partService.getParts()) {
                if (!(mPart.getObject() instanceof MSGlycanAnnotationMultiPageViewer) || !mPart.equals(mPart.getParent().getSelectedElement())) continue;
                curView = (MSGlycanAnnotationMultiPageViewer)((Object)part.getObject());
            }
        }
        if (curView == null) {
            return false;
        }
        Entry msEntry = curView.getEntry();
        Property msProp = msEntry.getProperty();
        return msProp instanceof MSAnnotationEntityProperty && (msAnnotEntityProp = (MSAnnotationEntityProperty)msProp).getMsLevel() == 2;
    }
}

