/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed;

import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.inject.Inject;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Section;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.entry.ms.annotation.glycan.filter.MSGlycanAnnotationFilterSetup;
import org.grits.toolbox.entry.ms.annotation.glycan.filter.MSGlycanCustomFilterSelection;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanFilterCateogoryPreference;
import org.grits.toolbox.entry.ms.annotation.glycan.util.FileUtils;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationMultiPageViewer;
import org.grits.toolbox.entry.ms.annotation.process.loader.MSAnnotationTableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationFilterView;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecPeaksView;
import org.grits.toolbox.ms.om.data.AnnotationFilter;
import org.grits.toolbox.ms.om.data.CustomExtraData;
import org.grits.toolbox.util.structure.glycan.filter.om.Category;
import org.grits.toolbox.util.structure.glycan.filter.om.Filter;
import org.grits.toolbox.util.structure.glycan.filter.om.FiltersLibrary;
import org.grits.toolbox.util.structure.glycan.gui.FilterChangedListener;
import org.grits.toolbox.util.structure.glycan.gui.FilterTableSetup;

public class MSGlycanAnnotationFilterView
extends MSAnnotationFilterView
implements FilterChangedListener,
IPropertyChangeListener {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationFilterView.class);
    public static final String FILTERMESSAGE = "Please note that, the \"stucture based\" filters you select are applied first to change the selected candidates, then the score based filters are applied to further restrict the selections";
    public static final String FILTERWARNING = "The following settings will affect the glycan candidate selection in the structure table. \nIf you don't want the structure filters to modify your selections, select \"Highlight Only\" option.";
    private FiltersLibrary filterLibrary;
    private List<Filter> filterList;
    private Button applyButton;
    private Button applyScoreFilterButton;
    private Combo filterCombo;
    private FilterTableSetup filterTable;
    private Label txtOutput;
    private Text txtNumTopHits;
    private Button btnOverrideManualAnnotations2;
    private List<CustomExtraData> customExtraData;
    private Category preferredCategory;
    private boolean highlightOnly = true;
    private Color sectionColor;
    private Color backgroundColor;

    @Inject
    public MSGlycanAnnotationFilterView(Entry entry) {
        super(entry);
        this.loadFilterList();
        this.loadFilterCategoryPreference();
    }

    private void loadFilterCategoryPreference() {
        try {
            MSGlycanFilterCateogoryPreference preferences = MSGlycanFilterCateogoryPreference.getMSGlycanFilterCategoryPreferences(MSGlycanFilterCateogoryPreference.getPreferenceEntity());
            if (preferences != null) {
                this.preferredCategory = preferences.getCategoryPreference();
            }
        }
        catch (UnsupportedVersionException unsupportedVersionException) {
            logger.error((Object)"Cannot load filter preference");
        }
    }

    private void loadFilterList() {
        try {
            this.filterLibrary = FileUtils.readFilters(FileUtils.getFilterPath());
            this.filterList = this.filterLibrary.getFilters();
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"Error loading the filters", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Cannot locate the filters file", (Throwable)e);
        }
        catch (JAXBException e) {
            logger.error((Object)"Error loading the filters", (Throwable)e);
        }
    }

    protected void addFilterSettings() {
        this.sectionColor = new Color((Device)Display.getCurrent(), 20, 199, 255);
        this.backgroundColor = Display.getCurrent().getSystemColor(22);
        MSGlycanAnnotationMultiPageViewer parentViewer = MSGlycanAnnotationMultiPageViewer.getActiveViewerForEntry(this.getPart().getContext(), this.entry.getParent());
        this.createGlycanFilterSection(parentViewer);
        this.createScoreFilterSection(parentViewer);
    }

    private void createGlycanFilterSection(MSGlycanAnnotationMultiPageViewer parentViewer) {
        Section section = new Section(this.getContainer(), 324);
        section.setText("Filter Settings");
        section.setTitleBarBackground(this.sectionColor);
        section.setBackground(this.backgroundColor);
        section.setTitleBarForeground(Display.getCurrent().getSystemColor(10));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 6;
        section.setLayoutData((Object)gridData);
        Composite filterComposite = new Composite((Composite)section, 64);
        filterComposite.setLayoutData((Object)new GridData(16384, 4, true, true, 6, 4));
        filterComposite.setBackground(this.backgroundColor);
        filterComposite.setBackgroundMode(2);
        Label filterWarning = new Label(filterComposite, 65);
        filterWarning.setForeground(Display.getCurrent().getSystemColor(3));
        filterWarning.setText(FILTERWARNING);
        filterWarning.setLayoutData((Object)new GridData(4, 4, true, true, 3, 2));
        MSGlycanAnnotationFilterSetup.addHelpButton(filterComposite, FILTERMESSAGE);
        final Button highlightButton = new Button(filterComposite, 32);
        highlightButton.setText("Highlight Only");
        highlightButton.setSelection(true);
        highlightButton.setLayoutData((Object)new GridData(4, 4, true, true, 6, 1));
        highlightButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MSGlycanAnnotationFilterView.this.highlightOnly = highlightButton.getSelection();
                MSGlycanAnnotationFilterView.this.btnOverrideManualAnnotations2.setEnabled(!MSGlycanAnnotationFilterView.this.highlightOnly);
                if (MSGlycanAnnotationFilterView.this.highlightOnly) {
                    MSGlycanAnnotationFilterView.this.btnOverrideManualAnnotations2.setSelection(false);
                }
                MSGlycanAnnotationFilterView.this.applyButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnOverrideManualAnnotations2 = new Button(filterComposite, 32);
        this.btnOverrideManualAnnotations2.setText("Override manually selected annotations");
        this.btnOverrideManualAnnotations2.setEnabled(false);
        GridData gridData3 = new GridData(768);
        gridData3.horizontalSpan = 4;
        gridData3.verticalSpan = 1;
        this.btnOverrideManualAnnotations2.setLayoutData((Object)gridData3);
        this.btnOverrideManualAnnotations2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MSGlycanAnnotationFilterView.this.applyButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (parentViewer != null && parentViewer.getFilter() != null) {
            this.btnOverrideManualAnnotations2.setEnabled(false);
        }
        Label dummy = new Label(filterComposite, 0);
        dummy.setLayoutData((Object)new GridData(4, 4, true, true, 6, 1));
        MSGlycanCustomFilterSelection customSelection = new MSGlycanCustomFilterSelection(this);
        customSelection.createFilterSelectionArea(filterComposite);
        this.filterTable = this.filterLibrary != null ? new MSGlycanAnnotationFilterSetup(this.filterLibrary.getCategories()) : new MSGlycanAnnotationFilterSetup();
        this.filterTable.setFilterList(this.filterList);
        ((MSGlycanAnnotationFilterSetup)this.filterTable).setSelectedCategory(this.preferredCategory);
        ((MSGlycanAnnotationFilterSetup)this.filterTable).setFilterMessage(FILTERMESSAGE);
        try {
            this.filterTable.createFilterTableSection(filterComposite);
            this.filterTable.addFilterChangedListener((FilterChangedListener)this);
        }
        catch (Exception e) {
            logger.error((Object)"Cannot create filter table. ", (Throwable)e);
        }
        customSelection.setFilterTableSetup(this.filterTable);
        if (parentViewer != null && parentViewer.getFilter() != null) {
            this.filterTable.setExistingFilters(parentViewer.getFilter().getFilterSetting());
            this.filterTable.setEnabled(false);
        }
        Label noMatchLabel = new Label(filterComposite, 0);
        noMatchLabel.setText("Choose how to handle 'no match' cases (Applicable only when \"Highlight Only\" is NOT checked)");
        GridData gd = new GridData(16384, 128, true, true, 4, 1);
        noMatchLabel.setLayoutData((Object)gd);
        final Button keepOption = new Button(filterComposite, 16);
        keepOption.setText("Keep existing selections");
        gd = new GridData(16384, 128, true, true, 4, 1);
        keepOption.setLayoutData((Object)gd);
        keepOption.setSelection(true);
        keepOption.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MSGlycanAnnotationFilterView.this.applyButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (parentViewer != null && parentViewer.getFilter() != null) {
            keepOption.setEnabled(false);
        }
        Button noSelectionOption = new Button(filterComposite, 16);
        noSelectionOption.setText("Do not select anything");
        gd = new GridData(16384, 128, true, true, 4, 1);
        noSelectionOption.setLayoutData((Object)gd);
        noSelectionOption.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MSGlycanAnnotationFilterView.this.applyButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (parentViewer != null && parentViewer.getFilter() != null) {
            noSelectionOption.setEnabled(false);
        }
        this.applyButton = new Button(filterComposite, 8);
        this.applyButton.setText("Apply Filters");
        this.applyButton.setEnabled(false);
        this.applyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MSGlycanAnnotationMultiPageViewer viewer = MSGlycanAnnotationMultiPageViewer.getActiveViewer(MSGlycanAnnotationFilterView.this.getPart().getContext());
                if (viewer.getPeaksView().isEmpty()) {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)"Open MS Annotation Table first before applying filters");
                    return;
                }
                if (((MassSpecPeaksView)viewer.getPeaksView().get(0)).getViewBase() == null) {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)"You cannot apply filters for this table");
                    return;
                }
                AnnotationFilter filter = new AnnotationFilter();
                filter.setFilterSetting(MSGlycanAnnotationFilterView.this.filterTable.getFilterSetting());
                filter.setNumTopHits(Integer.valueOf(MSGlycanAnnotationFilterView.this.getNumTopHits()));
                filter.setColumnKey(this.getFilterKey());
                viewer.setFilter(filter);
                viewer.applyFilter(filter.getFilterSetting(), null, -1, MSGlycanAnnotationFilterView.this.btnOverrideManualAnnotations2.getSelection(), keepOption.getSelection(), MSGlycanAnnotationFilterView.this.highlightOnly);
            }

            private String getFilterKey() {
                if (!MSGlycanAnnotationFilterView.this.filterCombo.getText().equals("")) {
                    for (CustomExtraData cnd : MSGlycanAnnotationFilterView.this.customExtraData) {
                        if (!MSGlycanAnnotationFilterView.this.filterCombo.getText().equals(cnd.getLabel())) continue;
                        return cnd.getKey();
                    }
                }
                return null;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        section.setClient((Control)filterComposite);
    }

    private void createScoreFilterSection(MSGlycanAnnotationMultiPageViewer parentViewer) {
        Section scoreSection = new Section(this.getContainer(), 320);
        scoreSection.setText("Score Filters");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 6;
        scoreSection.setLayoutData((Object)gridData);
        scoreSection.setTitleBarBackground(this.sectionColor);
        scoreSection.setBackground(this.backgroundColor);
        scoreSection.setTitleBarForeground(Display.getCurrent().getSystemColor(10));
        Composite scoreFilterComposite = new Composite((Composite)scoreSection, 0);
        scoreFilterComposite.setLayoutData((Object)new GridData(16384, 4, true, true, 6, 6));
        scoreFilterComposite.setLayout((Layout)new GridLayout(6, false));
        scoreFilterComposite.setBackground(this.backgroundColor);
        scoreFilterComposite.setBackgroundMode(2);
        Label scoreWarning = new Label(scoreFilterComposite, 65);
        scoreWarning.setForeground(Display.getCurrent().getSystemColor(3));
        scoreWarning.setText("The following settings will affect the glycan candidate selection in the structure table!");
        scoreWarning.setLayoutData((Object)new GridData(4, 4, true, true, 6, 1));
        Label dummy = new Label(scoreFilterComposite, 0);
        dummy.setLayoutData((Object)new GridData(4, 4, true, true, 6, 1));
        dummy = new Label(scoreFilterComposite, 0);
        dummy.setLayoutData((Object)new GridData(4, 4, true, true, 6, 1));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        Label lblFilter = new Label(scoreFilterComposite, 0);
        lblFilter.setText("Choose a criterion to use as score filter");
        lblFilter.setLayoutData((Object)gridData);
        this.createLists(parentViewer, scoreFilterComposite);
        Label lblNumTopHits = new Label(scoreFilterComposite, 0);
        lblNumTopHits.setText("Number of Top Hits to Select: ");
        GridData gridData2 = new GridData(768);
        gridData2.horizontalSpan = 2;
        gridData2.verticalSpan = 1;
        lblNumTopHits.setLayoutData((Object)gridData2);
        this.txtNumTopHits = new Text(scoreFilterComposite, 2048);
        this.txtNumTopHits.setText("All");
        GridData gridData4 = new GridData(768);
        gridData4.horizontalSpan = 4;
        gridData4.verticalSpan = 1;
        this.txtNumTopHits.setLayoutData((Object)gridData4);
        if (parentViewer != null && parentViewer.getFilter() != null) {
            if (parentViewer.getFilter().getNumTopHits() == -1) {
                this.txtNumTopHits.setText("All");
            } else {
                this.txtNumTopHits.setText(String.valueOf(parentViewer.getFilter().getNumTopHits()));
            }
            this.txtNumTopHits.setEnabled(false);
        }
        this.txtNumTopHits.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!MSGlycanAnnotationFilterView.this.txtNumTopHits.getText().equals("All")) {
                    try {
                        Integer.parseInt(MSGlycanAnnotationFilterView.this.txtNumTopHits.getText());
                        MSGlycanAnnotationFilterView.this.txtOutput.setText("");
                        MSGlycanAnnotationFilterView.this.applyScoreFilterButton.setEnabled(true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        MSGlycanAnnotationFilterView.this.txtOutput.setText("Invalid value for 'Num Top Hits'. Please enter 'All' or an integer greater than 0.");
                        MSGlycanAnnotationFilterView.this.applyScoreFilterButton.setEnabled(false);
                    }
                } else {
                    MSGlycanAnnotationFilterView.this.txtOutput.setText("");
                    MSGlycanAnnotationFilterView.this.applyScoreFilterButton.setEnabled(true);
                }
            }
        });
        final Button btnOverrideManualAnnotations = new Button(scoreFilterComposite, 32);
        btnOverrideManualAnnotations.setText("Override manually selected annotations");
        GridData gridData3 = new GridData(768);
        gridData3.horizontalSpan = 6;
        gridData3.verticalSpan = 1;
        btnOverrideManualAnnotations.setLayoutData((Object)gridData3);
        btnOverrideManualAnnotations.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MSGlycanAnnotationFilterView.this.applyScoreFilterButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (parentViewer != null && parentViewer.getFilter() != null) {
            btnOverrideManualAnnotations.setEnabled(false);
        }
        this.txtOutput = new Label(scoreFilterComposite, 0);
        this.txtOutput.setLayoutData((Object)gridData3);
        this.txtOutput.setForeground(Display.getCurrent().getSystemColor(3));
        this.applyScoreFilterButton = new Button(scoreFilterComposite, 8);
        this.applyScoreFilterButton.setText("Apply Score Filter");
        this.applyScoreFilterButton.setEnabled(false);
        this.applyScoreFilterButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MSGlycanAnnotationMultiPageViewer viewer = MSGlycanAnnotationMultiPageViewer.getActiveViewer(MSGlycanAnnotationFilterView.this.getPart().getContext());
                if (viewer.getPeaksView().isEmpty()) {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)"Open MS Annotation Table first before applying filters");
                    return;
                }
                if (((MassSpecPeaksView)viewer.getPeaksView().get(0)).getViewBase() == null) {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)"You cannot apply filters for this table");
                    return;
                }
                AnnotationFilter filter = new AnnotationFilter();
                filter.setFilterSetting(MSGlycanAnnotationFilterView.this.filterTable.getFilterSetting());
                filter.setNumTopHits(Integer.valueOf(MSGlycanAnnotationFilterView.this.getNumTopHits()));
                filter.setColumnKey(this.getFilterKey());
                viewer.setFilter(filter);
                viewer.applyFilter(null, this.getFilterKey(), MSGlycanAnnotationFilterView.this.getNumTopHits(), btnOverrideManualAnnotations.getSelection(), true, MSGlycanAnnotationFilterView.this.highlightOnly);
            }

            private String getFilterKey() {
                if (!MSGlycanAnnotationFilterView.this.filterCombo.getText().equals("")) {
                    for (CustomExtraData cnd : MSGlycanAnnotationFilterView.this.customExtraData) {
                        if (!MSGlycanAnnotationFilterView.this.filterCombo.getText().equals(cnd.getLabel())) continue;
                        return cnd.getKey();
                    }
                }
                return null;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        scoreSection.setClient((Control)scoreFilterComposite);
    }

    private int getNumTopHits() {
        if (this.txtNumTopHits.getText().equals("All")) {
            return -1;
        }
        try {
            return Integer.parseInt(this.txtNumTopHits.getText());
        }
        catch (NumberFormatException ex) {
            logger.error((Object)"Invalid value for 'Number of Top Hits'", (Throwable)ex);
            return -2;
        }
    }

    private void createLists(MSGlycanAnnotationMultiPageViewer parentViewer, Composite parent) {
        if (this.filterCombo != null) {
            this.filterCombo.removeAll();
        } else {
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 4;
            gridData.verticalSpan = 1;
            this.filterCombo = new Combo(parent, 4);
            this.filterCombo.setLayoutData((Object)gridData);
        }
        this.filterCombo.add("");
        this.filterCombo.setEnabled(false);
        this.customExtraData = MSAnnotationTableDataProcessor.getMSAnnotationFeatureCustomExtraData((Entry)this.entry);
        if (this.customExtraData == null) {
            return;
        }
        int i = 1;
        for (CustomExtraData cnd : this.customExtraData) {
            this.filterCombo.add(cnd.getLabel());
            if (parentViewer != null && parentViewer.getFilter() != null && cnd.getKey().equals(parentViewer.getFilter().getColumnKey())) {
                this.filterCombo.select(i);
            }
            ++i;
        }
        if (this.filterCombo.getItemCount() > 1) {
            if (parentViewer != null && parentViewer.getFilter() != null) {
                this.filterCombo.setEnabled(false);
            } else {
                this.filterCombo.setEnabled(true);
                this.filterCombo.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        if (!MSGlycanAnnotationFilterView.this.filterCombo.getText().equals("")) {
                            if (MSGlycanAnnotationFilterView.this.getNumTopHits() != -2) {
                                MSGlycanAnnotationFilterView.this.txtOutput.setText("");
                                MSGlycanAnnotationFilterView.this.applyScoreFilterButton.setEnabled(true);
                            } else {
                                MSGlycanAnnotationFilterView.this.txtOutput.setText("Please select a criterion for the score filter");
                                MSGlycanAnnotationFilterView.this.applyScoreFilterButton.setEnabled(false);
                            }
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
        }
    }

    public void filterChanged() {
        this.applyButton.setEnabled(true);
    }

    @Optional
    @Inject
    public void filterChangedInViewer(@UIEventTopic(value="FilterChanged") MSGlycanAnnotationMultiPageViewer viewer) {
        AnnotationFilter filter;
        if (viewer != null && (filter = viewer.getFilter()) != null) {
            if (filter.getFilterSetting() == null) {
                this.filterTable.resetFilters();
            } else {
                this.filterTable.setExistingFilters(filter.getFilterSetting());
            }
            if (filter.getNumTopHits() == -1) {
                this.txtNumTopHits.setText("All");
            } else {
                this.txtNumTopHits.setText(String.valueOf(filter.getNumTopHits()));
            }
            if (filter.getColumnKey() != null) {
                int i = 1;
                for (CustomExtraData cnd : this.customExtraData) {
                    if (cnd.getKey().equals(filter.getColumnKey())) {
                        this.filterCombo.select(i);
                    }
                    ++i;
                }
            } else {
                this.filterCombo.select(0);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
    }
}

