/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed;

import org.apache.log4j.Logger;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationMultiPageViewer;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationMultiPageViewerWorker;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;
import org.grits.toolbox.widgets.tools.GRITSProcessStatus;

public class MSGlycanAnnotationMultiPageViewerWorker
extends MSAnnotationMultiPageViewerWorker {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationMultiPageViewerWorker.class);

    public MSGlycanAnnotationMultiPageViewerWorker(MassSpecMultiPageViewer parentEditor, MassSpecEntityProperty prop) {
        super(parentEditor, prop);
    }

    public int doWork() {
        int iSuccess = super.doWork();
        if (this.getParentEditor().getStatus() != GRITSProcessStatus.OK) {
            return this.getParentEditor().getStatus();
        }
        MSGlycanAnnotationMultiPageViewer msParentEditor = (MSGlycanAnnotationMultiPageViewer)this.getParentEditor();
        if (msParentEditor.needsSummaryView(this.prop)) {
            iSuccess = this.addSummaryPage(this.prop, this.iMajorCount);
            if (iSuccess != GRITSProcessStatus.OK) {
                return iSuccess;
            }
            this.iMajorCount += 2;
        }
        this.updateListeners("Finished MS Glycan Annotation work!", this.iMajorCount);
        logger.debug((Object)"Finished MS Annotation work");
        return iSuccess;
    }

    public int addSummaryPage(MassSpecEntityProperty prop, int iProcessCount) {
        try {
            this.updateListeners("Creating Summary tab (loading)", iProcessCount);
            int iSuccess = ((MSGlycanAnnotationMultiPageViewer)this.getParentEditor()).addSummaryPage_Step1(prop);
            if (iSuccess != GRITSProcessStatus.OK) {
                return iSuccess;
            }
            this.updateListeners("Creating Summary tab (populating)", iProcessCount + 1);
            iSuccess = ((MSGlycanAnnotationMultiPageViewer)this.getParentEditor()).addSummaryPage_Step2();
            this.updateListeners("Creating Summary tab (done)", iProcessCount + 2);
            return iSuccess;
        }
        catch (Exception e) {
            logger.error((Object)"Unable to open Summary view", (Throwable)e);
            return GRITSProcessStatus.ERROR;
        }
    }
}

