/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.table.merge;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.entry.qrtpcr.model.merge.MergeData;
import org.grits.toolbox.entry.qrtpcr.model.merge.MergeTableData;

public class MergeReportColumnPropertyAccessor<TableData>
implements IColumnPropertyAccessor<TableData> {
    List<GRITSColumnHeader> propertyNames;
    List<String> aliasList;

    public MergeReportColumnPropertyAccessor(List<GRITSColumnHeader> columns, List<String> aliasList) {
        this.propertyNames = columns;
        this.aliasList = aliasList;
    }

    Integer getLastNotGroupedColumn() {
        int notGrouped = 0;
        for (GRITSColumnHeader col : this.propertyNames) {
            if (col.isGrouped()) continue;
            ++notGrouped;
        }
        return notGrouped;
    }

    public int getColumnCount() {
        return this.propertyNames.size();
    }

    public Object getDataValue(TableData element, int columnIndex) {
        String columnName = this.getColumnProperty(columnIndex);
        if (columnName == null) {
            return null;
        }
        List<MergeData> dataList = ((MergeTableData)element).getDataList();
        int index = (int)Math.floor((columnIndex - this.getLastNotGroupedColumn()) / 2);
        switch (columnName) {
            case "Gene Identifier": {
                return ((MergeTableData)element).getGene().getGeneIdentifier();
            }
            case "Gene Symbol": {
                return ((MergeTableData)element).getGene().getGeneSymbol();
            }
            case "Average": {
                if (index < 0 || index >= dataList.size()) break;
                return dataList.get(index).getAverage();
            }
            case "St Dev - Adjusted": {
                if (index < 0 || index >= dataList.size()) break;
                return dataList.get(index).getStDev();
            }
        }
        return null;
    }

    public void setDataValue(TableData arg0, int arg1, Object arg2) {
    }

    public int getColumnIndex(String columnName) {
        int index = 0;
        for (GRITSColumnHeader simianColumnHeader : this.propertyNames) {
            if (simianColumnHeader.getKeyValue().equals(columnName)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public String getColumnProperty(int columnIndex) {
        if (columnIndex >= this.propertyNames.size()) {
            return null;
        }
        GRITSColumnHeader header = this.propertyNames.get(columnIndex);
        if (header != null) {
            return header.getKeyValue();
        }
        return null;
    }
}

