/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.widgets.processDialog;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.widgets.progress.IProgressThreadHandler;
import org.grits.toolbox.widgets.progress.ProgressThread;

public class ProgressDialog
extends Dialog
implements IProgressThreadHandler {
    private static final Logger logger = Logger.getLogger(ProgressDialog.class);
    protected ProgressThread m_worker = null;
    protected Label processMessageLabel;
    protected Label updateMessageLabel;
    protected Button cancelButton;
    protected Text descriptionText;
    protected Composite cancelComposite;
    protected Shell shell;
    protected Display display = null;
    private int max = 0;
    private double count = 0.0;
    private double increment = 0.0;
    protected boolean isCanceled = false;
    protected ProgressBar progressBar;
    protected int progressBarStyle;

    public ProgressDialog(Shell parent) {
        super(parent);
        this.progressBarStyle = 65792;
    }

    public ProgressDialog(Shell parent, int style) {
        super(parent);
        this.progressBarStyle = style;
    }

    public Shell getShell() {
        return this.shell;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public ProgressThread getWorker() {
        return this.m_worker;
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setWorker(ProgressThread a_worker) {
        this.m_worker = a_worker;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public void setProcessMessageLabel(String a_message) {
        final String t_message = new String(a_message);
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.processMessageLabel.setText(t_message);
            }
        });
    }

    public void updateProgresBar(String msg) {
        final String t_message = new String(msg);
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.progressBar.setSelection((int)(ProgressDialog.this.count + ProgressDialog.this.increment));
                ProgressDialog progressDialog = ProgressDialog.this;
                progressDialog.count = progressDialog.count + ProgressDialog.this.increment;
                ProgressDialog.this.updateMessageLabel.setText(String.valueOf(t_message) + " of " + ProgressDialog.this.max);
            }
        });
    }

    public int open() {
        this.createContents();
        Monitor primary = this.shell.getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        this.shell.open();
        this.shell.layout();
        this.m_worker.setProgressThreadHandler((IProgressThreadHandler)this);
        this.m_worker.start();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.isCanceled) {
            return 256;
        }
        return 32;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public static Shell getModalDialog(Shell parent) {
        return new Shell(parent, 67616);
    }

    protected void createContents() {
        this.shell = ProgressDialog.getModalDialog(this.getParent());
        this.display = this.shell.getDisplay();
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 10;
        this.shell.setLayout((Layout)gridLayout);
        this.shell.setSize(483, 300);
        this.shell.setText("Progress Dialog");
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayoutData((Object)new GridData(4, 2, true, false));
        composite.setLayout((Layout)new GridLayout());
        this.processMessageLabel = new Label((Composite)this.shell, 0);
        this.processMessageLabel.setLayoutData((Object)new GridData(4, 2, false, false));
        this.progressBar = new ProgressBar((Composite)this.shell, this.progressBarStyle);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(this.max);
        this.progressBar.setLayoutData((Object)gd);
        this.updateMessageLabel = new Label((Composite)this.shell, 0);
        this.updateMessageLabel.setLayoutData((Object)new GridData(4, 2, false, false));
        this.cancelComposite = new Composite((Composite)this.shell, 0);
        this.cancelComposite.setLayoutData((Object)new GridData(4, 2, false, false));
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 2;
        this.cancelComposite.setLayout((Layout)gridLayout_1);
        GridData descriptionTextData = new GridData();
        descriptionTextData.minimumHeight = 80;
        descriptionTextData.grabExcessHorizontalSpace = true;
        descriptionTextData.grabExcessVerticalSpace = true;
        descriptionTextData.horizontalAlignment = 4;
        descriptionTextData.horizontalSpan = 2;
        this.descriptionText = new Text(this.cancelComposite, 2816);
        this.descriptionText.setLayoutData((Object)descriptionTextData);
        this.descriptionText.setEditable(false);
        this.cancelButton = new Button(this.cancelComposite, 0);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProgressDialog.this.isCanceled = true;
                ProgressDialog.this.clickCancel();
            }
        });
        this.cancelButton.setLayoutData((Object)new GridData(78, -1));
        this.cancelButton.setText("cancel");
    }

    protected void clickCancel() {
        this.m_worker.cancelWork();
    }

    public void setDescriptionText(String description) {
        final String t_message = new String(description);
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                StringBuffer sb = new StringBuffer();
                if (ProgressDialog.this.descriptionText.getText().equals("")) {
                    sb.append(t_message);
                } else {
                    sb.append(ProgressDialog.this.descriptionText.getText());
                    sb.append("\r\n");
                    sb.append(t_message);
                }
                ProgressDialog.this.descriptionText.setText(sb.toString());
                ProgressDialog.this.descriptionText.setSelection(ProgressDialog.this.descriptionText.getCharCount());
            }
        });
    }

    public void setMax(int max) {
        this.max = max;
        this.increment = 100.0 / (double)max;
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.progressBar.setSelection(0);
                ProgressDialog.this.count = 0.0;
            }
        });
    }

    public Display getDisplay() {
        return this.display;
    }

    public void threadFinished(boolean successful) {
        if (!this.isCanceled && successful) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    ProgressDialog.this.progressBar.setSelection(100);
                    ProgressDialog.this.cancelButton.setText("Finish");
                    ProgressDialog.this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            (this).ProgressDialog.this.isCanceled = false;
                            (this).ProgressDialog.this.shell.close();
                        }
                    });
                    if (ProgressDialog.this.descriptionText.getText().equals("")) {
                        ProgressDialog.this.isCanceled = false;
                        ProgressDialog.this.shell.close();
                    }
                }
            });
        } else {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    ProgressDialog.this.isCanceled = true;
                    ProgressDialog.this.shell.close();
                }
            });
        }
    }

    public void endWithException(final Exception e) {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                logger.error((Object)e.getMessage(), (Throwable)e);
                ProgressDialog.this.isCanceled = true;
                ProgressDialog.this.shell.close();
            }
        });
    }

    public void cancelThread() {
    }
}

