/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.dialog;

import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMPeak;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMPrecursorPeak;
import org.grits.toolbox.entry.ms.annotation.adaptor.MSAnnotationExportFileAdapter;

public class FilterDialog
extends TitleAreaDialog {
    private static final Logger logger = Logger.getLogger(FilterDialog.class);
    private static final String PARAMS_OK = "Valid parameters";
    Integer numTopHits;
    Double thresholdValue;
    String filterKey;
    private Combo filterCombo;
    private Text txtNumTopHits;
    private Text txtThresholdValue;
    private Label txtOutput;
    protected MSAnnotationExportFileAdapter exportFileAdapter;

    public FilterDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Filtering Settings");
        Composite area = (Composite)super.createDialogArea(parent);
        ScrolledComposite sc = new ScrolledComposite(area, 2816);
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 400;
        data.widthHint = 700;
        sc.setLayoutData((Object)data);
        Composite otherFilterArea = new Composite((Composite)sc, 0);
        otherFilterArea.setLayout((Layout)new GridLayout(4, false));
        this.createFilterTable(otherFilterArea);
        this.txtOutput = new Label(otherFilterArea, 8);
        this.txtOutput.setText("\n\nPlease select other Filter Options\n");
        GridData gridDataTxtOutput = new GridData(768);
        gridDataTxtOutput.horizontalSpan = 4;
        gridDataTxtOutput.verticalSpan = 2;
        this.txtOutput.setLayoutData((Object)gridDataTxtOutput);
        this.txtOutput.setEnabled(false);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        Label lblFilter = new Label(otherFilterArea, 0);
        lblFilter.setText("Choose a criterion to use as filter");
        lblFilter.setLayoutData((Object)gridData);
        this.createFilterOptions(otherFilterArea);
        Label lblNumTopHits = new Label(otherFilterArea, 0);
        lblNumTopHits.setText("Number of Top Hits to Select: ");
        GridData gridData2 = new GridData(768);
        gridData2.horizontalSpan = 1;
        gridData2.verticalSpan = 1;
        lblNumTopHits.setLayoutData((Object)gridData2);
        this.txtNumTopHits = new Text(otherFilterArea, 2048);
        this.txtNumTopHits.setText("All");
        GridData gridData4 = new GridData(768);
        gridData4.horizontalSpan = 3;
        gridData4.verticalSpan = 1;
        this.txtNumTopHits.setLayoutData((Object)gridData4);
        if (this.numTopHits != null) {
            this.txtNumTopHits.setText("" + this.numTopHits);
        }
        this.txtNumTopHits.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilterDialog.this.validateInput();
            }
        });
        Label lblThreshold = new Label(otherFilterArea, 0);
        lblThreshold.setText("Threshold Value: ");
        lblThreshold.setToolTipText("Get only those whose selected filter criterion is greater than the threshold");
        GridData gridData5 = new GridData(768);
        gridData5.horizontalSpan = 1;
        gridData5.verticalSpan = 1;
        lblThreshold.setLayoutData((Object)gridData5);
        this.txtThresholdValue = new Text(otherFilterArea, 2048);
        this.txtThresholdValue.setText("");
        gridData5 = new GridData(768);
        gridData5.horizontalSpan = 3;
        gridData5.verticalSpan = 1;
        this.txtThresholdValue.setLayoutData((Object)gridData5);
        new Label(otherFilterArea, 0);
        new Label(otherFilterArea, 0);
        if (this.thresholdValue != null) {
            this.txtThresholdValue.setText("" + this.thresholdValue);
        }
        this.txtThresholdValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilterDialog.this.validateInput();
            }
        });
        sc.setContent((Control)otherFilterArea);
        sc.setMinSize(otherFilterArea.computeSize(-1, -1));
        return area;
    }

    protected void createFilterTable(Composite parent) {
    }

    private void createFilterOptions(Composite parent) {
        if (this.filterCombo != null && !this.filterCombo.isDisposed()) {
            this.filterCombo.removeAll();
        } else {
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            gridData.verticalSpan = 1;
            this.filterCombo = new Combo(parent, 4);
            this.filterCombo.setLayoutData((Object)gridData);
        }
        this.filterCombo.add("");
        this.filterCombo.setEnabled(false);
        this.filterCombo.add(DMPeak.peak_intensity.getLabel());
        this.filterCombo.add(DMPrecursorPeak.precursor_peak_intensity.getLabel());
        if (this.filterKey != null) {
            this.filterCombo.select(this.filterCombo.indexOf(this.filterKey));
        }
        if (this.filterCombo.getItemCount() > 1) {
            this.filterCombo.setEnabled(true);
            this.filterCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    FilterDialog.this.validateInput();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    public int getNumTopHits() throws NumberFormatException {
        if (this.txtNumTopHits.getText().equals("All")) {
            return -1;
        }
        return Integer.parseInt(this.txtNumTopHits.getText());
    }

    public String getFilterKey() {
        if (!this.filterCombo.getText().equals("")) {
            return this.filterCombo.getText();
        }
        return null;
    }

    public double getThresholdValue() throws NumberFormatException {
        if (this.txtThresholdValue.getText().equals("")) {
            return 0.0;
        }
        double threshold = Double.parseDouble(this.txtThresholdValue.getText());
        return threshold;
    }

    public void validateInput() {
        this.txtOutput.setText(PARAMS_OK);
        boolean error = false;
        try {
            this.numTopHits = this.getNumTopHits();
        }
        catch (NumberFormatException numberFormatException) {
            error = true;
            this.txtOutput.setText("Invalid value for 'Num Top Hits'. Please enter 'All' or an integer greater than 0.");
        }
        if (!error && this.numTopHits > 0 && (this.filterKey = this.getFilterKey()) == null) {
            this.txtOutput.setText("Please select a filter criterion");
        } else {
            try {
                this.thresholdValue = this.getThresholdValue();
                if (this.getFilterKey() == null) {
                    this.txtOutput.setText("Please select a filter criterion");
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.txtOutput.setText("Invalid Value for 'Threshold Value'. Please enter a number");
            }
        }
        if (this.txtOutput.getText().equals(PARAMS_OK)) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    protected void okPressed() {
        if (this.exportFileAdapter != null) {
            this.exportFileAdapter.setFilterColumn(this.getFilterKey());
            this.exportFileAdapter.setTopHits(this.getNumTopHits());
            this.exportFileAdapter.setThresholdValue(this.getThresholdValue());
        }
        super.okPressed();
    }

    protected Point getInitialSize() {
        return new Point(700, 450);
    }

    public void setExportFileAdapter(MSAnnotationExportFileAdapter msAnnotationExportFileAdapter) {
        this.exportFileAdapter = msAnnotationExportFileAdapter;
    }
}

