/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.dialog;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Composite;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationEntityProperty;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationProperty;
import org.grits.toolbox.entry.ms.annotation.property.datamodel.MSAnnotationMetaData;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationMultiPageViewer;
import org.grits.toolbox.entry.ms.dialog.MassSpecStandardQuantFileGrid;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecMetaData;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecUISettings;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;

public class MSAnnotationStandardQuantFileGrid
extends MassSpecStandardQuantFileGrid {
    private static final Logger logger = Logger.getLogger(MSAnnotationStandardQuantFileGrid.class);

    public MSAnnotationStandardQuantFileGrid(Composite parent, MassSpecMultiPageViewer contextViewer) {
        super(parent, contextViewer);
    }

    public MassSpecMultiPageViewer getCurrentViewer() {
        try {
            EPartService partService = this.getContextViewer().getPartService();
            for (MPart mPart : partService.getParts()) {
                MSAnnotationMultiPageViewer viewer;
                if (!(mPart.getObject() instanceof MSAnnotationMultiPageViewer) || !mPart.equals(mPart.getParent().getSelectedElement()) || (viewer = (MSAnnotationMultiPageViewer)((Object)mPart.getObject())) == null || viewer.getEntry().getProperty() == null || !(viewer.getEntry().getProperty() instanceof MSAnnotationEntityProperty)) continue;
                return viewer;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public Property getEntryParentProperty() {
        try {
            Entry entry = this.getEntryForCurrentViewer();
            MSAnnotationEntityProperty msep = (MSAnnotationEntityProperty)entry.getProperty();
            MSAnnotationProperty msap = msep.getMSAnnotationParentProperty();
            return msap;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public Property getMSEntryParentProperty() {
        try {
            Entry entry = this.getEntryForCurrentViewer();
            MSAnnotationEntityProperty msep = (MSAnnotationEntityProperty)entry.getProperty();
            MassSpecProperty msp = msep.getMassSpecParentProperty();
            return msp;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    protected MassSpecUISettings getEntrySettings() {
        MSAnnotationProperty prop = (MSAnnotationProperty)this.getEntryParentProperty();
        MSAnnotationMetaData msSettings = prop.getMSAnnotationMetaData();
        return msSettings;
    }

    protected List<MSPropertyDataFile> getStandardQuantificationFiles() {
        MassSpecProperty msp = (MassSpecProperty)this.getMSEntryParentProperty();
        MassSpecMetaData entrySettings = msp.getMassSpecMetaData();
        ArrayList<MSPropertyDataFile> fileList = new ArrayList<MSPropertyDataFile>();
        fileList.addAll(entrySettings.getAnnotationFiles());
        fileList.addAll(entrySettings.getQuantificationFiles());
        return fileList;
    }
}

