/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.tablehelpers;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.resize.command.ColumnResizeCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.RowResizeCommand;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.grits.toolbox.display.control.table.tablecore.GRITSImagePainter;
import org.grits.toolbox.utils.image.GlycanImageProvider;

public class AutoResizeImagePainter
extends GRITSImagePainter {
    private final boolean calculate;
    private final int spacing;
    private Rectangle imageBounds = null;
    private GlycanImageProvider.GlycanImageObject gio = null;

    public AutoResizeImagePainter() {
        super(null);
        this.calculate = false;
        this.spacing = 0;
    }

    public AutoResizeImagePainter(GlycanImageProvider.GlycanImageObject gio) {
        super(null, true);
        this.calculate = false;
        this.spacing = 0;
        this.gio = gio;
    }

    public AutoResizeImagePainter(GlycanImageProvider.GlycanImageObject gio, boolean paintBg) {
        super(null, paintBg);
        this.calculate = false;
        this.spacing = 0;
        this.gio = gio;
    }

    public AutoResizeImagePainter(GlycanImageProvider.GlycanImageObject gio, boolean paintBg, int spacing, boolean calculate) {
        super(null, paintBg);
        this.calculate = calculate;
        this.spacing = spacing;
        this.gio = gio;
    }

    public void paintCell(ILayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        ILayer layer;
        Rectangle newBounds = this.calculate ? this.getBoundsFromCache(cell, gc, bounds, configRegistry) : bounds;
        newBounds.x = bounds.x;
        newBounds.y = bounds.y;
        if (bounds.height < newBounds.height && this.calculate) {
            layer = cell.getLayer();
            layer.doCommand((ILayerCommand)new RowResizeCommand(layer, cell.getRowPosition(), newBounds.height));
        }
        if (bounds.width < newBounds.width && this.calculate) {
            layer = cell.getLayer();
            layer.doCommand((ILayerCommand)new ColumnResizeCommand(layer, cell.getColumnPosition(), newBounds.width));
        }
        Rectangle adjustedCellBounds = cell.getLayer().getLayerPainter().adjustCellBounds(cell.getColumnPosition(), cell.getRowPosition(), newBounds);
        IStyle cellStyle = CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry);
        adjustedCellBounds.x += CellStyleUtil.getHorizontalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)adjustedCellBounds.width);
        adjustedCellBounds.y += CellStyleUtil.getVerticalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)adjustedCellBounds.height);
        super.paintCell(cell, gc, adjustedCellBounds, configRegistry);
    }

    protected Rectangle getBoundsFromCache(ILayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        if (this.imageBounds != null) {
            return this.imageBounds;
        }
        int iWidth = this.getPreferredWidth(cell, gc, configRegistry) + this.spacing;
        int iHeight = this.getPreferredHeight(cell, gc, configRegistry) + this.spacing;
        this.imageBounds = new Rectangle(0, 0, iWidth, iHeight);
        return this.getBoundsFromCache(cell, gc, bounds, configRegistry);
    }

    public ICellPainter getCellPainterAt(int x, int y, ILayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        Rectangle imageBounds = this.getImage(cell, configRegistry).getBounds();
        IStyle cellStyle = CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry);
        int x0 = bounds.x + CellStyleUtil.getHorizontalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)imageBounds.width);
        int y0 = bounds.y + CellStyleUtil.getVerticalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)imageBounds.height);
        if (x >= x0 && x < x0 + imageBounds.width && y >= y0 && y < y0 + imageBounds.height) {
            return super.getCellPainterAt(x, y, cell, gc, bounds, configRegistry);
        }
        return null;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    protected Image getImage(ILayerCell cell, IConfigRegistry configRegistry) {
        if (this.gio == null) {
            this.image = null;
            return this.image;
        }
        this.image = this.gio.getSwtImage();
        return this.image;
    }
}

