/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.views.tabbed;

import org.apache.log4j.Logger;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.entry.ms.annotation.process.loader.MSAnnotationTableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.SharedCheckboxWidget;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationDetails;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationPeaksView;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.ms.om.data.Scan;

public class MSAnnotationEntityScroller
extends Composite {
    private static final Logger logger = Logger.getLogger(MSAnnotationEntityScroller.class);
    protected Feature feature = null;
    protected Peak peak = null;
    protected Annotation annotation = null;
    protected Scan scan = null;
    protected Button prevButton = null;
    protected Button nextButton = null;
    protected Composite featureControl = null;
    protected MSAnnotationDetails msAnnotationDetails = null;
    private int iCurViewInx = -1;
    protected Composite compositeTop = null;
    protected CLabel idLabel = null;
    protected Label featCounterLabel = null;
    protected int iMaxHeight;
    protected int iMaxWidth;

    public MSAnnotationEntityScroller(Composite parent, int style) {
        super(parent, style);
    }

    public MSAnnotationEntityScroller(Composite parent, int style, MSAnnotationDetails msAnnotationDetails) {
        this(parent, style);
        this.msAnnotationDetails = msAnnotationDetails;
    }

    public String toString() {
        return "MSAnnotationEntityScroller (" + this.feature + ")";
    }

    public int calcMaxHeight() {
        int iHeight = this.iMaxHeight * 2;
        if (iHeight < 175) {
            return 175;
        }
        return iHeight;
    }

    public int getMaxHeight() {
        return this.iMaxHeight;
    }

    public void setMaxHeight(int iMaxHeight) {
        this.iMaxHeight = iMaxHeight;
    }

    public int calcMaxWidth() {
        int iWidth = (int)((double)this.iMaxWidth * 1.3);
        if (iWidth < 250) {
            return 250;
        }
        return iWidth;
    }

    public int getMaxWidth() {
        return this.iMaxWidth;
    }

    public void setMaxWidth(int iMaxWidth) {
        this.iMaxWidth = iMaxWidth;
    }

    public Scan getScan() {
        return this.scan;
    }

    public void setScan(Scan scan) {
        this.scan = scan;
    }

    public void setAnnotation(Annotation annotation) {
        this.annotation = annotation;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public Peak getPeak() {
        return this.peak;
    }

    public void setPeak(Peak peak) {
        this.peak = peak;
    }

    public String getFeatureDesc() {
        return "" + this.annotation.getId();
    }

    public String getFeatureCountDesc() {
        return "(" + (this.getCurViewIndex() + 1) + " of " + this.msAnnotationDetails.getNumFeatures() + ")";
    }

    public void reDraw() {
        Feature curFeature = this.getMsAnnotationDetails().getFeature(this.getCurViewIndex());
        Annotation annot = ((MSAnnotationTableDataProcessor)this.getCurrentPeaksView().getTableDataProcessor()).getAnnotation(curFeature.getAnnotationId());
        Scan scan = ((MSAnnotationTableDataProcessor)this.getCurrentPeaksView().getTableDataProcessor()).getScan(this.getMsAnnotationDetails().getMsEntityProperty().getScanNum());
        this.setFeature(curFeature);
        this.setAnnotation(annot);
        this.setScan(scan);
        this.reDrawLabel();
        this.reDrawCounterLabel();
    }

    protected void reDrawLabel() {
        if (this.idLabel != null) {
            this.idLabel.setText(this.getFeatureDesc());
        }
    }

    protected void reDrawCounterLabel() {
        if (this.featCounterLabel != null) {
            this.featCounterLabel.setText(this.getFeatureCountDesc());
        }
    }

    public CLabel getNewCLabel(Composite parent, int style) {
        CLabel newLabel = new CLabel(parent, style);
        return newLabel;
    }

    protected void drawLabel() {
        GridData idLabelData = new GridData();
        idLabelData.grabExcessHorizontalSpace = true;
        idLabelData.horizontalAlignment = 4;
        idLabelData.horizontalSpan = 2;
        this.idLabel = this.getNewCLabel(this.compositeTop, 0);
        this.idLabel.setLayoutData((Object)idLabelData);
        GridData fcLabelData = new GridData();
        fcLabelData.horizontalAlignment = 2;
        this.featCounterLabel = new Label(this.compositeTop, 0);
        this.featCounterLabel.setLayoutData((Object)fcLabelData);
    }

    protected void drawFeature() {
        if (this.featureControl != null) {
            this.featureControl.dispose();
        }
        this.featureControl = new Composite((Composite)this, 0);
        this.featureControl.setLayout((Layout)new FillLayout());
        Label featLabel = new Label(this.featureControl, 0);
        featLabel.setText("Feature Id: ");
        Text featText = new Text(this.featureControl, 2048);
        if (this.getFeature() == null) {
            this.setFeature(this.msAnnotationDetails.getFeature(this.msAnnotationDetails.getCurViewIndex()));
        }
        featText.setText(this.getFeature().getId());
        Label seqLabel = new Label(this.featureControl, 0);
        seqLabel.setText("Sequence: ");
        Text seqText = new Text(this.featureControl, 2048);
        seqText.setText(this.feature.getSequence());
    }

    public Composite getFeatureControl() {
        return this.featureControl;
    }

    public void createPartControl(Composite parent) {
        this.compositeTop = new Composite(parent, 2048);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 5;
        this.compositeTop.setLayout((Layout)new GridLayout(3, false));
        GridData prevButtonData = new GridData();
        prevButtonData.grabExcessVerticalSpace = true;
        prevButtonData.verticalAlignment = 4;
        this.prevButton = new Button(this.compositeTop, -1);
        this.prevButton.setText("Prev");
        this.prevButton.setLayoutData((Object)prevButtonData);
        this.drawFeature();
        GridData nextButtonData = new GridData();
        nextButtonData.grabExcessVerticalSpace = true;
        nextButtonData.verticalAlignment = 4;
        this.nextButton = new Button(this.compositeTop, -1);
        this.nextButton.setText("Next");
        this.nextButton.setLayoutData((Object)nextButtonData);
        this.drawLabel();
        this.getPrevButton().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                MSAnnotationEntityScroller.this.goPrev();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.getNextButton().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                MSAnnotationEntityScroller.this.goNext();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    public void goNext() {
        ++this.iCurViewInx;
        if (this.iCurViewInx >= this.getMsAnnotationDetails().getPeakComposites().size()) {
            this.iCurViewInx = 0;
        }
        this.reDraw();
    }

    public void goPrev() {
        --this.iCurViewInx;
        if (this.iCurViewInx < 0) {
            this.iCurViewInx = this.getMsAnnotationDetails().getPeakComposites().size() - 1;
        }
        this.reDraw();
    }

    public Button getNextButton() {
        return this.nextButton;
    }

    public Button getPrevButton() {
        return this.prevButton;
    }

    public MSAnnotationDetails getMsAnnotationDetails() {
        return this.msAnnotationDetails;
    }

    public static String getCombinedKeyForLookup(Integer _iPeakId, String _sFeatureId) {
        return _iPeakId + ":" + _sFeatureId;
    }

    protected SharedCheckboxWidget getParentSharedCheckboxWidget() {
        return this.getMsAnnotationDetails().getParentSharedCheckboxWidget();
    }

    public void setCurViewIndex(int iCurViewInx) {
        this.iCurViewInx = iCurViewInx;
    }

    public int getCurViewIndex() {
        if (this.iCurViewInx < 0) {
            this.iCurViewInx = this.getMsAnnotationDetails().getCurViewIndex();
        }
        return this.iCurViewInx;
    }

    public MSAnnotationPeaksView getCurrentPeaksView() {
        return this.getMsAnnotationDetails().getPeaksViews().get(this.getCurViewIndex());
    }
}

