/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.views.tabbed;

import java.util.List;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.DataModelHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.editor.IEntryEditorPart;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.datamodel.ms.annotation.preference.MSAnnotationViewerPreference;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.MSAnnotationTableDataObject;
import org.grits.toolbox.datamodel.ms.preference.MassSpecViewerPreference;
import org.grits.toolbox.datamodel.ms.tablemodel.FillTypes;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.display.control.table.preference.TableViewerPreference;
import org.grits.toolbox.entry.ms.annotation.command.ViewRowChooserInTabCommandExecutor;
import org.grits.toolbox.entry.ms.annotation.process.loader.MSAnnotationTableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationEntityProperty;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationProperty;
import org.grits.toolbox.entry.ms.annotation.property.datamodel.MSAnnotationMetaData;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.MSAnnotationTable;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationDetails;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationFilterView;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationMultiPageViewerTableRefreshWorker;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationMultiPageViewerWorker;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationOtherSettingsView;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationPeaksView;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationPropertyView;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationQuantificationView;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationScansView;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationSelectionView;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationSpectraView;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.ExternalQuantAlias;
import org.grits.toolbox.entry.ms.property.datamodel.ExternalQuantFileToAlias;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecMetaData;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecUISettings;
import org.grits.toolbox.entry.ms.tablehelpers.MassSpecTable;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecPeaksView;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecScansView;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecSpectraView;
import org.grits.toolbox.ms.file.FileCategory;
import org.grits.toolbox.ms.om.data.AnnotationFilter;
import org.grits.toolbox.widgets.processDialog.GRITSProgressDialog;
import org.grits.toolbox.widgets.tools.GRITSProcessStatus;
import org.grits.toolbox.widgets.tools.GRITSWorker;

public class MSAnnotationMultiPageViewer
extends MassSpecMultiPageViewer {
    private static final Logger logger = Logger.getLogger(MSAnnotationMultiPageViewer.class);
    public static final String ROW_NUM_CONTEXT = "Row Number Context";
    protected MSAnnotationPropertyView msAnnotPropertyView = null;
    protected MSAnnotationFilterView msAnnotFilterView = null;
    protected int msAnnotPropertyViewTabIndex = -1;
    protected int msAnnotFilterViewTabIndex = -1;
    protected int msAnnotOtherViewTabIndex = -1;
    protected int msAnnotQuantViewTabIndex = -1;
    protected MSAnnotationDetails annotDetails = null;
    protected int annotDetailsTabIndex = -1;
    protected int numDetailSteps = -1;
    protected MSAnnotationOtherSettingsView msAnnotOtherView;
    protected MSAnnotationQuantificationView msAnnotQuantView;
    public static String VIEW_ID = "plugin.ms.annotation.views.MSAnnotationMultiPageViewer";

    public MSAnnotationMultiPageViewer() {
    }

    @Inject
    public MSAnnotationMultiPageViewer(Entry entry) {
        super(entry);
    }

    @Inject
    public MSAnnotationMultiPageViewer(MPart part) {
        super(part);
    }

    public int getNumDetailSteps() {
        return this.numDetailSteps;
    }

    public int getMsAnnotPropertyViewTabIndex() {
        return this.msAnnotPropertyViewTabIndex;
    }

    public void setMsAnnotPropertyViewTabIndex(int msAnnotPropertyViewTabIndex) {
        this.msAnnotPropertyViewTabIndex = msAnnotPropertyViewTabIndex;
    }

    public int getAnnotDetailsTabIndex() {
        return this.annotDetailsTabIndex;
    }

    public void setAnnotDetailsTabIndex(int annotDetailsTabIndex) {
        this.annotDetailsTabIndex = annotDetailsTabIndex;
    }

    public void setMsAnnotFilterViewTabIndex(int msAnnotFilterViewTabIndex) {
        this.msAnnotFilterViewTabIndex = msAnnotFilterViewTabIndex;
    }

    public int getMsAnnotFilterViewTabIndex() {
        return this.msAnnotFilterViewTabIndex;
    }

    public int getMsAnnotOtherViewTabIndex() {
        return this.msAnnotOtherViewTabIndex;
    }

    public int getMsAnnotQuantViewTabIndex() {
        return this.msAnnotQuantViewTabIndex;
    }

    public void setMsAnnotOtherViewTabIndex(int msAnnotOtherViewTabIndex) {
        this.msAnnotOtherViewTabIndex = msAnnotOtherViewTabIndex;
    }

    public void setMsAnnotQuantViewTabIndex(int msAnnotQuantViewTabIndex) {
        this.msAnnotQuantViewTabIndex = msAnnotQuantViewTabIndex;
    }

    public String toString() {
        return "MSAnnotationMultiPageViewer (" + this.entry + ")";
    }

    public MSAnnotationDetails getAnnotationDetails() {
        return this.annotDetails;
    }

    protected Entry getNewTableCompatibleEntry(Entry parentEntry) {
        Entry newEntry = MSAnnotationEntityProperty.getTableCompatibleEntry(parentEntry);
        return newEntry;
    }

    protected Entry getFirstPageEntry() {
        Entry parentEntry = null;
        if (gritsModelService.getLastSelection() != null && gritsModelService.getLastSelection().getFirstElement() instanceof Entry) {
            parentEntry = (Entry)gritsModelService.getLastSelection().getFirstElement();
        }
        Entry newEntry = this.getNewTableCompatibleEntry(parentEntry);
        MassSpecEntityProperty msEntityProp = (MassSpecEntityProperty)newEntry.getProperty();
        msEntityProp.setScanNum(Integer.valueOf(-1));
        msEntityProp.setMz(Double.valueOf(0.0));
        msEntityProp.setParentMz(Double.valueOf(0.0));
        this.setMinMSLevel(1);
        msEntityProp.setMsLevel(Integer.valueOf(this.getMinMSLevel()));
        newEntry.setDisplayName(newEntry.getDisplayName());
        if (newEntry.getProperty() instanceof MSAnnotationEntityProperty) {
            MSAnnotationEntityProperty msAnnotEntityProp = (MSAnnotationEntityProperty)newEntry.getProperty();
            msAnnotEntityProp.setAnnotationId(-1);
        }
        return newEntry;
    }

    protected Object getDesiredActivePage() {
        return this.annotDetails != null ? this.annotDetails : (this.getPeaksView().isEmpty() ? this.scansView : this.alPeaksViews.get(0));
    }

    protected int addPages(int _iMajorCount, MassSpecEntityProperty prop) {
        this.dtpdThreadedDialog = new GRITSProgressDialog(new Shell(), 1, false);
        this.dtpdThreadedDialog.open();
        this.dtpdThreadedDialog.getMajorProgressBarListener().setMaxValue(_iMajorCount);
        MSAnnotationMultiPageViewerWorker msmpvw = new MSAnnotationMultiPageViewerWorker(this, prop);
        this.dtpdThreadedDialog.setGritsWorker((GRITSWorker)msmpvw);
        int iSuccess = this.dtpdThreadedDialog.startWorker();
        return iSuccess;
    }

    public int addPeakListPage_Step2() {
        MSAnnotationEntityProperty ep;
        int iStatus = super.addPeakListPage_Step2();
        if (iStatus != GRITSProcessStatus.OK) {
            return iStatus;
        }
        int inx = this.getPeaksViewsFirstTabIndex();
        String sTitle = "Structure Annotation";
        if (this.entry.getProperty() instanceof MSAnnotationEntityProperty && (ep = (MSAnnotationEntityProperty)this.entry.getProperty()).getMsLevel() > 3 && ep.getAnnotationId() == -1) {
            sTitle = "Peak List";
        }
        this.setPageText(inx, sTitle);
        return this.getStatus();
    }

    public int addDetailsTab_Step1(MassSpecEntityProperty prop) {
        try {
            int iSuccess = this.initDetailsView(prop);
            this.dtpdThreadedDialog.setMinorStatus(iSuccess);
            if (iSuccess == GRITSProcessStatus.CANCEL) {
                this.setStatus(GRITSProcessStatus.CANCEL);
                return GRITSProcessStatus.CANCEL;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open Details view", (Throwable)ex);
            this.setStatus(GRITSProcessStatus.ERROR);
        }
        if (this.getStatus() == GRITSProcessStatus.ERROR) {
            String sMessage = "An error occurred creating the Details tab.";
            this.dtpdThreadedDialog.getMajorProgressBarListener().setError(sMessage);
        }
        return this.getStatus();
    }

    public int addDetailsTab_Step2() {
        try {
            boolean success = true;
            int iPageCount = this.getPageCount();
            try {
                int inx = this.getAnnotDetailsTabIndex();
                if (inx >= this.getPageCount()) {
                    inx = this.addPage((IEntryEditorPart)this.annotDetails, this.entry);
                    this.setAnnotDetailsTabIndex(inx);
                } else {
                    this.addPage(inx, (IEntryEditorPart)this.annotDetails, this.entry);
                }
                this.setPageText(inx, "Details View");
                this.setActivePage(inx);
                int iSuccess = this.annotDetails.getStatus();
                this.setStatus(iSuccess);
                this.dtpdThreadedDialog.setMinorStatus(iSuccess);
            }
            catch (Exception ex) {
                logger.error((Object)"Error adding Details tab.", (Throwable)ex);
                this.setStatus(GRITSProcessStatus.ERROR);
            }
            boolean bl = success = this.getStatus() != GRITSProcessStatus.ERROR;
            if (!success) {
                if (this.getPageCount() != iPageCount) {
                    this.removePage(this.getPageCount());
                }
                this.annotDetails = null;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open Details view", (Throwable)ex);
            this.setStatus(GRITSProcessStatus.ERROR);
        }
        if (this.getStatus() == GRITSProcessStatus.ERROR) {
            String sMessage = "An error occurred creating the Details tab.";
            this.dtpdThreadedDialog.getMajorProgressBarListener().setError(sMessage);
        }
        return this.getStatus();
    }

    protected int getNumMajorSteps(MassSpecEntityProperty prop) {
        int iCount = 1;
        int iTabCnt = 0;
        this.setPropertyViewTabIndex(iTabCnt++);
        this.setMsAnnotPropertyViewTabIndex(iTabCnt++);
        this.setMsAnnotFilterViewTabIndex(iTabCnt++);
        this.setMsAnnotOtherViewTabIndex(iTabCnt++);
        this.setMsAnnotQuantViewTabIndex(iTabCnt++);
        if (this.getMinMSLevel() < 0) {
            ++iCount;
        }
        iCount += 2;
        this.setScansViewTabIndex(iTabCnt++);
        ++iCount;
        if (this.needsPeaksView(prop)) {
            if (this.needsDetailsView((MSAnnotationEntityProperty)prop)) {
                ++iCount;
                ++iCount;
                this.setAnnotDetailsTabIndex(iTabCnt++);
                MSAnnotationMultiPageViewer viewer = MSAnnotationMultiPageViewer.getActiveViewer(this.getContext());
                if (viewer != null) {
                    if (viewer.getDetailsView() != null && !viewer.getDetailsView().getPeaksViews().isEmpty()) {
                        MSAnnotationPeaksView peakView = null;
                        int i = 0;
                        while (i < viewer.getDetailsView().getPeaksViews().size()) {
                            Integer scan;
                            MSAnnotationTableDataObject stdo;
                            MSAnnotationTable subTable;
                            peakView = viewer.getDetailsView().getPeaksViews().get(i);
                            if (peakView.getSelectionView() != null && (subTable = peakView.getSelectionView().getSubTable()) != null && !(stdo = (MSAnnotationTableDataObject)subTable.getGRITSTableDataObject()).getTableData().isEmpty() && (scan = (Integer)((GRITSListDataRow)stdo.getTableData().get(0)).getDataRow().get((Integer)stdo.getScanNoCols().get(0))) != null && scan.intValue() == prop.getScanNum().intValue()) {
                                this.numDetailSteps = stdo.getTableData().size();
                                iCount += this.numDetailSteps;
                                break;
                            }
                            ++i;
                        }
                    } else if (!viewer.getPeaksView().isEmpty() && viewer.getPeaksView().get(0) instanceof MSAnnotationPeaksView) {
                        MSAnnotationPeaksView peakView = (MSAnnotationPeaksView)viewer.getPeaksView().get(0);
                        this.numDetailSteps = peakView.getSelectionView().getSubTable().getGRITSTableDataObject().getTableData().size() - 2;
                        iCount += this.numDetailSteps;
                    }
                }
            } else {
                iCount += 2;
                this.setPeaksViewsFirstTabIndex(iTabCnt++);
            }
        }
        if (this.needsSpectraView(prop)) {
            ++iCount;
            this.setSpectraViewTabIndex(iTabCnt++);
        }
        return iCount;
    }

    public void createPages() {
        Property prop;
        this.setMinMSLevel(-1);
        if (this.entry == null || !(this.entry.getProperty() instanceof MassSpecEntityProperty)) {
            this.entry = this.getFirstPageEntry();
        }
        if (((MassSpecEntityProperty)(prop = this.entry.getProperty())).getDataFile() == null) {
            this.msFile = MSAnnotationMultiPageViewer.getAnnotationFile(this.entry);
            ((MassSpecEntityProperty)prop).setDataFile(this.msFile);
        } else {
            this.msFile = ((MassSpecEntityProperty)prop).getDataFile();
        }
        int iNumSteps = this.getNumMajorSteps((MassSpecEntityProperty)prop);
        this.getPart().getContext().set(MSAnnotationMultiPageViewer.class, (Object)this);
        this.iStatus = this.addPages(iNumSteps, (MassSpecEntityProperty)prop);
        if (this.iStatus == GRITSProcessStatus.ERROR) {
            throw new RuntimeException("Failed to open the entry");
        }
        this.setPartName(this.entry.getDisplayName());
        this.setActivePage();
    }

    protected String getScanHierarchyPartName() {
        return "ScanHierarchy-Annotation";
    }

    protected boolean needsScanHierarchyReload(MassSpecEntityProperty oldProp, MassSpecEntityProperty newProp) {
        return oldProp == null || !oldProp.getParentProperty().equals(newProp.getParentProperty());
    }

    protected MPart getScanHiearchyViewPart() {
        MPart part;
        String label = "Scan Hierarchy View";
        MPart msPart = this.partService.findPart("ScanHierarchy");
        if (msPart != null) {
            this.partService.hidePart(msPart, true);
        }
        if ((part = this.partService.findPart("ScanHierarchy-Annotation")) != null) {
            this.partService.activate(part);
        } else {
            part = this.partService.createPart("ScanHierarchy-Annotation");
            part.setLabel(label);
            List stacks = this.modelService.findElements((MUIElement)this.application, "org.grits.toolbox.core.partstack.ms", MPartStack.class, null);
            if (stacks.size() < 1) {
                this.setStatus(GRITSProcessStatus.ERROR);
                this.dtpdThreadedDialog.getMajorProgressBarListener().setError("Part stack not found. Is the following ID correct?org.grits.toolbox.core.partstack.ms");
                return null;
            }
            ((MPartStack)stacks.get(0)).getChildren().add(part);
            ((MPartStack)stacks.get(0)).setVisible(true);
            PropertyHandler.changePerspective((String)"org.grits.toolbox.core.perspective.msperspective");
            this.partService.showPart(part, EPartService.PartState.ACTIVATE);
        }
        return part;
    }

    private static void updateLegacyProjectMetaData(MSAnnotationMetaData metaData, MSPropertyDataFile pdf) {
        if (pdf.getMSFileType().equals("Instrument")) {
            return;
        }
        if (pdf.getCategory().equals((Object)FileCategory.ANNOTATION_CATEGORY)) {
            MSPropertyDataFile file = new MSPropertyDataFile(pdf.getName(), pdf.getVersion(), pdf.getType(), pdf.getCategory(), pdf.getMSFileType(), pdf.getOriginalFileName(), pdf.getPurpose());
            metaData.addAnnotationFile(file);
        } else if (pdf.getCategory().equals((Object)FileCategory.EXTERNAL_QUANTIFICATION_CATEGORY)) {
            MSPropertyDataFile file = new MSPropertyDataFile(pdf.getName(), pdf.getVersion(), pdf.getType(), pdf.getCategory(), pdf.getMSFileType(), pdf.getOriginalFileName(), pdf.getPurpose());
            metaData.addSourceFile(file);
            ExternalQuantAlias eqa = new ExternalQuantAlias();
            eqa.setAlias(MSPropertyDataFile.getLegacyExternalQuantAlias((MSPropertyDataFile)file));
            metaData.addExternalQuantFile(file, eqa);
            String sExtQuantType = MassSpecUISettings.getExternalQuantType((MSPropertyDataFile)file);
            ExternalQuantFileToAlias mAliases = metaData.getExternalQuantToAliasByQuantType(sExtQuantType);
            metaData.updateQuantAliasKeyInfo(file, mAliases, null);
        }
    }

    private static void updateLegacyProjectMetaData(Entry entry) {
        Property parentProperty = entry.getParent().getProperty();
        if (parentProperty instanceof MSAnnotationProperty) {
            MSAnnotationMetaData metaData = ((MSAnnotationProperty)parentProperty).getMSAnnotationMetaData();
            Entry msParent = entry.getParent().getParent();
            if (msParent != null && msParent.getProperty() instanceof MassSpecProperty) {
                MassSpecProperty msProperty = (MassSpecProperty)msParent.getProperty();
                MassSpecMetaData msMetaData = msProperty.getMassSpecMetaData();
                for (MSPropertyDataFile pdf : msMetaData.getFileList()) {
                    MSAnnotationMultiPageViewer.updateLegacyProjectMetaData(metaData, pdf);
                    if (pdf.getChildren() == null || pdf.getChildren().isEmpty()) continue;
                    for (MSPropertyDataFile pdfChild : pdf.getChildren()) {
                        MSAnnotationMultiPageViewer.updateLegacyProjectMetaData(metaData, pdfChild);
                    }
                }
                String settingsFile = ((MSAnnotationProperty)parentProperty).getFullyQualifiedMetaDataFileName(entry.getParent());
                MSAnnotationProperty.marshallSettingsFile(settingsFile, metaData);
            }
        }
    }

    private static MSPropertyDataFile getAnnotationFile(Entry entry) {
        Property parentProperty;
        if (entry.getParent() != null && (parentProperty = entry.getParent().getProperty()) instanceof MSAnnotationProperty) {
            MSAnnotationMetaData metaData = ((MSAnnotationProperty)parentProperty).getMSAnnotationMetaData();
            if (metaData.getAnnotationFile() == null) {
                MSAnnotationMultiPageViewer.updateLegacyProjectMetaData(entry);
            }
            return metaData.getAnnotationFile();
        }
        return null;
    }

    protected boolean initMSAnnotationPropertyView() {
        try {
            this.getPart().getContext().set(Entry.class, (Object)this.entry);
            this.msAnnotPropertyView = (MSAnnotationPropertyView)((Object)ContextInjectionFactory.make(MSAnnotationPropertyView.class, (IEclipseContext)this.getPart().getContext()));
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open property view", (Throwable)ex);
            return false;
        }
    }

    protected boolean initMsAnnotationFilterView() {
        try {
            this.getPart().getContext().set(Entry.class, (Object)this.entry);
            this.msAnnotFilterView = (MSAnnotationFilterView)((Object)ContextInjectionFactory.make(MSAnnotationFilterView.class, (IEclipseContext)this.getPart().getContext()));
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open property view", (Throwable)ex);
            return false;
        }
    }

    protected boolean initOtherSettingsView() {
        try {
            this.getPart().getContext().set(Entry.class, (Object)this.entry);
            this.msAnnotOtherView = (MSAnnotationOtherSettingsView)((Object)ContextInjectionFactory.make(MSAnnotationOtherSettingsView.class, (IEclipseContext)this.getPart().getContext()));
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open property view", (Throwable)ex);
            return false;
        }
    }

    protected boolean initQuantificationView() {
        try {
            this.getPart().getContext().set(Entry.class, (Object)this.entry);
            this.msAnnotQuantView = (MSAnnotationQuantificationView)((Object)ContextInjectionFactory.make(MSAnnotationQuantificationView.class, (IEclipseContext)this.getPart().getContext()));
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open property view", (Throwable)ex);
            return false;
        }
    }

    public int addMSAnnotationPropertyView() {
        try {
            boolean success = this.initMSAnnotationPropertyView();
            int iPageCount = this.getPageCount();
            if (success) {
                try {
                    int inx;
                    if (this.scansViewTabIndex >= 0) {
                        MSAnnotationTableDataProcessor proc = (MSAnnotationTableDataProcessor)this.scansView.getTableDataProcessor();
                        this.msAnnotPropertyView.setMsAnnotationMethod(proc.getMethod());
                    }
                    if ((inx = this.getMsAnnotPropertyViewTabIndex()) >= this.getPageCount()) {
                        inx = this.addPage((IEntryEditorPart)this.msAnnotPropertyView, this.entry);
                        this.setMsAnnotPropertyViewTabIndex(inx);
                    } else {
                        this.addPage(inx, (IEntryEditorPart)this.msAnnotPropertyView, this.entry);
                    }
                    this.setPageText(inx, "MS Annotation Properties");
                    this.setActivePage(inx);
                    this.setStatus(GRITSProcessStatus.OK);
                }
                catch (Exception ex) {
                    logger.error((Object)"Unable to open MS property view", (Throwable)ex);
                    this.setStatus(GRITSProcessStatus.ERROR);
                }
            }
            if (this.isCanceled()) {
                this.setStatus(GRITSProcessStatus.CANCEL);
            }
            boolean bl = success = this.getStatus() == GRITSProcessStatus.OK;
            if (!success) {
                if (this.getPageCount() != iPageCount) {
                    this.removePage(this.getPageCount());
                }
                this.msAnnotPropertyView = null;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open MS property view", (Throwable)ex);
            this.setStatus(GRITSProcessStatus.ERROR);
        }
        if (this.getStatus() == GRITSProcessStatus.ERROR) {
            String sMessage = "An error occurred creating the MS Annotation Properties tab.";
            this.dtpdThreadedDialog.getMajorProgressBarListener().setError(sMessage);
        }
        return this.getStatus();
    }

    public int addMsFilterPage() {
        try {
            boolean success = this.initMsAnnotationFilterView();
            int iPageCount = this.getPageCount();
            if (success) {
                try {
                    int inx;
                    if (this.scansViewTabIndex >= 0) {
                        MSAnnotationTableDataProcessor proc = (MSAnnotationTableDataProcessor)this.scansView.getTableDataProcessor();
                        this.msAnnotFilterView.setMsAnnotationMethod(proc.getMethod());
                    }
                    if ((inx = this.getMsAnnotFilterViewTabIndex()) >= this.getPageCount()) {
                        inx = this.addPage((IEntryEditorPart)this.msAnnotFilterView, this.entry);
                        this.setMsAnnotFilterViewTabIndex(inx);
                    } else {
                        this.addPage(inx, (IEntryEditorPart)this.msAnnotFilterView, this.entry);
                    }
                    this.setPageText(inx, "Filter Settings");
                    this.setActivePage(inx);
                    this.setStatus(GRITSProcessStatus.OK);
                }
                catch (Exception ex) {
                    logger.error((Object)"Unable to open MS Filter Settings view", (Throwable)ex);
                    this.setStatus(GRITSProcessStatus.ERROR);
                }
            }
            if (this.isCanceled()) {
                this.setStatus(GRITSProcessStatus.CANCEL);
            }
            boolean bl = success = this.getStatus() == GRITSProcessStatus.OK;
            if (!success) {
                if (this.getPageCount() != iPageCount) {
                    this.removePage(this.getPageCount());
                }
                this.msAnnotFilterView = null;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open MS settings view", (Throwable)ex);
            this.setStatus(GRITSProcessStatus.ERROR);
        }
        if (this.getStatus() == GRITSProcessStatus.ERROR) {
            String sMessage = "An error occurred creating the MS Annotation Filter Settings tab.";
            this.dtpdThreadedDialog.getMajorProgressBarListener().setError(sMessage);
        }
        return this.getStatus();
    }

    public int addOtherSettingsPage() {
        try {
            boolean success = this.initOtherSettingsView();
            int iPageCount = this.getPageCount();
            if (success) {
                try {
                    int inx = this.getMsAnnotOtherViewTabIndex();
                    if (inx >= this.getPageCount()) {
                        inx = this.addPage((IEntryEditorPart)this.msAnnotOtherView, this.entry);
                        this.setMsAnnotOtherViewTabIndex(inx);
                    } else {
                        this.addPage(inx, (IEntryEditorPart)this.msAnnotOtherView, this.entry);
                    }
                    this.setPageText(inx, "Custom Annotations");
                    this.setActivePage(inx);
                    this.setStatus(GRITSProcessStatus.OK);
                }
                catch (Exception ex) {
                    logger.error((Object)"Unable to open MS Custom Annotations view", (Throwable)ex);
                    this.setStatus(GRITSProcessStatus.ERROR);
                }
            }
            if (this.isCanceled()) {
                this.setStatus(GRITSProcessStatus.CANCEL);
            }
            boolean bl = success = this.getStatus() == GRITSProcessStatus.OK;
            if (!success) {
                if (this.getPageCount() != iPageCount) {
                    this.removePage(this.getPageCount());
                }
                this.msAnnotOtherView = null;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open MS custom annotations view", (Throwable)ex);
            this.setStatus(GRITSProcessStatus.ERROR);
        }
        if (this.getStatus() == GRITSProcessStatus.ERROR) {
            String sMessage = "An error occurred creating the MS Annotation Custom Annotations tab.";
            this.dtpdThreadedDialog.getMajorProgressBarListener().setError(sMessage);
        }
        return this.getStatus();
    }

    public int addQuantificationPage() {
        try {
            boolean success = this.initQuantificationView();
            int iPageCount = this.getPageCount();
            if (success) {
                try {
                    int inx = this.getMsAnnotQuantViewTabIndex();
                    if (inx >= this.getPageCount()) {
                        inx = this.addPage((IEntryEditorPart)this.msAnnotQuantView, this.entry);
                        this.setMsAnnotQuantViewTabIndex(inx);
                    } else {
                        this.addPage(inx, (IEntryEditorPart)this.msAnnotQuantView, this.entry);
                    }
                    this.setPageText(inx, "Quantification Settings");
                    this.setActivePage(inx);
                    this.setStatus(GRITSProcessStatus.OK);
                }
                catch (Exception ex) {
                    logger.error((Object)"Unable to open MS Quantification Settings view", (Throwable)ex);
                    this.setStatus(GRITSProcessStatus.ERROR);
                }
            }
            if (this.isCanceled()) {
                this.setStatus(GRITSProcessStatus.CANCEL);
            }
            boolean bl = success = this.getStatus() == GRITSProcessStatus.OK;
            if (!success) {
                if (this.getPageCount() != iPageCount) {
                    this.removePage(this.getPageCount());
                }
                this.msAnnotQuantView = null;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open MS quantification settings view", (Throwable)ex);
            this.setStatus(GRITSProcessStatus.ERROR);
        }
        if (this.getStatus() == GRITSProcessStatus.ERROR) {
            String sMessage = "An error occurred creating the MS Quantification Settings tab.";
            this.dtpdThreadedDialog.getMajorProgressBarListener().setError(sMessage);
        }
        return this.getStatus();
    }

    protected MassSpecSpectraView getNewSpectraView() {
        this.getPart().getContext().set(Entry.class, (Object)this.entry);
        return (MassSpecSpectraView)ContextInjectionFactory.make(MSAnnotationSpectraView.class, (IEclipseContext)this.getPart().getContext());
    }

    protected boolean initSpectraView(MassSpecEntityProperty prop) {
        try {
            int iMSLevelForSpectrum = 1;
            if (prop.getMsLevel() != null && this.entry.getParent().getProperty() instanceof MSAnnotationEntityProperty) {
                MSAnnotationEntityProperty parentProp = (MSAnnotationEntityProperty)this.entry.getParent().getProperty();
                iMSLevelForSpectrum = parentProp.getMsLevel();
            }
            this.spectraView = this.getNewSpectraView();
            if (this.getScansView() != null) {
                MSAnnotationTableDataProcessor scansTableProcessor = (MSAnnotationTableDataProcessor)this.getScansView().getTableDataProcessor();
                ((MSAnnotationSpectraView)this.spectraView).setScanListTableProcessor(scansTableProcessor);
            }
            if (!this.getPeaksView().isEmpty() && this.getPeaksView().get(0) != null) {
                MSAnnotationTableDataProcessor peaksTableProcessor = (MSAnnotationTableDataProcessor)((MassSpecPeaksView)this.getPeaksView().get(0)).getTableDataProcessor();
                ((MSAnnotationSpectraView)this.spectraView).setPeakListTableProcessor(peaksTableProcessor);
            }
            ((MSAnnotationSpectraView)this.spectraView).setMSLevel(iMSLevelForSpectrum);
            this.updateMSView(prop, this.spectraView);
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open spectra view", (Throwable)ex);
            return false;
        }
    }

    protected int initPeaksView(MassSpecEntityProperty entityProperty) {
        try {
            MassSpecEntityProperty msProp = (MassSpecEntityProperty)entityProperty.clone();
            msProp.setParentScanNum(entityProperty.getScanNum());
            msProp.setScanNum(null);
            MSAnnotationPeaksView peaksView = this.getNewPeaksView(this.entry, msProp);
            int iSuccess = peaksView.setTableDataProcessor(this.dtpdThreadedDialog);
            if (iSuccess == GRITSProcessStatus.OK) {
                this.alPeaksViews.add(peaksView);
            }
            return iSuccess;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open peaks view", (Throwable)ex);
            return GRITSProcessStatus.ERROR;
        }
    }

    protected MSAnnotationScansView getNewScansView(Entry entry, MassSpecEntityProperty entityProperty) {
        MSAnnotationEntityProperty msProp = (MSAnnotationEntityProperty)((Object)entityProperty.clone());
        msProp.setParentScanNum(entityProperty.getScanNum());
        msProp.setScanNum(null);
        this.getPart().getContext().set("MinMSLevelContext", (Object)this.getMinMSLevel());
        this.getPart().getContext().set(Property.class, (Object)msProp);
        this.getPart().getContext().set(Entry.class, (Object)entry);
        MSAnnotationScansView view = (MSAnnotationScansView)((Object)ContextInjectionFactory.make(MSAnnotationScansView.class, (IEclipseContext)this.getPart().getContext()));
        return view;
    }

    protected MSAnnotationPeaksView getNewPeaksView(Entry entry, MassSpecEntityProperty entityProperty) {
        this.getPart().getContext().set("MinMSLevelContext", (Object)this.getMinMSLevel());
        this.getPart().getContext().set(Property.class, (Object)entityProperty);
        this.getPart().getContext().set(Entry.class, (Object)entry);
        MSAnnotationPeaksView view = (MSAnnotationPeaksView)ContextInjectionFactory.make(MSAnnotationPeaksView.class, (IEclipseContext)this.getPart().getContext());
        return view;
    }

    public boolean needsDetailsView(MassSpecEntityProperty entityProperty) {
        if (entityProperty.getParentScanNum() == null || entityProperty.getParentScanNum() < 0) {
            return false;
        }
        if (entityProperty.getMsLevel() < 3) {
            return false;
        }
        return ((MSAnnotationEntityProperty)entityProperty).getAnnotationId() != null && ((MSAnnotationEntityProperty)entityProperty).getAnnotationId() >= 0;
    }

    protected int initDetailsView(MassSpecEntityProperty entityProperty) {
        try {
            this.annotDetails = this.getNewDetailsView(this.entry, entityProperty);
            return GRITSProcessStatus.OK;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open peaks view", (Throwable)ex);
            return GRITSProcessStatus.ERROR;
        }
    }

    protected MSAnnotationDetails getNewDetailsView(Entry entry, MassSpecEntityProperty entityProperty) {
        MSAnnotationMultiPageViewer parent = MSAnnotationMultiPageViewer.getActiveViewerForEntry(this.getContext(), entry);
        if (parent != null) {
            this.getPart().getContext().set(MSAnnotationMultiPageViewer.class, (Object)this);
            this.getPart().getContext().set("MinMSLevelContext", (Object)this.getMinMSLevel());
            this.getPart().getContext().set(Property.class, (Object)entityProperty);
            this.getPart().getContext().set(Entry.class, (Object)entry);
            MSAnnotationDetails view = (MSAnnotationDetails)ContextInjectionFactory.make(MSAnnotationDetails.class, (IEclipseContext)this.getPart().getContext());
            return view;
        }
        return null;
    }

    public static void showRowSelection(IEclipseContext context, Entry entry, MSAnnotationTable parentTable, int iRowIndex, int iScanNum, String sRowId) {
        try {
            MSAnnotationMultiPageViewer parent = MSAnnotationMultiPageViewer.getActiveViewerForEntry(context, entry);
            if (parent != null) {
                MSAnnotationPeaksView me = null;
                IEntryEditorPart oActiveTab = parent.getPageItem(parent.getActivePage());
                if (oActiveTab instanceof MSAnnotationDetails) {
                    me = parent.getAnnotationDetails().getCurrentPeaksView();
                } else if (me instanceof MSAnnotationPeaksView) {
                    me = (MSAnnotationPeaksView)((Object)parent.getPeaksView());
                }
                if (me == null) {
                    return;
                }
                MSAnnotationSelectionView viewer = ViewRowChooserInTabCommandExecutor.showRowChooser(me, parentTable, iRowIndex, iScanNum, sRowId);
                me.setSelectionView(viewer);
                me.getBottomPane().layout();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static MSAnnotationMultiPageViewer getActiveViewerForEntry(IEclipseContext context, Entry entry) {
        EPartService partService = (EPartService)context.get(EPartService.class);
        for (MPart part : partService.getParts()) {
            if (!(part.getObject() instanceof MSAnnotationMultiPageViewer) || !((MSAnnotationMultiPageViewer)((Object)part.getObject())).getEntry().equals(entry)) continue;
            return (MSAnnotationMultiPageViewer)((Object)part.getObject());
        }
        return null;
    }

    public static MSAnnotationMultiPageViewer getActiveViewer(IEclipseContext context) {
        MPart part = (MPart)context.get("e4ActivePart");
        if (part != null && part.getObject() instanceof MSAnnotationMultiPageViewer) {
            return (MSAnnotationMultiPageViewer)((Object)part.getObject());
        }
        return null;
    }

    public static Entry getEntryByAnnotationId(String _sAnnotationId) {
        Entry root = DataModelHandler.instance().getRoot();
        List kids = root.getChildren();
        Entry foundEntry = null;
        int i = 0;
        while (i < kids.size()) {
            Entry res = MSAnnotationMultiPageViewer.getEntryByAnnotationId(_sAnnotationId, (Entry)kids.get(i));
            if (res != null) {
                foundEntry = res;
                break;
            }
            ++i;
        }
        return foundEntry;
    }

    private static Entry getEntryByAnnotationId(String _sAnnotationId, Entry _entry) {
        MSAnnotationProperty prop;
        if (_entry.getProperty() instanceof MSAnnotationProperty && _sAnnotationId.equals((prop = (MSAnnotationProperty)_entry.getProperty()).getMSAnnotationMetaData().getAnnotationId())) {
            return _entry;
        }
        if (_entry.hasChildren()) {
            List kids = _entry.getChildren();
            int i = 0;
            while (i < kids.size()) {
                Entry res = MSAnnotationMultiPageViewer.getEntryByAnnotationId(_sAnnotationId, (Entry)kids.get(i));
                if (res != null) {
                    return res;
                }
                ++i;
            }
        }
        return null;
    }

    @Persist
    public void doSave(final IProgressMonitor monitor) {
        GRITSProgressDialog progressDialog = new GRITSProgressDialog(Display.getCurrent().getActiveShell(), 0, false, false);
        progressDialog.open();
        progressDialog.getMajorProgressBarListener().setMaxValue(5 + this.alPeaksViews.size());
        progressDialog.setGritsWorker(new GRITSWorker(){

            public int doWork() {
                if (MSAnnotationMultiPageViewer.this.propertyView != null && MSAnnotationMultiPageViewer.this.propertyView.isDirty()) {
                    this.updateListeners("Saving properties", 1);
                    MSAnnotationMultiPageViewer.this.propertyView.doSave(monitor);
                }
                if (MSAnnotationMultiPageViewer.this.scansView != null && MSAnnotationMultiPageViewer.this.scansView.isDirty()) {
                    this.updateListeners("Saving scans", 2);
                    MSAnnotationMultiPageViewer.this.scansView.doSave(monitor);
                }
                int i = 3;
                for (MassSpecPeaksView peaksView : MSAnnotationMultiPageViewer.this.alPeaksViews) {
                    if (peaksView == null || !peaksView.isDirty()) continue;
                    this.updateListeners("Saving changes", i++);
                    peaksView.doSave(monitor);
                }
                if (MSAnnotationMultiPageViewer.this.msAnnotPropertyView != null && MSAnnotationMultiPageViewer.this.msAnnotPropertyView.isDirty()) {
                    this.updateListeners("Saving annotation properties", i++);
                    MSAnnotationMultiPageViewer.this.msAnnotPropertyView.doSave(monitor);
                }
                if (MSAnnotationMultiPageViewer.this.annotDetails != null && MSAnnotationMultiPageViewer.this.annotDetails.isDirty()) {
                    this.updateListeners("Saving annotation details", i++);
                    MSAnnotationMultiPageViewer.this.annotDetails.doSave(monitor);
                }
                MSAnnotationMultiPageViewer.this.setDirty(false);
                this.updateListeners("Done saving", i);
                return GRITSProcessStatus.OK;
            }
        });
        progressDialog.startWorker();
    }

    @Optional
    @Inject
    public void tabContentModified(@UIEventTopic(value="content_modified_in_a_tab") IEntryEditorPart part) {
        super.tabContentModified(part);
        if (part.equals((Object)this.msAnnotPropertyView) || part.equals(this.annotDetails)) {
            this.setDirty(part.isDirty());
        }
    }

    public MSAnnotationDetails getDetailsView() {
        return this.annotDetails;
    }

    public MSAnnotationPeaksView getPrimaryAnnotatedPeaksView() {
        if (this.annotDetails != null) {
            return this.annotDetails.getCurrentPeaksView();
        }
        return (MSAnnotationPeaksView)this.getPeaksView().get(0);
    }

    public boolean needsPeaksView(MassSpecEntityProperty entityProperty) {
        boolean bRes = entityProperty.getScanNum() != null && entityProperty.getScanNum() != -1;
        return bRes |= entityProperty.getParentScanNum() != null && entityProperty.getParentScanNum() != -1;
    }

    protected void updateColumnVisibility(MassSpecTable table, MassSpecViewerPreference curPref, MassSpecViewerPreference updatePref) {
        if (curPref.getClass().equals(updatePref.getClass()) && curPref.getMSLevel() == updatePref.getMSLevel() && curPref.getFillType() == updatePref.getFillType()) {
            if (!updatePref.getColumnSettings().equals(curPref.getColumnSettings())) {
                table.getGRITSTableDataObject().setTablePreferences((TableViewerPreference)updatePref);
                table.updateViewFromPreferenceSettings();
            }
            if (Boolean.compare(((MSAnnotationViewerPreference)curPref).isHideUnannotatedPeaks(), ((MSAnnotationViewerPreference)updatePref).isHideUnannotatedPeaks()) != 0) {
                table.getGRITSTableDataObject().setTablePreferences((TableViewerPreference)updatePref);
                if (((MSAnnotationViewerPreference)curPref).isHideUnannotatedPeaks()) {
                    ((MSAnnotationTable)table).showUnannotatedRows();
                } else {
                    ((MSAnnotationTable)table).hideUnannotatedRows();
                }
            }
        }
    }

    protected void updateColumnVisibility(MassSpecViewerPreference updatePref) {
        MassSpecViewerPreference curPref;
        MSAnnotationTable table;
        MSAnnotationPeaksView peaksView;
        if (this.getScansView() != null) {
            try {
                MassSpecScansView scansView = this.getScansView();
                this.updateColumnVisibilityForView(scansView, updatePref);
            }
            catch (Exception ex) {
                logger.error((Object)("Error updating scans view from editor: " + this.getTitle()), (Throwable)ex);
            }
        }
        if (this.getPeaksView() != null) {
            int j = 0;
            while (j < this.getPeaksView().size()) {
                try {
                    peaksView = (MSAnnotationPeaksView)this.getPeaksView().get(j);
                    this.updateColumnVisibilityForView((MassSpecScansView)peaksView, updatePref);
                    if (peaksView.getSelectionView() != null) {
                        table = peaksView.getSelectionView().getSubTable();
                        curPref = (MassSpecViewerPreference)table.getGRITSTableDataObject().getTablePreferences();
                        this.updateColumnVisibility(table, curPref, updatePref);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)("Error updating peak view: " + j + " from editor: " + this.getTitle()), (Throwable)ex);
                }
                ++j;
            }
        }
        if (this.getDetailsView() != null && this.getDetailsView().getPeaksViews() != null) {
            int j = 0;
            while (j < this.getDetailsView().getPeaksViews().size()) {
                try {
                    peaksView = this.getDetailsView().getPeaksViews().get(j);
                    this.updateColumnVisibilityForView((MassSpecScansView)peaksView, updatePref);
                    if (peaksView.getSelectionView() != null) {
                        table = peaksView.getSelectionView().getSubTable();
                        curPref = (MassSpecViewerPreference)table.getGRITSTableDataObject().getTablePreferences();
                        this.updateColumnVisibility(table, curPref, updatePref);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)("Error updating details peak view: " + j + " from editor: " + this.getTitle()), (Throwable)ex);
                }
                ++j;
            }
        }
    }

    @Optional
    @Inject
    public void updatePreferences(@UIEventTopic(value="preference_value_changed_in_grits") String preferenceName) {
        if (preferenceName != null && preferenceName.startsWith(MSAnnotationViewerPreference.class.getName())) {
            try {
                PreferenceEntity preferenceEntity = this.gritsPreferenceStore.getPreferenceEntity(preferenceName);
                MSAnnotationViewerPreference updatePref = (MSAnnotationViewerPreference)TableViewerPreference.getTableViewerPreference((PreferenceEntity)preferenceEntity, MSAnnotationViewerPreference.class);
                this.updateColumnVisibility((MassSpecViewerPreference)updatePref);
            }
            catch (UnsupportedVersionException e) {
                logger.error((Object)"Error updating column visibility", (Throwable)e);
            }
        }
    }

    public int reLoadStructureAnnotationTab(List<String> columnKeys) {
        this.dtpdThreadedDialog = new GRITSProgressDialog(Display.getCurrent().getActiveShell(), 1, false);
        this.dtpdThreadedDialog.open();
        this.dtpdThreadedDialog.getMajorProgressBarListener().setMaxValue(1);
        MSAnnotationMultiPageViewerTableRefreshWorker msmpvw = new MSAnnotationMultiPageViewerTableRefreshWorker(this, columnKeys);
        this.dtpdThreadedDialog.setGritsWorker((GRITSWorker)msmpvw);
        int iSuccess = this.dtpdThreadedDialog.startWorker();
        return iSuccess;
    }

    public int reInitPeaksView(List<String> columnKeys) {
        try {
            ((MassSpecPeaksView)this.alPeaksViews.get(0)).getTableDataProcessor().setProgressBarDialog(this.dtpdThreadedDialog);
            ((MassSpecPeaksView)this.alPeaksViews.get(0)).reLoadView();
            ((MassSpecPeaksView)this.alPeaksViews.get(0)).getTopPane().layout();
            if (columnKeys != null) {
                for (String sKeyVal : columnKeys) {
                    ((MassSpecPeaksView)this.alPeaksViews.get(0)).getViewBase().getNatTable().moveToFirstColumn(sKeyVal);
                }
                ((MassSpecPeaksView)this.alPeaksViews.get(0)).getViewBase().getNatTable().updatePreferenceSettingsFromCurrentView();
                ((MassSpecPeaksView)this.alPeaksViews.get(0)).getViewBase().getNatTable().getGRITSTableDataObject().getTablePreferences().writePreference();
            }
            return GRITSProcessStatus.OK;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open scans view", (Throwable)ex);
            return GRITSProcessStatus.ERROR;
        }
    }

    public static String[] getPreferencePageLabels(int _iMSLevel) {
        if (_iMSLevel == 1) {
            return new String[]{"MS Scans"};
        }
        return new String[]{"MS Scans", "Annotated Peak List"};
    }

    public static FillTypes[] getPreferencePageFillTypes(int _iMSLevel) {
        if (_iMSLevel == 1) {
            return new FillTypes[]{FillTypes.Scans};
        }
        return new FillTypes[]{FillTypes.Scans, FillTypes.PeaksWithFeatures};
    }

    public static int getPreferencePageMaxNumPages() {
        return 2;
    }

    protected AnnotationFilter getFilter() {
        return null;
    }

    public static /* bridge */ /* synthetic */ MassSpecMultiPageViewer getActiveViewerForEntry(IEclipseContext iEclipseContext, Entry entry) {
        return MSAnnotationMultiPageViewer.getActiveViewerForEntry(iEclipseContext, entry);
    }
}

