/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.display.control.table.tablecore;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;

public class GRITSReflectiveColumnPropertyAccessor<R>
implements IColumnPropertyAccessor<R> {
    private static final Logger logger = Logger.getLogger(GRITSReflectiveColumnPropertyAccessor.class);
    private final List<String> propertyNames;
    private Map<String, PropertyDescriptor> propertyDescriptorMap;

    public GRITSReflectiveColumnPropertyAccessor(List<String> propertyNames) {
        this.propertyNames = propertyNames;
    }

    public int getColumnCount() {
        return this.propertyNames.size();
    }

    public Object getDataValue(R rowObj, int columnIndex) {
        try {
            PropertyDescriptor propertyDesc = this.getPropertyDescriptor(rowObj, columnIndex);
            Method readMethod = propertyDesc.getReadMethod();
            return readMethod.invoke(rowObj, new Object[0]);
        }
        catch (Exception e) {
            logger.warn((Object)e);
            throw new RuntimeException(e);
        }
    }

    public void setDataValue(R rowObj, int columnIndex, Object newValue) {
        try {
            PropertyDescriptor propertyDesc = this.getPropertyDescriptor(rowObj, columnIndex);
            Method writeMethod = propertyDesc.getWriteMethod();
            if (writeMethod == null) {
                throw new RuntimeException("Setter method not found in backing bean for value at column index: " + columnIndex);
            }
            writeMethod.invoke(rowObj, newValue);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Data type being set does not match the data type of the setter method in the backing bean");
        }
        catch (Exception e) {
            logger.warn((Object)e);
            throw new RuntimeException("Error while setting data value");
        }
    }

    public String getColumnProperty(int columnIndex) {
        return this.propertyNames.get(columnIndex);
    }

    public int getColumnIndex(String propertyName) {
        return this.propertyNames.indexOf(propertyName);
    }

    private PropertyDescriptor getPropertyDescriptor(R rowObj, int columnIndex) throws IntrospectionException {
        if (this.propertyDescriptorMap == null) {
            PropertyDescriptor[] propertyDescriptors;
            this.propertyDescriptorMap = new HashMap<String, PropertyDescriptor>();
            PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors = Introspector.getBeanInfo(rowObj.getClass()).getPropertyDescriptors();
            int n = propertyDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
                String someString = propertyDescriptor.getName();
                this.propertyDescriptorMap.put(String.valueOf(someString.substring(0, 1).toLowerCase()) + someString.substring(1), propertyDescriptor);
                ++n2;
            }
        }
        String propertyName = this.propertyNames.get(columnIndex);
        return this.propertyDescriptorMap.get(propertyName);
    }
}

