/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.core.utilShare.FileSelectionAdapter;
import org.grits.toolbox.core.utilShare.TextFieldUtils;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.FilterSettingLibrary;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanFilterCateogoryPreference;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanFilterPreference;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.utils.DatabaseUtils;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.utils.GlycanStructureDatabase;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.utils.GlycanStructureDatabaseIndex;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.Filtering;
import org.grits.toolbox.ms.annotation.structure.GlycanPreDefinedOptions;
import org.grits.toolbox.ms.annotation.structure.StructureHandlerFileSystem;
import org.grits.toolbox.ms.om.data.GlycanFilter;
import org.grits.toolbox.ms.om.data.GlycanSettings;
import org.grits.toolbox.ms.om.data.ReducingEnd;
import org.grits.toolbox.util.structure.glycan.filter.om.Category;
import org.grits.toolbox.util.structure.glycan.filter.om.FilterSetting;
import org.grits.toolbox.util.structure.glycan.filter.om.FiltersLibrary;

public class GlycanSettingsDialog
extends TitleAreaDialog {
    private static final Logger logger = Logger.getLogger(GlycanSettingsDialog.class);
    private static final int OTHER_REDEND_MAX_LENGTH = 15;
    private Combo cmbSelectFilter;
    private Button chkUseDatabaseMetaInfo;
    private Combo cmbPerDeriv;
    private Combo cmbRedEnd;
    private Label lblredEndName;
    private Text txtRedEndName;
    private Label lblMass;
    private Text txtRedEndMass;
    private Combo cmbDatabases;
    private Text txtNewDb;
    private Button btnBrowse;
    private FilterSetting filterSetting = null;
    private Filtering filtering;
    private FilterSettingLibrary preferenceFilterLibrary;
    private Category preferredFilterCategory;
    private ArrayList<String> databases;
    private HashMap<String, GlycanStructureDatabase> m_databaseIndex = new HashMap();
    protected GlycanSettings gSettings;
    private String m_databasePath;
    boolean editingMode = false;
    private String dbVersion = "1.0";

    public GlycanSettingsDialog(Shell parentShell, FiltersLibrary filterLibrary) {
        super(parentShell);
        this.gSettings = new GlycanSettings();
        this.loadFilterPreferences();
        this.filtering = new Filtering(this.getShell(), filterLibrary, this.preferredFilterCategory, null);
    }

    public GlycanSettingsDialog(Shell parentShell, FiltersLibrary filterLibrary, GlycanSettings gSettings) {
        super(parentShell);
        this.gSettings = gSettings;
        this.loadFilterPreferences();
        this.filtering = new Filtering(this.getShell(), filterLibrary, this.preferredFilterCategory, null);
        this.editingMode = true;
    }

    protected boolean isResizable() {
        return true;
    }

    private void loadFilterPreferences() {
        try {
            MSGlycanFilterCateogoryPreference categoryPreferences;
            MSGlycanFilterPreference preferences = MSGlycanFilterPreference.getMSGlycanFilterPreferences((PreferenceEntity)MSGlycanFilterPreference.getPreferenceEntity());
            if (preferences != null) {
                this.preferenceFilterLibrary = preferences.getFilterSettings();
            }
            if ((categoryPreferences = MSGlycanFilterCateogoryPreference.getMSGlycanFilterCategoryPreferences((PreferenceEntity)MSGlycanFilterCateogoryPreference.getPreferenceEntity())) != null) {
                this.preferredFilterCategory = categoryPreferences.getCategoryPreference();
            }
        }
        catch (UnsupportedVersionException unsupportedVersionException) {
            logger.error((Object)"Cannot load filter preference");
        }
    }

    protected Label setMandatoryLabel(Label lable) {
        lable.setText(String.valueOf(lable.getText()) + "*");
        lable.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        return lable;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Database Settings");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(4, false));
        container.setLayoutData((Object)new GridData(1808));
        this.addDatabaseControls(container);
        this.addUseMetaInfoControls(container);
        this.addSelectFilterItem(container);
        this.addPerDerivTypeControls(container);
        this.addReducingEndControls(container);
        return container;
    }

    private void addUseMetaInfoControls(Composite container) {
        this.chkUseDatabaseMetaInfo = new Button(container, 32);
        this.chkUseDatabaseMetaInfo.setText("Use specified structure settings from database.");
        this.chkUseDatabaseMetaInfo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        if (this.editingMode) {
            this.chkUseDatabaseMetaInfo.setSelection(this.gSettings.getFilter().getUseDatabaseStructureMetaInfo().booleanValue());
        }
        this.chkUseDatabaseMetaInfo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (GlycanSettingsDialog.this.cmbPerDeriv != null) {
                    GlycanSettingsDialog.this.cmbPerDeriv.setEnabled(!GlycanSettingsDialog.this.chkUseDatabaseMetaInfo.getSelection());
                }
                if (GlycanSettingsDialog.this.cmbRedEnd != null) {
                    GlycanSettingsDialog.this.cmbRedEnd.setEnabled(!GlycanSettingsDialog.this.chkUseDatabaseMetaInfo.getSelection());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(container, 0);
    }

    private void addPerDerivTypeControls(Composite container) {
        Label lblPerdrivType = new Label(container, 0);
        lblPerdrivType.setText("PerDeriv Type");
        lblPerdrivType = this.setMandatoryLabel(lblPerdrivType);
        this.cmbPerDeriv = new Combo(container, 0);
        this.cmbPerDeriv.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.cmbPerDeriv.setItems(GlycanPreDefinedOptions.getAllDerivitizationTypes());
        this.cmbPerDeriv.select(0);
        if (this.editingMode) {
            int selected = -1;
            int i = 0;
            String[] stringArray = this.cmbPerDeriv.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (this.gSettings.getPerDerivatisationType().equals(item)) {
                    selected = i;
                    break;
                }
                ++i;
                ++n2;
            }
            if (selected != -1) {
                this.cmbPerDeriv.select(selected);
            }
        }
    }

    private void addReducingEndControls(Composite container) {
        Label lblReducingEnd = new Label(container, 0);
        lblReducingEnd.setText("Reducing End");
        lblReducingEnd = this.setMandatoryLabel(lblReducingEnd);
        this.cmbRedEnd = new Combo(container, 0);
        this.cmbRedEnd.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.cmbRedEnd.setItems(GlycanPreDefinedOptions.getAllReducingEndTypes());
        this.cmbRedEnd.select(0);
        new Label(container, 0);
        this.lblredEndName = new Label(container, 0);
        this.lblredEndName.setText("Reducing End Name");
        this.txtRedEndName = new Text(container, 2048);
        this.txtRedEndName.setEnabled(false);
        this.txtRedEndName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        new Label(container, 0);
        this.lblMass = new Label(container, 0);
        this.lblMass.setText("Reducing End Mass");
        this.txtRedEndMass = new Text(container, 2048);
        this.txtRedEndMass.setEnabled(false);
        this.txtRedEndMass.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        if (this.editingMode) {
            int selected = -1;
            int i = 0;
            if (this.gSettings.getReducingEnd() != null && !this.gSettings.getReducingEnd().getType().equals(GlycanPreDefinedOptions.OTHER)) {
                String[] stringArray = this.cmbRedEnd.getItems();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    if (this.gSettings.getReducingEnd().getLabel().equals(item)) {
                        selected = i;
                        break;
                    }
                    ++i;
                    ++n2;
                }
            }
            if (selected != -1) {
                this.cmbRedEnd.select(selected);
            } else if (this.gSettings.getReducingEnd() != null && this.gSettings.getReducingEnd().getType().equals(GlycanPreDefinedOptions.OTHER)) {
                this.cmbRedEnd.select(this.cmbRedEnd.getItemCount() - 1);
                this.txtRedEndName.setEnabled(true);
                this.txtRedEndMass.setEnabled(true);
                this.txtRedEndName.setText(this.gSettings.getReducingEnd().getLabel());
                this.txtRedEndMass.setText("" + this.gSettings.getReducingEnd().getMass());
            }
        }
        this.txtRedEndName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GlycanSettingsDialog.this.getButton(0).setEnabled(GlycanSettingsDialog.this.validateInput());
            }
        });
        this.txtRedEndMass.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GlycanSettingsDialog.this.getButton(0).setEnabled(GlycanSettingsDialog.this.validateInput());
            }
        });
        this.cmbRedEnd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GlycanSettingsDialog.this.cmbRedEnd.getItem(GlycanSettingsDialog.this.cmbRedEnd.getSelectionIndex()).equals("other")) {
                    GlycanSettingsDialog.this.txtRedEndName.setEnabled(true);
                    GlycanSettingsDialog.this.txtRedEndMass.setEnabled(true);
                } else {
                    GlycanSettingsDialog.this.txtRedEndName.setEnabled(false);
                    GlycanSettingsDialog.this.txtRedEndMass.setEnabled(false);
                }
                GlycanSettingsDialog.this.getButton(0).setEnabled(GlycanSettingsDialog.this.validateInput());
            }
        });
    }

    private void addDatabaseControls(Composite container) {
        GlycanFilter filter;
        this.databases = new ArrayList();
        try {
            GlycanStructureDatabaseIndex t_databaseIndex = DatabaseUtils.getGelatoDatabases();
            for (GlycanStructureDatabase t_db : t_databaseIndex.getDatabase()) {
                String t_nameString = String.valueOf(t_db.getName()) + " - " + t_db.getNumberOfStructures().toString() + " glycans";
                this.databases.add(t_nameString);
                this.m_databaseIndex.put(t_nameString, t_db);
            }
            this.m_databasePath = DatabaseUtils.getDatabasePath();
        }
        catch (IOException e) {
            logger.error((Object)"Unable to find GELATO database index", (Throwable)e);
        }
        catch (JAXBException e) {
            logger.error((Object)"XML format problem in GELATO database index", (Throwable)e);
        }
        this.databases.add(GlycanPreDefinedOptions.OTHER);
        String[] cmbDBs = this.databases.toArray(new String[this.databases.size()]);
        int inx = 0;
        Label lblDatabase = new Label(container, 0);
        lblDatabase.setText("Database");
        lblDatabase = this.setMandatoryLabel(lblDatabase);
        this.cmbDatabases = new Combo(container, 0);
        GridData gd_cmbDatabases = new GridData(4, 0x1000000, true, false, 3, 1);
        gd_cmbDatabases.widthHint = 131;
        this.cmbDatabases.setLayoutData((Object)gd_cmbDatabases);
        this.cmbDatabases.setItems(cmbDBs);
        this.cmbDatabases.select(inx);
        new Label(container, 0);
        this.txtNewDb = new Text(container, 2048);
        this.txtNewDb.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.btnBrowse = new Button(container, 8);
        if (!this.cmbDatabases.getItem(this.cmbDatabases.getSelectionIndex()).equals(GlycanPreDefinedOptions.OTHER)) {
            this.btnBrowse.setEnabled(false);
            this.txtNewDb.setEnabled(false);
        }
        this.btnBrowse.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnBrowse.setText("Browse");
        FileSelectionAdapter rawFileBrowserSelectionAdapter = new FileSelectionAdapter();
        rawFileBrowserSelectionAdapter.setShell(container.getShell());
        rawFileBrowserSelectionAdapter.setText(this.txtNewDb);
        this.btnBrowse.addSelectionListener((SelectionListener)rawFileBrowserSelectionAdapter);
        new Label(container, 0);
        if (this.editingMode && (filter = this.gSettings.getFilter()) != null && filter.getDatabase() != null) {
            String dbNameString = null;
            for (GlycanStructureDatabase t_db : this.m_databaseIndex.values()) {
                if (!t_db.getPath().contains(filter.getDatabase())) continue;
                dbNameString = String.valueOf(t_db.getName()) + " - " + t_db.getNumberOfStructures().toString() + " glycans";
                break;
            }
            if (dbNameString != null) {
                int selected = -1;
                int i = 0;
                String[] stringArray = this.cmbDatabases.getItems();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    if (dbNameString.equals(item)) {
                        selected = i;
                        break;
                    }
                    ++i;
                    ++n2;
                }
                if (selected != -1) {
                    this.cmbDatabases.select(selected);
                }
            } else {
                this.cmbDatabases.select(this.cmbDatabases.getItemCount() - 1);
                this.txtNewDb.setText(filter.getDatabase());
            }
        }
        this.txtNewDb.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GlycanSettingsDialog.this.getButton(0).setEnabled(GlycanSettingsDialog.this.validateInput());
            }
        });
        this.cmbDatabases.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GlycanSettingsDialog.this.cmbDatabases.getItem(GlycanSettingsDialog.this.cmbDatabases.getSelectionIndex()).equals("other")) {
                    GlycanSettingsDialog.this.txtNewDb.setEnabled(true);
                    GlycanSettingsDialog.this.btnBrowse.setEnabled(true);
                    GlycanSettingsDialog.this.getButton(0).setEnabled(GlycanSettingsDialog.this.validateInput());
                } else {
                    GlycanSettingsDialog.this.txtNewDb.setEnabled(false);
                    GlycanSettingsDialog.this.btnBrowse.setEnabled(false);
                    GlycanSettingsDialog.this.getButton(0).setEnabled(GlycanSettingsDialog.this.validateInput());
                }
            }
        });
    }

    private void addSelectFilterItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        Label lblSelectFilter = new Label(parent, 0);
        lblSelectFilter.setText("Database Filter");
        lblSelectFilter.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false, 3, 1);
        this.cmbSelectFilter = new Combo(parent, 8);
        this.cmbSelectFilter.setLayoutData((Object)gd2);
        this.initStoredFiltersList();
        if (this.editingMode) {
            if (this.gSettings.getFilterSetting() != null && this.gSettings.getFilterSetting().getName() != null) {
                int selected = -1;
                int i = 0;
                String[] stringArray = this.cmbSelectFilter.getItems();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String filter = stringArray[n2];
                    if (this.gSettings.getFilterSetting().getName().equals(filter)) {
                        selected = i;
                        break;
                    }
                    ++i;
                    ++n2;
                }
                if (selected != -1) {
                    this.cmbSelectFilter.select(selected);
                }
            } else if (this.gSettings.getFilterSetting() != null) {
                this.cmbSelectFilter.select(this.cmbSelectFilter.getItemCount() - 1);
            }
        }
        this.cmbSelectFilter.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GlycanSettingsDialog.this.processSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void initStoredFiltersList() {
        this.cmbSelectFilter.removeAll();
        if (this.preferenceFilterLibrary != null && this.preferenceFilterLibrary.getFilterSettings() != null) {
            for (FilterSetting filter : this.preferenceFilterLibrary.getFilterSettings()) {
                this.cmbSelectFilter.add(filter.getName());
            }
        }
        this.cmbSelectFilter.add(GlycanPreDefinedOptions.OTHER);
        this.cmbSelectFilter.add("", 0);
    }

    private void processSelection() {
        if (!this.cmbSelectFilter.getText().trim().equals("")) {
            if (this.cmbSelectFilter.getText().equals(GlycanPreDefinedOptions.OTHER)) {
                if (this.filtering != null && this.filtering.open() == 0) {
                    this.filterSetting = this.filtering.getFilterSetting();
                    this.filtering.setFilterSetting(this.filterSetting);
                }
            } else {
                this.filterSetting = this.getCurrentFilter(this.cmbSelectFilter.getText().trim());
            }
        } else {
            this.filterSetting = null;
        }
    }

    private FilterSetting getCurrentFilter(String selFilter) {
        if (this.preferenceFilterLibrary != null && this.preferenceFilterLibrary.getFilterSettings() != null) {
            int i = 0;
            while (i < this.preferenceFilterLibrary.getFilterSettings().size()) {
                FilterSetting curFilter = (FilterSetting)this.preferenceFilterLibrary.getFilterSettings().get(i);
                if (curFilter.getName().equals(selFilter)) {
                    return curFilter;
                }
                ++i;
            }
        }
        return null;
    }

    public boolean validateInput() {
        if (this.txtRedEndName != null && this.txtRedEndName.getEnabled()) {
            if (TextFieldUtils.isEmpty((Text)this.txtRedEndName)) {
                this.setErrorMessage("Please enter a valid name for the reducing end.");
                return false;
            }
            if (this.txtRedEndName.getText().trim().length() > 15) {
                this.setErrorMessage("The maximum length for \"Other\" reducing end is 15.");
                return false;
            }
        }
        if (this.txtRedEndMass != null && this.txtRedEndMass.getEnabled() && (TextFieldUtils.isEmpty((Text)this.txtRedEndMass) || !TextFieldUtils.isDouble((Text)this.txtRedEndMass))) {
            this.setErrorMessage("Please enter a valid mass for the reducing end ");
            return false;
        }
        if (this.txtNewDb != null && this.txtNewDb.getEnabled() && (TextFieldUtils.isEmpty((Text)this.txtNewDb) || !this.isValidDatabase(this.txtNewDb.getText()))) {
            this.setErrorMessage("Please select a valid database");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private boolean isValidDatabase(String dbName) {
        GlycanFilter filter;
        block7: {
            try {
                filter = new GlycanFilter();
                if (dbName.indexOf(File.separator) == -1) {
                    try {
                        filter.setDatabase(String.valueOf(DatabaseUtils.getDatabasePath()) + File.separator + dbName);
                    }
                    catch (IOException e) {
                        logger.error((Object)"Database path cannot be determined", (Throwable)e);
                    }
                } else {
                    filter.setDatabase(dbName);
                }
                StructureHandlerFileSystem handler = new StructureHandlerFileSystem();
                if (handler.getStructures(filter) != null) break block7;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        this.dbVersion = filter.getVersion();
        return true;
    }

    protected void okPressed() {
        if (this.validateInput()) {
            this.saveGlycanSettings();
            super.okPressed();
        }
    }

    private void saveGlycanSettings() {
        String sSelectedDb = this.cmbDatabases.getText();
        String sSelectedPerDerivType = this.cmbPerDeriv.getText();
        String sSelectedRedEndName = this.cmbRedEnd.getText();
        String sOtherRedEndName = "";
        double dOtherRedEndMass = 0.0;
        if (this.cmbRedEnd.getText().equals(GlycanPreDefinedOptions.OTHER)) {
            sOtherRedEndName = this.txtRedEndName.getText().trim();
            dOtherRedEndMass = Double.parseDouble(this.txtRedEndMass.getText().trim());
        }
        this.gSettings.setPerDerivatisationType(sSelectedPerDerivType);
        ReducingEnd re = new ReducingEnd();
        if (sSelectedRedEndName.equalsIgnoreCase(GlycanPreDefinedOptions.OTHER)) {
            re.setLabel(sOtherRedEndName);
            re.setMass(Double.valueOf(dOtherRedEndMass));
            re.setType(GlycanPreDefinedOptions.OTHER);
        } else {
            re.setLabel(sSelectedRedEndName);
            re.setType(sSelectedRedEndName);
        }
        this.gSettings.setReducingEnd(re);
        GlycanStructureDatabase selectedDatabase = this.m_databaseIndex.get(sSelectedDb);
        GlycanFilter filter = new GlycanFilter();
        if (selectedDatabase == null) {
            filter.setDatabase(this.txtNewDb.getText());
        } else {
            filter.setDatabase(selectedDatabase.getFileName());
        }
        filter.setUseDatabaseStructureMetaInfo(Boolean.valueOf(this.chkUseDatabaseMetaInfo.getSelection()));
        filter.setVersion(this.dbVersion != null ? this.dbVersion : "1.0");
        this.gSettings.setFilter(filter);
        this.gSettings.setFilterSetting(this.filterSetting);
    }

    public GlycanSettings getGlycanSettings() {
        return this.gSettings;
    }
}

