/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.StandardType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TypeTuple;

public abstract class HierarchyType
extends TType {
    private HierarchyType fSuperclass;
    private HierarchyType[] fInterfaces;
    private IType fJavaElementType;

    protected HierarchyType(TypeEnvironment environment) {
        super(environment);
    }

    protected void initialize(ITypeBinding binding, IType javaElementType) {
        super.initialize(binding);
        Assert.isNotNull((Object)javaElementType);
        this.fJavaElementType = javaElementType;
        TypeEnvironment environment = this.getEnvironment();
        ITypeBinding superclass = binding.getSuperclass();
        if (superclass != null) {
            this.fSuperclass = (HierarchyType)environment.create(superclass);
        }
        ITypeBinding[] interfaces = binding.getInterfaces();
        this.fInterfaces = new HierarchyType[interfaces.length];
        int i = 0;
        while (i < interfaces.length) {
            this.fInterfaces[i] = (HierarchyType)environment.create(interfaces[i]);
            ++i;
        }
    }

    public TType getSuperclass() {
        return this.fSuperclass;
    }

    public TType[] getInterfaces() {
        return this.fInterfaces;
    }

    public IType getJavaElementType() {
        return this.fJavaElementType;
    }

    public boolean isSubType(HierarchyType other) {
        if (this.getEnvironment() == other.getEnvironment()) {
            TypeTuple key;
            Map<TypeTuple, Boolean> cache = this.getEnvironment().getSubTypeCache();
            Boolean value = cache.get(key = new TypeTuple(this, other));
            if (value != null) {
                return value;
            }
            boolean isSub = this.doIsSubType(other);
            value = isSub;
            cache.put(key, value);
            return isSub;
        }
        return this.doIsSubType(other);
    }

    private boolean doIsSubType(HierarchyType other) {
        if (this.fSuperclass != null && (other.isTypeEquivalentTo(this.fSuperclass) || this.fSuperclass.doIsSubType(other))) {
            return true;
        }
        int i = 0;
        while (i < this.fInterfaces.length) {
            if (other.isTypeEquivalentTo(this.fInterfaces[i]) || this.fInterfaces[i].doIsSubType(other)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean canAssignToStandardType(StandardType target) {
        if (target.isJavaLangObject()) {
            return true;
        }
        return this.isSubType(target);
    }
}

