/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.io.GlycoCT;

import java.util.ArrayList;
import java.util.HashMap;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.eurocarbdb.MolecularFramework.io.SugarImporterText;
import org.eurocarbdb.MolecularFramework.sugar.Anomer;
import org.eurocarbdb.MolecularFramework.sugar.BaseType;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraph;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraphAlternative;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Linkage;
import org.eurocarbdb.MolecularFramework.sugar.LinkageType;
import org.eurocarbdb.MolecularFramework.sugar.Modification;
import org.eurocarbdb.MolecularFramework.sugar.ModificationType;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.NonMonosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.SubstituentType;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitAlternative;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.Superclass;
import org.eurocarbdb.MolecularFramework.sugar.UnderdeterminedSubTree;

public class SugarImporterGlycoCTCondensed
extends SugarImporterText {
    private HashMap<Integer, GlycoNode> m_hashResidues = new HashMap();
    private HashMap<Integer, Linkage> m_hashLinkages = new HashMap();
    private HashMap<Integer, SugarUnitRepeat> m_hashRepeats = new HashMap();
    private HashMap<Integer, SugarUnitAlternative> m_hashAlternatives = new HashMap();
    private GlycoGraph m_objSugarUnit = null;
    private HashMap<GlycoNode, GlycoGraph> m_hashGraphs = new HashMap();
    private int m_iNonNumber = 0;
    private String m_strLineSeparator = null;

    public void setLineSeparator(String a_strSep) throws SugarImporterException {
        if (a_strSep == null) {
            this.m_strLineSeparator = null;
        } else {
            if (a_strSep.length() < 1) {
                throw new SugarImporterException("GLYCOCTC046", this.m_iPosition);
            }
            if (a_strSep.indexOf("$") != -1) {
                throw new SugarImporterException("GLYCOCTC047", this.m_iPosition);
            }
            this.m_strLineSeparator = a_strSep;
        }
    }

    public String getLineSeparator() {
        return this.m_strLineSeparator;
    }

    protected void start() throws SugarImporterException {
        this.clear();
        try {
            this.m_objSugarUnit = this.m_objSugar;
            this.residue_block();
            if (this.m_cToken == 'L') {
                this.linkage_block();
            }
            if (this.m_cToken == 'R') {
                this.repeat_block();
            }
            if (this.m_cToken == 'U') {
                this.underdeterminded_block();
            }
            if (this.m_cToken == 'A') {
                this.alternative_block();
            }
            while (this.m_cToken == 'N') {
                this.non_monosaccharide();
            }
        }
        catch (GlycoconjugateException e) {
            throw new SugarImporterException("COMMON013", this.m_iPosition);
        }
        if (!this.finished()) {
            throw new SugarImporterException("GLYCOCTC018", this.m_iPosition);
        }
    }

    private void non_monosaccharide() throws SugarImporterException, GlycoconjugateException {
        if (this.m_cToken != 'N') {
            throw new SugarImporterException("GLYCOCTC038", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'O') {
            throw new SugarImporterException("GLYCOCTC038", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'N') {
            throw new SugarImporterException("GLYCOCTC038", this.m_iPosition);
        }
        this.nextToken();
        int t_iNumber = this.number();
        ++this.m_iNonNumber;
        if (t_iNumber != this.m_iNonNumber) {
            throw new SugarImporterException("GLYCOCTC039", this.m_iPosition);
        }
        this.zeilen_abschluss();
        boolean t_bParent = false;
        if (this.m_cToken == 'P') {
            this.parseString("Parent:");
            t_bParent = true;
        } else {
            this.parseString("Child:");
        }
        int t_iResidue = this.number();
        this.zeilen_abschluss();
        this.parseString("Linkage:");
        GlycoEdge t_objEdge = this.specialLinkage();
        this.zeilen_abschluss();
        String t_strName = "";
        if (this.m_cToken == 'H') {
            this.parseString("HistoricalEntity:");
            t_strName = this.parseNonMsName();
        } else if (this.m_cToken == 'S') {
            this.parseString("SmallMolecule:");
            t_strName = this.parseNonMsName();
        } else if (this.m_cToken == 'P' && this.aheadToken(1) == 'e') {
            this.parseString("Peptide:");
            t_strName = this.parseNonMsName();
        } else {
            throw new SugarImporterException("GLYCOCTC041", this.m_iPosition);
        }
        NonMonosaccharide t_objNonMs = new NonMonosaccharide(t_strName);
        GlycoNode t_objRes = this.m_hashResidues.get(t_iResidue);
        if (t_objRes == null) {
            throw new SugarImporterException("GLYCOCTC042", this.m_iPosition);
        }
        GlycoGraph t_objGraph = this.m_hashGraphs.get(t_objRes);
        if (t_objGraph == null) {
            throw new SugarImporterException("GLYCOCTC043", this.m_iPosition);
        }
        t_objGraph.addNode(t_objNonMs);
        if (t_bParent) {
            t_objGraph.addEdge(t_objRes, t_objNonMs, t_objEdge);
        } else {
            if (t_objRes.getParentEdge() != null) {
                throw new SugarImporterException("GLYCOCTC044", this.m_iPosition);
            }
            t_objGraph.addEdge(t_objNonMs, t_objRes, t_objEdge);
        }
    }

    private String parseNonMsName() throws SugarImporterException {
        String t_strResult = "";
        if (this.m_strLineSeparator == null) {
            while (this.m_cToken != '\n' && this.m_cToken != '\r' && this.m_cToken != '$') {
                t_strResult = t_strResult + this.m_cToken;
                this.nextToken();
            }
        } else {
            while (this.m_cToken != this.m_strLineSeparator.charAt(0) && this.m_cToken != '$') {
                t_strResult = t_strResult + this.m_cToken;
                this.nextToken();
            }
        }
        return t_strResult;
    }

    private void parseString(String a_strString) throws SugarImporterException {
        String t_strString = "" + this.m_cToken;
        for (int t_iLength = a_strString.length() - 1; t_iLength > 0; --t_iLength) {
            this.nextToken();
            t_strString = t_strString + this.m_cToken;
        }
        if (!t_strString.equals(a_strString)) {
            throw new SugarImporterException("GLYCOCTC040", this.m_iPosition);
        }
        this.nextToken();
    }

    private GlycoEdge specialLinkage() throws SugarImporterException, GlycoconjugateException {
        LinkageType t_objLinkType;
        Linkage t_objLinkage = new Linkage();
        try {
            t_objLinkType = LinkageType.forName(this.m_cToken);
            t_objLinkage.setParentLinkageType(t_objLinkType);
            this.nextToken();
        }
        catch (GlycoconjugateException e) {
            throw new SugarImporterException("GLYCOCTC013", this.m_iPosition);
        }
        if (this.m_cToken != '(') {
            throw new SugarImporterException("GLYCOCTC014", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken == '-') {
            this.nextToken();
            if (this.m_cToken != '1') {
                throw new SugarImporterException("GLYCOCTC035", this.m_iPosition);
            }
            this.nextToken();
            t_objLinkage.addParentLinkage(-1);
        } else {
            t_objLinkage.addParentLinkage(this.number());
            while (this.m_cToken == '|') {
                this.nextToken();
                t_objLinkage.addParentLinkage(this.number());
            }
        }
        if (this.m_cToken != '+') {
            throw new SugarImporterException("GLYCOCTC015", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken == '-') {
            this.nextToken();
            if (this.m_cToken != '1') {
                throw new SugarImporterException("GLYCOCTC035", this.m_iPosition);
            }
            this.nextToken();
            t_objLinkage.addChildLinkage(-1);
        } else {
            t_objLinkage.addChildLinkage(this.number());
            while (this.m_cToken == '|') {
                this.nextToken();
                t_objLinkage.addChildLinkage(this.number());
            }
        }
        if (this.m_cToken != ')') {
            throw new SugarImporterException("GLYCOCTC016", this.m_iPosition);
        }
        this.nextToken();
        try {
            t_objLinkType = LinkageType.forName(this.m_cToken);
            t_objLinkage.setChildLinkageType(t_objLinkType);
            this.nextToken();
        }
        catch (GlycoconjugateException e) {
            throw new SugarImporterException("GLYCOCTC013", this.m_iPosition);
        }
        GlycoEdge t_objEdge = new GlycoEdge();
        t_objEdge.addGlycosidicLinkage(t_objLinkage);
        return t_objEdge;
    }

    private void underdeterminded_block() throws SugarImporterException, GlycoconjugateException {
        if (this.m_cToken != 'U') {
            throw new SugarImporterException("GLYCOCTC028", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'N') {
            throw new SugarImporterException("GLYCOCTC028", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'D') {
            throw new SugarImporterException("GLYCOCTC028", this.m_iPosition);
        }
        this.nextToken();
        this.zeilen_abschluss();
        this.underdeterminded_unit();
        while (this.m_cToken == 'U') {
            this.underdeterminded_unit();
        }
    }

    private void underdeterminded_unit() throws SugarImporterException, GlycoconjugateException {
        GlycoGraph t_objRepeat;
        if (this.m_cToken != 'U') {
            throw new SugarImporterException("GLYCOCTC028", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'N') {
            throw new SugarImporterException("GLYCOCTC028", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'D') {
            throw new SugarImporterException("GLYCOCTC028", this.m_iPosition);
        }
        this.nextToken();
        this.number();
        UnderdeterminedSubTree t_objUnderSubtree = new UnderdeterminedSubTree();
        if (this.m_cToken != ':') {
            throw new SugarImporterException("GLYCOCTC005", this.m_iPosition);
        }
        this.nextToken();
        double t_dMinStat = this.float_number_signed();
        if (this.m_cToken != ':') {
            throw new SugarImporterException("GLYCOCTC005", this.m_iPosition);
        }
        this.nextToken();
        double t_dMaxStat = this.float_number_signed();
        this.zeilen_abschluss();
        t_objUnderSubtree.setProbability(t_dMinStat, t_dMaxStat);
        String t_strTemp = "";
        for (int t_iCounter = 0; t_iCounter < 10; ++t_iCounter) {
            t_strTemp = t_strTemp + this.m_cToken;
            this.nextToken();
        }
        if (!t_strTemp.equals("ParentIDs:")) {
            throw new SugarImporterException("GLYCOCTC029", this.m_iPosition);
        }
        ArrayList<GlycoNode> t_aParents = new ArrayList<GlycoNode>();
        GlycoNode t_objNode2 = this.m_hashResidues.get(this.number());
        if (t_objNode2 == null) {
            throw new SugarImporterException("GLYCOCTC032", this.m_iPosition);
        }
        t_aParents.add(t_objNode2);
        while (this.m_cToken == '|') {
            this.nextToken();
            t_objNode2 = this.m_hashResidues.get(this.number());
            if (t_objNode2 == null) {
                throw new SugarImporterException("GLYCOCTC032", this.m_iPosition);
            }
            t_aParents.add(t_objNode2);
        }
        this.zeilen_abschluss();
        if (this.m_cToken != 'S') {
            throw new SugarImporterException("GLYCOCTC030", this.m_iPosition);
        }
        GlycoEdge t_objEdge = new GlycoEdge();
        while (this.m_cToken == 'S') {
            LinkageType t_objLinkType;
            t_strTemp = "";
            for (int t_iCounter = 0; t_iCounter < 16; ++t_iCounter) {
                t_strTemp = t_strTemp + this.m_cToken;
                this.nextToken();
            }
            if (!t_strTemp.equals("SubtreeLinkageID")) {
                throw new SugarImporterException("GLYCOCTC030", this.m_iPosition);
            }
            this.number();
            if (this.m_cToken != ':') {
                throw new SugarImporterException("GLYCOCTC005", this.m_iPosition);
            }
            this.nextToken();
            Linkage t_objLinkage = new Linkage();
            try {
                t_objLinkType = LinkageType.forName(this.m_cToken);
                t_objLinkage.setParentLinkageType(t_objLinkType);
                this.nextToken();
            }
            catch (GlycoconjugateException e) {
                throw new SugarImporterException("GLYCOCTC013", this.m_iPosition);
            }
            if (this.m_cToken != '(') {
                throw new SugarImporterException("GLYCOCTC014", this.m_iPosition);
            }
            this.nextToken();
            if (this.m_cToken == '-') {
                this.nextToken();
                if (this.m_cToken != '1') {
                    throw new SugarImporterException("GLYCOCTC035", this.m_iPosition);
                }
                this.nextToken();
                t_objLinkage.addParentLinkage(-1);
            } else {
                t_objLinkage.addParentLinkage(this.number());
                while (this.m_cToken == '|') {
                    this.nextToken();
                    t_objLinkage.addParentLinkage(this.number());
                }
            }
            if (this.m_cToken != '+') {
                throw new SugarImporterException("GLYCOCTC015", this.m_iPosition);
            }
            this.nextToken();
            if (this.m_cToken == '-') {
                this.nextToken();
                if (this.m_cToken != '1') {
                    throw new SugarImporterException("GLYCOCTC035", this.m_iPosition);
                }
                this.nextToken();
                t_objLinkage.addChildLinkage(-1);
            } else {
                t_objLinkage.addChildLinkage(this.number());
                while (this.m_cToken == '|') {
                    this.nextToken();
                    t_objLinkage.addChildLinkage(this.number());
                }
            }
            if (this.m_cToken != ')') {
                throw new SugarImporterException("GLYCOCTC016", this.m_iPosition);
            }
            this.nextToken();
            try {
                t_objLinkType = LinkageType.forName(this.m_cToken);
                t_objLinkage.setChildLinkageType(t_objLinkType);
                this.nextToken();
            }
            catch (GlycoconjugateException e) {
                throw new SugarImporterException("GLYCOCTC013", this.m_iPosition);
            }
            t_objEdge.addGlycosidicLinkage(t_objLinkage);
            this.zeilen_abschluss();
        }
        t_objUnderSubtree.setConnection(t_objEdge);
        this.m_objSugarUnit = t_objUnderSubtree;
        this.residue_block();
        if (this.m_cToken == 'L') {
            this.linkage_block();
        }
        if (t_aParents.size() == 0) {
            throw new SugarImporterException("GLYCOCTC031", this.m_iPosition);
        }
        GlycoGraph t_objUnit = this.m_hashGraphs.get(t_aParents.get(0));
        if (t_objUnit.getClass() == SugarUnitRepeat.class) {
            t_objRepeat = (SugarUnitRepeat)t_objUnit;
            ((SugarUnitRepeat)t_objRepeat).addUndeterminedSubTree(t_objUnderSubtree);
            for (GlycoNode t_objNode2 : t_aParents) {
                if (this.m_hashGraphs.get(t_objNode2) != t_objUnit) {
                    throw new SugarImporterException("GLYCOCTC033", this.m_iPosition);
                }
                ((SugarUnitRepeat)t_objRepeat).addUndeterminedSubTreeParent(t_objUnderSubtree, t_objNode2);
            }
        } else if (t_objUnit.getClass() == Sugar.class) {
            t_objRepeat = (Sugar)t_objUnit;
            ((Sugar)t_objRepeat).addUndeterminedSubTree(t_objUnderSubtree);
            for (GlycoNode t_objNode2 : t_aParents) {
                if (this.m_hashGraphs.get(t_objNode2) != t_objUnit) {
                    throw new SugarImporterException("GLYCOCTC033", this.m_iPosition);
                }
                ((Sugar)t_objRepeat).addUndeterminedSubTreeParent(t_objUnderSubtree, t_objNode2);
            }
        } else {
            throw new SugarImporterException("GLYCOCTC034", this.m_iPosition);
        }
    }

    private void alternative_block() throws SugarImporterException, GlycoconjugateException {
        if (this.m_cToken != 'A') {
            throw new SugarImporterException("GLYCOCTC023", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'L') {
            throw new SugarImporterException("GLYCOCTC023", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'T') {
            throw new SugarImporterException("GLYCOCTC023", this.m_iPosition);
        }
        this.nextToken();
        this.zeilen_abschluss();
        this.alternative_unit();
        while (this.m_cToken == 'A') {
            this.alternative_unit();
        }
    }

    private void alternative_unit() throws SugarImporterException, GlycoconjugateException {
        if (this.m_cToken != 'A') {
            throw new SugarImporterException("GLYCOCTC023", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'L') {
            throw new SugarImporterException("GLYCOCTC023", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'T') {
            throw new SugarImporterException("GLYCOCTC023", this.m_iPosition);
        }
        this.nextToken();
        int t_iAltNumber = this.number();
        SugarUnitAlternative t_objAlternative = this.m_hashAlternatives.get(t_iAltNumber);
        if (t_objAlternative == null) {
            throw new SugarImporterException("GLYCOCTC024", this.m_iPosition);
        }
        this.zeilen_abschluss();
        this.alternative_graph(t_objAlternative);
        this.alternative_graph(t_objAlternative);
        while (this.m_cToken != '$' && this.m_cToken != 'U') {
            this.alternative_graph(t_objAlternative);
        }
    }

    private void alternative_graph(SugarUnitAlternative a_objAltUnit) throws SugarImporterException, GlycoconjugateException {
        int t_iCounter;
        String t_strTemp = "";
        for (t_iCounter = 0; t_iCounter < 11; ++t_iCounter) {
            t_strTemp = t_strTemp + this.m_cToken;
            this.nextToken();
        }
        if (!t_strTemp.equals("ALTSUBGRAPH")) {
            throw new SugarImporterException("GLYCOCTC036", this.m_iPosition);
        }
        this.number();
        this.zeilen_abschluss();
        t_strTemp = "";
        for (t_iCounter = 0; t_iCounter < 12; ++t_iCounter) {
            t_strTemp = t_strTemp + this.m_cToken;
            this.nextToken();
        }
        if (!t_strTemp.equals("LEAD-IN RES:")) {
            throw new SugarImporterException("GLYCOCTC025", this.m_iPosition);
        }
        int t_iLeadIn = this.number();
        this.zeilen_abschluss();
        t_strTemp = "";
        for (int t_iCounter2 = 0; t_iCounter2 < 13; ++t_iCounter2) {
            t_strTemp = t_strTemp + this.m_cToken;
            this.nextToken();
        }
        if (!t_strTemp.equals("LEAD-OUT RES:")) {
            throw new SugarImporterException("GLYCOCTC026", this.m_iPosition);
        }
        HashMap<Integer, Integer> t_hLeadOUT = new HashMap<Integer, Integer>();
        char t_iDigit = this.m_cToken;
        while (t_iDigit > '/' && t_iDigit < ':') {
            int t_iFrom = this.number();
            if (this.m_cToken != '+') {
                throw new SugarImporterException("GLYCOCTC015", this.m_iPosition);
            }
            this.nextToken();
            int t_iTo = this.number();
            if (t_hLeadOUT.get(t_iTo) != null) {
                throw new SugarImporterException("GLYCOCTC027", this.m_iPosition);
            }
            t_hLeadOUT.put(t_iTo, t_iFrom);
            if (this.m_cToken != '|') {
                throw new SugarImporterException("GLYCOCTC037", this.m_iPosition);
            }
            this.nextToken();
            t_iDigit = this.m_cToken;
        }
        this.zeilen_abschluss();
        GlycoGraphAlternative t_objAlternative = new GlycoGraphAlternative();
        this.m_objSugarUnit = t_objAlternative;
        this.residue_block();
        if (this.m_cToken == 'L') {
            this.linkage_block();
        }
        this.zeilen_abschluss();
        a_objAltUnit.addAlternative(t_objAlternative);
        GlycoNode t_objNode = this.m_hashResidues.get(t_iLeadIn);
        a_objAltUnit.setLeadInNode(t_objNode, t_objAlternative);
        for (Integer t_iExtern : t_hLeadOUT.keySet()) {
            Integer t_iIntern = (Integer)t_hLeadOUT.get(t_iExtern);
            GlycoNode t_objParent = this.m_hashResidues.get(t_iIntern);
            GlycoNode t_objChild = this.m_hashResidues.get(t_iExtern);
            if (t_objParent == null || t_objChild == null) {
                throw new SugarImporterException("GLYCOCTC017", this.m_iPosition);
            }
            a_objAltUnit.addLeadOutNodeToNode(t_objParent, t_objAlternative, t_objChild);
        }
    }

    private void repeat_block() throws SugarImporterException, GlycoconjugateException {
        if (this.m_cToken != 'R') {
            throw new SugarImporterException("GLYCOCTC019", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'E') {
            throw new SugarImporterException("GLYCOCTC019", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'P') {
            throw new SugarImporterException("GLYCOCTC019", this.m_iPosition);
        }
        this.nextToken();
        this.zeilen_abschluss();
        this.repeat_unit();
        while (this.m_cToken == 'R') {
            this.repeat_unit();
        }
    }

    private void repeat_unit() throws SugarImporterException, GlycoconjugateException {
        int t_iMax;
        int t_iMin;
        LinkageType t_objLinkType;
        if (this.m_cToken != 'R') {
            throw new SugarImporterException("GLYCOCTC019", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'E') {
            throw new SugarImporterException("GLYCOCTC019", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'P') {
            throw new SugarImporterException("GLYCOCTC019", this.m_iPosition);
        }
        this.nextToken();
        int t_iRepeatNumber = this.number();
        if (this.m_cToken != ':') {
            throw new SugarImporterException("GLYCOCTC005", this.m_iPosition);
        }
        this.nextToken();
        Linkage t_objLinkage = new Linkage();
        int t_iParent = this.number();
        try {
            t_objLinkType = LinkageType.forName(this.m_cToken);
            t_objLinkage.setParentLinkageType(t_objLinkType);
            this.nextToken();
        }
        catch (GlycoconjugateException e) {
            throw new SugarImporterException("GLYCOCTC013", this.m_iPosition);
        }
        if (this.m_cToken != '(') {
            throw new SugarImporterException("GLYCOCTC014", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken == '-') {
            this.nextToken();
            if (this.m_cToken != '1') {
                throw new SugarImporterException("GLYCOCTC035", this.m_iPosition);
            }
            this.nextToken();
            t_objLinkage.addParentLinkage(-1);
        } else {
            t_objLinkage.addParentLinkage(this.number());
            while (this.m_cToken == '|') {
                this.nextToken();
                t_objLinkage.addParentLinkage(this.number());
            }
        }
        if (this.m_cToken != '+') {
            throw new SugarImporterException("GLYCOCTC015", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken == '-') {
            this.nextToken();
            if (this.m_cToken != '1') {
                throw new SugarImporterException("GLYCOCTC035", this.m_iPosition);
            }
            this.nextToken();
            t_objLinkage.addChildLinkage(-1);
        } else {
            t_objLinkage.addChildLinkage(this.number());
            while (this.m_cToken == '|') {
                this.nextToken();
                t_objLinkage.addChildLinkage(this.number());
            }
        }
        if (this.m_cToken != ')') {
            throw new SugarImporterException("GLYCOCTC016", this.m_iPosition);
        }
        this.nextToken();
        int t_iChild = this.number();
        try {
            t_objLinkType = LinkageType.forName(this.m_cToken);
            t_objLinkage.setChildLinkageType(t_objLinkType);
            this.nextToken();
        }
        catch (GlycoconjugateException e) {
            throw new SugarImporterException("GLYCOCTC013", this.m_iPosition);
        }
        if (this.m_cToken != '=') {
            throw new SugarImporterException("GLYCOCTC020", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken == '-') {
            this.nextToken();
            if (this.m_cToken != '1') {
                throw new SugarImporterException("GLYCOCTC021", this.m_iPosition);
            }
            this.nextToken();
            t_iMin = -1;
        } else {
            t_iMin = this.number();
        }
        if (this.m_cToken != '-') {
            throw new SugarImporterException("GLYCOCTC007", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken == '-') {
            this.nextToken();
            if (this.m_cToken != '1') {
                throw new SugarImporterException("GLYCOCTC021", this.m_iPosition);
            }
            this.nextToken();
            t_iMax = -1;
        } else {
            t_iMax = this.number();
        }
        this.zeilen_abschluss();
        SugarUnitRepeat t_objRepeat = this.m_hashRepeats.get(t_iRepeatNumber);
        if (t_objRepeat == null) {
            throw new SugarImporterException("GLYCOCTC022", this.m_iPosition);
        }
        t_objRepeat.setMinRepeatCount(t_iMin);
        t_objRepeat.setMaxRepeatCount(t_iMax);
        this.m_objSugarUnit = t_objRepeat;
        this.residue_block();
        if (this.m_cToken == 'L') {
            this.linkage_block();
        }
        GlycoEdge t_objEdge = new GlycoEdge();
        t_objEdge.addGlycosidicLinkage(t_objLinkage);
        GlycoNode t_objParent = this.m_hashResidues.get(t_iParent);
        GlycoNode t_objChild = this.m_hashResidues.get(t_iChild);
        if (t_objParent == null || t_objChild == null) {
            throw new SugarImporterException("GLYCOCTC017", this.m_iPosition);
        }
        t_objRepeat.setRepeatLinkage(t_objEdge, t_objParent, t_objChild);
    }

    private void residue_block() throws SugarImporterException, GlycoconjugateException {
        if (this.m_cToken != 'R') {
            throw new SugarImporterException("GLYCOCTC002", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'E') {
            throw new SugarImporterException("GLYCOCTC002", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'S') {
            throw new SugarImporterException("GLYCOCTC002", this.m_iPosition);
        }
        this.nextToken();
        this.zeilen_abschluss();
        this.residue_entry();
        this.zeilen_abschluss();
        char t_iDigit = this.m_cToken;
        while (t_iDigit > '/' && t_iDigit < ':') {
            this.residue_entry();
            this.zeilen_abschluss();
            t_iDigit = this.m_cToken;
        }
    }

    private void residue_entry() throws SugarImporterException, GlycoconjugateException {
        int t_iNumber = this.number();
        GlycoNode t_objNode = this.residue();
        this.m_objSugarUnit.addNode(t_objNode);
        this.m_hashGraphs.put(t_objNode, this.m_objSugarUnit);
        if (this.m_hashResidues.containsKey(t_iNumber)) {
            throw new SugarImporterException("Dupplicated residue ID.");
        }
        this.m_hashResidues.put(t_iNumber, t_objNode);
    }

    private GlycoNode residue() throws SugarImporterException, GlycoconjugateException {
        if (this.m_cToken == 's') {
            this.nextToken();
            if (this.m_cToken != ':') {
                throw new SugarImporterException("GLYCOCTC005", this.m_iPosition);
            }
            this.nextToken();
            int t_iStart = this.m_iPosition;
            this.substituent_name();
            String t_strName = this.m_strText.substring(t_iStart, this.m_iPosition);
            try {
                return new Substituent(SubstituentType.forName(t_strName));
            }
            catch (Exception e) {
                throw new SugarImporterException("GLYCOCTC004", this.m_iPosition);
            }
        }
        if (this.m_cToken == 'b') {
            int t_iRingStart;
            Superclass t_objSuper;
            int t_iCounter;
            Anomer t_objAnomer;
            this.nextToken();
            if (this.m_cToken != ':') {
                throw new SugarImporterException("GLYCOCTC005", this.m_iPosition);
            }
            this.nextToken();
            try {
                t_objAnomer = Anomer.forSymbol(this.m_cToken);
            }
            catch (Exception e) {
                throw new SugarImporterException("GLYCOCTC006", this.m_iPosition);
            }
            this.nextToken();
            if (this.m_cToken != '-') {
                throw new SugarImporterException("GLYCOCTC007", this.m_iPosition);
            }
            this.nextToken();
            int t_iMaxPos = this.m_strText.indexOf(":", this.m_iPosition) - 7;
            ArrayList<BaseType> t_aConfiguration = new ArrayList<BaseType>();
            String t_strInformation = "";
            while (this.m_iPosition < t_iMaxPos) {
                t_strInformation = "";
                for (t_iCounter = 0; t_iCounter < 4; ++t_iCounter) {
                    t_strInformation = t_strInformation + this.m_cToken;
                    this.nextToken();
                }
                try {
                    t_aConfiguration.add(BaseType.forName(t_strInformation));
                }
                catch (Exception e) {
                    throw new SugarImporterException("GLYCOCTC008", this.m_iPosition);
                }
                if (this.m_cToken != '-') {
                    throw new SugarImporterException("GLYCOCTC007", this.m_iPosition);
                }
                this.nextToken();
            }
            t_strInformation = "";
            for (t_iCounter = 0; t_iCounter < 3; ++t_iCounter) {
                t_strInformation = t_strInformation + this.m_cToken;
                this.nextToken();
            }
            try {
                t_objSuper = Superclass.forName(t_strInformation.toLowerCase());
            }
            catch (Exception e) {
                throw new SugarImporterException("GLYCOCTC009", this.m_iPosition);
            }
            Monosaccharide t_objMS = new Monosaccharide(t_objAnomer, t_objSuper);
            t_objMS.setBaseType(t_aConfiguration);
            if (this.m_cToken != '-') {
                throw new SugarImporterException("GLYCOCTC007", this.m_iPosition);
            }
            this.nextToken();
            if (this.m_cToken == 'x') {
                t_iRingStart = -1;
                this.nextToken();
            } else {
                t_iRingStart = this.number();
            }
            if (this.m_cToken != ':') {
                throw new SugarImporterException("GLYCOCTC005", this.m_iPosition);
            }
            this.nextToken();
            if (this.m_cToken == 'x') {
                t_objMS.setRing(t_iRingStart, -1);
                this.nextToken();
            } else {
                t_objMS.setRing(t_iRingStart, this.number());
            }
            while (this.m_cToken == '|') {
                ModificationType t_enumMod;
                int t_iPosOne;
                Integer t_iPosTwo = null;
                this.nextToken();
                if (this.m_cToken == 'x') {
                    t_iPosOne = 0;
                    this.nextToken();
                } else {
                    t_iPosOne = this.number();
                }
                if (this.m_cToken == ',') {
                    this.nextToken();
                    t_iPosTwo = this.number();
                }
                if (this.m_cToken != ':') {
                    throw new SugarImporterException("GLYCOCTC005", this.m_iPosition);
                }
                this.nextToken();
                int t_iStart = this.m_iPosition;
                this.modification_name();
                try {
                    t_enumMod = ModificationType.forName(this.m_strText.substring(t_iStart, this.m_iPosition));
                }
                catch (Exception e) {
                    throw new SugarImporterException("GLYCOCTC010", this.m_iPosition);
                }
                Modification t_objModi = new Modification(t_enumMod, t_iPosOne, t_iPosTwo);
                t_objMS.addModification(t_objModi);
            }
            return t_objMS;
        }
        if (this.m_cToken == 'a') {
            this.nextToken();
            if (this.m_cToken != ':') {
                throw new SugarImporterException("GLYCOCTC005", this.m_iPosition);
            }
            this.nextToken();
            if (this.m_cToken != 'a') {
                throw new SugarImporterException("GLYCOCTC011", this.m_iPosition);
            }
            this.nextToken();
            int t_iID = this.number();
            SugarUnitAlternative t_objAlternative = new SugarUnitAlternative();
            if (this.m_hashAlternatives.containsKey(t_iID)) {
                throw new SugarImporterException("Dupplicated alternative ID.");
            }
            this.m_hashAlternatives.put(t_iID, t_objAlternative);
            return t_objAlternative;
        }
        if (this.m_cToken == 'r') {
            this.nextToken();
            if (this.m_cToken != ':') {
                throw new SugarImporterException("GLYCOCTC005", this.m_iPosition);
            }
            this.nextToken();
            if (this.m_cToken != 'r') {
                throw new SugarImporterException("GLYCOCTC012", this.m_iPosition);
            }
            this.nextToken();
            int t_iID = this.number();
            SugarUnitRepeat t_objRepeat = new SugarUnitRepeat();
            if (this.m_hashRepeats.containsKey(t_iID)) {
                throw new SugarImporterException("Dupplicated repeat ID.");
            }
            this.m_hashRepeats.put(t_iID, t_objRepeat);
            return t_objRepeat;
        }
        throw new SugarImporterException("GLYCOCTC003", this.m_iPosition);
    }

    private void modification_name() throws SugarImporterException {
        boolean t_bNext = true;
        while (t_bNext) {
            t_bNext = false;
            if (this.m_cToken >= 'A' && this.m_cToken <= 'Z') {
                this.nextToken();
                t_bNext = true;
                continue;
            }
            if (this.m_cToken < 'a' || this.m_cToken > 'z') continue;
            this.nextToken();
            t_bNext = true;
        }
    }

    private void substituent_name() throws SugarImporterException {
        boolean t_bNext = true;
        while (t_bNext) {
            t_bNext = false;
            if (this.m_cToken >= 'A' && this.m_cToken <= 'Z') {
                this.nextToken();
                t_bNext = true;
                continue;
            }
            if (this.m_cToken >= 'a' && this.m_cToken <= 'z') {
                this.nextToken();
                t_bNext = true;
                continue;
            }
            if (this.m_cToken == '-' || this.m_cToken == '_') {
                this.nextToken();
                t_bNext = true;
                continue;
            }
            if (this.m_cToken != '(' && this.m_cToken != ')') continue;
            this.nextToken();
            t_bNext = true;
        }
    }

    private void linkage_block() throws SugarImporterException, GlycoconjugateException {
        if (this.m_cToken != 'L') {
            throw new SugarImporterException("GLYCOCTC001", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'I') {
            throw new SugarImporterException("GLYCOCTC001", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'N') {
            throw new SugarImporterException("GLYCOCTC001", this.m_iPosition);
        }
        this.nextToken();
        this.zeilen_abschluss();
        char t_iDigit = this.m_cToken;
        while (t_iDigit > '/' && t_iDigit < ':') {
            this.linkage();
            this.zeilen_abschluss();
            t_iDigit = this.m_cToken;
        }
    }

    private void linkage() throws SugarImporterException, GlycoconjugateException {
        LinkageType t_objLinkType;
        Linkage t_objLinkage = new Linkage();
        int t_iLinkageNumber = this.number();
        if (this.m_cToken != ':') {
            throw new SugarImporterException("GLYCOCTC005", this.m_iPosition);
        }
        this.nextToken();
        int t_iParent = this.number();
        try {
            t_objLinkType = LinkageType.forName(this.m_cToken);
            t_objLinkage.setParentLinkageType(t_objLinkType);
            this.nextToken();
        }
        catch (GlycoconjugateException e) {
            throw new SugarImporterException("GLYCOCTC013", this.m_iPosition);
        }
        if (this.m_cToken != '(') {
            throw new SugarImporterException("GLYCOCTC014", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken == '-') {
            this.nextToken();
            if (this.m_cToken != '1') {
                throw new SugarImporterException("GLYCOCTC035", this.m_iPosition);
            }
            this.nextToken();
            t_objLinkage.addParentLinkage(-1);
        } else {
            t_objLinkage.addParentLinkage(this.number());
            while (this.m_cToken == '|') {
                this.nextToken();
                t_objLinkage.addParentLinkage(this.number());
            }
        }
        if (this.m_cToken != '+') {
            throw new SugarImporterException("GLYCOCTC015", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken == '-') {
            this.nextToken();
            if (this.m_cToken != '1') {
                throw new SugarImporterException("GLYCOCTC035", this.m_iPosition);
            }
            this.nextToken();
            t_objLinkage.addChildLinkage(-1);
        } else {
            t_objLinkage.addChildLinkage(this.number());
            while (this.m_cToken == '|') {
                this.nextToken();
                t_objLinkage.addChildLinkage(this.number());
            }
        }
        if (this.m_cToken != ')') {
            throw new SugarImporterException("GLYCOCTC016", this.m_iPosition);
        }
        this.nextToken();
        int t_iChild = this.number();
        try {
            t_objLinkType = LinkageType.forName(this.m_cToken);
            t_objLinkage.setChildLinkageType(t_objLinkType);
            this.nextToken();
        }
        catch (GlycoconjugateException e) {
            throw new SugarImporterException("GLYCOCTC013", this.m_iPosition);
        }
        GlycoNode t_objParent = this.m_hashResidues.get(t_iParent);
        GlycoNode t_objChild = this.m_hashResidues.get(t_iChild);
        if (t_objParent == null || t_objChild == null) {
            throw new SugarImporterException("GLYCOCTC017", this.m_iPosition);
        }
        GlycoEdge t_objEdge = t_objChild.getParentEdge();
        if (t_objEdge == null) {
            t_objEdge = new GlycoEdge();
            t_objEdge.addGlycosidicLinkage(t_objLinkage);
            this.m_objSugarUnit.addEdge(t_objParent, t_objChild, t_objEdge);
        } else {
            if (t_objEdge.getParent() != t_objParent) {
                throw new SugarImporterException("GLYCOCTC016", this.m_iPosition);
            }
            t_objEdge.addGlycosidicLinkage(t_objLinkage);
        }
        this.m_hashLinkages.put(t_iLinkageNumber, t_objLinkage);
    }

    private void zeilen_abschluss() throws SugarImporterException {
        block4: {
            block3: {
                if (this.m_strLineSeparator != null) break block3;
                while (this.m_cToken == '\r' || this.m_cToken == '\n') {
                    this.nextToken();
                }
                break block4;
            }
            if (this.m_cToken == '$') break block4;
            for (int t_iCounter = 0; t_iCounter < this.m_strLineSeparator.length(); ++t_iCounter) {
                if (this.m_cToken != this.m_strLineSeparator.charAt(t_iCounter)) {
                    throw new SugarImporterException("GLYCOCTC045", this.m_iPosition);
                }
                this.nextToken();
            }
        }
    }

    private void clear() {
        this.m_objSugarUnit = null;
        this.m_hashResidues.clear();
        this.m_hashResidues.clear();
        this.m_hashRepeats.clear();
        this.m_hashAlternatives.clear();
        this.m_hashGraphs.clear();
        this.m_hashLinkages.clear();
        this.m_iNonNumber = 0;
    }
}

