/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.util.similiarity.PairSimiliarity;

import org.eurocarbdb.MolecularFramework.io.GlycoCT.SugarExporterGlycoCTCondensed;
import org.eurocarbdb.MolecularFramework.io.Linucs.SugarImporterLinucs;
import org.eurocarbdb.MolecularFramework.io.SugarImporter;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.eurocarbdb.MolecularFramework.io.namespace.GlycoVisitorToGlycoCT;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.util.analytical.disaccharide.Disaccharide;
import org.eurocarbdb.MolecularFramework.util.similiarity.PairSimiliarity.PairSimiliarity;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.NodeComparatorWithSubstituents;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.io.MonosaccharideConversion;
import org.eurocarbdb.resourcesdb.io.MonosaccharideConverter;

public class ExampleUsage {
    public static void main(String[] args) throws ResourcesDbException, SugarImporterException, GlycoVisitorException {
        SugarImporterLinucs t_objImporter = new SugarImporterLinucs();
        Config t_objConf = new Config();
        String t_strCode = "[][a-D-GALNAC]{[(4+1)][B-D-GLCP]{[(3+1)][A-D-MANP]{[(2+1)][A-D-MANP]{}}}}";
        MonosaccharideConverter t_objTrans = new MonosaccharideConverter(t_objConf);
        Sugar g1 = ((SugarImporter)t_objImporter).parse(t_strCode);
        GlycoVisitorToGlycoCT t_objTo = new GlycoVisitorToGlycoCT((MonosaccharideConversion)t_objTrans);
        t_objTo.start(g1);
        g1 = t_objTo.getNormalizedSugar();
        t_strCode = "[][a-D-GAL]{[(4+1)][B-D-GLCPNAC]{[(3+1)][A-D-MANP]{[(2+1)][A-D-MANP]{}}}}";
        SugarImporterLinucs t_objImporter2 = new SugarImporterLinucs();
        Config t_objConf2 = new Config();
        MonosaccharideConverter t_objTrans2 = new MonosaccharideConverter(t_objConf2);
        t_objTrans2 = new MonosaccharideConverter(t_objConf2);
        Sugar g2 = ((SugarImporter)t_objImporter2).parse(t_strCode);
        GlycoVisitorToGlycoCT t_objTo2 = new GlycoVisitorToGlycoCT((MonosaccharideConversion)t_objTrans2);
        t_objTo2.start(g1);
        g1 = t_objTo2.getNormalizedSugar();
        t_objTo2.start(g2);
        g2 = t_objTo2.getNormalizedSugar();
        PairSimiliarity t_oComp = new PairSimiliarity();
        t_oComp.setNodeComparator(new NodeComparatorWithSubstituents());
        t_oComp.calculate(g1, g2);
        System.out.println("Score: \t" + t_oComp.getScore());
        System.out.println("Normalized Score: " + t_oComp.getNormalizedScore());
        Integer counter = 0;
        for (Disaccharide p : t_oComp.getPairs()) {
            Integer n = counter;
            Integer n2 = counter = Integer.valueOf(counter + 1);
            Sugar t_oSug = new Sugar();
            try {
                t_oSug.addNode(p.getParent());
                t_oSug.addNode(p.getChild());
                t_oSug.addEdge(p.getParent(), p.getChild(), p.getLinkage());
                SugarExporterGlycoCTCondensed exp = new SugarExporterGlycoCTCondensed();
                exp.start(t_oSug);
                System.out.print("PAIR " + counter + ":  \n" + exp.getHashCode() + "\n");
            }
            catch (GlycoconjugateException e) {
                e.printStackTrace();
            }
        }
    }
}

