/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.datamodel.ms.annotation.preference;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.core.preference.share.PreferenceReader;
import org.grits.toolbox.core.preference.share.PreferenceWriter;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.dmtranslate.DMAnnotation;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.dmtranslate.DMFeature;
import org.grits.toolbox.datamodel.ms.preference.MassSpecViewerPreference;
import org.grits.toolbox.datamodel.ms.tablemodel.FillTypes;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;

@XmlRootElement(name="msAnnotationViewerPreference")
public class MSAnnotationViewerPreference
extends MassSpecViewerPreference {
    private static final Logger logger = Logger.getLogger(MSAnnotationViewerPreference.class);
    private static final String PREFERENCE_NAME_ALL = "org.grits.toolbox.datamodel.ms.annotation.preference.MSAnnotationViewerPreference";
    private static final String CURRENT_VERSION = "1.1";
    protected boolean bHideUnannotatedPeaks = false;
    protected boolean bShowUnannotated = false;
    protected boolean bShowUnannotatedLabels = false;

    public MSAnnotationViewerPreference() {
        this(0, FillTypes.Scans);
    }

    public MSAnnotationViewerPreference(int _iMSLevel, FillTypes fillType) {
        super(_iMSLevel, fillType);
    }

    public boolean isHideUnannotatedPeaks() {
        return this.bHideUnannotatedPeaks;
    }

    @XmlAttribute(name="hideUnannotatedPeaks")
    public void setHideUnannotatedPeaks(boolean _bVal) {
        this.bHideUnannotatedPeaks = _bVal;
    }

    public boolean isShowUnannotated() {
        return this.bShowUnannotated;
    }

    @XmlAttribute(name="showUnannotatedPeaks")
    public void setShowUnannotated(boolean bShowUnannotated) {
        this.bShowUnannotated = bShowUnannotated;
    }

    public boolean isShowUnannotatedLabels() {
        return this.bShowUnannotatedLabels;
    }

    @XmlAttribute(name="showUnannotatedPeakLabels")
    public void setShowUnannotatedLabels(boolean bShowUnannotatedLabels) {
        this.bShowUnannotatedLabels = bShowUnannotatedLabels;
    }

    protected static String getPreferenceID(int _iMSLevel, FillTypes fillType) {
        String sAdder = "";
        String sName = PREFERENCE_NAME_ALL;
        if (fillType == FillTypes.Scans) {
            sAdder = ".Scans";
        } else if (fillType == FillTypes.PeakList) {
            sAdder = ".Peaks";
        } else if (fillType == FillTypes.PeaksWithFeatures) {
            sAdder = ".PeaksWithFeatures";
        } else if (fillType == FillTypes.Selection) {
            sAdder = ".Selection";
        }
        sName = String.valueOf(sName) + sAdder;
        sName = String.valueOf(sName) + ".MSLevel" + (_iMSLevel - 1);
        return sName;
    }

    public static PreferenceEntity getPreferenceEntity(int _iMSLevel, FillTypes fillType) throws UnsupportedVersionException {
        PreferenceEntity preferenceEntity = PreferenceReader.getPreferenceByName((String)MSAnnotationViewerPreference.getPreferenceID(_iMSLevel, fillType));
        return preferenceEntity;
    }

    protected String getCurrentVersion() {
        return CURRENT_VERSION;
    }

    public boolean writePreference() {
        PreferenceEntity preferenceEntity = new PreferenceEntity(MSAnnotationViewerPreference.getPreferenceID(this.getMSLevel(), this.getFillType()));
        preferenceEntity.setVersion(this.getCurrentVersion());
        preferenceEntity.setValue(this.marshalXML());
        return PreferenceWriter.savePreference((PreferenceEntity)preferenceEntity);
    }

    public GRITSColumnHeader getColumnHeader(String _sKey) {
        if (_sKey.equals(DMAnnotation.annotation_type.name())) {
            return new GRITSColumnHeader(DMAnnotation.annotation_type.getLabel(), DMAnnotation.annotation_type.name());
        }
        if (_sKey.equals(DMAnnotation.annotation_id.name())) {
            return new GRITSColumnHeader(DMAnnotation.annotation_id.getLabel(), DMAnnotation.annotation_id.name());
        }
        if (_sKey.equals(DMAnnotation.annotation_sequence.name())) {
            return new GRITSColumnHeader(DMAnnotation.annotation_sequence.getLabel(), DMAnnotation.annotation_sequence.name());
        }
        if (_sKey.equals(DMAnnotation.annotation_num_candidates.name())) {
            return new GRITSColumnHeader(DMAnnotation.annotation_num_candidates.getLabel(), DMAnnotation.annotation_num_candidates.name());
        }
        if (_sKey.equals(DMFeature.feature_id.name())) {
            return new GRITSColumnHeader(DMFeature.feature_id.getLabel(), DMFeature.feature_id.name());
        }
        if (_sKey.equals(DMFeature.feature_type.name())) {
            return new GRITSColumnHeader(DMFeature.feature_type.getLabel(), DMFeature.feature_type.name());
        }
        if (_sKey.equals(DMFeature.feature_sequence.name())) {
            return new GRITSColumnHeader(DMFeature.feature_sequence.getLabel(), DMFeature.feature_sequence.name());
        }
        if (_sKey.equals(DMFeature.feature_mz.name())) {
            return new GRITSColumnHeader(DMFeature.feature_mz.getLabel(), DMFeature.feature_mz.name());
        }
        if (_sKey.equals(DMFeature.feature_deviation.name())) {
            return new GRITSColumnHeader(DMFeature.feature_deviation.getLabel(), DMFeature.feature_deviation.name());
        }
        if (_sKey.equals(DMFeature.feature_charge.name())) {
            return new GRITSColumnHeader(DMFeature.feature_charge.getLabel(), DMFeature.feature_charge.name());
        }
        if (_sKey.equals(DMFeature.feature_annotation_id.name())) {
            return new GRITSColumnHeader(DMFeature.feature_annotation_id.getLabel(), DMFeature.feature_annotation_id.name());
        }
        if (_sKey.equals(DMFeature.feature_precursor_id.name())) {
            return new GRITSColumnHeader(DMFeature.feature_precursor_id.getLabel(), DMFeature.feature_precursor_id.name());
        }
        if (_sKey.equals(DMFeature.feature_ions.name())) {
            return new GRITSColumnHeader(DMFeature.feature_ions.getLabel(), DMFeature.feature_ions.name());
        }
        if (_sKey.equals(DMFeature.feature_fragmentType.name())) {
            return new GRITSColumnHeader(DMFeature.feature_fragmentType.getLabel(), DMFeature.feature_fragmentType.name());
        }
        if (_sKey.equals(DMFeature.feature_neutralLosses.name())) {
            return new GRITSColumnHeader(DMFeature.feature_neutralLosses.getLabel(), DMFeature.feature_neutralLosses.name());
        }
        if (_sKey.equals(DMFeature.feature_exchanges.name())) {
            return new GRITSColumnHeader(DMFeature.feature_exchanges.getLabel(), DMFeature.feature_exchanges.name());
        }
        return super.getColumnHeader(_sKey);
    }
}

