/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.datamodel.ms.annotation.tablemodel.dmtranslate;

public enum DMFeature {
    feature_id("Feature Id", "The auto-assigned ID of the annotation object assigned to a scan."),
    feature_type("Feature Type", "The system-assigned type of feature assigned."),
    feature_sequence("Feature Sequence", "The sequence of the annotation object associated with this feature."),
    feature_mz("Feature m/z", "The theoretical m/z of the feature."),
    feature_deviation("Feature Mass Error", "The delta between the feature and observed m/zs in parts-per-million (ppm)"),
    feature_charge("Feature Charge", "The observed charge of the feature (could differ from scan if annotation considers other charge states)."),
    feature_annotation_id("Annotation Id", "The ID of the annotation object associated with this features."),
    feature_precursor_id("Precursor Id", "The ID of the peak assigned with this feature."),
    feature_fragmentType("Fragmentation Type", "Name of the fragmentation type (ions) that produced this feature, if applicable."),
    feature_ions("Adducts", "Text representation of the adducts (with quantity) that produced this feature."),
    feature_neutralLosses("Neutral Losses", "Text representation of the neutral losses (with quantity) that produced this feature, if any."),
    feature_exchanges("Ion Exchanges", "Text representation of the ion exchanges (with quantity) that produced this feature, if any.");

    private String sLabel;
    private String sDescription;

    private DMFeature(String sLabel, String sDescription) {
        this.sLabel = sLabel;
        this.sDescription = sDescription;
    }

    public String getDescription() {
        return this.sDescription;
    }

    public String getLabel() {
        return this.sLabel;
    }

    public static DMFeature lookUp(String _sKey) {
        if (feature_id.name().equals(_sKey)) {
            return feature_id;
        }
        if (feature_type.name().equals(_sKey)) {
            return feature_type;
        }
        if (feature_sequence.name().equals(_sKey)) {
            return feature_sequence;
        }
        if (feature_mz.name().equals(_sKey)) {
            return feature_mz;
        }
        if (feature_deviation.name().equals(_sKey)) {
            return feature_deviation;
        }
        if (feature_charge.name().equals(_sKey)) {
            return feature_charge;
        }
        if (feature_annotation_id.name().equals(_sKey)) {
            return feature_annotation_id;
        }
        if (feature_precursor_id.name().equals(_sKey)) {
            return feature_precursor_id;
        }
        if (feature_ions.name().equals(_sKey)) {
            return feature_ions;
        }
        if (feature_fragmentType.name().equals(_sKey)) {
            return feature_fragmentType;
        }
        if (feature_neutralLosses.name().equals(_sKey)) {
            return feature_neutralLosses;
        }
        if (feature_exchanges.name().equals(_sKey)) {
            return feature_exchanges;
        }
        return null;
    }
}

