/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.datamodel.ms.annotation.tablemodel.dmtranslate;

public enum DMMethod {
    method_annotationType("Annotation Type", "The type of annotation for the MS Experiment."),
    method_monoisotopic("Use Monoisotopic Mass", "Tells whether to use monoisotopic mass (if true) or average (if false)."),
    method_accuracy("Mass Accuracy", "The specified mass accuracy for assigning annotation objects to MS data."),
    method_accuracyPpm("Use PPM Accuracy", "Tells whether to use parts-per-million (ppm) mass accuracy (if true) or mass delta (in daltons)."),
    method_shift("Mass Shift", "Global shift to add to observed precursor mass in order to account for MS instrument calibration errors."),
    method_maxIonCount("Max Ion Count", "The maximum number of total adducts for a feature."),
    method_maxIonExchangeCount("Max Ion Exchange Count", "The maximum number of total neutral exchanges for a feature.");

    private String sLabel;
    private String sDescription;

    private DMMethod(String sLabel, String sDescription) {
        this.sLabel = sLabel;
        this.sDescription = sDescription;
    }

    public String getDescription() {
        return this.sDescription;
    }

    public String getLabel() {
        return this.sLabel;
    }

    public static DMMethod lookUp(String _sKey) {
        if (method_annotationType.name().equals(_sKey)) {
            return method_annotationType;
        }
        if (method_monoisotopic.name().equals(_sKey)) {
            return method_monoisotopic;
        }
        if (method_accuracy.name().equals(_sKey)) {
            return method_accuracy;
        }
        if (method_accuracyPpm.name().equals(_sKey)) {
            return method_accuracyPpm;
        }
        if (method_shift.name().equals(_sKey)) {
            return method_shift;
        }
        if (method_maxIonCount.name().equals(_sKey)) {
            return method_maxIonCount;
        }
        if (method_maxIonExchangeCount.name().equals(_sKey)) {
            return method_maxIonExchangeCount;
        }
        return null;
    }
}

