/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.simian;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Vector;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.eurocarbdb.application.glycanbuilder.BBoxManager;
import org.eurocarbdb.application.glycanbuilder.DefaultPaintable;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.Paintable;
import org.eurocarbdb.application.glycanbuilder.PositionManager;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SimianSVGUtils {
    public static byte[] getTranscodedSVG(GlycanRenderer gr, Collection<Glycan> structures, boolean show_masses, boolean show_redend, Transcoder transcoder) {
        if (structures == null) {
            structures = new Vector<Glycan>();
        }
        try {
            PositionManager posManager = new PositionManager();
            BBoxManager bboxManager = new BBoxManager();
            Rectangle all_bbox = gr.computeBoundingBoxes(structures, show_masses, show_redend, posManager, bboxManager);
            Dimension all_dim = gr.computeSize(all_bbox);
            SVGGraphics2D g2d = SimianSVGUtils.prepareGraphics(all_dim);
            for (Glycan s : structures) {
                gr.paint((Paintable)new DefaultPaintable((Graphics2D)g2d), s, null, null, show_masses, show_redend, posManager, bboxManager);
            }
            return SimianSVGUtils.transcode(g2d, all_dim, transcoder);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static byte[] transcode(SVGGraphics2D g2d, Dimension all_dim, Transcoder transcoder) throws Exception {
        StringWriter out = new StringWriter();
        g2d.stream((Writer)out, true);
        String svg = out.toString();
        if (transcoder == null) {
            return svg.getBytes();
        }
        transcoder.addTranscodingHint(ImageTranscoder.KEY_FORCE_TRANSPARENT_WHITE, (Object)true);
        transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, (Object)new Float(0.3528f));
        transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_MAX_WIDTH, (Object)new Float(all_dim.width));
        transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_MAX_HEIGHT, (Object)new Float(all_dim.height));
        transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, (Object)new Float(all_dim.width));
        transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, (Object)new Float(all_dim.height));
        transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_AOI, (Object)new Rectangle(0, 0, all_dim.width, all_dim.height));
        StringReader in = new StringReader(svg);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(baos);
        TranscoderInput input = new TranscoderInput((Reader)in);
        TranscoderOutput output = new TranscoderOutput((OutputStream)bos);
        transcoder.transcode(input, output);
        return baos.toByteArray();
    }

    private static SVGGraphics2D prepareGraphics(Dimension all_dim) {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        Document document = domImpl.createDocument(null, "svg", null);
        SVGGraphics2D g2d = new SVGGraphics2D(document);
        double sf = 2.0;
        all_dim.width = (int)((double)all_dim.width * sf);
        all_dim.height = (int)((double)all_dim.height * sf);
        g2d.setSVGCanvasSize(all_dim);
        return g2d;
    }
}

