/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.ByteArrayInputStream;
import org.apache.batik.svggen.font.table.GlyfDescript;
import org.apache.batik.svggen.font.table.GlyfTable;

public class GlyfSimpleDescript
extends GlyfDescript {
    private int[] endPtsOfContours;
    private byte[] flags;
    private short[] xCoordinates;
    private short[] yCoordinates;
    private int count;

    public GlyfSimpleDescript(GlyfTable glyfTable, short n, ByteArrayInputStream byteArrayInputStream) {
        super(glyfTable, (short)n, byteArrayInputStream);
        this.endPtsOfContours = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.endPtsOfContours[n2] = byteArrayInputStream.read() << 8 | byteArrayInputStream.read();
            ++n2;
        }
        this.count = this.endPtsOfContours[n - 1] + 1;
        this.flags = new byte[this.count];
        this.xCoordinates = new short[this.count];
        this.yCoordinates = new short[this.count];
        int n3 = byteArrayInputStream.read() << 8 | byteArrayInputStream.read();
        this.readInstructions(byteArrayInputStream, n3);
        this.readFlags(this.count, byteArrayInputStream);
        this.readCoords(this.count, byteArrayInputStream);
    }

    public int getEndPtOfContours(int n) {
        return this.endPtsOfContours[n];
    }

    public byte getFlags(int n) {
        return this.flags[n];
    }

    public short getXCoordinate(int n) {
        return this.xCoordinates[n];
    }

    public short getYCoordinate(int n) {
        return this.yCoordinates[n];
    }

    public boolean isComposite() {
        return false;
    }

    public int getPointCount() {
        return this.count;
    }

    public int getContourCount() {
        return this.getNumberOfContours();
    }

    private void readCoords(int n, ByteArrayInputStream byteArrayInputStream) {
        short s = 0;
        short s2 = 0;
        int n2 = 0;
        while (n2 < n) {
            if ((this.flags[n2] & 0x10) != 0) {
                if ((this.flags[n2] & 2) != 0) {
                    s = (short)(s + (short)byteArrayInputStream.read());
                }
            } else {
                s = (this.flags[n2] & 2) != 0 ? (short)(s + (short)(-((short)byteArrayInputStream.read()))) : (short)(s + (short)(byteArrayInputStream.read() << 8 | byteArrayInputStream.read()));
            }
            this.xCoordinates[n2] = s;
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            if ((this.flags[n3] & 0x20) != 0) {
                if ((this.flags[n3] & 4) != 0) {
                    s2 = (short)(s2 + (short)byteArrayInputStream.read());
                }
            } else {
                s2 = (this.flags[n3] & 4) != 0 ? (short)(s2 + (short)(-((short)byteArrayInputStream.read()))) : (short)(s2 + (short)(byteArrayInputStream.read() << 8 | byteArrayInputStream.read()));
            }
            this.yCoordinates[n3] = s2;
            ++n3;
        }
    }

    private void readFlags(int n, ByteArrayInputStream byteArrayInputStream) {
        try {
            int n2 = 0;
            while (n2 < n) {
                this.flags[n2] = (byte)byteArrayInputStream.read();
                if ((this.flags[n2] & 8) != 0) {
                    int n3 = byteArrayInputStream.read();
                    int n4 = 1;
                    while (n4 <= n3) {
                        this.flags[n2 + n4] = this.flags[n2];
                        ++n4;
                    }
                    n2 += n3;
                }
                ++n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("error: array index out of bounds");
        }
    }
}

