/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.dev;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.util.LittleEndian;

public final class PPTXMLDump {
    public static final int HEADER_SIZE = 8;
    public static final int PICT_HEADER_SIZE = 25;
    public static final String PPDOC_ENTRY = "PowerPoint Document";
    public static final String PICTURES_ENTRY = "Pictures";
    public static final String CR = System.getProperty("line.separator");
    protected Writer out;
    protected byte[] docstream;
    protected byte[] pictstream;
    protected boolean hexHeader = true;
    private static final byte[] hexval = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PPTXMLDump(File ppt) throws IOException {
        NPOIFSFileSystem fs = new NPOIFSFileSystem(ppt, true);
        DocumentInputStream is = null;
        try {
            DocumentEntry entry = (DocumentEntry)fs.getRoot().getEntry(PPDOC_ENTRY);
            this.docstream = new byte[entry.getSize()];
            is = fs.createDocumentInputStream(PPDOC_ENTRY);
            is.read(this.docstream);
            is.close();
            entry = (DocumentEntry)fs.getRoot().getEntry(PICTURES_ENTRY);
            this.pictstream = new byte[entry.getSize()];
            is = fs.createDocumentInputStream(PICTURES_ENTRY);
            is.read(this.pictstream);
        }
        catch (FileNotFoundException e) {
        }
        finally {
            if (is != null) {
                is.close();
            }
            fs.close();
        }
    }

    public void dump(Writer outWriter) throws IOException {
        this.out = outWriter;
        int padding = 0;
        PPTXMLDump.write(this.out, "<Presentation>" + CR, padding);
        ++padding;
        if (this.pictstream != null) {
            PPTXMLDump.write(this.out, "<Pictures>" + CR, padding);
            this.dumpPictures(this.pictstream, padding);
            PPTXMLDump.write(this.out, "</Pictures>" + CR, padding);
        }
        PPTXMLDump.write(this.out, "<PowerPointDocument>" + CR, padding);
        this.dump(this.docstream, 0, this.docstream.length, ++padding);
        PPTXMLDump.write(this.out, "</PowerPointDocument>" + CR, --padding);
        PPTXMLDump.write(this.out, "</Presentation>", --padding);
    }

    public void dump(byte[] data, int offset, int length, int padding) throws IOException {
        int size;
        for (int pos = offset; pos <= offset + length - 8 && pos >= 0; pos += size) {
            boolean isContainer;
            int info = LittleEndian.getUShort((byte[])data, (int)pos);
            int type = LittleEndian.getUShort((byte[])data, (int)(pos += 2));
            size = (int)LittleEndian.getUInt((byte[])data, (int)(pos += 2));
            String recname = RecordTypes.forTypeID(type).name();
            PPTXMLDump.write(this.out, "<" + recname + " info=\"" + info + "\" type=\"" + type + "\" size=\"" + size + "\" offset=\"" + ((pos += 4) - 8) + "\"", padding);
            if (this.hexHeader) {
                this.out.write(" header=\"");
                PPTXMLDump.dump(this.out, data, pos - 8, 8, 0, false);
                this.out.write("\"");
            }
            this.out.write(">" + CR);
            ++padding;
            boolean bl = isContainer = (info & 0xF) == 15;
            if (isContainer) {
                this.dump(data, pos, size, padding);
            } else {
                PPTXMLDump.dump(this.out, data, pos, Math.min(size, data.length - pos), padding, true);
            }
            PPTXMLDump.write(this.out, "</" + recname + ">" + CR, --padding);
        }
    }

    public void dumpPictures(byte[] data, int padding) throws IOException {
        int pos = 0;
        while (pos < data.length) {
            byte[] header = new byte[25];
            System.arraycopy(data, pos, header, 0, header.length);
            int size = LittleEndian.getInt((byte[])header, (int)4) - 17;
            byte[] pictdata = new byte[size];
            System.arraycopy(data, pos + 25, pictdata, 0, pictdata.length);
            pos += 25 + size;
            PPTXMLDump.write(this.out, "<picture size=\"" + size + "\" type=\"" + this.getPictureType(header) + "\">" + CR, ++padding);
            PPTXMLDump.write(this.out, "<header>" + CR, ++padding);
            PPTXMLDump.dump(this.out, header, 0, header.length, padding, true);
            PPTXMLDump.write(this.out, "</header>" + CR, padding);
            PPTXMLDump.write(this.out, "<imgdata>" + CR, padding);
            PPTXMLDump.dump(this.out, pictdata, 0, Math.min(pictdata.length, 100), padding, true);
            PPTXMLDump.write(this.out, "</imgdata>" + CR, padding);
            PPTXMLDump.write(this.out, "</picture>" + CR, --padding);
            --padding;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Usage: PPTXMLDump (options) pptfile\nWhere options include:\n    -f     write output to <pptfile>.xml file in the current directory");
            return;
        }
        boolean outFile = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (!"-f".equals(args[i])) continue;
                outFile = true;
                continue;
            }
            File ppt = new File(args[i]);
            PPTXMLDump dump = new PPTXMLDump(ppt);
            System.out.println("Dumping " + args[i]);
            if (outFile) {
                FileOutputStream fos = new FileOutputStream(ppt.getName() + ".xml");
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, Charset.forName("UTF8"));
                dump.dump(out);
                out.close();
                continue;
            }
            StringWriter out = new StringWriter();
            dump.dump(out);
            System.out.println(out.toString());
        }
    }

    private static void write(Writer out, String str, int padding) throws IOException {
        for (int i = 0; i < padding; ++i) {
            out.write("  ");
        }
        out.write(str);
    }

    private String getPictureType(byte[] header) {
        String type;
        int meta = LittleEndian.getUShort((byte[])header, (int)0);
        switch (meta) {
            case 18080: {
                type = "jpeg";
                break;
            }
            case 8544: {
                type = "wmf";
                break;
            }
            case 28160: {
                type = "png";
                break;
            }
            default: {
                type = "unknown";
            }
        }
        return type;
    }

    private static void dump(Writer out, byte[] data, int offset, int length, int padding, boolean nl) throws IOException {
        int i;
        int linesize = 25;
        for (i = 0; i < padding; ++i) {
            out.write("  ");
        }
        for (i = offset; i < offset + length; ++i) {
            byte c = data[i];
            out.write((char)hexval[(c & 0xF0) >> 4]);
            out.write((char)hexval[(c & 0xF) >> 0]);
            out.write(32);
            if ((i + 1 - offset) % linesize != 0 || i == offset + length - 1) continue;
            out.write(CR);
            for (int j = 0; j < padding; ++j) {
                out.write("  ");
            }
        }
        if (nl && length > 0) {
            out.write(CR);
        }
    }
}

