/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.commands;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.ProjectFileHandler;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.core.service.IGritsUIService;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.qrtpcr.dialogs.UploadDataWizard;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRRun;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRTable;
import org.grits.toolbox.entry.qrtpcr.property.QrtPCRProperty;

public class CreateQrtPCRDataTable {
    private static final Logger logger = Logger.getLogger(CreateQrtPCRDataTable.class);
    @Inject
    private static IGritsDataModelService gritsDataModelService = null;
    @Inject
    static IGritsUIService gritsUIService = null;

    @Execute
    public Object execute(@Named(value="org.eclipse.ui.selection") Object object, IEventBroker eventBroker, @Named(value="activeShell") Shell shell) {
        logger.debug((Object)"BEGIN CreateQrtPCRDataTable");
        Entry qrtPCREntry = null;
        Entry selectedEntry = null;
        if (object instanceof Entry) {
            selectedEntry = (Entry)object;
        } else if (object instanceof StructuredSelection && ((StructuredSelection)object).getFirstElement() instanceof Entry) {
            selectedEntry = (Entry)((StructuredSelection)object).getFirstElement();
        }
        if (selectedEntry == null && gritsDataModelService.getLastSelection() != null && gritsDataModelService.getLastSelection().getFirstElement() instanceof Entry) {
            selectedEntry = (Entry)gritsDataModelService.getLastSelection().getFirstElement();
        }
        if (!(selectedEntry == null || selectedEntry.getProperty() != null && "org.grits.toolbox.property.sample".equals(selectedEntry.getProperty().getType()))) {
            selectedEntry = null;
        }
        if ((qrtPCREntry = this.createNewQrtPCRTable(shell, selectedEntry)) != null) {
            eventBroker.send("grits_entry_selected", (Object)qrtPCREntry);
            gritsUIService.openEntryInPart(qrtPCREntry);
        }
        logger.debug((Object)"END CreateQrtPCRDataTable");
        return qrtPCREntry;
    }

    private Entry createNewQrtPCRTable(Shell shell, Entry sample) {
        UploadDataWizard wizard = new UploadDataWizard();
        wizard.setSampleEntry(sample);
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard);
        if (wizardDialog.open() == 0) {
            logger.debug((Object)"qrtPCR Wizard: Ok pressed");
            try {
                sample = wizard.getSampleEntry();
                QrtPCRTable table = wizard.getTable();
                QrtPCRRun originalRun = new QrtPCRRun();
                originalRun.setGeneListFile(wizard.getMasterListFile());
                originalRun.addRun(table);
                originalRun.setThreshold(wizard.getThresholdSetting());
                originalRun.setStDevCutOff(wizard.getCutOffSetting());
                String qrtPCRFileName = CreateQrtPCRDataTable.createQrtPCRFile(sample, wizard.getEntryName(), originalRun);
                Entry qrtPCREntry = new Entry();
                qrtPCREntry.setDisplayName(wizard.getEntryName());
                QrtPCRProperty property = new QrtPCRProperty();
                property.setFilename(qrtPCRFileName);
                qrtPCREntry.setProperty((Property)property);
                qrtPCREntry.setParent(sample);
                gritsDataModelService.addEntry(sample, qrtPCREntry);
                try {
                    ProjectFileHandler.saveProject((Entry)sample.getParent());
                }
                catch (IOException e) {
                    logger.error((Object)("Something went wrong while saving project entry \n" + e.getMessage()), (Throwable)e);
                    logger.fatal((Object)("Closing project entry \"" + sample.getParent().getDisplayName() + "\""));
                    gritsDataModelService.closeProject(sample.getParent());
                    throw e;
                }
                return qrtPCREntry;
            }
            catch (IOException e) {
                logger.error((Object)("org.grits.toolbox.entry.qrtpcr " + e.getMessage()), (Throwable)e);
                ErrorUtils.createErrorMessageBox((Shell)shell, (String)e.getMessage(), (Exception)e);
            }
        } else {
            logger.debug((Object)"qrtPCR Wizard: Cancel pressed");
        }
        return null;
    }

    public static String generateFileName(String[] existingNames) {
        String fileName = "";
        int randomLength = 0;
        do {
            fileName = "qrtPCR";
            while (randomLength < 5) {
                int randomcharacter = (int)(Math.random() * 10.0);
                ++randomLength;
                fileName = String.valueOf(fileName) + randomcharacter;
            }
            fileName = String.valueOf(fileName) + ".xml";
        } while (Arrays.asList(existingNames).contains(fileName));
        return fileName;
    }

    public static String createQrtPCRFile(Entry selectedSampleEntry, String qrtPCRName, QrtPCRRun originalRun) throws IOException {
        File qrtPCRFolder = CreateQrtPCRDataTable.getQrtPCRDirectory(selectedSampleEntry);
        String qrtPCRFileName = CreateQrtPCRDataTable.generateFileName(qrtPCRFolder.list());
        CreateQrtPCRDataTable.createFileContent(selectedSampleEntry, qrtPCRFolder, qrtPCRFileName, qrtPCRName, originalRun);
        return qrtPCRFileName;
    }

    private static void createFileContent(Entry selectedSampleEntry, File qrtPCRFolder, String qrtPCRFileName, String qrtPCRName, QrtPCRRun originalRun) throws IOException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{QrtPCRRun.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)originalRun, (OutputStream)os);
            FileWriter fileWriter = new FileWriter(String.valueOf(qrtPCRFolder.getAbsolutePath()) + File.separator + qrtPCRFileName);
            fileWriter.write(os.toString((String)marshaller.getProperty("jaxb.encoding")));
            fileWriter.close();
            os.close();
        }
        catch (JAXBException e) {
            throw new IOException("Error creating new file", e);
        }
        catch (IOException e) {
            throw e;
        }
    }

    public static File getQrtPCRDirectory(Entry selectedSampleEntry) {
        Entry projectEntry = selectedSampleEntry.getParent();
        String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
        String projectFolderLocation = String.valueOf(workspaceLocation.substring(0, workspaceLocation.length() - 1)) + File.separator + projectEntry.getDisplayName();
        String qrtPCRFolderLocation = String.valueOf(projectFolderLocation) + File.separator + "qrtPCR";
        File qrtPCRFolder = new File(qrtPCRFolderLocation);
        if (!qrtPCRFolder.exists() || !qrtPCRFolder.isDirectory()) {
            qrtPCRFolder.mkdir();
        }
        return qrtPCRFolder;
    }
}

