/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.applications.ms.glycopeakfinder.calculation.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.ParameterException;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.Persubstitution;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.util.MassValueStorage;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

public class DefaultMasses
implements MassValueStorage {
    private Document m_docDefaultMasses;
    private Document m_docAX;

    public DefaultMasses(URL uRL, URL uRL2) throws JDOMException, IOException {
        this.m_docAX = new SAXBuilder().build(uRL2);
        this.m_docDefaultMasses = new SAXBuilder().build(uRL);
    }

    public DefaultMasses(String string, String string2) throws JDOMException, IOException {
        this.m_docAX = new SAXBuilder().build(new File(string2));
        this.m_docDefaultMasses = new SAXBuilder().build(new File(string));
    }

    public DefaultMasses() throws JDOMException, IOException {
        this.m_docDefaultMasses = new SAXBuilder().build(this.getClass().getResource("/default_masses.xml"));
        this.m_docAX = new SAXBuilder().build(this.getClass().getResource("/residue_fragments.xml"));
    }

    @Override
    public double getDerivatisationMass(String string, Persubstitution persubstitution, boolean bl) throws Exception, ParameterException {
        XPath xPath = XPath.newInstance((String)"/defaults/dericatisation/derivate");
        for (Element element : xPath.selectNodes((Object)this.m_docDefaultMasses)) {
            if (!element.getAttributeValue("abbr").equals(string)) continue;
            String string2 = "mass";
            if (persubstitution != Persubstitution.None) {
                string2 = string2 + "_" + persubstitution.getAbbr();
            }
            string2 = bl ? string2 + "_mono" : string2 + "_avg";
            Element element2 = element.getChild(string2);
            return Double.parseDouble(element2.getTextTrim());
        }
        throw new ParameterException("Unknown derivatisation.");
    }

    @Override
    public double getMoleculeMass(String string, boolean bl) throws Exception, ParameterException {
        XPath xPath = XPath.newInstance((String)"/defaults/molecules/small_molecules");
        for (Element element : xPath.selectNodes((Object)this.m_docDefaultMasses)) {
            if (!element.getChild("name").getTextTrim().equals(string)) continue;
            Element element2 = null;
            element2 = bl ? element.getChild("mass_mono") : element.getChild("mass_avg");
            return Double.parseDouble(element2.getTextTrim());
        }
        throw new ParameterException("Unknown small molecule.");
    }

    @Override
    public double getCompletionMass(String string, Persubstitution persubstitution, boolean bl) throws ParameterException, Exception {
        XPath xPath = XPath.newInstance((String)"/defaults/persubstitutions/persubstitution");
        for (Element element : xPath.selectNodes((Object)this.m_docDefaultMasses)) {
            if (!element.getChild("name").getTextTrim().equals(persubstitution.getAbbr())) continue;
            Element element2 = null;
            if (bl) {
                if (string.equals("red")) {
                    element2 = element.getChild("ergaenzung_red_mono");
                } else if (string.equals("nonred")) {
                    element2 = element.getChild("ergaenzung_nonred_mono");
                } else if (string.equals("profile")) {
                    element2 = element.getChild("mono");
                }
            } else if (string.equals("red")) {
                element2 = element.getChild("ergaenzung_red_avg");
            } else if (string.equals("nonred")) {
                element2 = element.getChild("ergaenzung_nonred_avg");
            } else if (string.equals("profile")) {
                element2 = element.getChild("avg");
            }
            if (element2 == null) {
                throw new ParameterException("Unknown completion type.");
            }
            if (string.equals("profile")) {
                return Double.parseDouble(element2.getTextTrim()) - this.getMassH(bl);
            }
            return Double.parseDouble(element2.getTextTrim());
        }
        throw new ParameterException("Unknown persubstitution type.");
    }

    @Override
    public double getMassH(boolean bl) throws ParameterException, Exception {
        if (bl) {
            return Double.parseDouble("1.007825");
        }
        return Double.parseDouble("1.007947");
    }

    @Override
    public double getMassOH(boolean bl) throws ParameterException, Exception {
        if (bl) {
            return Double.parseDouble("17.0027396");
        }
        return Double.parseDouble("17.007377");
    }

    @Override
    public double getMassO(boolean bl) throws ParameterException, Exception {
        if (bl) {
            return Double.parseDouble("15.9949146");
        }
        return Double.parseDouble("15.99943");
    }

    @Override
    public double getMassH2O(boolean bl) throws ParameterException, Exception {
        if (bl) {
            return Double.parseDouble("18.0106646");
        }
        return Double.parseDouble("18.015324");
    }

    @Override
    public double getIonMass(String string, boolean bl) throws ParameterException, Exception {
        XPath xPath = XPath.newInstance((String)"/defaults/ions/ion");
        for (Element element : xPath.selectNodes((Object)this.m_docDefaultMasses)) {
            if (!element.getChild("formula").getTextTrim().equals(string)) continue;
            Element element2 = null;
            element2 = bl ? element.getChild("mass_mono") : element.getChild("mass_avg");
            return Double.parseDouble(element2.getTextTrim()) - this.getMassE(bl);
        }
        throw new ParameterException("Unknown ion.");
    }

    @Override
    public double getGlycosidicFragmentMass(String string, boolean bl) throws ParameterException, Exception {
        if (string.equalsIgnoreCase("y")) {
            return this.getMassH(bl);
        }
        if (string.equalsIgnoreCase("z")) {
            return 0.0 - this.getMassOH(bl);
        }
        if (string.equalsIgnoreCase("c")) {
            return this.getMassOH(bl);
        }
        if (string.equalsIgnoreCase("b")) {
            return 0.0 - this.getMassH(bl);
        }
        throw new ParameterException("Unknown fragment type.");
    }

    @Override
    public double getIncrementMass(Persubstitution persubstitution, boolean bl) throws ParameterException, Exception {
        XPath xPath = XPath.newInstance((String)"/defaults/persubstitutions/persubstitution");
        for (Element element : xPath.selectNodes((Object)this.m_docDefaultMasses)) {
            if (!element.getChild("name").getTextTrim().equals(persubstitution.getAbbr())) continue;
            Element element2 = null;
            element2 = bl ? element.getChild("increment_mono") : element.getChild("increment_avg");
            return Double.parseDouble(element2.getTextTrim());
        }
        throw new ParameterException("Unknown persubstitution.");
    }

    @Override
    public double getIncrementMassAX(Persubstitution persubstitution, boolean bl) throws ParameterException, Exception {
        XPath xPath = XPath.newInstance((String)"/defaults/persubstitutions/persubstitution");
        for (Element element : xPath.selectNodes((Object)this.m_docDefaultMasses)) {
            if (!element.getChild("name").getTextTrim().equals(persubstitution.getAbbr())) continue;
            if (bl) {
                return Double.parseDouble(element.getChild("increment_mono").getTextTrim()) - Double.parseDouble(element.getChild("mono").getTextTrim());
            }
            return Double.parseDouble(element.getChild("increment_avg").getTextTrim()) - Double.parseDouble(element.getChild("avg").getTextTrim());
        }
        throw new ParameterException("Unknown persubstitution.");
    }

    @Override
    public double getResidueMass(String string, Persubstitution persubstitution, boolean bl) throws ParameterException, Exception {
        String string2 = "mass_";
        if (persubstitution == Persubstitution.Me) {
            string2 = string2 + "pm_";
        } else if (persubstitution == Persubstitution.DMe) {
            string2 = string2 + "pdm_";
        } else if (persubstitution == Persubstitution.Ac) {
            string2 = string2 + "pac_";
        } else if (persubstitution == Persubstitution.DAc) {
            string2 = string2 + "pdac_";
        }
        string2 = bl ? string2 + "mono" : string2 + "avg";
        XPath xPath = XPath.newInstance((String)"/defaults/residues/residue");
        for (Element element : xPath.selectNodes((Object)this.m_docDefaultMasses)) {
            if (!element.getChild("abbr").getTextTrim().equals(string.trim())) continue;
            double d = Double.parseDouble(element.getChild(string2).getText());
            if (element.getChild("increment").getTextTrim().equals("0")) {
                d -= this.getIncrementMass(persubstitution, bl);
            }
            return d;
        }
        throw new ParameterException("Unknown residue.");
    }

    @Override
    public double getCrossringFragmentMass(String string, Persubstitution persubstitution, boolean bl, String string2, int n, int n2) throws ParameterException, Exception {
        String string3 = "mass_";
        if (persubstitution == Persubstitution.Me) {
            string3 = string3 + "pm_";
        } else if (persubstitution == Persubstitution.DMe) {
            string3 = string3 + "pdm_";
        } else if (persubstitution == Persubstitution.Ac) {
            string3 = string3 + "pac_";
        } else if (persubstitution == Persubstitution.DAc) {
            string3 = string3 + "pdac_";
        }
        string3 = bl ? string3 + "mono" : string3 + "avg";
        XPath xPath = XPath.newInstance((String)"/fragments/fragment_ax");
        for (Element element : xPath.selectNodes((Object)this.m_docAX)) {
            int n3;
            if (!element.getChild("residue_id").getTextTrim().equals(string2) || !element.getChild("type").getTextTrim().equals(string) || (n3 = Integer.parseInt(element.getChild("cleav_one").getTextTrim())) != n || (n3 = Integer.parseInt(element.getChild("cleav_two").getTextTrim())) != n2) continue;
            double d = Double.parseDouble(element.getChild(string3).getTextTrim());
            d = string.equalsIgnoreCase("A") ? d - this.getIncrementMassAX(persubstitution, bl) + this.getMassOH(bl) : d - this.getIncrementMassAX(persubstitution, bl) + this.getMassH(bl);
            return d;
        }
        throw new ParameterException("Unknown fragment.");
    }

    @Override
    public double getResidueFragmentMass(String string, Persubstitution persubstitution, boolean bl, String string2) throws ParameterException, Exception {
        String string3 = "mass_";
        if (persubstitution == Persubstitution.Me) {
            string3 = string3 + "pm_";
        } else if (persubstitution == Persubstitution.DMe) {
            string3 = string3 + "pdm_";
        } else if (persubstitution == Persubstitution.Ac) {
            string3 = string3 + "pac_";
        } else if (persubstitution == Persubstitution.DAc) {
            string3 = string3 + "pdac_";
        }
        string3 = bl ? string3 + "mono" : string3 + "avg";
        XPath xPath = XPath.newInstance((String)"/fragments/fragment");
        for (Element element : xPath.selectNodes((Object)this.m_docAX)) {
            if (!element.getChild("residue_id").getTextTrim().equals(string2) || !element.getChild("type").getTextTrim().equals(string)) continue;
            double d = Double.parseDouble(element.getChild(string3).getTextTrim());
            d = string.equalsIgnoreCase("E") ? d - this.getIncrementMassAX(persubstitution, bl) + this.getMassOH(bl) : d - this.getIncrementMassAX(persubstitution, bl) + this.getMassH(bl);
            return d;
        }
        throw new ParameterException("Unknown fragment.");
    }

    @Override
    public double getExchangeIonMass(boolean bl) throws ParameterException, Exception {
        return this.getMassH(bl);
    }

    @Override
    public double getNonReducingDifference(Persubstitution persubstitution, boolean bl) throws ParameterException, Exception {
        XPath xPath = XPath.newInstance((String)"/defaults/persubstitutions/persubstitution");
        for (Element element : xPath.selectNodes((Object)this.m_docDefaultMasses)) {
            if (!element.getChild("name").getTextTrim().equals(persubstitution.getAbbr())) continue;
            Element element2 = null;
            element2 = bl ? element.getChild("ergaenzung_nonred_mono") : element.getChild("ergaenzung_nonred_avg");
            if (element2 == null) {
                throw new ParameterException("Unknown persubstitution type.");
            }
            return Double.parseDouble(element2.getTextTrim());
        }
        throw new ParameterException("Unknown persubstitution type.");
    }

    @Override
    public double getMassE(boolean bl) throws ParameterException, Exception {
        if (bl) {
            return Double.parseDouble("0.0005486");
        }
        return Double.parseDouble("0.0005486");
    }
}

