/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.om.data;

import java.text.DecimalFormat;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;

@XmlType
public class CustomExtraData {
    private static final Logger logger = Logger.getLogger(CustomExtraData.class);
    @XmlElement(name="key")
    protected String m_key;
    @XmlElement(name="label")
    protected String m_label;
    @XmlElement(name="description")
    protected String m_description;
    @XmlElement(name="type")
    protected Type m_type;
    @XmlElement(name="doubleFormat")
    protected String m_doubleFormat = null;
    @XmlTransient
    private DecimalFormat m_doubleDecFormat = null;

    public CustomExtraData() {
    }

    public CustomExtraData(String a_key, String a_label, String a_description, Type a_type) {
        this.setKey(a_key);
        this.setLabel(a_label);
        this.setDescription(a_description);
        this.setType(a_type);
    }

    public CustomExtraData(String a_key, String a_label, String a_description, Type a_type, String a_doubleFormat) {
        this(a_key, a_label, a_description, a_type);
        this.setDoubleFormat(a_doubleFormat);
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof CustomExtraData)) {
            return false;
        }
        CustomExtraData ced = (CustomExtraData)arg0;
        return this.m_key.equals(ced.m_key);
    }

    @XmlTransient
    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String a_description) {
        this.m_description = a_description;
    }

    @XmlTransient
    public String getKey() {
        return this.m_key;
    }

    public void setKey(String a_key) {
        this.m_key = a_key;
    }

    @XmlTransient
    public String getLabel() {
        return this.m_label;
    }

    public void setLabel(String a_label) {
        this.m_label = a_label;
    }

    @XmlTransient
    public Type getType() {
        return this.m_type;
    }

    public void setType(Type a_type) {
        this.m_type = a_type;
    }

    @XmlTransient
    public DecimalFormat getDoubleFormat() {
        if (this.m_doubleFormat == null) {
            this.m_doubleFormat = "0.0000";
        }
        if (this.m_doubleDecFormat == null) {
            this.m_doubleDecFormat = new DecimalFormat(this.m_doubleFormat);
        }
        return this.m_doubleDecFormat;
    }

    public void setDoubleFormat(String m_doubleFormat) {
        this.m_doubleFormat = m_doubleFormat;
        try {
            this.m_doubleDecFormat = new DecimalFormat(this.m_doubleFormat);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public String toString() {
        return "Key: " + this.m_key + ", Label: " + this.m_label + ", Type: " + (Object)((Object)this.m_type) + ", Dec format: " + this.m_doubleFormat;
    }

    @XmlEnum(value=String.class)
    public static enum Type {
        Integer,
        Double,
        String,
        Boolean;

    }
}

