/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed;

import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Composite;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.datamodel.ms.annotation.glycan.tablemodel.MSGlycanAnnotationTableDataObject;
import org.grits.toolbox.display.control.spectrum.chart.GRITSSpectralViewerChart;
import org.grits.toolbox.entry.ms.annotation.glycan.spectrum.chart.MSGlycanAnnotationSpectralViewerChart;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationDetails;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationSpectraControlPanelView;
import org.grits.toolbox.entry.ms.annotation.process.loader.MSAnnotationTableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationPeaksView;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationSpectraView;
import org.grits.toolbox.entry.ms.exceptions.MSException;
import org.grits.toolbox.entry.ms.process.loader.MassSpecTableDataProcessor;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecSpectraControlPanelView;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecSpectraView;
import org.grits.toolbox.utils.image.GlycanImageProvider;

public class MSGlycanAnnotationSpectraView
extends MSAnnotationSpectraView {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationSpectraView.class);
    protected MSGlycanAnnotationDetails detailView = null;

    @Inject
    public MSGlycanAnnotationSpectraView(Entry entry) {
        super(entry);
    }

    public void setDetailsView(MSGlycanAnnotationDetails curDetailsView) {
        this.detailView = curDetailsView;
    }

    public MSGlycanAnnotationDetails getDetailsView() {
        return this.detailView;
    }

    protected Object getPeakLabel(Double dMz, Object oFeatureId, Object oLabel, String sFeatureSeq) {
        if (oFeatureId == null) {
            return super.getPeakLabel(dMz, oFeatureId, oLabel, sFeatureSeq);
        }
        try {
            GlycanImageProvider.GlycanImageObject gio = MSGlycanAnnotationTableDataObject.glycanImageProvider.getImage(sFeatureSeq.toString());
            return gio;
        }
        catch (Exception e) {
            logger.error((Object)"Error getting image for chart!", (Throwable)e);
            return null;
        }
    }

    protected GRITSSpectralViewerChart getNewSpectralViewerChart() {
        return new MSGlycanAnnotationSpectralViewerChart(this.sDescription, this.iScanNum, this.iMSLevel, this.bIsCentroid == false, true, this.sID, this.dMz);
    }

    protected MassSpecSpectraControlPanelView getNewSpectraControlPanel() {
        return new MSGlycanAnnotationSpectraControlPanelView((MassSpecSpectraView)this);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
    }

    public void createView() throws MSException {
        super.createView();
    }

    public MSAnnotationPeaksView getCurrentPeaksView() {
        if (this.getDetailsView() == null) {
            return null;
        }
        int iInx = this.getDetailsView().getCurViewIndex();
        if (this.getControlPanel() != null) {
            iInx = ((MSGlycanAnnotationSpectraControlPanelView)this.getControlPanel()).getCurViewIndex();
        }
        return (MSAnnotationPeaksView)this.getDetailsView().getPeaksViews().get(iInx);
    }

    public void createChart(Composite parent) throws MSException {
        if (this.getDetailsView() != null) {
            super.setPeakListTableProcessor((MassSpecTableDataProcessor)((MSAnnotationTableDataProcessor)this.getCurrentPeaksView().getTableDataProcessor()));
        }
        super.createChart(parent);
        if (this.getDetailsView() == null) {
            return;
        }
        ((MSGlycanAnnotationSpectraControlPanelView)this.getControlPanel()).setCurViewIndex(this.getDetailsView().getCurViewIndex());
        ((MSGlycanAnnotationSpectraControlPanelView)this.getControlPanel()).updateView();
    }

    protected int getPrefEntityScrollerWeight() {
        int iTopWeight = 280;
        try {
            if (((MSGlycanAnnotationSpectraControlPanelView)this.controlPanel).getEntityScroller() == null) {
                return super.getPrefEntityScrollerWeight();
            }
            int iTopHeight = ((MSGlycanAnnotationSpectraControlPanelView)this.controlPanel).getEntityScroller().getSize().y;
            if (iTopHeight != 0) {
                int iFormHeight = this.sashForm.getSize().y;
                if (iFormHeight < iTopHeight) {
                    return iTopWeight;
                }
                iTopWeight = (int)Math.ceil((double)iTopHeight / (double)iFormHeight * 1000.0) + 30;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error setting weights.", (Throwable)ex);
        }
        return iTopWeight;
    }

    protected void setWeights() {
        try {
            if (this.getDetailsView() == null) {
                super.setWeights();
                return;
            }
            int[] dWeights = this.getSashWeights();
            this.sashForm.setWeights(dWeights);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception ex) {
            logger.error((Object)"Error setting weights.", (Throwable)ex);
        }
    }
}

