/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ConnectionEditPolicy;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.requests.GroupRequest;
import org.grits.toolbox.editor.experimentdesigner.commands.ConnectionDeleteCommand;
import org.grits.toolbox.editor.experimentdesigner.model.Connection;
import org.grits.toolbox.editor.experimentdesigner.model.ExperimentGraph;
import org.grits.toolbox.editor.experimentdesigner.model.ModelElement;

class ConnectionEditPart
extends AbstractConnectionEditPart
implements PropertyChangeListener {
    ConnectionEditPart() {
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((ModelElement)this.getModel()).addPropertyChangeListener(this);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new ConnectionEditPolicy(){

            protected Command getDeleteCommand(GroupRequest request) {
                return new ConnectionDeleteCommand((ExperimentGraph)ConnectionEditPart.this.getSource().getParent().getModel(), ConnectionEditPart.this.getCastedModel());
            }
        });
    }

    protected IFigure createFigure() {
        PolylineConnection connection = (PolylineConnection)super.createFigure();
        connection.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        connection.setLineStyle(this.getCastedModel().getLineStyle());
        return connection;
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((ModelElement)this.getModel()).removePropertyChangeListener(this);
        }
    }

    private Connection getCastedModel() {
        return (Connection)this.getModel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getPropertyName();
        if ("LineStyle".equals(property)) {
            ((PolylineConnection)this.getFigure()).setLineStyle(this.getCastedModel().getLineStyle());
        }
    }
}

